/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.ruleFunction;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.rule.ruleFunction.FunctionRefMember;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class GetAttributeRuleFunction
extends RuleFunction {
    public GetAttributeRuleFunction(String functionName) {
        super(functionName);
    }

    public GetAttributeRuleFunction(String functionKey, String functionInfoStr, String functionName) {
        super(functionKey, functionInfoStr, functionName);
    }

    @Override
    public String genNewFunParseStr() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(this.functionName);
        sb.append('[').append(this.functionKey).append(']').append('(');
        this.dealGetAttributeVal(sb);
        sb.append(')');
        return sb.toString();
    }

    private void dealGetAttributeVal(StringBuilder sb) {
        String dimNumber = (String)this.allVals.get("dimensionlist");
        sb.append(dimNumber);
        sb.append(',');
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmember");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            sb.append(childFun.genNewFunParseStr());
        } else {
            String memberNumber = (String)this.allVals.get("dimmember");
            sb.append('`');
            sb.append(memberNumber);
            sb.append('`');
        }
        sb.append(',');
        sb.append('`');
        sb.append(this.allVals.get("attribute"));
        sb.append('`');
    }

    @Override
    public FunctionRefMember genRefMember(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        FunctionRefMember functionRefMember;
        String dimNumber = (String)this.allVals.get("dimensionlist");
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmember");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            functionRefMember = childFun.genRefMember(leftMemberScope, modelCache, viewMap);
        } else {
            functionRefMember = new FunctionRefMember();
            functionRefMember.setDimNumber(dimNumber);
            String memberNumber = (String)this.allVals.get("dimmember");
            HashSet<String> members = new HashSet<String>(16);
            members.add(memberNumber);
            functionRefMember.setMembers(members);
        }
        String attribute = (String)this.allVals.get("attribute");
        functionRefMember.getRefPropSet().add(attribute);
        return functionRefMember;
    }

    @Override
    public Set<String> analyzeRealMember(IModelCacheHelper modelCache, Map<String, Long> viewMap, String dimNumber, Map<String, Set<String>> currMemberMap, Map<String, String> leftMemberMap, Long currDataSetId) {
        Set<String> memNumber = currMemberMap.get(dimNumber);
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmember");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            memNumber = childFun.analyzeRealMember(modelCache, viewMap, dimNumber, currMemberMap, leftMemberMap, currDataSetId);
        }
        return memNumber;
    }

    @Override
    public List<MemberQuoteDao> genFunctionRefQuote(Long modelId, Long bizctrlrangeidLong, Long ruleId) {
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmember");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            return childFun.genFunctionRefQuote(modelId, bizctrlrangeidLong, ruleId);
        }
        String dimNumber = (String)this.allVals.get("dimensionlist");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        String memNumber = (String)this.allVals.get("dimmember");
        String viewIdStr = (String)this.allVals.get("allvals_view_id");
        Long viewId = IDUtils.toLong(viewIdStr);
        Member member = dimension.getMember(viewId, memNumber);
        MemberQuoteDao memberQuoteDao = new MemberQuoteDao(modelId, bizctrlrangeidLong, dimension.getId(), member.getId(), MemberQuoteResourceEnum.BizRule, ruleId);
        RuleFunctionUtils.putMemberQuoteViewMap(member.getId(), viewId, memberQuoteDao);
        return Lists.newArrayList((Object[])new MemberQuoteDao[]{memberQuoteDao});
    }

    @Override
    public CustomPropertyValue handleAttributeValueGenRefMember(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        String dimNumber = (String)this.allVals.get("dimensionlist");
        Dimension dimension = modelCache.getDimension(dimNumber);
        String attribute = (String)this.allVals.get("attribute");
        FunctionRefMember functionRefMember = this.genRefMember(leftMemberScope, modelCache, viewMap);
        Set<String> memberNumbers = functionRefMember.getMembers();
        if (CollectionUtils.isEmpty(memberNumbers)) {
            return null;
        }
        Long viewId = this.getDimensionViewId(this.allVals, dimNumber, viewMap);
        Member member = dimension.getMember(viewId, memberNumbers.iterator().next());
        if (member == null) {
            return null;
        }
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate(modelCache.getModelobj().getId());
        return memberPropCache.getPropertyValueByMemNumber(dimNumber, attribute, member.getNumber());
    }

    @Override
    public CustomPropertyValue handleAttributeValueByAnalyzeRealMember(IModelCacheHelper modelCache, Map<String, Long> viewMap, String dimNumber, Set<String> refMembers, Map<String, String> leftMemberMap, Long currDataSetId, Map<String, Set<String>> currMemberMap) {
        Dimension dimension = modelCache.getDimension(dimNumber);
        String attribute = (String)this.allVals.get("attribute");
        Set<String> memberNumbers = this.analyzeRealMember(modelCache, viewMap, dimNumber, currMemberMap, leftMemberMap, currDataSetId);
        if (CollectionUtils.isEmpty(memberNumbers)) {
            return null;
        }
        Long viewId = this.getDimensionViewId(this.allVals, dimNumber, viewMap);
        Member member = dimension.getMember(viewId, memberNumbers.iterator().next());
        if (member == null) {
            return null;
        }
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate(modelCache.getModelobj().getId());
        return memberPropCache.getPropertyValueByMemNumber(dimNumber, attribute, member.getNumber());
    }

    @Override
    public CustomPropertyValue handleAttributeValueGenFunctionRefQuote(Long modelId, Long bizctrlrangeidLong, Long ruleId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        String dimNumber = (String)this.allVals.get("dimensionlist");
        Dimension dimension = modelCache.getDimension(dimNumber);
        String attribute = (String)this.allVals.get("attribute");
        List<MemberQuoteDao> memberQuoteDaos = this.genFunctionRefQuote(modelId, bizctrlrangeidLong, ruleId);
        if (CollectionUtils.isEmpty(memberQuoteDaos) || CollectionUtils.isEmpty(memberQuoteDaos.get(0).getMemberIds())) {
            return null;
        }
        Set<Long> memberIds = memberQuoteDaos.get(0).getMemberIds();
        Long viewId = this.getDimensionViewId(this.allVals, dimNumber, Collections.emptyMap());
        Member member = dimension.getMember(viewId, memberIds.iterator().next());
        if (member == null) {
            return null;
        }
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate(modelCache.getModelobj().getId());
        return memberPropCache.getPropertyValueByMemNumber(dimNumber, attribute, member.getNumber());
    }
}

