/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.ruleFunction;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.rule.ruleFunction.FunctionRefMember;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;

public class IsAttributeRuleFunction
extends RuleFunction {
    public IsAttributeRuleFunction(String functionName) {
        super(functionName);
    }

    public IsAttributeRuleFunction(String functionKey, String functionInfoStr, String functionName) {
        super(functionKey, functionInfoStr, functionName);
    }

    @Override
    public String genNewFunParseStr() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(this.functionName);
        sb.append('[').append(this.functionKey).append(']').append('(');
        this.dealIsAttributeVal(sb);
        sb.append(')');
        return sb.toString();
    }

    private void dealIsAttributeVal(StringBuilder sb) {
        String dimNumber = (String)this.allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        sb.append(dimNumber);
        sb.append(',');
        sb.append('`');
        sb.append(this.allVals.get("attribute"));
        sb.append('`');
        sb.append(',');
        sb.append('`');
        sb.append(this.allVals.get(FunctionItemEnum.ATTRIBUTEVAL.getKey()));
        sb.append('`');
    }

    @Override
    public FunctionRefMember genRefMember(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        String dimNumber = (String)this.allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        FunctionRefMember functionRefMember = new FunctionRefMember();
        functionRefMember.setDimNumber(dimNumber);
        functionRefMember.setSkip(true);
        functionRefMember.setLoop(true);
        Set<String> memberNumSet = leftMemberScope.get(dimNumber);
        if (memberNumSet == null) {
            functionRefMember.setAllMember(true);
            functionRefMember.setMembers(Sets.newLinkedHashSet());
        } else {
            functionRefMember.setMembers(memberNumSet);
        }
        String attribute = (String)this.allVals.get("attribute");
        functionRefMember.getRefPropSet().add(attribute);
        return functionRefMember;
    }

    @Override
    public Set<String> analyzeRealMember(IModelCacheHelper modelCache, Map<String, Long> viewMap, String dimNumber, Map<String, Set<String>> currMemberMap, Map<String, String> leftMemberMap, Long currDataSetId) {
        return currMemberMap.get(dimNumber);
    }

    @Override
    public List<MemberQuoteDao> genFunctionRefQuote(Long modelId, Long bizctrlrangeidLong, Long ruleId) {
        LinkedList memberQuoteList = Lists.newLinkedList();
        String dimNumber = (String)this.allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Dimension dimension = modelCacheHelper.getDimension(dimNumber);
        String attribute = (String)this.allVals.get(FunctionItemEnum.ATTRIBUTE.getKey());
        String attributeVal = (String)this.allVals.get(FunctionItemEnum.ATTRIBUTEVAL.getKey());
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate(modelId);
        CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(dimNumber, attribute, attributeVal);
        if (propertyValue != null) {
            memberQuoteList.add(new MemberQuoteDao(modelId, bizctrlrangeidLong, dimension.getId(), propertyValue.getId(), MemberTypeEnum.ATTRIBUTEVALUE, MemberQuoteResourceEnum.BizRule, ruleId));
        }
        return memberQuoteList;
    }
}

