/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.ruleFunction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.rule.ruleFunction.FunctionRefMember;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ListRuleFunction
extends RuleFunction {
    public ListRuleFunction(String functionName) {
        super(functionName);
    }

    public ListRuleFunction(String functionKey, String functionInfoStr, String functionName) {
        super(functionKey, functionInfoStr, functionName);
    }

    @Override
    public String genNewFunParseStr() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(this.functionName);
        sb.append('[').append(this.functionKey).append(']').append('(');
        LambdaUtils.run(() -> {
            String dimNumber = (String)this.allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
            sb.append(dimNumber);
            sb.append(',');
            if (this.allVals.containsKey("childIsFun")) {
                String funStr = (String)this.allVals.get(FunctionItemEnum.DIMEMBERRANGE.getKey());
                RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
                sb.append(childFun.genNewFunParseStr());
            } else {
                sb.append("RangeMemberSetFun");
            }
        });
        sb.append(')');
        return sb.toString();
    }

    @Override
    public FunctionRefMember genRefMember(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        FunctionRefMember functionRefMember;
        String dimNumber = (String)this.allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get(FunctionItemEnum.DIMEMBERRANGE.getKey());
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            functionRefMember = childFun.genRefMember(leftMemberScope, modelCache, viewMap);
        } else {
            functionRefMember = new FunctionRefMember();
            functionRefMember.setDimNumber(dimNumber);
            Set memberNumberStringSet = LambdaUtils.get(() -> {
                String memberNumber = (String)this.allVals.get(FunctionItemEnum.DIMEMBERRANGE.getKey());
                List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)memberNumber);
                Pair<List<MemberCondition>, List<MemberCondition>> matchedAndNotMatchedListPair = LambdaUtils.getMatchedAndNotMatchedListPair(memberConditionList, item -> !Boolean.TRUE.equals(item.getRemoveBoolean()));
                List normalMemberConditionList = (List)matchedAndNotMatchedListPair.getLeft();
                Set normalMemberNumberStringSet = normalMemberConditionList.stream().map(item -> modelCache.getMember(dimNumber, IDUtils.toLong(item.getViewId()), item.getNumber(), Integer.parseInt(item.getRange())).stream().map(BaseCache::getNumber).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
                List removeMemberConditionList = (List)matchedAndNotMatchedListPair.getRight();
                if (CollectionUtils.isEmpty((Collection)removeMemberConditionList)) {
                    return normalMemberNumberStringSet;
                }
                Set removeMemberNumberStringSet = removeMemberConditionList.stream().map(item -> modelCache.getMember(dimNumber, IDUtils.toLong(item.getViewId()), item.getNumber(), Integer.parseInt(item.getRange())).stream().map(BaseCache::getNumber).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
                normalMemberNumberStringSet.removeAll(removeMemberNumberStringSet);
                return normalMemberNumberStringSet;
            });
            functionRefMember.setMembers(memberNumberStringSet);
        }
        return functionRefMember;
    }

    @Override
    public Set<String> analyzeRealMember(IModelCacheHelper modelCache, Map<String, Long> viewMap, String dimNumber, Map<String, Set<String>> currMemberMap, Map<String, String> leftMemberMap, Long currDataSetId) {
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get(FunctionItemEnum.DIMEMBERRANGE.getKey());
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            return childFun.analyzeRealMember(modelCache, viewMap, dimNumber, currMemberMap, leftMemberMap, currDataSetId);
        }
        String memberNumber = (String)this.allVals.get(FunctionItemEnum.DIMEMBERRANGE.getKey());
        List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)memberNumber);
        Pair<List<MemberCondition>, List<MemberCondition>> matchedAndNotMatchedListPair = LambdaUtils.getMatchedAndNotMatchedListPair(memberConditionList, item -> !Boolean.TRUE.equals(item.getRemoveBoolean()));
        List normalMemberConditionList = (List)matchedAndNotMatchedListPair.getLeft();
        Set<String> normalMemberNumberStringSet = normalMemberConditionList.stream().map(item -> modelCache.getMember(dimNumber, IDUtils.toLong(item.getViewId()), item.getNumber(), Integer.parseInt(item.getRange())).stream().map(BaseCache::getNumber).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
        List removeMemberConditionList = (List)matchedAndNotMatchedListPair.getRight();
        if (CollectionUtils.isEmpty((Collection)removeMemberConditionList)) {
            return normalMemberNumberStringSet;
        }
        Set removeMemberNumberStringSet = removeMemberConditionList.stream().map(item -> modelCache.getMember(dimNumber, IDUtils.toLong(item.getViewId()), item.getNumber(), Integer.parseInt(item.getRange())).stream().map(BaseCache::getNumber).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
        normalMemberNumberStringSet.removeAll(removeMemberNumberStringSet);
        return normalMemberNumberStringSet;
    }

    @Override
    public List<MemberQuoteDao> genFunctionRefQuote(Long modelId, Long bizctrlrangeidLong, Long ruleId) {
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get(FunctionItemEnum.DIMEMBERRANGE.getKey());
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            return childFun.genFunctionRefQuote(modelId, bizctrlrangeidLong, ruleId);
        }
        String dimNumber = (String)this.allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        String dimmemberrangeString = (String)this.allVals.get(FunctionItemEnum.DIMEMBERRANGE.getKey());
        List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)dimmemberrangeString);
        ArrayList memberIds = Lists.newArrayListWithExpectedSize((int)memberConditionList.size());
        Long viewId = IDUtils.toLong(((MemberCondition)memberConditionList.get(0)).getViewId());
        for (MemberCondition memberCondition : memberConditionList) {
            Member member = dimension.getMember(IDUtils.toLong(memberCondition.getViewId()), memberCondition.getNumber());
            memberIds.add(member.getId());
        }
        MemberQuoteDao memberQuoteDao = new MemberQuoteDao(modelId, bizctrlrangeidLong, dimension.getId(), memberIds, MemberQuoteResourceEnum.BizRule, ruleId);
        for (Long memberId : memberIds) {
            RuleFunctionUtils.putMemberQuoteViewMap(memberId, viewId, memberQuoteDao);
        }
        return Lists.newArrayList((Object[])new MemberQuoteDao[]{memberQuoteDao});
    }
}

