/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.ruleFunction;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.rule.ruleFunction.FunctionRefMember;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;

public class ParentRuleFunction
extends RuleFunction {
    public ParentRuleFunction(String functionName) {
        super(functionName);
    }

    public ParentRuleFunction(String functionKey, String functionInfoStr, String functionName) {
        super(functionKey, functionInfoStr, functionName);
    }

    @Override
    public String genNewFunParseStr() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(this.functionName);
        sb.append('[').append(this.functionKey).append(']').append('(');
        this.dealParentVal(sb);
        sb.append(')');
        return sb.toString();
    }

    private void dealParentVal(StringBuilder sb) {
        String dimNumber = (String)this.allVals.get("dimensionlist");
        sb.append(dimNumber);
        sb.append(',');
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmember");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            sb.append(childFun.genNewFunParseStr());
        } else {
            String memberNumber = (String)this.allVals.get("dimmember");
            sb.append('`');
            sb.append(memberNumber);
            sb.append('`');
        }
    }

    @Override
    public FunctionRefMember genRefMember(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        LinkedHashSet members;
        FunctionRefMember functionRefMember;
        String dimNumber = (String)this.allVals.get("dimensionlist");
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmember");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            functionRefMember = childFun.genRefMember(leftMemberScope, modelCache, viewMap);
        } else {
            functionRefMember = new FunctionRefMember();
            functionRefMember.setDimNumber(dimNumber);
            String memberNumber = (String)this.allVals.get("dimmember");
            members = new HashSet(16);
            members.add(memberNumber);
            functionRefMember.setMembers(members);
        }
        Set<String> childMembers = functionRefMember.getMembers();
        members = Sets.newLinkedHashSet();
        Long viewId = this.getDimensionViewId(this.allVals, dimNumber, viewMap);
        for (String memNum : childMembers) {
            Member member = modelCache.getMember(dimNumber, viewId, memNum);
            Member parent = modelCache.getParent(viewId, member);
            if (parent == null) continue;
            members.add(parent.getNumber());
        }
        functionRefMember.setMembers(members);
        return functionRefMember;
    }

    @Override
    public Set<String> analyzeRealMember(IModelCacheHelper modelCache, Map<String, Long> viewMap, String dimNumber, Map<String, Set<String>> currMemberMap, Map<String, String> leftMemberMap, Long currDataSetId) {
        Set<String> memNumber = currMemberMap.get(dimNumber);
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmember");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            memNumber = childFun.analyzeRealMember(modelCache, viewMap, dimNumber, currMemberMap, leftMemberMap, currDataSetId);
        }
        LinkedHashSet members = Sets.newLinkedHashSet();
        Long viewId = this.getDimensionViewId(this.allVals, dimNumber, viewMap);
        for (String memNum : memNumber) {
            Member member = modelCache.getMember(dimNumber, viewId, memNum);
            Member parent = modelCache.getParent(viewId, member);
            if (parent == null) continue;
            members.add(parent.getNumber());
        }
        return members;
    }

    @Override
    public List<MemberQuoteDao> genFunctionRefQuote(Long modelId, Long bizctrlrangeidLong, Long ruleId) {
        if (this.allVals.containsKey("childIsFun")) {
            return null;
        }
        String dimNumber = (String)this.allVals.get("dimensionlist");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        String memNumber = (String)this.allVals.get("dimmember");
        Long viewId = this.getDimensionViewId(this.allVals, dimNumber, Collections.emptyMap());
        Member member = dimension.getMember(viewId, memNumber);
        MemberQuoteDao memberQuoteDao = new MemberQuoteDao(modelId, bizctrlrangeidLong, dimension.getId(), member.getId(), MemberQuoteResourceEnum.BizRule, ruleId);
        RuleFunctionUtils.putMemberQuoteViewMap(member.getId(), viewId, memberQuoteDao);
        return Lists.newArrayList((Object[])new MemberQuoteDao[]{memberQuoteDao});
    }
}

