/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.ruleFunction;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.rule.ruleFunction.FunctionRefMember;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;

public class RelativeRuleFunction
extends RuleFunction {
    public RelativeRuleFunction(String functionName) {
        super(functionName);
    }

    public RelativeRuleFunction(String functionKey, String functionInfoStr, String functionName) {
        super(functionKey, functionInfoStr, functionName);
    }

    @Override
    public String genNewFunParseStr() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(this.functionName);
        sb.append('[').append(this.functionKey).append(']').append('(');
        this.dealRelativeVal(sb);
        sb.append(')');
        return sb.toString();
    }

    private void dealRelativeVal(StringBuilder sb) {
        String dimNumber = (String)this.allVals.get("dimensionlist");
        sb.append(dimNumber);
        sb.append(',');
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmember");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            sb.append(childFun.genNewFunParseStr());
        } else {
            sb.append("SimpleMemberSetFun");
        }
    }

    @Override
    public FunctionRefMember genRefMember(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        LinkedHashSet members;
        FunctionRefMember functionRefMember;
        String dimNumber = (String)this.allVals.get("dimensionlist");
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmember");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            functionRefMember = childFun.genRefMember(leftMemberScope, modelCache, viewMap);
        } else {
            String[] split;
            Long viewId = this.getDimensionViewId(this.allVals, dimNumber, viewMap);
            functionRefMember = new FunctionRefMember();
            functionRefMember.setDimNumber(dimNumber);
            members = new HashSet(16);
            functionRefMember.setMembers(members);
            String memberNumbers = (String)this.allVals.get("dimmember");
            for (String memberNumber : split = memberNumbers.split(",")) {
                List<Member> member = modelCache.getMember(dimNumber, viewId, memberNumber, RangeEnum.ALL_DETAIL.getIndex());
                Set collect = member.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                members.addAll(collect);
            }
        }
        Set<String> childMembers = functionRefMember.getMembers();
        members = Sets.newLinkedHashSet();
        Long viewId = this.getDimensionViewId(this.allVals, dimNumber, viewMap);
        for (String childMember : childMembers) {
            List<Member> leafMembers = modelCache.getMember(dimNumber, viewId, childMember, RangeEnum.ALL_DETAIL.getIndex());
            Set memNumbers = leafMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            members.addAll(memNumbers);
        }
        functionRefMember.setMembers(members);
        return functionRefMember;
    }

    @Override
    public Set<String> analyzeRealMember(IModelCacheHelper modelCache, Map<String, Long> viewMap, String dimNumber, Map<String, Set<String>> currMemberMap, Map<String, String> leftMemberMap, Long currDataSetId) {
        Set<String> memNumber = currMemberMap.get(dimNumber);
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmember");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            memNumber = childFun.analyzeRealMember(modelCache, viewMap, dimNumber, currMemberMap, leftMemberMap, currDataSetId);
        }
        LinkedHashSet members = Sets.newLinkedHashSet();
        Long viewId = this.getDimensionViewId(this.allVals, dimNumber, viewMap);
        for (String childMember : memNumber) {
            List<Member> leafMembers = modelCache.getMember(dimNumber, viewId, childMember, RangeEnum.ALL_DETAIL.getIndex());
            Set memNumbers = leafMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            members.addAll(memNumbers);
        }
        return members;
    }

    @Override
    public List<MemberQuoteDao> genFunctionRefQuote(Long modelId, Long bizctrlrangeidLong, Long ruleId) {
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get("dimmember");
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            return childFun.genFunctionRefQuote(modelId, bizctrlrangeidLong, ruleId);
        }
        String dimNumber = (String)this.allVals.get("dimensionlist");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        String memberNumbers = (String)this.allVals.get("dimmember");
        String[] split = memberNumbers.split(",");
        ArrayList memberIds = Lists.newArrayListWithExpectedSize((int)split.length);
        Long viewId = this.getDimensionViewId(this.allVals, dimNumber, Collections.emptyMap());
        for (String memberNumber : split) {
            Member member = dimension.getMember(viewId, memberNumber);
            memberIds.add(member.getId());
        }
        MemberQuoteDao memberQuoteDao = new MemberQuoteDao(modelId, bizctrlrangeidLong, dimension.getId(), memberIds, MemberQuoteResourceEnum.BizRule, ruleId);
        for (Long memberId : memberIds) {
            RuleFunctionUtils.putMemberQuoteViewMap(memberId, viewId, memberQuoteDao);
        }
        return Lists.newArrayList((Object[])new MemberQuoteDao[]{memberQuoteDao});
    }
}

