/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.ruleFunction;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.rule.ruleFunction.AncestorRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.AttributeRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.ChildrenRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.CurrMBRRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.DateRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.GetAttributeRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.GetNameRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.GetNumberRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.IsAttributeRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.ListRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.MemberRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.ParentRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RelativeRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.SiblingRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.YearValueRuleFunction;
import org.jetbrains.annotations.NotNull;

public class RuleFunctionFactory {
    public static RuleFunction getFunction(@NotNull String functionName) {
        RuleFunctionEnum functionEnum = RuleFunctionEnum.getFunctionEnumByName(functionName);
        switch (functionEnum) {
            case Attribute: {
                return new AttributeRuleFunction(functionName);
            }
            case IsAttribute: {
                return new IsAttributeRuleFunction(functionName);
            }
            case GetAttribute: {
                return new GetAttributeRuleFunction(functionName);
            }
            case Sibling: {
                return new SiblingRuleFunction(functionName);
            }
            case Children: {
                return new ChildrenRuleFunction(functionName);
            }
            case Relative: {
                return new RelativeRuleFunction(functionName);
            }
            case Ancestor: {
                return new AncestorRuleFunction(functionName);
            }
            case Parent: {
                return new ParentRuleFunction(functionName);
            }
            case CurrMBR: {
                return new CurrMBRRuleFunction(functionName);
            }
            case List: {
                return new ListRuleFunction(functionName);
            }
            case Date: {
                return new DateRuleFunction(functionName);
            }
            case YearValue: {
                return new YearValueRuleFunction(functionName);
            }
            case GetNumber: {
                return new GetNumberRuleFunction(functionName);
            }
            case GetName: {
                return new GetNameRuleFunction(functionName);
            }
            case Member: {
                return new MemberRuleFunction(functionName);
            }
        }
        return new RuleFunction(functionName);
    }

    public static RuleFunction getFunction(@NotNull String functionKey, String functionInfoStr, @NotNull String functionName) {
        RuleFunctionEnum functionEnum = RuleFunctionEnum.getFunctionEnumByName(functionName);
        switch (functionEnum) {
            case Attribute: {
                return new AttributeRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case GetAttribute: {
                return new GetAttributeRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case IsAttribute: {
                return new IsAttributeRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case Sibling: {
                return new SiblingRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case Children: {
                return new ChildrenRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case Relative: {
                return new RelativeRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case Ancestor: {
                return new AncestorRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case Parent: {
                return new ParentRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case CurrMBR: {
                return new CurrMBRRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case List: {
                return new ListRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case Date: {
                return new DateRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case YearValue: {
                return new YearValueRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case GetNumber: {
                return new GetNumberRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case GetName: {
                return new GetNameRuleFunction(functionKey, functionInfoStr, functionName);
            }
            case Member: {
                return new MemberRuleFunction(functionKey, functionInfoStr, functionName);
            }
        }
        return new RuleFunction(functionKey, functionInfoStr, functionName);
    }

    public static RuleFunction fromJsonString(String funStr) {
        RuleFunction ruleFunction = (RuleFunction)SerializationUtils.fromJsonString((String)funStr, RuleFunction.class);
        return RuleFunctionFactory.getRealFunction(ruleFunction);
    }

    public static RuleFunction getRealFunction(RuleFunction ruleFunction) {
        String functionName = ruleFunction.getFunctionName();
        RuleFunctionEnum functionEnum = RuleFunctionEnum.getFunctionEnumByName(functionName);
        switch (functionEnum) {
            case Attribute: {
                return RuleFunctionFactory.toChildFun(new AttributeRuleFunction(functionName), ruleFunction);
            }
            case GetAttribute: {
                return RuleFunctionFactory.toChildFun(new GetAttributeRuleFunction(functionName), ruleFunction);
            }
            case IsAttribute: {
                return RuleFunctionFactory.toChildFun(new IsAttributeRuleFunction(functionName), ruleFunction);
            }
            case Sibling: {
                return RuleFunctionFactory.toChildFun(new SiblingRuleFunction(functionName), ruleFunction);
            }
            case Children: {
                return RuleFunctionFactory.toChildFun(new ChildrenRuleFunction(functionName), ruleFunction);
            }
            case Relative: {
                return RuleFunctionFactory.toChildFun(new RelativeRuleFunction(functionName), ruleFunction);
            }
            case Ancestor: {
                return RuleFunctionFactory.toChildFun(new AncestorRuleFunction(functionName), ruleFunction);
            }
            case Parent: {
                return RuleFunctionFactory.toChildFun(new ParentRuleFunction(functionName), ruleFunction);
            }
            case CurrMBR: {
                return RuleFunctionFactory.toChildFun(new CurrMBRRuleFunction(functionName), ruleFunction);
            }
            case List: {
                return RuleFunctionFactory.toChildFun(new ListRuleFunction(functionName), ruleFunction);
            }
            case Date: {
                return RuleFunctionFactory.toChildFun(new DateRuleFunction(functionName), ruleFunction);
            }
            case YearValue: {
                return RuleFunctionFactory.toChildFun(new YearValueRuleFunction(functionName), ruleFunction);
            }
            case GetNumber: {
                return RuleFunctionFactory.toChildFun(new GetNumberRuleFunction(functionName), ruleFunction);
            }
            case GetName: {
                return RuleFunctionFactory.toChildFun(new GetNameRuleFunction(functionName), ruleFunction);
            }
            case Member: {
                return RuleFunctionFactory.toChildFun(new MemberRuleFunction(functionName), ruleFunction);
            }
        }
        return ruleFunction;
    }

    private static RuleFunction toChildFun(RuleFunction childFun, RuleFunction ruleFunction) {
        childFun.setFunctionKey(ruleFunction.getFunctionKey());
        childFun.setFunctionShowStr(ruleFunction.getFunctionShowStr());
        childFun.setBizRuleId(ruleFunction.getBizRuleId());
        childFun.setAllVals(ruleFunction.getAllVals());
        return childFun;
    }
}

