/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.ruleFunction;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.PeriodEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.BGCells;
import kd.epm.eb.common.olapdao.BgmdOlapReader;
import kd.epm.eb.common.olapdao.BgmdShrekDao;
import kd.epm.eb.common.olapdao.OlapReadOption;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RuleFunctionUtils {
    public static String getFunctionShowString(List<MemberCondition> memberConditionList) {
        if (CollectionUtils.isEmpty(memberConditionList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u79fb\u9664\u72b6\u6001\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u53ef\u4e3a\u7a7a", (String)"RuleFunctionEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Pair<List<MemberCondition>, List<MemberCondition>> matchedAndNotMatchedListPair = LambdaUtils.getMatchedAndNotMatchedListPair(memberConditionList, item -> !Boolean.TRUE.equals(item.getRemoveBoolean()));
        List normalMemberConditionList = (List)matchedAndNotMatchedListPair.getLeft();
        if (CollectionUtils.isEmpty((Collection)normalMemberConditionList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u79fb\u9664\u72b6\u6001\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u53ef\u4e3a\u7a7a", (String)"RuleFunctionEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String normalFunctionShowString = normalMemberConditionList.stream().map(item -> item.getName() + "." + RangeEnum.getRangeByVal(Integer.parseInt(item.getRange())).getName()).collect(Collectors.joining(","));
        List removeMemberConditionList = (List)matchedAndNotMatchedListPair.getRight();
        if (CollectionUtils.isEmpty((Collection)removeMemberConditionList)) {
            return normalFunctionShowString;
        }
        return normalFunctionShowString + removeMemberConditionList.stream().map(item -> item.getName() + "." + RangeEnum.getRangeByVal(Integer.parseInt(item.getRange())).getName()).collect(Collectors.joining(",", ",Remove(", ")"));
    }

    public static String getRelationDimNumber(String relationStr) {
        String dimNumber = "";
        if (StringUtils.isEmpty(relationStr)) {
            return dimNumber;
        }
        RuleFunction childFun = RuleFunctionFactory.fromJsonString(relationStr);
        Map<String, Object> allValues = childFun.getAllValues();
        dimNumber = (String)allValues.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        return dimNumber;
    }

    public static void putInChildFun(Map<String, RuleFunction> newFunctionMap, RuleFunction ruleFunction) {
        Map<String, Object> allValues = ruleFunction.getAllValues();
        if (allValues.containsKey("childIsFun")) {
            String funStr3;
            String funStr2;
            String funStr = (String)allValues.get("dimmember");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)funStr)) {
                RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
                newFunctionMap.put(childFun.getFunctionKey(), childFun);
                RuleFunctionUtils.putInChildFun(newFunctionMap, childFun);
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(funStr2 = (String)allValues.get("dimmemberrange")))) {
                RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr2);
                newFunctionMap.put(childFun.getFunctionKey(), childFun);
                RuleFunctionUtils.putInChildFun(newFunctionMap, childFun);
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(funStr3 = (String)allValues.get(FunctionItemEnum.RELATIONFUN.getKey())))) {
                RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr3);
                newFunctionMap.put(childFun.getFunctionKey(), childFun);
                RuleFunctionUtils.putInChildFun(newFunctionMap, childFun);
            }
        }
    }

    public static void removeCtControlMem(String dimNumber, Set<String> leafMembers) {
        if (SysDimensionEnum.ChangeType.getNumber().equals(dimNumber) && CollectionUtils.isNotEmpty(leafMembers)) {
            Set<String> memberNumSet = RuleFunctionUtils.getCtControlMemSet();
            leafMembers.removeAll(memberNumSet);
        }
    }

    public static Set<String> getCtControlMemSet() {
        return Sets.newHashSet((Object[])new String[]{"Occupation", "Execute"});
    }

    public static void putMemberQuoteViewMap(Long memberId, Long viewId, MemberQuoteDao memberQuoteDao) {
        if (memberQuoteDao == null || IDUtils.isEmptyLong(memberId).booleanValue() || IDUtils.isEmptyLong(viewId).booleanValue()) {
            return;
        }
        memberQuoteDao.getMemberViewMap().put(memberId, viewId);
    }

    public static Map<String, Long> getRuleViewMapByViewNumber(IModelCacheHelper modelCacheHelper, String ruleViewStr, Set<String> scopeHasViewDimSet, String number, Set<String> hasViewDimSet) {
        if (CollectionUtils.isNotEmpty(hasViewDimSet) && StringUtils.isEmpty(ruleViewStr)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219%1\u7684\u89c6\u56fe\u6570\u636e\u9700\u8981\u5347\u7ea7\uff0c\u8bf7\u5728\u89c4\u5219\u5217\u8868\u5347\u7ea7\u65e7\u89c4\u5219\u3002", (String)"RuleManageQueryOp_12", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
        }
        Map ruleView = JsonUtils.readValue(ruleViewStr, Map.class);
        scopeHasViewDimSet.removeAll(ruleView.keySet());
        if (CollectionUtils.isNotEmpty(scopeHasViewDimSet)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219%1\u7684\u89c6\u56fe\u6570\u636e\u9700\u8981\u5347\u7ea7\uff0c\u8bf7\u5728\u89c4\u5219\u5217\u8868\u5347\u7ea7\u65e7\u89c4\u5219\u3002", (String)"RuleManageQueryOp_12", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
        }
        hasViewDimSet.removeAll(ruleView.keySet());
        if (CollectionUtils.isNotEmpty(hasViewDimSet)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219%1\u7684\u89c6\u56fe\u6570\u636e\u9700\u8981\u5347\u7ea7\uff0c\u8bf7\u5728\u89c4\u5219\u5217\u8868\u5347\u7ea7\u65e7\u89c4\u5219\u3002", (String)"RuleManageQueryOp_12", (String)"epm-eb-formplugin", (Object[])new Object[]{number}));
        }
        HashMap<String, Long> ruleViewIdMap = new HashMap<String, Long>(16);
        ruleView.forEach((dimNum, viewNum) -> {
            Dimension dimension = modelCacheHelper.getDimension((String)dimNum);
            List<Long> viewList = dimension.getViewList();
            for (Long viewId : viewList) {
                View view = dimension.getView(viewId);
                if (view == null || !viewNum.equals(view.getNumber())) continue;
                ruleViewIdMap.put((String)dimNum, view.getId());
                break;
            }
        });
        return ruleViewIdMap;
    }

    public static List<BGCell> queryList(IModelCacheHelper modelCache, Long datasetId, Map<String, Set<String>> dimMemberMap) {
        List<String> selectDims = Arrays.asList(modelCache.getDimensionNums(datasetId));
        ArrayList datas = Lists.newArrayListWithExpectedSize((int)1024);
        try (BgmdOlapReader reader = RuleFunctionUtils.queryReader(modelCache, dimMemberMap, datasetId, selectDims);){
            while (reader.hasNext()) {
                Object[] row = reader.next();
                if (row[0] == null) continue;
                datas.add(BGCells.of(row, selectDims));
            }
        }
        return datas;
    }

    private static BgmdOlapReader queryReader(IModelCacheHelper modelCache, Map<String, Set<String>> dimMemberMap, Long datasetId, List<String> selectDims) {
        Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(datasetId);
        String cubeNumber = "CUBE" + dataSet.getNumber() + dataSet.getId();
        HashMap<String, Set<String>> newDimMemberMap = new HashMap<String, Set<String>>(16);
        HashSet<String> selectDimSet = new HashSet<String>(selectDims);
        dimMemberMap.forEach((dim, memSet) -> {
            if (selectDimSet.contains(dim)) {
                newDimMemberMap.put((String)dim, (Set<String>)memSet);
            }
        });
        return BgmdShrekDao.getInstance().read(modelCache.getModelobj(), cubeNumber, newDimMemberMap, selectDims, new OlapReadOption());
    }

    public static Set<String> getYearValueBpNumberSet(IModelCacheHelper modelCache, Map<String, Object> allVals, Set<String> memberNums) {
        HashSet<String> bpSet = new HashSet<String>(16);
        if (CollectionUtils.isEmpty(memberNums) || allVals == null || !allVals.containsKey(FunctionItemEnum.YEAROFFSET.getKey()) || !allVals.containsKey(FunctionItemEnum.SPECIFIEDPERIOD.getKey())) {
            return bpSet;
        }
        for (String memberNum : memberNums) {
            String yearOffset = (String)allVals.get(FunctionItemEnum.YEAROFFSET.getKey());
            Member memberOffset = modelCache.getMemberOffsetByLevel(SysDimensionEnum.BudgetPeriod.getNumber(), null, memberNum, Integer.parseInt(yearOffset), 2);
            if (memberOffset == null) continue;
            bpSet.add(RuleFunctionUtils.getYearValueBpNumber(allVals, memberOffset));
        }
        return bpSet;
    }

    public static String getYearValueBpNumber(Map<String, Object> allVals, Member memberOffset) {
        String specifiedPeriod = (String)allVals.get(FunctionItemEnum.SPECIFIEDPERIOD.getKey());
        PeriodEnum enumByKey = PeriodEnum.getEnumByKey(specifiedPeriod);
        String number = memberOffset.getNumber() + ".";
        number = enumByKey == PeriodEnum.Y ? memberOffset.getNumber() : number + enumByKey.getKey();
        return number;
    }
}

