/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.ruleFunction;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.rule.ruleFunction.FunctionRefMember;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import org.apache.commons.collections4.CollectionUtils;

public class YearValueRuleFunction
extends RuleFunction {
    public YearValueRuleFunction(String functionName) {
        super(functionName);
    }

    public YearValueRuleFunction(String functionKey, String functionInfoStr, String functionName) {
        super(functionKey, functionInfoStr, functionName);
    }

    @Override
    public String genNewFunParseStr() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(this.functionName);
        sb.append('[').append(this.functionKey).append(']').append('(');
        this.dealYearValueVal(sb);
        sb.append(')');
        return sb.toString();
    }

    private void dealYearValueVal(StringBuilder sb) {
        String account = (String)this.allVals.get("account");
        FormulaMemberPojo accountMemberPojo = JsonUtils.readValue(account, FormulaMemberPojo.class);
        sb.append("MBR:[");
        sb.append(accountMemberPojo.getMemberKey());
        sb.append("]");
        sb.append(',');
        sb.append('\'');
        sb.append(this.allVals.get("yearoffset"));
        sb.append('\'');
        sb.append(',');
        sb.append('\'');
        sb.append(this.allVals.get("specifiedperiod"));
        sb.append('\'');
        sb.append(',');
        sb.append('\'');
        String funStr = (String)this.allVals.get(FunctionItemEnum.RELATIONFUN.getKey());
        if (StringUtils.isNotEmpty(funStr)) {
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            sb.append(childFun.genNewFunParseStr());
        }
        sb.append('\'');
    }

    @Override
    public FunctionRefMember genRefMember(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        FunctionRefMember functionRefMember = super.genRefMember(leftMemberScope, modelCache, viewMap);
        functionRefMember.setDimNumber(SysDimensionEnum.BudgetPeriod.getNumber());
        functionRefMember.setLoop(false);
        functionRefMember.setSkip(true);
        Set<String> memberNums = leftMemberScope.get(SysDimensionEnum.BudgetPeriod.getNumber());
        if (memberNums == null) {
            functionRefMember.setAllMember(true);
            functionRefMember.setMembers(Sets.newLinkedHashSet());
        } else {
            Integer max;
            Integer min;
            Integer yearoffset = Integer.parseInt(this.allVals.get("yearoffset").toString());
            if (yearoffset >= 0) {
                min = 0;
                max = 12 * (yearoffset + 1);
            } else {
                min = 12 * (yearoffset - 1);
                max = 0;
            }
            Set<String> bpSet = YearValueRuleFunction.calcBp(modelCache, memberNums, min, max);
            Set<String> _bpSet = RuleFunctionUtils.getYearValueBpNumberSet(modelCache, this.allVals, memberNums);
            bpSet.addAll(_bpSet);
            HashSet<String> memSets = new HashSet<String>(16);
            for (String memBum : bpSet) {
                memSets.addAll(modelCache.getParents(null, modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, memBum), true).stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
            }
            functionRefMember.setMembers(memSets);
        }
        String funStr = (String)this.allVals.get(FunctionItemEnum.RELATIONFUN.getKey());
        if (StringUtils.isNotEmpty(funStr)) {
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            FunctionRefMember otherFuncRefMem = childFun.genRefMember(leftMemberScope, modelCache, viewMap);
            otherFuncRefMem.setLoop(false);
            otherFuncRefMem.setSkip(true);
            if (CollectionUtils.isEmpty(otherFuncRefMem.getMembers())) {
                otherFuncRefMem.setAllMember(true);
            }
            functionRefMember.setOtherFuncRefMem(otherFuncRefMem);
        }
        return functionRefMember;
    }

    @Override
    public FunctionRefMember genRefMemberFirst(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        FunctionRefMember functionRefMember = super.genRefMemberFirst(leftMemberScope, modelCache, viewMap);
        FunctionRefMember otherFuncRefMem = functionRefMember.getOtherFuncRefMem();
        if (otherFuncRefMem != null && otherFuncRefMem.isAllMember()) {
            String dimNumber = otherFuncRefMem.getDimNumber();
            Long viewId = viewMap.getOrDefault(dimNumber, 0L);
            HashSet<String> collect = new HashSet<String>(16);
            List<Member> members = modelCache.getMembers(viewId, dimNumber);
            collect.addAll(members.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
            otherFuncRefMem.setMembers(collect);
        }
        return functionRefMember;
    }

    public static Set<String> calcBp(IModelCacheHelper modelCache, Set<String> originBpSet, Integer min, Integer max) {
        HashSet<String> calcBp = new HashSet<String>(originBpSet);
        HashMap<Integer, List> bpMemberForLevel = new HashMap<Integer, List>(16);
        for (String bpNumber : originBpSet) {
            Member bpMember = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, bpNumber);
            int level = bpMember.getLevel();
            List bpMembers = bpMemberForLevel.computeIfAbsent(level, v -> new ArrayList(16));
            bpMembers.add(bpNumber);
        }
        HashSet fillSet = Sets.newHashSet();
        for (Map.Entry entry : bpMemberForLevel.entrySet()) {
            Member memberOffset;
            int i;
            List leafBpMembers = (List)entry.getValue();
            String minLeafBpNumber = (String)leafBpMembers.stream().min(String::compareTo).get();
            String maxLeafBpNumber = (String)leafBpMembers.stream().max(String::compareTo).get();
            fillSet.addAll(modelCache.getMemberBetween(SysDimensionEnum.BudgetPeriod.getNumber(), minLeafBpNumber, maxLeafBpNumber, true).stream().map(BaseCache::getNumber).collect(Collectors.toList()));
            if (min < 0) {
                for (i = min.intValue(); i < 0; ++i) {
                    memberOffset = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), minLeafBpNumber, i);
                    if (memberOffset != null) {
                        fillSet.add(memberOffset.getNumber());
                        continue;
                    }
                    fillSet.add(minLeafBpNumber);
                }
            }
            if (max <= 0) continue;
            for (i = 1; i <= max; ++i) {
                memberOffset = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), maxLeafBpNumber, i);
                if (memberOffset != null) {
                    fillSet.add(memberOffset.getNumber());
                    continue;
                }
                fillSet.add(maxLeafBpNumber);
            }
        }
        calcBp.addAll(fillSet);
        return calcBp;
    }

    @Override
    public Set<String> analyzeRealMember(IModelCacheHelper modelCache, Map<String, Long> viewMap, String dimNumber, Map<String, Set<String>> currMemberMap, Map<String, String> leftMemberMap, Long currDataSetId) {
        Set<String> memNumber = currMemberMap.get(dimNumber);
        boolean isBudgetPeriod = SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber);
        if (!isBudgetPeriod && this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get(FunctionItemEnum.RELATIONFUN.getKey());
            RuleFunction childFun = RuleFunctionFactory.fromJsonString(funStr);
            Set<String> refMembers = childFun.analyzeRealMember(modelCache, viewMap, dimNumber, currMemberMap, leftMemberMap, currDataSetId);
            if (CollectionUtils.isEmpty(refMembers)) {
                return memNumber;
            }
            Long viewId = this.getDimensionViewId(childFun.allVals, dimNumber, viewMap);
            List<Member> members = modelCache.getMembers(dimNumber, viewId, refMembers);
            List sortMembers = members.stream().sorted(Comparator.comparing(BaseCache::getNumber).reversed()).collect(Collectors.toList());
            refMembers.clear();
            refMembers.add(((Member)sortMembers.get(0)).getNumber());
            return refMembers;
        }
        if (isBudgetPeriod && CollectionUtils.isNotEmpty(memNumber)) {
            String yearOffset = (String)this.allVals.get(FunctionItemEnum.YEAROFFSET.getKey());
            String next = memNumber.iterator().next();
            Member memberOffset = modelCache.getMemberOffsetByLevel(SysDimensionEnum.BudgetPeriod.getNumber(), null, next, Integer.parseInt(yearOffset), 2);
            if (memberOffset == null) {
                return memNumber;
            }
            HashSet<String> refMembers = new HashSet<String>(16);
            refMembers.add(RuleFunctionUtils.getYearValueBpNumber(this.allVals, memberOffset));
            return refMembers;
        }
        return memNumber;
    }

    @Override
    public List<MemberQuoteDao> genFunctionRefQuote(Long modelId, Long bizctrlrangeidLong, Long ruleId) {
        RuleFunction childFun;
        List<MemberQuoteDao> relFuncMemQuoDaoList;
        String account = (String)this.allVals.get("account");
        FormulaMemberPojo accountMemberPojo = JsonUtils.readValue(account, FormulaMemberPojo.class);
        List<DimMemberPojo> refDimMembers = accountMemberPojo.getRefDimMembers();
        ArrayList memberQuoteDaoList = Lists.newArrayListWithExpectedSize((int)16);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        for (DimMemberPojo refDimMember : refDimMembers) {
            Dimension dimension = modelCache.getDimension(refDimMember.getDimNumber());
            MemberQuoteDao memberQuoteDao = new MemberQuoteDao(modelId, bizctrlrangeidLong, dimension.getId(), refDimMember.getId(), MemberQuoteResourceEnum.BizRule, ruleId);
            RuleFunctionUtils.putMemberQuoteViewMap(refDimMember.getId(), refDimMember.getViewId(), memberQuoteDao);
            memberQuoteDaoList.add(memberQuoteDao);
        }
        String funStr = (String)this.allVals.get(FunctionItemEnum.RELATIONFUN.getKey());
        if (StringUtils.isNotEmpty(funStr) && CollectionUtils.isNotEmpty(relFuncMemQuoDaoList = (childFun = RuleFunctionFactory.fromJsonString(funStr)).genFunctionRefQuote(modelId, bizctrlrangeidLong, ruleId))) {
            memberQuoteDaoList.addAll(relFuncMemQuoDaoList);
        }
        return memberQuoteDaoList;
    }
}

