/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.sdk.report;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.MemberPojo;
import kd.epm.eb.common.pojo.ReportProcessPojo;
import kd.epm.eb.common.pojo.TemplatePojo;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;

public class ReportSDKUtils {
    private static final Log log = LogFactory.getLog(ReportSDKUtils.class);

    public static ReportSDKUtils get() {
        return new ReportSDKUtils();
    }

    public List<ReportProcessPojo> getReportProcessIds(@NotNull DataTracking dataTracking, @NotNull IModelCacheHelper modelCache, ProcessTypeEnum processTypeEnum) {
        if (IDUtils.isNull(dataTracking.modelId) || IDUtils.isNull(dataTracking.busModelId) || dataTracking.member == null) {
            log.info("getReportProcessIds.dataTracking modelId/busModelId/member \u4e3a\u7a7a");
            return Collections.emptyList();
        }
        try {
            Object result;
            Dimension _dimension;
            HashMap memberIdMap = Maps.newHashMapWithExpectedSize((int)64);
            HashMap<Long, Long> dimMemberIds = new HashMap<Long, Long>(dataTracking.member.size());
            Map<String, Long> viewIds = BusinessModelServiceHelper.getViewIds(dataTracking.busModelId);
            LinkedList<TemplateDist> templateDists = new LinkedList<TemplateDist>();
            if (ProcessTypeEnum.REPORT == processTypeEnum) {
                templateDists.addAll(this.queryTemplateIdByReport(dataTracking, modelCache, memberIdMap));
            } else if (ProcessTypeEnum.TASK == processTypeEnum) {
                templateDists.addAll(this.queryTemplateIdByTask(dataTracking, modelCache, memberIdMap));
            }
            if (templateDists.isEmpty()) {
                log.info("getReportProcessIds.templateDists isEmpty");
                return Collections.emptyList();
            }
            Set taskListOrRptSchemaIds = templateDists.stream().filter(t -> IDUtils.isNotNull(t.taskId)).map(t -> t.taskId).collect(Collectors.toCollection(LinkedHashSet::new));
            Map<Long, Long> variableMap = this.queryVariable(dataTracking, taskListOrRptSchemaIds);
            HashMap<Long, Long> orgViewIdMap = new HashMap<Long, Long>(16);
            log.info("getReportProcessIds.assignId:" + dataTracking.assignId + " taskListId:" + dataTracking.taskListId);
            Map<Long, Set<String>> rptSchemeAssignMap = this.querySchemeAssign(processTypeEnum, taskListOrRptSchemaIds, memberIdMap, modelCache, orgViewIdMap, dataTracking);
            viewIds.put(SysDimensionEnum.Entity.getNumber(), ProcessTypeEnum.REPORT == processTypeEnum ? (Long)orgViewIdMap.get(dataTracking.assignId) : (Long)orgViewIdMap.get(dataTracking.taskListId));
            log.info("getReportProcessIds.OrgViewId:" + viewIds.get(SysDimensionEnum.Entity.getNumber()));
            for (Map.Entry<String, String> entry : dataTracking.member.entrySet()) {
                Long _viewId;
                _dimension = modelCache.getDimension(entry.getKey());
                Member tmpMember = _dimension.getMember(_viewId = viewIds.get(_dimension.getNumber()), entry.getValue());
                if (tmpMember == null) {
                    tmpMember = _dimension.getStructOfMember(entry.getValue());
                }
                if (tmpMember == null) continue;
                memberIdMap.put(entry.getKey(), tmpMember.getId());
                dimMemberIds.put(_dimension.getId(), tmpMember.getId());
            }
            Long entityId = (Long)memberIdMap.get("Entity");
            if (IDUtils.isNull(entityId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7ec4\u7ec7\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u3002", (String)"ReportSDKUtils_0", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            Long periodId = (Long)memberIdMap.get("BudgetPeriod");
            Long versionId = (Long)memberIdMap.get("Version");
            Long dataTypeId = (Long)memberIdMap.get("DataType");
            log.info("getReportProcessIds.entityId:" + entityId + " periodId:" + periodId + " versionId:" + versionId + " dataTypeId:" + dataTypeId);
            Set templateIds = templateDists.stream().map(t -> t.templateId).collect(Collectors.toCollection(LinkedHashSet::new));
            HashMap templateDistMap = new HashMap(templateDists.size());
            templateDists.forEach(t -> templateDistMap.computeIfAbsent(t.templateId, f -> new ArrayList()).add(t));
            log.info("ReportSDK-template:" + JSON.toJSONString((Object)templateIds));
            Map<Object, Object> templateMap = Maps.newHashMapWithExpectedSize((int)templateIds.size());
            DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,number,name", (QFilter[])new QFilter("id", "in", (Object)templateIds).toArray());
            if (templates != null) {
                templateMap = templates.stream().collect(Collectors.toMap(t -> t.getLong("id"), t -> t));
            }
            if ((result = DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"filterQuote", (Object[])new Object[]{dataTracking.modelId, dataTracking.busModelId, templateIds, variableMap, CollectionUtils.asList(dimMemberIds)})) instanceof Set) {
                templateIds.retainAll((Set)result);
                log.info("ReportSDK-filter-template:" + JSON.toJSONString((Object)templateIds));
            }
            LinkedHashSet<Long> _allEntityIds = new LinkedHashSet<Long>();
            LinkedHashSet<Long> _allPeriodIds = new LinkedHashSet<Long>();
            List<Member> entityParents = null;
            List<Member> periodParents = null;
            ArrayList<Object> rptProcess = Lists.newArrayListWithExpectedSize((int)128);
            if (!templateIds.isEmpty()) {
                SqlBuilder sql = new SqlBuilder();
                sql.append("select fid, ftemplate, fentity, fversion, fdatatype, fperiod, fstatus from t_eb_reportprocess where fmodel = ?", new Object[]{dataTracking.modelId});
                sql.append(" and ", new Object[0]).appendIn("ftemplate", templateIds.toArray());
                if (ProcessTypeEnum.EXAMINE == dataTracking.sourceType) {
                    View _view;
                    _dimension = modelCache.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
                    periodParents = _dimension.getParents(periodId);
                    _allPeriodIds.add(periodId);
                    periodParents.forEach(e -> _allPeriodIds.add(e.getId()));
                    sql.append(" and ", new Object[0]).appendIn("fperiod", _allPeriodIds.toArray());
                    if (IDUtils.isNotNull(dataTypeId)) {
                        sql.append(" and fdatatype = ?", new Object[]{dataTypeId});
                    }
                    if (IDUtils.isNotNull(versionId)) {
                        sql.append(" and fversion = ?", new Object[]{versionId});
                    }
                    entityParents = (_view = (_dimension = modelCache.getDimension(SysDimensionEnum.Entity.getNumber())).getView(viewIds.get(_dimension.getNumber()))) != null ? _view.getParents(entityId) : _dimension.getParents(entityId);
                    _allEntityIds.add(entityId);
                    entityParents.forEach(e -> _allEntityIds.add(e.getId()));
                    sql.append(" and ", new Object[0]).appendIn("fentity", _allEntityIds.toArray());
                    sql.append(" and fstatus != ?", new Object[]{BgTaskStateEnum.UNPREPARED.getNumber()});
                }
                log.info("queryReportProcess sql = " + sql);
                log.info("queryReportProcess sql params: modelid = " + dataTracking.modelId + ",templateIds=" + templateIds + ",_allPeriodIds=" + _allPeriodIds + ",dataTypeId=" + dataTypeId + ",versionId=" + versionId + ",_allEntityIds=" + _allEntityIds);
                try (DataSet ds = DB.queryDataSet((String)"queryReportProcess", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                    if (ds != null) {
                        LinkedHashMap allKeysMap = Maps.newLinkedHashMap();
                        Dimension periodDim = modelCache.getDimension("BudgetPeriod");
                        boolean isFindSameTask = false;
                        block12: for (Row row : ds) {
                            Member entity = modelCache.getMember("Entity", viewIds.get("Entity"), row.getLong("fentity"));
                            if (entity == null) {
                                Dimension dimension = modelCache.getDimension("Entity");
                                entity = dimension.getStructOfMember(row.getLong("fentity"));
                            }
                            Member version = modelCache.getMember("Version", null, row.getLong("fversion"));
                            Member datatype = modelCache.getMember("DataType", null, row.getLong("fdatatype"));
                            Member period = modelCache.getMember("BudgetPeriod", null, row.getLong("fperiod"));
                            List list = (List)templateDistMap.get(row.getLong("ftemplate"));
                            if (list == null) continue;
                            for (TemplateDist _dist : list) {
                                Set<String> pdvKey;
                                Set allKeys;
                                ReportProcessPojo rptProc = new ReportProcessPojo();
                                rptProc.setReportProcessIdLong(row.getLong("fid"));
                                rptProc.setReportOrTaskIdLong(_dist.taskId);
                                if (ProcessTypeEnum.REPORT == processTypeEnum) {
                                    allKeys = allKeysMap.computeIfAbsent(row.getString("fperiod"), f -> this.getParentPDVKey(row.getString("fperiod"), row.getString("fdatatype"), row.getString("fversion"), periodDim));
                                    pdvKey = rptSchemeAssignMap.get(_dist.taskId);
                                    if (pdvKey == null || allKeys == null || Collections.disjoint(allKeys, pdvKey)) {
                                        continue;
                                    }
                                } else if (ProcessTypeEnum.TASK == processTypeEnum) {
                                    allKeys = allKeysMap.computeIfAbsent(row.getString("fperiod"), f -> this.getParentPDVKey(row.getString("fperiod"), row.getString("fdatatype"), row.getString("fversion"), periodDim));
                                    pdvKey = rptSchemeAssignMap.get(_dist.taskListId);
                                    if (pdvKey == null || allKeys == null || Collections.disjoint(allKeys, pdvKey)) continue;
                                    if (_dist.taskListId.equals(dataTracking.taskListId)) {
                                        isFindSameTask = true;
                                    }
                                }
                                rptProc.setTaskListIdLong(_dist.taskListId);
                                if (IDUtils.isNotNull(rptProc.getTaskListIdLong())) {
                                    if (ProcessTypeEnum.TASK != processTypeEnum) continue;
                                    rptProc.setReportProcessTypeString(ProcessTypeEnum.TASK.name());
                                } else {
                                    if (ProcessTypeEnum.REPORT != processTypeEnum) continue;
                                    rptProc.setReportProcessTypeString(ProcessTypeEnum.REPORT.name());
                                }
                                rptProc.setTemplatePojo(new TemplatePojo());
                                rptProc.getTemplatePojo().setTemplateIdLong(_dist.templateId);
                                DynamicObject _template = (DynamicObject)templateMap.get(_dist.templateId);
                                if (_template != null) {
                                    rptProc.getTemplatePojo().setTemplateNumberString(_template.getString("number"));
                                    rptProc.getTemplatePojo().setTemplateNameString(_template.getString("name"));
                                }
                                rptProc.setMemberPojoList(new ArrayList<MemberPojo>(4));
                                if (entity != null) {
                                    rptProc.getMemberPojoList().add(MemberPojo.of(entity));
                                }
                                if (version != null) {
                                    rptProc.getMemberPojoList().add(MemberPojo.of(version));
                                }
                                if (datatype != null) {
                                    rptProc.getMemberPojoList().add(MemberPojo.of(datatype));
                                }
                                if (period != null) {
                                    rptProc.getMemberPojoList().add(MemberPojo.of(period));
                                }
                                rptProc.setStatusString(row.getString("fstatus"));
                                if (isFindSameTask) {
                                    rptProcess.clear();
                                    rptProcess.add(rptProc);
                                    continue block12;
                                }
                                rptProcess.add(rptProc);
                                isFindSameTask = false;
                                if (rptProcess.size() <= 3000) continue;
                                log.info("rptProcess.size() > 3000");
                                continue block12;
                            }
                        }
                    }
                }
            }
            if (!rptProcess.isEmpty() && ProcessTypeEnum.EXAMINE == dataTracking.sourceType) {
                String memKey;
                LinkedHashMap temRptProcessMap = Maps.newLinkedHashMap();
                Map<String, List> tmpRptMap = new HashMap(16);
                for (ReportProcessPojo reportProcessPojo : rptProcess) {
                    tmpRptMap = temRptProcessMap.computeIfAbsent(reportProcessPojo.getTemplatePojo().getTemplateIdLong(), f -> Maps.newLinkedHashMap());
                    if (reportProcessPojo.getMemberPojoList().size() != 4) continue;
                    memKey = "" + reportProcessPojo.getMemberPojoList().get(0).getMemberIdLong() + '_' + reportProcessPojo.getMemberPojoList().get(1).getMemberIdLong() + '_' + reportProcessPojo.getMemberPojoList().get(2).getMemberIdLong() + '_' + reportProcessPojo.getMemberPojoList().get(3).getMemberIdLong();
                    List rpts = tmpRptMap.computeIfAbsent(memKey, f -> Lists.newLinkedList());
                    rpts.add(reportProcessPojo);
                }
                if (entityParents != null && periodParents != null) {
                    ArrayList<Object> _filters = new ArrayList<Object>(rptProcess.size());
                    Member _entity = modelCache.getMember("Entity", viewIds.get("Entity"), (Long)memberIdMap.get("Entity"));
                    if (_entity == null) {
                        Dimension dimension = modelCache.getDimension("Entity");
                        _entity = dimension.getStructOfMember((Long)memberIdMap.get("Entity"));
                    }
                    Member _period = modelCache.getMember("BudgetPeriod", null, (Long)memberIdMap.get("BudgetPeriod"));
                    Member _version = modelCache.getMember("Version", null, (Long)memberIdMap.get("Version"));
                    Member _dataType = modelCache.getMember("DataType", null, (Long)memberIdMap.get("DataType"));
                    if (_entity != null && _period != null && _version != null && _dataType != null) {
                        memKey = "" + _entity.getId() + '_' + _version.getId() + '_' + _dataType.getId() + '_' + _period.getId();
                        log.info("memKey = " + memKey);
                        log.info("tmpRptMap.keys = " + tmpRptMap.keySet());
                        block15: for (Map entry : temRptProcessMap.values()) {
                            List list = (List)entry.get(memKey);
                            if (list != null) {
                                _filters.addAll(list);
                                log.info("memKey1 = " + memKey);
                                continue;
                            }
                            for (Long _entityId : _allEntityIds) {
                                for (Long _periodId : _allPeriodIds) {
                                    memKey = "" + _entityId + '_' + _version.getId() + '_' + _dataType.getId() + '_' + _periodId;
                                    List list2 = (List)entry.get(memKey);
                                    if (list2 == null) continue;
                                    _filters.addAll(list2);
                                    log.info("memKey2 = " + memKey);
                                    continue block15;
                                }
                            }
                        }
                    }
                    if (!_filters.isEmpty()) {
                        rptProcess = _filters;
                    }
                }
            }
            log.info("getReportProcessIds.rptProcess:" + JSON.toJSONString((Object)rptProcess));
            return rptProcess;
        }
        catch (Exception e2) {
            if (e2 instanceof KDBizException) {
                throw new KDBizException(e2.getMessage());
            }
            log.error("getReportProcessIds" + ExceptionUtils.getStackTrace((Throwable)e2), (Throwable)e2);
            throw new KDBizException(ResManager.loadKDString((String)"\u8054\u67e5\u62a5\u8868\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    public List<ReportProcessPojo> getReportProcessIdsNew(@NotNull DataTracking dataTracking, @NotNull IModelCacheHelper modelCache, ProcessTypeEnum processTypeEnum, List<Long> reportTemplates) {
        if (IDUtils.isNull(dataTracking.modelId) || IDUtils.isNull(dataTracking.busModelId) || dataTracking.member == null) {
            return Collections.emptyList();
        }
        HashMap memberIdMap = Maps.newHashMapWithExpectedSize((int)64);
        Map<String, Long> viewIds = BusinessModelServiceHelper.getViewIds(dataTracking.busModelId);
        for (Map.Entry<String, String> entry : dataTracking.member.entrySet()) {
            Long _viewId;
            Dimension _dimension = modelCache.getDimension(entry.getKey());
            Member tmpMember = _dimension.getMember(_viewId = viewIds.get(_dimension.getNumber()), entry.getValue());
            if (tmpMember == null) continue;
            memberIdMap.put(entry.getKey(), tmpMember.getId());
        }
        Long entityId = (Long)memberIdMap.get("Entity");
        if (IDUtils.isNull(entityId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7ec4\u7ec7\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u3002", (String)"ReportSDKUtils_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        LinkedList<TemplateDist> templateDists = new LinkedList<TemplateDist>();
        if (ProcessTypeEnum.REPORT == processTypeEnum) {
            templateDists.addAll(this.queryTemplateIdByReport(dataTracking, modelCache, memberIdMap));
        } else if (ProcessTypeEnum.TASK == processTypeEnum) {
            templateDists.addAll(this.queryTemplateIdByTask(dataTracking, modelCache, memberIdMap));
        }
        Set templateIds = templateDists.stream().map(t -> t.templateId).collect(Collectors.toCollection(LinkedHashSet::new));
        HashMap templateDistMap = new HashMap(templateDists.size());
        templateDists.stream().filter(t -> reportTemplates.contains(t.templateId)).forEach(t -> templateDistMap.computeIfAbsent(t.templateId, f -> new ArrayList()).add(t));
        log.info("ReportSDK-template:" + JSON.toJSONString((Object)templateIds));
        Map<Object, Object> templateMap = Maps.newHashMapWithExpectedSize((int)templateIds.size());
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,number,name", (QFilter[])new QFilter("id", "in", (Object)templateIds).toArray());
        if (templates != null) {
            templateMap = templates.stream().collect(Collectors.toMap(t -> t.getLong("id"), t -> t));
            templateIds.retainAll(templateMap.keySet());
        }
        ArrayList rptProcess = Lists.newArrayListWithExpectedSize((int)64);
        if (!templateIds.isEmpty()) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid, ftemplate, fentity, fversion, fdatatype, fperiod, fstatus from t_eb_reportprocess where fmodel = ?", new Object[]{dataTracking.modelId});
            sql.append(" and ", new Object[0]).appendIn("ftemplate", templateIds.toArray());
            sql.append(" and fentity = ?", new Object[]{entityId});
            sql.append(" and fversion = ?", new Object[]{dataTracking.versionId});
            sql.append(" and fdatatype = ?", new Object[]{dataTracking.dataTypeId});
            sql.append(" and fperiod = ?", new Object[]{dataTracking.budgetPeriodId});
            try (DataSet ds = DB.queryDataSet((String)"queryReportProcess", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds != null) {
                    for (Row row : ds) {
                        Member entity = modelCache.getMember("Entity", viewIds.get("Entity"), row.getLong("fentity"));
                        Member version = modelCache.getMember("Version", null, row.getLong("fversion"));
                        Member datatype = modelCache.getMember("DataType", null, row.getLong("fdatatype"));
                        Member period = modelCache.getMember("BudgetPeriod", null, row.getLong("fperiod"));
                        List _templates = (List)templateDistMap.get(row.getLong("ftemplate"));
                        if (_templates == null) continue;
                        for (TemplateDist _dist : _templates) {
                            ReportProcessPojo rptProc = new ReportProcessPojo();
                            rptProc.setReportProcessIdLong(row.getLong("fid"));
                            rptProc.setReportOrTaskIdLong(_dist.taskId);
                            rptProc.setTaskListIdLong(_dist.taskListId);
                            if (IDUtils.isNotNull(rptProc.getTaskListIdLong())) {
                                if (ProcessTypeEnum.TASK != processTypeEnum) continue;
                                rptProc.setReportProcessTypeString(ProcessTypeEnum.TASK.name());
                            } else {
                                if (ProcessTypeEnum.REPORT != processTypeEnum) continue;
                                rptProc.setReportProcessTypeString(ProcessTypeEnum.REPORT.name());
                            }
                            rptProc.setTemplatePojo(new TemplatePojo());
                            rptProc.getTemplatePojo().setTemplateIdLong(_dist.templateId);
                            DynamicObject _template = (DynamicObject)templateMap.get(_dist.templateId);
                            if (_template != null) {
                                rptProc.getTemplatePojo().setTemplateNumberString(_template.getString("number"));
                                rptProc.getTemplatePojo().setTemplateNameString(_template.getString("name"));
                            }
                            rptProc.setMemberPojoList(new ArrayList<MemberPojo>(4));
                            if (entity != null) {
                                rptProc.getMemberPojoList().add(MemberPojo.of(entity));
                            }
                            if (version != null) {
                                rptProc.getMemberPojoList().add(MemberPojo.of(version));
                            }
                            if (datatype != null) {
                                rptProc.getMemberPojoList().add(MemberPojo.of(datatype));
                            }
                            if (period != null) {
                                rptProc.getMemberPojoList().add(MemberPojo.of(period));
                            }
                            rptProc.setStatusString(row.getString("fstatus"));
                            rptProcess.add(rptProc);
                        }
                    }
                }
            }
        }
        return rptProcess;
    }

    private List<TemplateDist> queryTemplateIdByReport(@NotNull DataTracking dataTracking, @NotNull IModelCacheHelper modelCache, Map<String, Long> memberIdMap) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select s.fid, s.forgviewid, t.ftemplateid, t.fapplytemplateid, t.forgid, t.forgrange from t_eb_templateorg t join t_eb_rptscheme s on t.fschemeid = s.fid where s.fmodelid = ? and s.fbizrangeid = ? and s.fstatus = '1'", new Object[]{dataTracking.modelId, dataTracking.busModelId});
        if (IDUtils.isNotNull(dataTracking.rptSchemaId)) {
            sql.append(" and s.fid = ?", new Object[]{dataTracking.rptSchemaId});
        }
        if (IDUtils.isNotNull(dataTracking.templateId)) {
            sql.append(" and t.ftemplateid = ?", new Object[]{dataTracking.templateId});
        }
        LinkedList templateDists = Lists.newLinkedList();
        LinkedHashSet<String> templateKeys = new LinkedHashSet<String>();
        log.info("queryTemplateIdByReport sql=" + sql + " params: dataTracking.modelId=" + dataTracking.modelId + ",dataTracking.busModelId=" + dataTracking.busModelId + "dataTracking.rptSchemaId=" + dataTracking.rptSchemaId + ",dataTracking.templateId" + dataTracking.templateId);
        try (DataSet ds = DB.queryDataSet((String)"queryTemplateBySchema", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    TemplateDist templateDist = new TemplateDist();
                    templateDist.templateId = row.getLong("ftemplateid");
                    if (IDUtils.isNull(templateDist.templateId)) {
                        templateDist.templateId = row.getLong("fapplytemplateid");
                        templateDist.isAppleTemplate = true;
                    }
                    templateDist.taskId = row.getLong("fid");
                    String templateKey = "" + templateDist.taskId + '_' + templateDist.templateId;
                    if (!templateKeys.add(templateKey)) continue;
                    templateDists.add(templateDist);
                }
            }
        }
        log.info("queryTemplateIdByReport templateKeys=" + templateKeys);
        return templateDists;
    }

    private List<TemplateDist> queryTemplateIdByTask(@NotNull DataTracking dataTracking, @NotNull IModelCacheHelper modelCache, Map<String, Long> memberIdMap) {
        HashSet<Long> taskListIds = new HashSet<Long>();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_eb_tasklist where fmodelid = ? and fbizmodelid = ?", new Object[]{dataTracking.modelId, dataTracking.busModelId});
        log.info("queryTaskListId sql=" + sql + " params: dataTracking.modelId=" + dataTracking.modelId + ",dataTracking.busModelId=" + dataTracking.busModelId);
        try (DataSet ds = DB.queryDataSet((String)"queryTaskListId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Object row : ds) {
                    taskListIds.add(row.getLong("fid"));
                }
            }
        }
        if (taskListIds.isEmpty()) {
            return Collections.emptyList();
        }
        sql = new SqlBuilder();
        sql.append("select fid, ftasklistid from t_eb_task where ", new Object[0]).appendIn("ftasklistid", taskListIds.toArray());
        sql.append(" and fid in (select ftaskid from t_eb_tasksave where ", new Object[0]).appendIn("ftasklistid", taskListIds.toArray()).append(" and ftaskstatus = '1')", new Object[0]);
        log.info("queryTaskId sql=" + sql + " params: taskListIds=" + taskListIds);
        LinkedHashMap<Long, Long> taskIds = new LinkedHashMap<Long, Long>();
        DataSet ds = DB.queryDataSet((String)"queryTaskId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        Object object = null;
        try {
            if (ds != null) {
                for (Row row : ds) {
                    taskIds.put(row.getLong("fid"), row.getLong("ftasklistid"));
                }
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        LinkedList templateDists = Lists.newLinkedList();
        if (!taskIds.isEmpty()) {
            LinkedHashSet<String> templateKeys = new LinkedHashSet<String>();
            sql = new SqlBuilder();
            sql.append("select t.fid, t.ftaskid, t.forgid, t.forgrange, t.forgviewid, tt.ftemplateid from t_eb_tasksave t join t_eb_taskreftemplate tt on t.ftaskid = tt.fid where ", new Object[0]);
            sql.appendIn("t.ftaskid", taskIds.keySet().toArray());
            sql.append(" and t.ftaskstatus = '1'", new Object[0]);
            if (IDUtils.isNotNull(dataTracking.templateId)) {
                sql.append(" and tt.ftemplateid = ?", new Object[]{dataTracking.templateId});
            }
            log.info("queryTemplateByTask sql=" + sql + " params: taskIds.keySet()=" + taskIds.keySet() + ",dataTracking.templateId" + dataTracking.templateId);
            try (DataSet ds2 = DB.queryDataSet((String)"queryTemplateByTask", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds2 != null) {
                    for (Row row : ds2) {
                        TemplateDist templateDist = new TemplateDist();
                        templateDist.templateId = row.getLong("ftemplateid");
                        templateDist.taskId = row.getLong("ftaskid");
                        templateDist.taskListId = (Long)taskIds.get(templateDist.taskId);
                        String templateKey = "" + templateDist.taskId + '_' + templateDist.templateId;
                        if (!templateKeys.add(templateKey)) continue;
                        templateDists.add(templateDist);
                    }
                }
            }
            log.info("queryTemplateIdByTask templateKeys=" + templateKeys);
        }
        return templateDists;
    }

    private List<TemplateDist> queryTemplate(@NotNull DataTracking dataTracking) {
        LinkedList templateDists = Lists.newLinkedList();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_eb_template where fmodelid = ? and fisreadonly = '0' and fdatasetid in (select fid from t_eb_dataset where fbizmodelid = ?)", new Object[]{dataTracking.modelId, dataTracking.busModelId});
        try (DataSet ds = DB.queryDataSet((String)"queryTemplate", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    TemplateDist templateDist = new TemplateDist();
                    templateDist.templateId = row.getLong("fid");
                    templateDists.add(templateDist);
                }
            }
        }
        return templateDists;
    }

    private Map<Long, Long> queryVariable(DataTracking dataTracking, Set<Long> taskListOrRptSchemaIds) {
        SqlBuilder sql;
        LinkedHashMap variableMap = Maps.newLinkedHashMap();
        if (IDUtils.isNotNull(dataTracking.taskListId) || taskListOrRptSchemaIds != null && !taskListOrRptSchemaIds.isEmpty()) {
            sql = new SqlBuilder();
            sql.append("select fid, fvariablenumber, fvariablejsontext from t_eb_taskvariableset where ", new Object[0]);
            if (IDUtils.isNotNull(dataTracking.taskListId)) {
                sql.append("fid = ?", new Object[]{dataTracking.taskListId});
            } else {
                sql.appendIn("fid", taskListOrRptSchemaIds.toArray());
            }
            this.dealVariables(sql, variableMap);
        }
        if (IDUtils.isNull(dataTracking.assignId) && IDUtils.isNotNull(dataTracking.rptSchemaId) && IDUtils.isNotNull(dataTracking.budgetPeriodId) && IDUtils.isNotNull(dataTracking.dataTypeId) && IDUtils.isNotNull(dataTracking.versionId)) {
            sql = new SqlBuilder();
            sql.append("select fid from t_eb_schemeassign where fmodelid = ? and fbizrangeid = ? and fschemeid = ? and fyearid = ? and fdatatypeid = ? and fversionid = ?", new Object[]{dataTracking.modelId, dataTracking.busModelId, dataTracking.rptSchemaId, dataTracking.budgetPeriodId, dataTracking.dataTypeId, dataTracking.versionId});
            try (DataSet ds = DB.queryDataSet((String)"queryAssign", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds != null && ds.hasNext()) {
                    dataTracking.assignId = ds.next().getLong("fid");
                }
            }
        }
        if (IDUtils.isNotNull(dataTracking.assignId) && taskListOrRptSchemaIds != null) {
            sql = new SqlBuilder();
            sql.append("select fid, fvariablenumber, fvariablejsontext from t_eb_schemevariable where ", new Object[0]);
            if (IDUtils.isNotNull(dataTracking.assignId)) {
                sql.append("fid = ?", new Object[]{dataTracking.assignId});
            } else {
                sql.appendIn("fid", taskListOrRptSchemaIds.toArray());
            }
            this.dealVariables(sql, variableMap);
        }
        log.info("queryVariable variableMap=" + variableMap);
        return variableMap;
    }

    /*
     * Unable to fully structure code
     */
    private Map<Long, Set<String>> querySchemeAssign(ProcessTypeEnum processTypeEnum, Set<Long> taskListOrRptSchemaIds, Map<String, Long> memberIdMap, IModelCacheHelper modelCacheHelper, Map<Long, Long> orgViewIdMap, DataTracking dataTracking) {
        if (taskListOrRptSchemaIds == null || taskListOrRptSchemaIds.isEmpty()) {
            return Collections.emptyMap();
        }
        rptSchemeAssignMap = Maps.newLinkedHashMap();
        if (ProcessTypeEnum.REPORT == processTypeEnum) {
            sql = new SqlBuilder();
            sql.append("select sc.fid, fschemeid, fyearid, fdatatypeid, fversionid ,forgviewid from t_eb_schemeassign sc left join t_eb_rptscheme er on sc.fschemeid = er.fid where ", new Object[0]).appendIn("fschemeid", taskListOrRptSchemaIds.toArray());
            ds = DB.queryDataSet((String)"querySchemeAssign", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            var10_12 = null;
            try {
                if (ds == null) ** GOTO lbl138
                for (Row row : ds) {
                    orgViewIdMap.put(row.getLong("fid"), row.getLong("forgviewid"));
                    fschemeid = rptSchemeAssignMap.computeIfAbsent(row.getLong("fschemeid"), (Function<Long, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$querySchemeAssign$19(java.lang.Long ), (Ljava/lang/Long;)Ljava/util/Set;)());
                    fschemeid.add(this.getPDVKey(row.getString("fyearid"), row.getString("fdatatypeid"), row.getString("fversionid")));
                }
            }
            catch (Throwable var11_16) {
                var10_12 = var11_16;
                throw var11_16;
            }
            finally {
                if (ds != null) {
                    if (var10_12 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable var11_15) {
                            var10_12.addSuppressed(var11_15);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        } else if (ProcessTypeEnum.TASK == processTypeEnum) {
            sql = new SqlBuilder();
            sql.append("select fid, fyearid, fdatetypeid, fversionid, forgview from t_eb_tasklist where fid in (select ftasklistid from t_eb_task where ", new Object[0]).appendIn("fid", taskListOrRptSchemaIds.toArray()).append(")", new Object[0]);
            ds = DB.queryDataSet((String)"querySchemeAssign", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            var10_13 = null;
            try {
                if (ds != null) {
                    for (Row row : ds) {
                        fschemeid = rptSchemeAssignMap.computeIfAbsent(row.getLong("fid"), (Function<Long, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$querySchemeAssign$20(java.lang.Long ), (Ljava/lang/Long;)Ljava/util/Set;)());
                        fschemeid.add(this.getPDVKey(row.getString("fyearid"), row.getString("fdatetypeid"), row.getString("fversionid")));
                        orgViewIdMap.put(row.getLong("fid"), row.getLong("forgview"));
                    }
                }
            }
            catch (Throwable var11_19) {
                var10_13 = var11_19;
                throw var11_19;
            }
            finally {
                if (ds != null) {
                    if (var10_13 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable var11_18) {
                            var10_13.addSuppressed(var11_18);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            if (!orgViewIdMap.isEmpty()) {
                orgDim = modelCacheHelper.getDimension("Entity");
                currOrgId = memberIdMap.get("Entity");
                for (Map.Entry<String, String> entry : dataTracking.member.entrySet()) {
                    if (!"Entity".equals(entry.getKey())) continue;
                    currOrgId = orgDim.getMember(orgViewIdMap.get(dataTracking.taskListId), entry.getValue()) == null ? currOrgId : orgDim.getMember(orgViewIdMap.get(dataTracking.taskListId), entry.getValue()).getId();
                    break;
                }
                if (IDUtils.isNull(currOrgId)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7ec4\u7ec7\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u3002", (String)"ReportSDKUtils_0", (String)"epm-eb-common", (Object[])new Object[0]));
                }
                filterTaskIds = Sets.newLinkedHashSet();
                filterTaskListIds = Sets.newLinkedHashSet();
                orgIds = Sets.newLinkedHashSet();
                for (Map.Entry<Long, Long> entry : orgViewIdMap.entrySet()) {
                    view = orgDim.getView(entry.getValue());
                    parents = view != null ? view.getParents(currOrgId) : orgDim.getParents(currOrgId);
                    parents.forEach((Consumer<Member>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$querySchemeAssign$21(java.util.Set kd.epm.eb.common.cache.impl.Member ), (Lkd/epm/eb/common/cache/impl/Member;)V)((Set)orgIds));
                }
                sql = new SqlBuilder();
                sql.append("select distinct ftaskid from t_eb_taskdistorg where ", new Object[0]).appendIn("ftaskid", taskListOrRptSchemaIds.toArray()).append(" and ", new Object[0]).appendIn("forgid", orgIds.toArray());
                ds = DB.queryDataSet((String)"querySchemeAssign", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
                var17_31 = null;
                try {
                    if (ds != null) {
                        for (Row row : ds) {
                            filterTaskIds.add(row.getLong("ftaskid"));
                        }
                    }
                }
                catch (Throwable var18_34) {
                    var17_31 = var18_34;
                    throw var18_34;
                }
                finally {
                    if (ds != null) {
                        if (var17_31 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable var18_33) {
                                var17_31.addSuppressed(var18_33);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                if (!filterTaskIds.isEmpty()) {
                    sql.append("select ftasklistid from t_eb_task where ", new Object[0]).appendIn("fid", filterTaskIds.toArray());
                    ds = DB.queryDataSet((String)"querySchemeAssign", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
                    var17_31 = null;
                    try {
                        if (ds != null) {
                            for (Row row : ds) {
                                filterTaskListIds.add(row.getLong("ftasklistid"));
                            }
                        }
                    }
                    catch (Throwable var18_36) {
                        var17_31 = var18_36;
                        throw var18_36;
                    }
                    finally {
                        if (ds != null) {
                            if (var17_31 != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable var18_35) {
                                    var17_31.addSuppressed(var18_35);
                                }
                            } else {
                                ds.close();
                            }
                        }
                    }
                }
                CollectionUtils.retainAll(rptSchemeAssignMap, filterTaskListIds);
            }
        }
lbl138:
        // 7 sources

        ReportSDKUtils.log.info("querySchemeAssign rptSchemeAssignMap=" + rptSchemeAssignMap);
        return rptSchemeAssignMap;
    }

    private String getPDVKey(String periodId, String dataTypeId, String versionId) {
        return periodId + '_' + dataTypeId + '_' + versionId;
    }

    private Set<String> getParentPDVKey(String periodId, String dataTypeId, String versionId, Dimension periodDim) {
        LinkedHashSet allKeys = Sets.newLinkedHashSet();
        allKeys.add(this.getPDVKey(periodId, dataTypeId, versionId));
        this.getParentPDVKey(periodId, dataTypeId, versionId, periodDim, allKeys);
        return allKeys;
    }

    private void getParentPDVKey(String periodId, String dataTypeId, String versionId, Dimension periodDim, Set<String> allKeys) {
        Member parent;
        Member member = periodDim.getMember(null, IDUtils.toLong(periodId));
        if (member != null && (parent = periodDim.getMember(null, member.getParentId())) != null) {
            String pPeriodId = parent.getId().toString();
            allKeys.add(this.getPDVKey(pPeriodId, dataTypeId, versionId));
            this.getParentPDVKey(pPeriodId, dataTypeId, versionId, periodDim, allKeys);
        }
    }

    private void dealVariables(SqlBuilder sql, Map<Long, Long> variableMap) {
        try (DataSet ds = DB.queryDataSet((String)"queryRefVar", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    String json = row.getString("fvariablejsontext");
                    if (!StringUtils.isNotEmpty(json)) continue;
                    try {
                        Object memberId;
                        Map memberMap = (Map)JSON.parseObject((String)json, Map.class);
                        if (memberMap == null || (memberId = memberMap.get("id")) == null) continue;
                        variableMap.put(row.getLong("fvariablenumber"), IDUtils.toLong(memberId));
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static /* synthetic */ void lambda$querySchemeAssign$21(Set orgIds, Member m) {
        orgIds.add(m.getId());
    }

    private static /* synthetic */ Set lambda$querySchemeAssign$20(Long k) {
        return new HashSet(16);
    }

    private static /* synthetic */ Set lambda$querySchemeAssign$19(Long k) {
        return new HashSet(16);
    }

    public static class TemplateDist {
        public Long templateId = null;
        public boolean isAppleTemplate = false;
        public Long taskListId = null;
        public Long taskId = null;

        public static TemplateDist of(DataTracking dataTracking) {
            TemplateDist dist = new TemplateDist();
            dist.templateId = dataTracking.templateId;
            dist.taskListId = dataTracking.taskListId;
            return dist;
        }
    }

    public static class DataTracking {
        public Long modelId = null;
        public Long busModelId = null;
        public Long taskListId = null;
        public Long rptSchemaId = null;
        public Long budgetPeriodId = null;
        public Long versionId = null;
        public Long dataTypeId = null;
        public Long assignId = null;
        public Long templateId = null;
        public Map<String, String> member = null;
        public ProcessTypeEnum sourceType = null;
    }
}

