/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.controller;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekEmptySave;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekCubeServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekExecuteServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekMemberServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import org.jetbrains.annotations.NotNull;

public class EbShrekOlapServiceHelper {
    public static OlapConnection getConnection(Model model) {
        Dataset dataset = EbShrekOlapServiceHelper.createDataSet(model);
        return ShrekCubeServiceHelper.getConnection(model, dataset);
    }

    public static boolean existCube(Model model) {
        Dataset dataset = EbShrekOlapServiceHelper.createDataSet(model);
        return ShrekCubeServiceHelper.existCube(model, dataset);
    }

    public static void createCube(Model model) {
        Dataset dataset = EbShrekOlapServiceHelper.createDataSet(model);
        ShrekConfig ebConfig = ShrekConfigServiceHelper.getEBConfig();
        IModelCacheHelper modelCacheHelper = EbShrekOlapServiceHelper.getModelCacheHelper(model);
        ShrekCubeServiceHelper.createCube(model, dataset, modelCacheHelper, ebConfig);
    }

    public static void updateCubeMember(Model model, String dimensionNumber, Member member) {
        EbShrekOlapServiceHelper.updateCubeMembers(model, dimensionNumber, Collections.singletonList(member));
    }

    public static void updateCubeMembers(Model model, String dimensionNumber, List<Member> members) {
        List<Dataset> datasets = Collections.singletonList(EbShrekOlapServiceHelper.createDataSet(model));
        ShrekConfig config = ShrekConfigServiceHelper.getEBConfig();
        ShrekMemberServiceHelper.updateCubeMembers(model, datasets, dimensionNumber, members, config);
    }

    public static boolean existCubeData(Model model, String dimensionNumber, Set<String> memberNumbers) {
        List<Dataset> datasets = Collections.singletonList(EbShrekOlapServiceHelper.createDataSet(model));
        return ShrekMemberServiceHelper.existCubeDatas(model, datasets, dimensionNumber, memberNumbers);
    }

    public static Set<String> getExistDataMember(Model model, String dimensionNumber, Set<String> memberNumbers) {
        if (memberNumbers == null || memberNumbers.isEmpty()) {
            return Collections.emptySet();
        }
        List<Dataset> datasets = Collections.singletonList(EbShrekOlapServiceHelper.createDataSet(model));
        return ShrekMemberServiceHelper.getExistDataMember(model, datasets, dimensionNumber, memberNumbers);
    }

    public static ShrekOlapReader queryReader(Model model, SelectCommandInfo query, LogStats stats) {
        return ShrekOlapServiceHelper.queryReader(model, query, stats);
    }

    public static IShrekSave saveData(@NotNull Model model, @NotNull String[] dimensions, @NotNull Map<String, String> shrekProperties) {
        if (model == null || dimensions == null || dimensions.length == 0) {
            return new ShrekEmptySave();
        }
        return ShrekExecuteServiceHelper.saveData(model, null, dimensions, shrekProperties);
    }

    public static IShrekSave saveDataByIncrement(@NotNull Model model, @NotNull String[] dimensions, @NotNull Map<String, String> shrekProperties) {
        if (model == null || dimensions == null || dimensions.length == 0) {
            return new ShrekEmptySave();
        }
        return ShrekExecuteServiceHelper.saveDataByIncrement(model, null, dimensions, shrekProperties);
    }

    private static IModelCacheHelper getModelCacheHelper(Model model) {
        return ModelCacheContext.getOrCreate(model.getId());
    }

    private static Dataset createDataSet(Model model) {
        return new Dataset(model.getId(), model.getNumber());
    }
}

