/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.controller;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.bos.olap.dataSources.ValuePair;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.shrek.controller.ShrekEmptySave;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.UserUtils;

public final class ShrekOlapSave
extends ShrekEmptySave {
    private static final Log log = LogFactory.getLog(ShrekOlapSave.class);
    public static final int OLAP_DATA_SCALA = 15;
    public static final int DEF_MEASURE_SIZE = 1;
    private String[] dimensions = null;
    private OlapConnection conn = null;
    private OlapDataWriter writer = null;
    private Object[] values = null;
    private Object[] copy;
    private LogStats stats;
    private long UPDATE_SIZE = 0L;
    private long REMOVE_SIZE = 0L;
    private List<Object[]> removes = Lists.newArrayListWithExpectedSize((int)10);

    public ShrekOlapSave(String[] dimensions, OlapConnection conn, OlapDataWriter writer) {
        this.dimensions = dimensions;
        this.conn = conn;
        this.writer = writer;
        this.removes.clear();
        this.stats = new LogStats("budget-shrek-log : ");
        this.stats.addInfo("begin-saveData.");
        this.stats.addInfo("user:" + UserUtils.getUserName() + "; userId:" + UserUtils.getUserId());
    }

    @Override
    public void add(String[] metas, Object value) {
        String _str;
        if (metas == null || metas.length == 0) {
            return;
        }
        if (metas.length != this.dimensions.length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e\u6570\u91cf\u4e0e\u6570\u636e\u96c6\u7684\u7ef4\u5ea6\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", (String)"ShrekOlapServiceHelper_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        if (this.values == null || this.values.length != this.dimensions.length + 1) {
            this.values = new Object[this.dimensions.length + 1];
            for (int i = 0; i < 1; ++i) {
                this.values[i] = new ValuePair(null, null);
            }
        } else {
            this.clear(this.values);
        }
        if (value instanceof BigDecimal) {
            BigDecimal _value = (BigDecimal)value;
            if (_value.scale() > 15) {
                value = _value.setScale(15, 4);
            }
            boolean check = false;
            if (_value.compareTo(BgConstant.MAX_VALUE) > 0) {
                _value = BgConstant.MAX_VALUE;
                check = true;
            } else if (_value.compareTo(BgConstant.MIN_VALUE) < 0) {
                _value = BgConstant.MIN_VALUE;
                check = true;
            }
            if (check) {
                String dataStr = Arrays.toString(metas);
                String valueStr = _value.stripTrailingZeros().toPlainString();
                log.warn(ResManager.loadResFormat((String)"\u6700\u5927\u5141\u8bb8\u8f93\u516518\u4f4d\u6570\u503c\uff0c\u201c%1\u201d\u5b58\u5728\u6570\u503c\u201c%2\u201d\u8d85\u51fa\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CubeData_10", (String)"epm-eb-olap", (Object[])new Object[]{dataStr, valueStr}));
            }
        } else if (value instanceof String && (_str = (String)value).length() > 600) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6700\u5927\u5141\u8bb8\u8f93\u5165600\u4e2a\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CubeData_11", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (this.values[0] instanceof ValuePair) {
            ValuePair _pair = (ValuePair)this.values[0];
            _pair.setCurrentValue(value);
        }
        for (Object this.values[j + 1] : metas) {
        }
        ++this.UPDATE_SIZE;
        if (value == null) {
            ++this.REMOVE_SIZE;
            if (this.removes.size() <= 5) {
                this.copy = Arrays.copyOf(this.values, this.values.length);
                this.copy[0] = null;
                this.removes.add(this.copy);
            }
        }
        this.writer.setValues(this.values);
    }

    @Override
    public void addValues(Object[] metaValue) {
        int i;
        if (metaValue == null || metaValue.length == 0) {
            return;
        }
        if (metaValue.length != this.dimensions.length + 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e\u6570\u91cf\u4e0e\u6570\u636e\u96c6\u7684\u7ef4\u5ea6\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", (String)"ShrekOlapServiceHelper_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        if (this.values == null || this.values.length != this.dimensions.length + 1) {
            this.values = new Object[this.dimensions.length + 1];
            for (i = 0; i < 1; ++i) {
                this.values[i] = new ValuePair(null, null);
            }
        } else {
            this.clear(this.values);
        }
        for (i = 0; i < 1; ++i) {
            String _str;
            if (metaValue[i] instanceof BigDecimal) {
                BigDecimal _value = (BigDecimal)metaValue[i];
                if (_value.scale() > 15) {
                    metaValue[i] = _value.setScale(15, 4);
                }
                boolean check = false;
                if (_value.compareTo(BgConstant.MAX_VALUE) > 0) {
                    _value = BgConstant.MAX_VALUE;
                    check = true;
                } else if (_value.compareTo(BgConstant.MIN_VALUE) < 0) {
                    _value = BgConstant.MIN_VALUE;
                    check = true;
                }
                if (check) {
                    String dataStr = Arrays.toString(metaValue);
                    String valueStr = _value.stripTrailingZeros().toPlainString();
                    log.warn(ResManager.loadResFormat((String)"\u6700\u5927\u5141\u8bb8\u8f93\u516518\u4f4d\u6570\u503c\uff0c\u201c%1\u201d\u5b58\u5728\u6570\u503c\u201c%2\u201d\u8d85\u51fa\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CubeData_10", (String)"epm-eb-olap", (Object[])new Object[]{dataStr, valueStr}));
                }
            } else if (metaValue[i] instanceof String && (_str = (String)metaValue[i]).length() > 600) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6587\u672c\u8d85\u8fc7600\u5b57\u7b26\uff0c\u8d85\u51fa\u5b58\u50a8\u9650\u5236\u3002\u76ee\u6807\u7ef4\u5ea6\u7ec4\u5408\uff08%1\uff09\u3002", (String)"CubeData_12", (String)"epm-eb-olap", (Object[])new Object[]{JSON.toJSONString((Object)metaValue)}));
            }
            if (!(this.values[i] instanceof ValuePair)) continue;
            ValuePair _pair = (ValuePair)this.values[i];
            _pair.setCurrentValue(metaValue[i]);
        }
        int jn = metaValue.length;
        for (int j = 1; j < jn; ++j) {
            this.values[j] = metaValue[j];
        }
        ++this.UPDATE_SIZE;
        if (this.values[0] == null) {
            ++this.REMOVE_SIZE;
            if (this.removes.size() <= 5) {
                this.copy = Arrays.copyOf(this.values, this.values.length);
                this.copy[0] = null;
                this.removes.add(this.copy);
            }
        }
        this.writer.setValues(this.values);
    }

    private void clear(Object[] values) {
        int i;
        if (values == null || values.length == 0) {
            return;
        }
        for (i = 0; i < 1; ++i) {
            if (!(values[i] instanceof ValuePair)) continue;
            ValuePair _pair = (ValuePair)values[i];
            _pair.setInitValue(null);
            _pair.setCurrentValue(null);
        }
        int in = values.length;
        for (i = 1; i < in; ++i) {
            values[i] = null;
        }
    }

    @Override
    public void close() {
        this.writer.flush();
        OlapContext.clearSaveDataContext();
        ShrekOlapUtils.close(this.writer, this.conn);
        this.stats.addInfo("all-update-size=" + this.UPDATE_SIZE);
        this.stats.addInfo("remove-size=" + this.REMOVE_SIZE);
        if (!this.removes.isEmpty()) {
            for (Object[] _value : this.removes) {
                this.stats.addInfo(Arrays.toString(_value));
            }
            this.removes.clear();
        }
        this.stats.addInfo("end-saveData.");
        log.info(this.stats.toString());
    }
}

