/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.controller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.olap.backup.BackupFile;
import kd.bos.olap.backup.DirectFile;
import kd.bos.olap.dataSources.BackupCommandInfo;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.FelLambdaExpressionItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.EbShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekEmptySave;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekCubeServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekDimensionServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekExecuteServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekMemberServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.shrek.util.ShrekVerify;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class ShrekOlapServiceHelper
extends ShrekVerify {
    public static boolean isStartShrek() {
        return ShrekConfigServiceHelper.isStartShrek();
    }

    public static boolean needDMLOlap(DynamicObject modelObj) {
        return ShrekConfigServiceHelper.needDMLOlap(modelObj);
    }

    public static OlapConnection getConnection(Model model, Dataset dataset) {
        return ShrekCubeServiceHelper.getConnection(model, dataset);
    }

    public static boolean existCube(Model model, Dataset dataset) {
        return ShrekCubeServiceHelper.existCube(model, dataset);
    }

    public static void createCube(Model model, Dataset dataset, IModelCacheHelper modelCacheHelper, ShrekConfig config) {
        ModelCacheContext.remove();
        ShrekCubeServiceHelper.createCube(model, dataset, modelCacheHelper, config);
    }

    public static void updateCube(Model model, Dataset dataset, IModelCacheHelper modelCacheHelper, ShrekConfig config) {
        ModelCacheContext.remove();
        ShrekCubeServiceHelper.updateCube(model, dataset, modelCacheHelper, config);
    }

    public static void dropCube(Model model, List<Dataset> datasets) {
        ShrekCubeServiceHelper.dropCube(model, datasets);
    }

    public static boolean olapConnectTest(String datasource, String userName, String password) {
        return ShrekCubeServiceHelper.tryOlapConnect(datasource, userName, password);
    }

    public static boolean olapConnectTest(String address, String port, String userName, String password) {
        return ShrekCubeServiceHelper.tryOlapConnect(address, port, userName, password);
    }

    public static void addCubeDimensions(Model model, Dataset dataset, IModelCacheHelper modelCacheHelper, ShrekConfig config) {
        ModelCacheContext.remove();
        ShrekDimensionServiceHelper.addCubeDimensions(model, dataset, modelCacheHelper, config);
    }

    public static void addCubeDimension(Model model, Dataset dataset, List<Long> dimId, IModelCacheHelper modelCacheHelper, ShrekConfig config) {
        ModelCacheContext.remove();
        ShrekDimensionServiceHelper.addCubeDimension(model, dataset, dimId, modelCacheHelper, config);
    }

    public static void updateDimension(Model model, List<Dataset> datasets, String dimNumber, ShrekConfig config) {
        ModelCacheContext.remove();
        ShrekDimensionServiceHelper.updateDimension(model, datasets, dimNumber, null, config);
    }

    public static void updateDimension(Model model, List<Dataset> datasets, String dimNumber, Map<String, Member> oldMembers, ShrekConfig config) {
        ModelCacheContext.remove();
        ShrekDimensionServiceHelper.updateDimension(model, datasets, dimNumber, oldMembers, config);
    }

    public static void dropCubeDimension(Model model, Dataset dataset, String dimensionNumber) {
        ModelCacheContext.remove();
        ShrekDimensionServiceHelper.dropCubeDimension(model, dataset, dimensionNumber);
    }

    public static void dropCubeDimensions(Model model, Dataset dataset) {
        ModelCacheContext.remove();
        ShrekDimensionServiceHelper.dropCubeDimensions(model, dataset);
    }

    public static boolean existCubeDimension(Model model, Dataset dataset, String dimensionNumber) {
        return ShrekDimensionServiceHelper.existCubeDimension(model, dataset, dimensionNumber);
    }

    public static void addCubeMembers(Model model, List<Dataset> datasets, String dimensionNumber, List<Member> members, ShrekConfig config) {
        ModelCacheContext.remove();
        ShrekMemberServiceHelper.addMembers(model, datasets, dimensionNumber, members, config);
        String datasetNums = kd.epm.eb.common.utils.StringUtils.join((Collection)datasets.stream().map(Dataset::getNumber).collect(Collectors.toList()), ',');
        String memberNums = StringUtils.join((Object[])members.stream().map(BaseCache::getNumber).toArray(), (char)',');
        log.info("addCubeMembers-model-" + model.getNumber() + ",dimNumber=" + dimensionNumber + ",datasets=" + datasetNums + ",members=" + memberNums);
    }

    public static Set<String> getAllMembers(Model model, Dataset dataset, String dimensionNumber) {
        return ShrekMemberServiceHelper.getAllMembers(model, dataset, dimensionNumber);
    }

    public static void updateCubeMember(Model model, Dataset dataset, String dimensionNumber, Member member, ShrekConfig config) {
        ShrekOlapServiceHelper.updateCubeMember(model, Collections.singletonList(dataset), dimensionNumber, member, config);
    }

    public static void updateCubeMember(Model model, List<Dataset> datasets, String dimensionNumber, Member member, ShrekConfig config) {
        ShrekOlapServiceHelper.updateCubeMembers(model, datasets, dimensionNumber, Collections.singletonList(member), config);
    }

    public static void updateCubeMembers(Model model, List<Dataset> datasets, String dimensionNumber, List<Member> members, ShrekConfig config) {
        ModelCacheContext.remove();
        ShrekMemberServiceHelper.updateCubeMembers(model, datasets, dimensionNumber, members, config);
    }

    public static void dropCubeMembers(Model model, List<Dataset> datasets, String dimensionNumber, List<String> memberNumbers) {
        ModelCacheContext.remove();
        ShrekMemberServiceHelper.dropCubeMembers(model, datasets, dimensionNumber, memberNumbers);
    }

    public static boolean existCubeData(Model model, List<Dataset> datasets, String dimensionNumber, Set<String> memberNumbers) {
        return ShrekMemberServiceHelper.existCubeDatas(model, datasets, dimensionNumber, memberNumbers);
    }

    public static Set<String> getExistDataMember(Model model, List<Dataset> datasets, String dimensionNumber, Set<String> memberNumbers) {
        return ShrekMemberServiceHelper.getExistDataMember(model, datasets, dimensionNumber, memberNumbers);
    }

    public static Set<String> getExistDataMemberByNotNull(Model model, List<Dataset> datasets, String dimensionNumber, Set<String> memberNumbers, boolean isIgnoreZero) {
        return ShrekMemberServiceHelper.getExistDataMemberByNotNull(model, datasets, dimensionNumber, memberNumbers, isIgnoreZero);
    }

    public static boolean existNoDetailData(IModelCacheHelper modelCache, List<Dataset> datasets, String metricNumber) {
        if (modelCache == null || datasets == null || datasets.isEmpty() || metricNumber == null) {
            return false;
        }
        Model model = modelCache.getModelobj();
        boolean hasData = false;
        for (Dataset dataset : datasets) {
            Map<String, List<Long>> viewsMap = modelCache.getViewGroupViewsByDataSet(dataset.getId());
            List<Dimension> dimensions = modelCache.getDimensionList(dataset.getId());
            for (Dimension dimension : dimensions) {
                Set<String> noLeafNumbers;
                ArrayList<Member> members = new ArrayList<Member>(16);
                if ("Metric".equals(dimension.getNumber())) continue;
                if (viewsMap != null) {
                    List<Long> viewIds = viewsMap.get(dimension.getNumber());
                    if (CollectionUtils.isNotEmpty(viewIds)) {
                        for (Long viewId : viewIds) {
                            members.addAll(dimension.getAllMembers(viewId));
                        }
                    } else {
                        members.addAll(dimension.getAllMembers());
                    }
                } else {
                    members.addAll(dimension.getAllMembers());
                }
                if (StringUtils.equals((CharSequence)dimension.getNumber(), (CharSequence)"Account")) {
                    noLeafNumbers = members.stream().filter(Objects::nonNull).filter(m -> !m.isLeaf()).filter(m -> m.getDatasetId() != null && m.getDatasetId().compareTo(dataset.getId()) == 0).map(BaseCache::getNumber).collect(Collectors.toSet());
                    noLeafNumbers.add("Account");
                } else {
                    noLeafNumbers = members.stream().filter(Objects::nonNull).filter(m -> !m.isLeaf()).map(BaseCache::getNumber).collect(Collectors.toSet());
                }
                if (!(hasData = ShrekMemberServiceHelper.existNoDetailData(model, dataset, dimension.getNumber(), noLeafNumbers, metricNumber))) continue;
                break;
            }
            if (!hasData) continue;
            break;
        }
        return hasData;
    }

    public static ShrekOlapReader queryReader(Model model, Dataset dataset, SelectCommandInfo query, LogStats stats) {
        if (ShrekOlapServiceHelper.verifyElements(model, dataset, query)) {
            return ShrekOlapServiceHelper.emptyReader();
        }
        return ShrekExecuteServiceHelper.queryReader(model, dataset, query, stats);
    }

    public static ShrekOlapReader queryReader(Model model, Dataset dataset, SelectCommandInfo query, boolean hasDynamicCalc, LogStats stats) {
        if (ShrekOlapServiceHelper.verifyElements(model, dataset, query)) {
            return ShrekOlapServiceHelper.emptyReader();
        }
        query.setExcludeDynamicCalcResult(!hasDynamicCalc);
        return ShrekExecuteServiceHelper.queryReader(model, dataset, query, stats);
    }

    public static ShrekOlapReader queryReaderByExcludeDynamicCalc(Model model, Dataset dataset, SelectCommandInfo query, LogStats stats) {
        if (ShrekOlapServiceHelper.verifyElements(model, dataset, query)) {
            return ShrekOlapServiceHelper.emptyReader();
        }
        query.setExcludeDynamicCalcResult(true);
        return ShrekExecuteServiceHelper.queryReader(model, dataset, query, stats);
    }

    public static ShrekOlapReader queryReader(Model model, SelectCommandInfo query, LogStats stats) {
        if (ShrekOlapServiceHelper.verifyElements(model, query)) {
            return ShrekOlapServiceHelper.emptyReader();
        }
        return ShrekExecuteServiceHelper.queryReader(model, query, stats);
    }

    public static ShrekOlapReader emptyReader() {
        return new ShrekOlapReader(null, null);
    }

    public static List<MembersKey> queryData(Model model, Dataset dataset, SelectCommandInfo query) {
        if (ShrekOlapServiceHelper.verifyElements(model, dataset, query)) {
            return null;
        }
        return ShrekExecuteServiceHelper.queryReader(model, dataset, query);
    }

    public static MembersKey queryOne(Model model, Dataset dataset, SelectCommandInfo query) {
        if (ShrekOlapServiceHelper.verifyElements(model, dataset, query)) {
            return null;
        }
        return ShrekExecuteServiceHelper.queryOne(model, dataset, query);
    }

    public static Map<String, Object> queryDataToMap(Model model, Dataset dataset, SelectCommandInfo query) {
        if (ShrekOlapServiceHelper.verifyElements(model, dataset, query)) {
            return null;
        }
        return ShrekExecuteServiceHelper.queryDataToMap(model, dataset, query);
    }

    public static IShrekSave saveData(@NotNull Model model, @NotNull Dataset dataset, @NotNull String[] dimensions, @NotNull Map<String, String> shrekProperties) {
        if (model == null || dataset == null || dimensions == null || dimensions.length == 0) {
            return ShrekOlapServiceHelper.emptySave();
        }
        return ShrekExecuteServiceHelper.saveData(model, dataset, dimensions, shrekProperties);
    }

    public static IShrekSave saveData(@NotNull Model model, @NotNull String[] dimensions, @NotNull Map<String, String> shrekProperties) {
        if (model == null || dimensions == null || dimensions.length == 0) {
            return ShrekOlapServiceHelper.emptySave();
        }
        return ShrekExecuteServiceHelper.saveData(model, null, dimensions, shrekProperties);
    }

    public static IShrekSave saveDataByIncrement(@NotNull Model model, @NotNull String[] dimensions, @NotNull Map<String, String> shrekProperties) {
        if (model == null || dimensions == null || dimensions.length == 0) {
            return ShrekOlapServiceHelper.emptySave();
        }
        return ShrekExecuteServiceHelper.saveDataByIncrement(model, null, dimensions, shrekProperties);
    }

    public static IShrekSave saveDataByIncrement(@NotNull Model model, @NotNull Dataset dataset, @NotNull String[] dimensions, @NotNull Map<String, String> shrekProperties) {
        if (model == null || dimensions == null || dimensions.length == 0) {
            return ShrekOlapServiceHelper.emptySave();
        }
        return ShrekExecuteServiceHelper.saveDataByIncrement(model, dataset, dimensions, shrekProperties);
    }

    public static IShrekSave emptySave() {
        return new ShrekEmptySave();
    }

    @Deprecated
    public static boolean deleteData(Long modelId, Long dataSetId, Map<String, Set<String>> deleteRange, String metricNumber) {
        Dataset dataSet;
        if (IDUtils.isEmptyLong(modelId).booleanValue() || IDUtils.isEmptyLong(dataSetId).booleanValue()) {
            return false;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        Model model = modelCache.getModelobj();
        if (ShrekOlapServiceHelper.verifyElements(model, dataSet = DatasetServiceHelper.getInstance().getDataSet(dataSetId)) || StringUtils.isEmpty((CharSequence)metricNumber)) {
            return false;
        }
        return ShrekExecuteServiceHelper.deleteData(model, dataSet, deleteRange, SysDimensionEnum.Metric.getNumber(), metricNumber);
    }

    @Deprecated
    public static boolean deleteData(Long modelId, Long dataSetId, Map<String, Set<String>> deleteRange, String dimNumber, String memNumber) {
        Dataset dataSet;
        if (IDUtils.isEmptyLong(modelId).booleanValue() || IDUtils.isEmptyLong(dataSetId).booleanValue()) {
            return false;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        Model model = modelCache.getModelobj();
        if (ShrekOlapServiceHelper.verifyElements(model, dataSet = DatasetServiceHelper.getInstance().getDataSet(dataSetId)) || StringUtils.isEmpty((CharSequence)dimNumber) || StringUtils.isEmpty((CharSequence)memNumber)) {
            return false;
        }
        return ShrekExecuteServiceHelper.deleteData(model, dataSet, deleteRange, dimNumber, memNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearParentDataNullForEb(Long memberId, String memberKey) {
        if (IDUtils.isNull(memberId)) {
            return;
        }
        DynamicObject ob = QueryServiceHelper.queryOne((String)memberKey, (String)"number,isleaf,dimension.number,model.id", (QFilter[])new QFilter("id", "=", (Object)memberId).toArray());
        if (ob == null || !ob.getBoolean("isleaf")) {
            return;
        }
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)ob.getLong("model.id"), (String)"epm_model");
        Dataset dataset = new Dataset(model.getLong("id"), model.getString("shownumber"));
        String dimNumber = ob.getString("dimension.number");
        String number = ob.getString("number");
        String left = dimNumber + "@" + number;
        FelLambdaExpressionItem exp = new FelLambdaExpressionItem();
        exp.setExpressLeft(left);
        exp.setExpression("null");
        ComputingCommandInfo info = new ComputingCommandInfo();
        info.getExpressionItems().add(exp);
        info.setMainMeaName("FMONEY");
        info.setMainDimName(dimNumber);
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)info, ShrekIdCodeUtils.getDefaultIdCodes(null));
        OlapConnection conn = null;
        try {
            conn = ShrekOlapServiceHelper.getConnection(Model.of(model), dataset);
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)info);
            cmd.executeCompute();
        }
        finally {
            if (conn != null) {
                conn.Close();
            }
        }
    }

    public static SelectCommandInfo getDefaultSelectCommand() {
        SelectCommandInfo command = new SelectCommandInfo();
        command.setExcludeNull(true);
        return command;
    }

    public static File backupCube(Long modelId, Long dataSetId) throws IOException {
        File file;
        if (IDUtils.isNull(modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlapTableUtils_1", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        Model model = modelCache.getModelobj();
        if (!model.isModelByEB() && IDUtils.isNull(dataSetId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlapTableUtils_2", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        Dataset dataSet = null;
        if (IDUtils.isNotNull(dataSetId)) {
            dataSet = DatasetServiceHelper.getInstance().getDataSet(dataSetId);
        }
        File tempDir = FileUtils.getTempDirectory();
        File genDataDir = dataSet != null ? new File(tempDir, FilenameUtils.getName((String)String.format("modeback_%s_%s", model.getNumber(), dataSet.getNumber()))) : new File(tempDir, FilenameUtils.getName((String)String.format("modeback_%s", model.getNumber())));
        FileUtils.forceMkdir((File)genDataDir);
        BackupCommandInfo commandInfo = new BackupCommandInfo((BackupFile)new DirectFile(genDataDir.getAbsolutePath()));
        OlapConnection conn = null;
        try {
            conn = dataSet != null ? ShrekOlapServiceHelper.getConnection(model, dataSet) : EbShrekOlapServiceHelper.getConnection(model);
            conn.Open();
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)commandInfo);
            cmd.executeBackup();
            List files = (List)FileUtils.listFiles((File)genDataDir, (String[])new String[]{"backup"}, (boolean)false);
            file = (File)files.get(files.size() - 1);
        }
        catch (Exception var10) {
            try {
                String errMsg = ResManager.loadResFormat((String)"\u5907\u4efdCUBE: %1 \u5230\u6587\u4ef6 %2 \u5931\u8d25: %3", (String)"OlapServiceHelper_8", (String)"epm-eb-common", (Object[])new Object[]{dataSetId, genDataDir.getAbsolutePath(), var10.getMessage()});
                throw new KDBizException((Throwable)var10, ErrorCodeUtils.getSystemErrorCode((String)errMsg), new Object[0]);
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close(new Object[]{conn});
                throw throwable;
            }
        }
        ShrekOlapUtils.close(new Object[]{conn});
        return file;
    }
}

