/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.shrek.domain.ShrekConfig;

public class ShrekConfigServiceHelper {
    private static final boolean isStartShrek = Boolean.parseBoolean(System.getProperty("OLAP_STORAGE_SHREK", "true"));

    public static boolean isStartShrek() {
        return isStartShrek;
    }

    public static boolean needDMLOlap(DynamicObject modelObj) {
        return ShrekConfigServiceHelper.isStartShrek() && modelObj != null && modelObj.get("datasource") != null;
    }

    public static ShrekConfig getDefaultConfig(DynamicObject model) {
        if (model != null && BizModel.isEBByModel(model)) {
            return ShrekConfigServiceHelper.getEBConfig();
        }
        return ShrekConfigServiceHelper.getBgMDConfig();
    }

    public static ShrekConfig getDefaultConfig(Model model) {
        if (model != null && model.isModelByEB()) {
            return ShrekConfigServiceHelper.getEBConfig();
        }
        return ShrekConfigServiceHelper.getBgMDConfig();
    }

    public static ShrekConfig getEBConfig() {
        ShrekConfig config = new ShrekConfig();
        config.setDefaultStorageType(MemberStorageTypes.Stored);
        return config;
    }

    public static ShrekConfig getStoredConfig() {
        ShrekConfig config = new ShrekConfig();
        config.setDefaultStorageType(MemberStorageTypes.Stored);
        return config;
    }

    public static ShrekConfig getBgMDConfig() {
        ShrekConfig config = new ShrekConfig();
        config.setDefaultStorageType(MemberStorageTypes.DynamicCalc);
        return config;
    }
}

