/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.ConnectionManager;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekServiceFactory;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import org.apache.commons.collections4.CollectionUtils;

public class ShrekCubeServiceHelper {
    private static final Log log = LogFactory.getLog(ShrekCubeServiceHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existCube(Model model, Dataset dataset) {
        boolean bl;
        ShrekServiceFactory.SHREK_METADATA.verifyElement(model, dataset);
        OlapConnection conn = null;
        try {
            conn = ShrekCubeServiceHelper.getEmptyConnection(model);
            bl = ShrekServiceFactory.SHREK_CUBE.existCube(conn, ShrekOlapUtils.getCubeNumber(dataset));
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCube(Model model, Dataset dataset, IModelCacheHelper modelCacheHelper, ShrekConfig config) {
        OlapConnection conn;
        LogStats stats;
        block15: {
            ShrekServiceFactory.SHREK_METADATA.verifyElement(model, dataset, modelCacheHelper, config);
            stats = new LogStats("budget-shrek-log : ");
            stats.addInfo("begin create cube.");
            conn = null;
            stats.addInfo("cubeNumber:" + ShrekOlapUtils.getCubeNumber(dataset));
            if (!ShrekOlapServiceHelper.existCube(model, dataset)) break block15;
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("end create cube.");
            log.info(stats.toString());
            return;
        }
        try {
            conn = ShrekCubeServiceHelper.getConnection(model, null);
            conn.Open();
            String cubeNumber = ShrekServiceFactory.SHREK_CUBE.createCube(conn, model, dataset);
            ShrekOlapUtils.close(new Object[]{conn});
            conn = ShrekCubeServiceHelper.getConnection(model, dataset);
            conn.Open();
            List<Dimension> dimensions = model.isModelByEB() ? modelCacheHelper.getDimensionList() : modelCacheHelper.getDimensionList(dataset.getId());
            ShrekServiceFactory.SHREK_DIMENSION.createDimension(conn, cubeNumber, dimensions);
            stats.add("end create dimension.");
            ShrekServiceFactory.SHREK_CUBE.createMeasure(conn, cubeNumber);
            stats.add("end create measure.");
            Map<Object, Object> viewsByDataSet = model.isModelByEB() ? new HashMap(16) : modelCacheHelper.getViewGroupViewsByDataSet(dataset.getId());
            for (Dimension dimension : dimensions) {
                List viewIds = new ArrayList(16);
                ArrayList<Member> allMembers = new ArrayList<Member>(16);
                if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
                    allMembers.addAll(dimension.getAllMembersByDataSetId(dataset.getId()));
                } else if (viewsByDataSet != null) {
                    viewIds = (List)viewsByDataSet.get(dimension.getNumber());
                    if (CollectionUtils.isNotEmpty(viewIds)) {
                        for (Long viewId : viewIds) {
                            View view = dimension.getView(viewId);
                            if (view == null) continue;
                            allMembers.addAll(view.getAllMembers());
                        }
                    } else {
                        allMembers.addAll(dimension.getAllMembers());
                    }
                } else {
                    allMembers.addAll(dimension.getAllMembers());
                }
                if (!CollectionUtils.isNotEmpty(allMembers)) continue;
                if (CollectionUtils.isNotEmpty(viewIds)) {
                    for (Long viewId : viewIds) {
                        List<Member> createMembers = ShrekCubeServiceHelper.getCreateMembersByViewId(allMembers, viewId);
                        if (CollectionUtils.isEmpty(createMembers)) continue;
                        ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimension.getNumber(), viewId, createMembers, config);
                    }
                    continue;
                }
                ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimension.getNumber(), 0L, allMembers, config);
            }
            stats.add("end create members.");
            if (!model.isModelByEB()) {
                ShrekServiceFactory.SHREK_CUBE.createPartition(conn, cubeNumber, SysDimensionEnum.BudgetPeriod.getNumber());
            }
            if (!model.isModelByEB()) {
                ShrekServiceFactory.SHREK_CUBE.alterCubeDatabase(conn, cubeNumber, model.getNumber());
            }
            DataLockService.getInstance().updateLockRuleAsync(SysDimensionEnum.Entity.getNumber(), Collections.singletonList(dataset.getId()), model.getId());
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("end create cube.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("end create cube.");
        log.info(stats.toString());
    }

    public static List<Member> getCreateMembersByViewId(List<Member> allMembers, Long viewId) {
        ArrayList<Member> createMembers = new ArrayList<Member>(16);
        if (CollectionUtils.isEmpty(allMembers)) {
            return createMembers;
        }
        if (IDUtils.isEmptyLong(viewId).booleanValue()) {
            return allMembers;
        }
        for (Member member : allMembers) {
            Long tempViewId;
            if (!(member instanceof ViewMember) || !(tempViewId = ((ViewMember)member).getViewId()).equals(viewId)) continue;
            createMembers.add(member);
        }
        return createMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCube(Model model, Dataset dataset, IModelCacheHelper modelCacheHelper, ShrekConfig config) {
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDataset(dataset);
        ShrekServiceFactory.SHREK_METADATA.verifyModel(modelCacheHelper);
        ShrekServiceFactory.SHREK_METADATA.verify(config);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-update-cube.");
        OlapConnection conn = null;
        try {
            stats.addInfo("cubeNumber:" + ShrekOlapUtils.getCubeNumber(dataset));
            conn = ShrekCubeServiceHelper.getConnection(model, dataset);
            conn.Open();
            String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
            List<Dimension> dimensions = model.isModelByEB() ? modelCacheHelper.getDimensionList() : modelCacheHelper.getDimensionList(dataset.getId());
            ShrekServiceFactory.SHREK_DIMENSION.createDimension(conn, cubeNumber, dimensions);
            for (Dimension dimension : dimensions) {
                String dimNumber = dimension.getNumber();
                stats.addInfo("begin-update-dimension:dimNumber=" + dimNumber);
                ShrekServiceFactory.SHREK_DIMENSION.updateDimension(model, conn, cubeNumber, dimNumber, modelCacheHelper, null, dataset, config, stats, true);
            }
            if (!model.isModelByEB()) {
                ShrekServiceFactory.SHREK_CUBE.alterCubeDatabase(conn, cubeNumber, model.getNumber());
            }
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("end-update-cube.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("end-update-cube.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dropCube(Model model, List<Dataset> datasets) {
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDatasets(datasets);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-drop-cube.");
        OlapConnection conn = null;
        try {
            for (Dataset dataset : datasets) {
                try {
                    conn = ShrekCubeServiceHelper.getConnection(model, dataset);
                    conn.Open();
                    String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
                    if (ShrekCubeServiceHelper.existCube(model, dataset)) {
                        ShrekServiceFactory.SHREK_CUBE.dropCube(conn, cubeNumber);
                        stats.add("over-drop-dataset-cube.");
                    }
                }
                catch (Throwable throwable) {
                    ShrekOlapUtils.close(new Object[]{conn});
                    throw throwable;
                }
                ShrekOlapUtils.close(new Object[]{conn});
            }
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("end-drop-cube.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("end-drop-cube.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void clearData(Model model, List<Dataset> datasets) {
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDatasets(datasets);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-clearData-cube.");
        OlapConnection conn = null;
        try {
            for (Dataset dataset : datasets) {
                try {
                    conn = ShrekCubeServiceHelper.getConnection(model, dataset);
                    conn.Open();
                    String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
                    if (ShrekCubeServiceHelper.existCube(model, dataset)) {
                        ShrekServiceFactory.SHREK_CUBE.clearCubeData(conn, cubeNumber);
                        stats.add("over-clearData-dataset-cube.");
                    }
                }
                catch (Throwable throwable) {
                    ShrekOlapUtils.close(new Object[]{conn});
                    throw throwable;
                }
                ShrekOlapUtils.close(new Object[]{conn});
            }
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("end-clearData-cube.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("end-clearData-cube.");
        log.info(stats.toString());
    }

    public static OlapConnection getEmptyConnection(Model model) {
        return ConnectionManager.getInstance().getEmptyConnection(model);
    }

    public static OlapConnection getConnection(Model model, Dataset dataset) {
        return ConnectionManager.getInstance().getConnection(model, dataset);
    }

    public static boolean tryOlapConnect(String datasource, String userName, String password) {
        return ConnectionManager.getInstance().tryOlapConnect(datasource, userName, password);
    }

    public static boolean tryOlapConnect(String address, String port, String userName, String password) {
        return ConnectionManager.getInstance().tryOlapConnect(address, port, userName, password);
    }
}

