/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekCubeServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekServiceFactory;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.LogStats;
import org.apache.commons.collections4.CollectionUtils;

public class ShrekDimensionServiceHelper {
    private static final Log log = LogFactory.getLog(ShrekDimensionServiceHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCubeDimensions(Model model, Dataset dataset, IModelCacheHelper modelCacheHelper, ShrekConfig config) {
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDataset(dataset);
        ShrekServiceFactory.SHREK_METADATA.verifyModel(modelCacheHelper);
        ShrekServiceFactory.SHREK_METADATA.verify(config);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("addDimensionsToCube begin create dimension.");
        OlapConnection conn = null;
        try {
            conn = ShrekOlapServiceHelper.getConnection(model, dataset);
            conn.Open();
            List<Dimension> dimensions = model.isModelByEB() ? modelCacheHelper.getDimensionList() : modelCacheHelper.getDimensionList(dataset.getId());
            String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
            ShrekServiceFactory.SHREK_DIMENSION.createDimension(conn, cubeNumber, dimensions);
            stats.add("addDimensionsToCube end create dimensions.");
            Map<Object, Object> viewsByDataSet = model.isModelByEB() ? new HashMap(16) : modelCacheHelper.getViewGroupViewsByDataSet(dataset.getId());
            for (Dimension dimension : dimensions) {
                ArrayList<Member> allMembers = new ArrayList<Member>(16);
                List viewIds = new ArrayList(16);
                if (viewsByDataSet != null) {
                    viewIds = (List)viewsByDataSet.get(dimension.getNumber());
                    if (CollectionUtils.isNotEmpty(viewIds)) {
                        for (Long viewId : viewIds) {
                            View view = dimension.getView(viewId);
                            if (view == null) continue;
                            allMembers.addAll(view.getAllMembers());
                        }
                    } else {
                        allMembers.addAll(dimension.getAllMembers());
                    }
                } else {
                    allMembers.addAll(dimension.getAllMembers());
                }
                if (!CollectionUtils.isNotEmpty(allMembers)) continue;
                if (CollectionUtils.isNotEmpty(viewIds)) {
                    for (Long viewId : viewIds) {
                        List<Member> createMembers = ShrekCubeServiceHelper.getCreateMembersByViewId(allMembers, viewId);
                        if (CollectionUtils.isEmpty(createMembers)) continue;
                        ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimension.getNumber(), viewId, createMembers, config);
                    }
                    continue;
                }
                ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimension.getNumber(), 0L, allMembers, config);
            }
            DataLockService.getInstance().updateLockRuleAsync(SysDimensionEnum.Entity.getNumber(), Collections.singletonList(dataset.getId()), model.getId());
            stats.add("addDimensionsToCube end create members.");
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("addDimensionsToCube finally create dimensions.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("addDimensionsToCube finally create dimensions.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCubeDimension(Model model, Dataset dataset, List<Long> dimIds, IModelCacheHelper modelCacheHelper, ShrekConfig config) {
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDataset(dataset);
        ShrekServiceFactory.SHREK_METADATA.verifyModel(modelCacheHelper);
        ShrekServiceFactory.SHREK_METADATA.verify(config);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("addDimensionsToCube begin create dimension.");
        OlapConnection conn = null;
        try {
            conn = ShrekOlapServiceHelper.getConnection(model, dataset);
            conn.Open();
            ArrayList<Dimension> dimensions = new ArrayList<Dimension>(dimIds.size());
            for (Long dimId : dimIds) {
                dimensions.add(modelCacheHelper.getDimension(dimId));
            }
            String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
            ShrekServiceFactory.SHREK_DIMENSION.createDimension(conn, cubeNumber, dimensions);
            stats.add("addDimensionsToCube end create dimensions.");
            Map<Object, Object> viewsByDataSet = model.isModelByEB() ? new HashMap(16) : modelCacheHelper.getViewGroupViewsByDataSet(dataset.getId());
            for (Dimension dimension : dimensions) {
                ArrayList<Member> allMembers = new ArrayList<Member>(16);
                List viewIds = new ArrayList(16);
                if (viewsByDataSet != null) {
                    viewIds = (List)viewsByDataSet.get(dimension.getNumber());
                    if (CollectionUtils.isNotEmpty(viewIds)) {
                        for (Long viewId : viewIds) {
                            View view = dimension.getView(viewId);
                            if (view == null) continue;
                            allMembers.addAll(view.getAllMembers());
                        }
                    } else {
                        allMembers.addAll(dimension.getAllMembers());
                    }
                } else {
                    allMembers.addAll(dimension.getAllMembers());
                }
                if (!CollectionUtils.isNotEmpty(allMembers)) continue;
                if (CollectionUtils.isNotEmpty(viewIds)) {
                    for (Long viewId : viewIds) {
                        List<Member> createMembers = ShrekCubeServiceHelper.getCreateMembersByViewId(allMembers, viewId);
                        if (CollectionUtils.isEmpty(createMembers)) continue;
                        ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimension.getNumber(), viewId, createMembers, config);
                    }
                    continue;
                }
                ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimension.getNumber(), 0L, allMembers, config);
            }
            stats.add("addDimensionsToCube end create members.");
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("addDimensionsToCube finally create dimensions.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("addDimensionsToCube finally create dimensions.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCubeDimension(Model model, Dataset dataset, List<Dimension> dimensions, Map<String, List<Member>> memberMap, IModelCacheHelper modelCacheHelper, ShrekConfig config) {
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDataset(dataset);
        ShrekServiceFactory.SHREK_METADATA.verifyModel(modelCacheHelper);
        ShrekServiceFactory.SHREK_METADATA.verify(config);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("addDimensionsToCube begin create dimension.");
        OlapConnection conn = null;
        try {
            conn = ShrekOlapServiceHelper.getConnection(model, dataset);
            conn.Open();
            String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
            ShrekServiceFactory.SHREK_DIMENSION.createDimension(conn, cubeNumber, dimensions);
            stats.add("addDimensionsToCube end create dimensions.");
            Map<Object, Object> viewsByDataSet = model.isModelByEB() ? new HashMap(16) : modelCacheHelper.getViewGroupViewsByDataSet(dataset.getId());
            for (Dimension dimension : dimensions) {
                String dimNumber = dimension.getNumber();
                List<Member> members = memberMap.get(dimNumber);
                if (viewsByDataSet != null) {
                    List viewIds = (List)viewsByDataSet.get(dimension.getNumber());
                    if (CollectionUtils.isNotEmpty((Collection)viewIds)) {
                        for (Long viewId : viewIds) {
                            List<Member> createMembers = ShrekCubeServiceHelper.getCreateMembersByViewId(members, viewId);
                            if (CollectionUtils.isEmpty(createMembers)) continue;
                            ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimNumber, viewId, createMembers, config);
                        }
                        continue;
                    }
                    ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimNumber, 0L, members, config);
                    continue;
                }
                ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimNumber, 0L, members, config);
            }
            DataLockService.getInstance().updateLockRuleAsync(SysDimensionEnum.Entity.getNumber(), Collections.singletonList(dataset.getId()), model.getId());
            stats.add("addDimensionsToCube end create members.");
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("addDimensionsToCube finally create dimensions.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("addDimensionsToCube finally create dimensions.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDimension(Model model, List<Dataset> datasets, String dimNumber, Map<String, Member> oldMembers, ShrekConfig config) {
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDatasets(datasets);
        ShrekServiceFactory.SHREK_METADATA.verifyDimensions(dimNumber);
        ShrekServiceFactory.SHREK_METADATA.verify(config);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-update-dimension.dimNumber=" + dimNumber);
        OlapConnection conn = null;
        try {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(model.getId());
            Dimension dimension = modelCache.getDimension(dimNumber);
            CubeUtils.updateDimensionVersion(model.getId(), dimension.getId());
            modelCache = ModelCacheContext.getOrCreate(model.getId());
            for (Dataset dataset : datasets) {
                block6: {
                    String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
                    stats.addInfo("datasetNumber=" + dataset.getNumber() + " cubeNumber=" + cubeNumber);
                    try {
                        conn = ShrekOlapServiceHelper.getConnection(model, dataset);
                        conn.Open();
                        if (oldMembers == null) {
                            ShrekServiceFactory.SHREK_DIMENSION.updateDimension(model, conn, cubeNumber, dimNumber, modelCache, oldMembers, dataset, config, stats, true);
                            break block6;
                        }
                        ShrekServiceFactory.SHREK_DIMENSION.updateDimension(model, conn, cubeNumber, dimNumber, modelCache, oldMembers, dataset, config, stats, false);
                    }
                    catch (Throwable throwable) {
                        ShrekOlapUtils.close(new Object[]{conn});
                        throw throwable;
                    }
                }
                ShrekOlapUtils.close(new Object[]{conn});
            }
            DataLockService.getInstance().updateLockRuleAsync(dimNumber, datasets.stream().map(Dataset::getId).collect(Collectors.toList()), model.getId());
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("end-update-dimension.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("end-update-dimension.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateAnalyzeViewDimension(Model model, List<Dataset> datasets, String dimNumber, Long analyzeViewId, ShrekConfig config) {
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDatasets(datasets);
        ShrekServiceFactory.SHREK_METADATA.verifyDimensions(dimNumber);
        ShrekServiceFactory.SHREK_METADATA.verify(config);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-update-analyzeViewDimension.");
        OlapConnection conn = null;
        try {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(model.getId());
            for (Dataset dataset : datasets) {
                String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
                stats.addInfo("datasetNumber=" + dataset.getNumber() + " cubeNumber=" + cubeNumber);
                try {
                    conn = ShrekOlapServiceHelper.getConnection(model, dataset);
                    conn.Open();
                    ShrekServiceFactory.SHREK_DIMENSION.updateAnalyzeViewDimension(model, conn, dataset, cubeNumber, dimNumber, analyzeViewId, modelCache, config, stats);
                }
                catch (Throwable throwable) {
                    ShrekOlapUtils.close(new Object[]{conn});
                    throw throwable;
                }
                ShrekOlapUtils.close(new Object[]{conn});
            }
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("end-update-analyzeViewDimension.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("end-update-analyzeViewDimension.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dropAnalyzeViewDimension(Model model, List<Dataset> datasets, String dimNumber, Long analyzeViewId, ShrekConfig config) {
        OlapConnection conn;
        LogStats stats;
        block7: {
            ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
            ShrekServiceFactory.SHREK_METADATA.verifyDatasets(datasets);
            ShrekServiceFactory.SHREK_METADATA.verifyDimensions(dimNumber);
            ShrekServiceFactory.SHREK_METADATA.verify(config);
            stats = new LogStats("budget-shrek-log : ");
            stats.addInfo("begin-drop-analyzeViewDimension.");
            conn = null;
            try {
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(model.getId());
                for (Dataset dataset : datasets) {
                    if (ShrekOlapServiceHelper.existCube(model, dataset)) {
                        String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
                        try {
                            conn = ShrekOlapServiceHelper.getConnection(model, dataset);
                            conn.Open();
                            ShrekServiceFactory.SHREK_DIMENSION.dropAnalyzeDimension(conn, model, cubeNumber, dimNumber, analyzeViewId, modelCache, config);
                        }
                        catch (Throwable throwable) {
                            ShrekOlapUtils.close(new Object[]{conn});
                            throw throwable;
                        }
                        ShrekOlapUtils.close(new Object[]{conn});
                        continue;
                    }
                    break block7;
                }
                DataLockService.getInstance().updateLockRuleAsync(dimNumber, datasets.stream().map(Dataset::getId).collect(Collectors.toList()), model.getId());
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close(new Object[]{conn});
                stats.addInfo("end-drop-analyzeViewDimension.");
                log.info(stats.toString());
                throw throwable;
            }
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("end-drop-analyzeViewDimension.");
            log.info(stats.toString());
            return;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("end-drop-analyzeViewDimension.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropCubeDimension(Model model, Dataset dataset, String dimensionNumber) {
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDataset(dataset);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-drop-cubeDimension.");
        String cubeNumber = null;
        OlapConnection conn = null;
        try {
            conn = ShrekOlapServiceHelper.getConnection(model, dataset);
            conn.Open();
            cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
            if (ShrekOlapServiceHelper.existCube(model, dataset)) {
                ShrekServiceFactory.SHREK_DIMENSION.dropDimension(conn, cubeNumber, dimensionNumber);
            }
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("end-drop-cubeDimension.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("end-drop-cubeDimension.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropCubeDimensions(Model model, Dataset dataset) {
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDataset(dataset);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin drop cube.");
        String cubeNumber = null;
        OlapConnection conn = null;
        try {
            conn = ShrekOlapServiceHelper.getConnection(model, dataset);
            conn.Open();
            cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
            if (ShrekOlapServiceHelper.existCube(model, dataset)) {
                ShrekServiceFactory.SHREK_DIMENSION.dropDimension(conn, cubeNumber, dataset.getDimensions().toArray(new String[0]));
                stats.add("end drop dataset cube.");
            }
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("end drop cube.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("end drop cube.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existCubeDimension(Model model, Dataset dataset, String dimensionNumber) {
        OlapConnection conn;
        LogStats stats;
        block2: {
            boolean bl;
            ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
            ShrekServiceFactory.SHREK_METADATA.verifyDataset(dataset);
            stats = new LogStats("budget-shrek-log : ");
            stats.addInfo("begin-drop-cubeDimension.");
            String cubeNumber = null;
            conn = null;
            try {
                conn = ShrekOlapServiceHelper.getConnection(model, dataset);
                conn.Open();
                cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
                if (!ShrekOlapServiceHelper.existCube(model, dataset)) break block2;
                bl = ShrekServiceFactory.SHREK_DIMENSION.existDimension(conn, cubeNumber, dimensionNumber);
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close(new Object[]{conn});
                stats.addInfo("end-drop-cubeDimension.");
                log.info(stats.toString());
                throw throwable;
            }
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("end-drop-cubeDimension.");
            log.info(stats.toString());
            return bl;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("end-drop-cubeDimension.");
        log.info(stats.toString());
        return false;
    }
}

