/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.DistinctSelectCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.metadata.IMetadataBuilder;
import kd.bos.olap.metadata.StringMetadataBuilder;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekCubeServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekServiceFactory;
import kd.epm.eb.common.shrek.service.bean.FactorBean;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.shrek.util.ShrekParamUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;

public class ShrekMemberServiceHelper {
    private static final Log log = LogFactory.getLog(ShrekMemberServiceHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMembers(Model model, List<Dataset> datasets, String dimensionNumber, List<Member> members, ShrekConfig config) {
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDatasets(datasets);
        ShrekServiceFactory.SHREK_METADATA.verifyDimensions(dimensionNumber);
        ShrekServiceFactory.SHREK_METADATA.verifyMembers(members);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-addMembers.");
        config.setStats(stats);
        OlapConnection conn = null;
        try {
            stats.addInfo("addCubeMembers begin create members.");
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(model.getId());
            for (Dataset dataset : datasets) {
                try {
                    conn = ShrekOlapServiceHelper.getConnection(model, dataset);
                    conn.Open();
                    String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
                    List<Long> views = modelCache.getViewGroupViewsByDataSetAndDimNumber(dataset.getId(), dimensionNumber);
                    if (CollectionUtils.isNotEmpty(views)) {
                        for (Long viewId : views) {
                            List<Member> createMembers = ShrekCubeServiceHelper.getCreateMembersByViewId(members, viewId);
                            if (org.apache.commons.collections4.CollectionUtils.isEmpty(createMembers)) continue;
                            ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimensionNumber, viewId, createMembers, config);
                        }
                    } else {
                        ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimensionNumber, 0L, members, config);
                    }
                    DataLockService.getInstance().updateLockRuleAsync(dimensionNumber, datasets.stream().map(Dataset::getId).collect(Collectors.toList()), model.getId());
                    stats.add("end-add-dataset=" + dataset.getNumber());
                }
                catch (Throwable throwable) {
                    ShrekOlapUtils.close(new Object[]{conn});
                    throw throwable;
                }
                ShrekOlapUtils.close(new Object[]{conn});
            }
            stats.add("addCubeMembers end create members.");
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("addCubeMembers finally create members.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("addCubeMembers finally create members.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getAllMembers(Model model, Dataset dataset, String dimensionNumber) {
        Set<String> set;
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDataset(dataset);
        ShrekServiceFactory.SHREK_METADATA.verifyDimensions(dimensionNumber);
        OlapConnection conn = null;
        try {
            conn = ShrekOlapServiceHelper.getConnection(model, dataset);
            conn.Open();
            String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
            set = ShrekServiceFactory.SHREK_MEMBER.getAllMembers(conn, cubeNumber, dimensionNumber, false);
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCubeMembers(Model model, List<Dataset> datasets, String dimensionNumber, List<Member> members, ShrekConfig config) {
        ShrekServiceFactory.SHREK_METADATA.verifyElement(model, config);
        ShrekServiceFactory.SHREK_METADATA.verifyDatasets(datasets);
        ShrekServiceFactory.SHREK_METADATA.verifyDimensions(dimensionNumber);
        ShrekServiceFactory.SHREK_METADATA.verifyMembers(members);
        LogStats stats = new LogStats("budget-shrek-log : ");
        OlapConnection conn = null;
        try {
            if (SysDimensionEnum.Entity.getNumber().equals(dimensionNumber)) {
                config.setCubeParams(ShrekParamUtils.getCubeParamsByCache(model.getId()));
            } else {
                config.setCubeParams(null);
            }
            stats.addInfo("updateCubeMembers begin update members.");
            for (Dataset dataset : datasets) {
                try {
                    conn = ShrekOlapServiceHelper.getConnection(model, dataset);
                    conn.Open();
                    ShrekServiceFactory.SHREK_MEMBER.updateMembers(conn, ShrekOlapUtils.getCubeNumber(dataset), dimensionNumber, members, config);
                }
                catch (Throwable throwable) {
                    ShrekOlapUtils.close(new Object[]{conn});
                    throw throwable;
                }
                ShrekOlapUtils.close(new Object[]{conn});
            }
            DataLockService.getInstance().updateLockRuleAsync(dimensionNumber, datasets.stream().map(Dataset::getId).collect(Collectors.toList()), model.getId());
            stats.add("updateCubeMembers end update members.");
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("updateCubeMembers finally update members.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("updateCubeMembers finally update members.");
        log.info(stats.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropCubeMembers(Model model, List<Dataset> datasets, String dimensionNumber, List<String> memberNumbers) {
        ShrekServiceFactory.SHREK_METADATA.verifyElement(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDatasets(datasets);
        ShrekServiceFactory.SHREK_METADATA.verifyDimensions(dimensionNumber);
        ShrekServiceFactory.SHREK_METADATA.verifyMemberList(memberNumbers);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("dropCubeMembers end drop begin.");
        OlapConnection conn = null;
        try {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(model.getId());
            for (Dataset dataset : datasets) {
                block5: {
                    try {
                        conn = ShrekOlapServiceHelper.getConnection(model, dataset);
                        conn.Open();
                        String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
                        if (!ShrekOlapServiceHelper.existCube(model, dataset)) break block5;
                        ShrekServiceFactory.SHREK_MEMBER.dropMembers(conn, cubeNumber, dimensionNumber, memberNumbers, modelCache);
                        stats.add("dropCubeMembers end drop member.");
                    }
                    catch (Throwable throwable) {
                        ShrekOlapUtils.close(new Object[]{conn});
                        throw throwable;
                    }
                }
                ShrekOlapUtils.close(new Object[]{conn});
            }
            DataLockService.getInstance().updateLockRuleAsync(dimensionNumber, datasets.stream().map(Dataset::getId).collect(Collectors.toList()), model.getId());
        }
        catch (Throwable throwable) {
            ShrekOlapUtils.close(new Object[]{conn});
            stats.addInfo("dropCubeMembers finally drop member.");
            log.info(stats.toString());
            throw throwable;
        }
        ShrekOlapUtils.close(new Object[]{conn});
        stats.addInfo("dropCubeMembers finally drop member.");
        log.info(stats.toString());
    }

    public static boolean existCubeDatas(Model model, List<Dataset> datasets, String dimensionNumber, Set<String> memberNumbers) {
        ShrekServiceFactory.SHREK_METADATA.verifyElement(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDatasets(datasets);
        ShrekServiceFactory.SHREK_METADATA.verifyDimensions(dimensionNumber);
        ShrekServiceFactory.SHREK_METADATA.verifyMemberList(memberNumbers);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("existCubeDatas begin.");
        boolean existDatas = ShrekServiceFactory.SHREK_MEMBER.existData(model, datasets, dimensionNumber, memberNumbers);
        stats.addInfo("existCubeDatas end check member.");
        log.info(stats.toString());
        return existDatas;
    }

    public static Set<String> getExistDataMember(Model model, List<Dataset> datasets, String dimensionNumber, Set<String> memberNumbers) {
        if (memberNumbers == null || memberNumbers.isEmpty()) {
            return Collections.emptySet();
        }
        ShrekServiceFactory.SHREK_METADATA.verifyElement(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDatasets(datasets);
        ShrekServiceFactory.SHREK_METADATA.verifyDimensions(dimensionNumber);
        ShrekServiceFactory.SHREK_METADATA.verifyMemberList(memberNumbers);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("getExistDataMember begin.");
        HashSet returnDatas = Sets.newHashSetWithExpectedSize((int)memberNumbers.size());
        for (Dataset dataset : datasets) {
            Set<String> existDataMember = ShrekServiceFactory.SHREK_MEMBER.getExistDataMember(model, dataset, dimensionNumber, memberNumbers);
            returnDatas.addAll(existDataMember);
        }
        stats.add("getExistDataMember end check member.");
        log.info(stats.toString());
        return returnDatas;
    }

    public static Set<String> getExistDataMemberByNotNull(Model model, List<Dataset> datasets, String dimensionNumber, Set<String> memberNumbers, boolean isIgnoreZero) {
        ShrekServiceFactory.SHREK_METADATA.verifyElement(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDatasets(datasets);
        ShrekServiceFactory.SHREK_METADATA.verifyDimensions(dimensionNumber);
        ShrekServiceFactory.SHREK_METADATA.verifyMemberList(memberNumbers);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("getExistDataMemberByNotNull begin.");
        HashSet returnDatas = Sets.newHashSetWithExpectedSize((int)memberNumbers.size());
        for (int i = 0; i < datasets.size(); ++i) {
            for (Dataset dataset : datasets) {
                Set<String> existDataMember = ShrekServiceFactory.SHREK_MEMBER.getExistDataMemberByNotNull(model, dataset, dimensionNumber, memberNumbers, isIgnoreZero);
                returnDatas.addAll(existDataMember);
            }
        }
        stats.add("getExistDataMemberByNotNull end check member.");
        log.info(stats.toString());
        return returnDatas;
    }

    public static Map<String, Set<String>> checkRangeDetail(Model model, Dataset dataset, Map<String, Set<String>> changeRange) {
        OlapConnection conn = null;
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)changeRange.size());
        try {
            conn = ShrekOlapServiceHelper.getConnection(model, dataset);
            String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
            for (Map.Entry<String, Set<String>> entry : changeRange.entrySet()) {
                String dimNumber = entry.getKey();
                Set<String> members = entry.getValue();
                for (String member : members) {
                    List factorBeans;
                    String storageType;
                    PropertyBag factors = ShrekServiceFactory.SHREK_METADATA.getFactors(conn, cubeNumber, dimNumber, member);
                    String result = factors.get("result");
                    if (!StringUtils.isNotEmpty(result) || !"dynamicCalc".equals(storageType = ((FactorBean)(factorBeans = (List)JsonUtils.readValue(result, new TypeReference<ArrayList<FactorBean>>(){})).get(0)).getStorageType())) continue;
                    Set strings = returnMap.computeIfAbsent(dimNumber, v -> new HashSet(4));
                    strings.add(member);
                }
            }
        }
        catch (Exception e) {
            try {
                log.warn("checkRangeNoDetail", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close(new Object[]{conn});
                throw throwable;
            }
        }
        ShrekOlapUtils.close(new Object[]{conn});
        return returnMap;
    }

    public static boolean existNoDetailData(Model model, Dataset dataset, String dimensionNumber, Set<String> memberNumbers, String metricNumber) {
        if (model == null || dimensionNumber == null || memberNumbers == null || memberNumbers.isEmpty() || metricNumber == null) {
            return false;
        }
        boolean hasData = false;
        OlapConnection conn = null;
        OlapDataReader reader = null;
        try {
            conn = ShrekOlapServiceHelper.getConnection(model, dataset);
            DistinctSelectCommandInfo select = new DistinctSelectCommandInfo();
            select.addFilter(dimensionNumber, memberNumbers.toArray(new String[0]));
            select.addFilter(SysDimensionEnum.Metric.getNumber(), new String[]{metricNumber});
            select.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            select.setExcludeNull(true);
            select.setExcludeDynamicCalcResult(true);
            select.setTop(1);
            select.setDimensions(CollectionUtils.asList(dimensionNumber, SysDimensionEnum.Metric.getNumber()));
            reader = new OlapCommand(conn, (CommandInfo)select).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
            if (reader.next()) {
                hasData = true;
            }
        }
        catch (Exception ex) {
            try {
                log.error("existNoDetailData", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close(reader, conn);
                throw throwable;
            }
        }
        ShrekOlapUtils.close(reader, conn);
        return hasData;
    }

    public static void addFunctionVirtualMembers(OlapConnection conn, String cubeNumber, Model model, Dataset dataset, String dimensionNumber, List<Member> members, ShrekConfig config) {
        ShrekServiceFactory.SHREK_METADATA.verifyModel(model);
        ShrekServiceFactory.SHREK_METADATA.verifyDatasets(Lists.newArrayList((Object[])new Dataset[]{dataset}));
        ShrekServiceFactory.SHREK_METADATA.verifyDimensions(dimensionNumber);
        ShrekServiceFactory.SHREK_METADATA.verifyMembers(members);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-addFunVirMembers.");
        config.setStats(stats);
        stats.addInfo("addCubeMembers begin create funVir members.");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(model.getId());
        Long viewId = modelCache.getViewByDataSetAndDimNumber(dataset.getId(), dimensionNumber);
        ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimensionNumber, viewId, members, config);
        stats.add("end-add-dataset=" + dataset.getNumber());
        stats.add("addCubeMembers end create funVir members.");
        stats.addInfo("addCubeMembers finally create funVir members.");
        log.info(stats.toString());
    }
}

