/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.service;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekServiceFactory;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.cache.Cache;
import org.apache.commons.lang3.StringUtils;

public class ShrekServerHelper {
    private static final Log log = LogFactory.getLog(ShrekServerHelper.class);
    private static ShrekServerHelper INSTANCE = null;
    private static final String SHREK_SERVICE_VERSION_KEY = "Shrek-Check-Service-Version-";

    public static ShrekServerHelper get() {
        if (INSTANCE == null) {
            INSTANCE = new ShrekServerHelper();
        }
        return INSTANCE;
    }

    public boolean equalsVersion(Model model, Dataset dataset, int majorVersion, int minorVersion, int subVersion) {
        if (model == null) {
            return false;
        }
        String cacheKey = model.getId().toString();
        if (dataset != null) {
            cacheKey = cacheKey + '#' + dataset.getId().toString();
        }
        boolean check = false;
        String cacheRes = Cache.get().get(SHREK_SERVICE_VERSION_KEY + cacheKey);
        if (cacheRes == null) {
            Object[] versions = this.getShrekVersion(model, dataset);
            if (versions != null && versions.length == 3) {
                int _majorVer = 0;
                int _minorVer = 0;
                int _subVersion = 0;
                try {
                    _majorVer = this.getVersion(versions[1]);
                    _minorVer = this.getVersion(versions[2]);
                    _subVersion = this.getSubVersion(versions[0]);
                }
                catch (Exception ex) {
                    log.error("shrekVersion-error:", (Throwable)ex);
                }
                if (_majorVer == 0 && _minorVer == 0 && _subVersion == 0) {
                    return false;
                }
                if (_majorVer > majorVersion || _majorVer == majorVersion && _minorVer > minorVersion) {
                    check = true;
                } else if (_majorVer == majorVersion && _minorVer == minorVersion) {
                    check = _subVersion >= subVersion;
                }
            }
            Cache.get().set(SHREK_SERVICE_VERSION_KEY + cacheKey, String.valueOf(check), 60, TimeUnit.SECONDS);
        } else {
            check = Boolean.parseBoolean(cacheRes);
        }
        return check;
    }

    private int getVersion(Object version) {
        int _version = 0;
        if (version instanceof Integer) {
            _version = (Integer)version;
        }
        return _version;
    }

    private int getSubVersion(Object version) {
        String[] tmpStr;
        int _version = 0;
        if (version instanceof String && (tmpStr = ((String)version).split("\\.")).length > 0) {
            try {
                _version = Integer.parseInt(tmpStr[tmpStr.length - 1]);
            }
            catch (Exception ex) {
                log.error("getSubVersion-error:", (Throwable)ex);
            }
        }
        return _version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getShrekVersion(Model model, Dataset dataset) {
        OlapConnection conn;
        Object[] versions;
        block4: {
            ShrekServiceFactory.SHREK_METADATA.verifyElement(model);
            versions = null;
            conn = null;
            try {
                Map verJson;
                conn = ShrekOlapServiceHelper.getConnection(model, dataset);
                FunctionCommandInfo command = new FunctionCommandInfo("getServerInfo", new PropertyBag());
                PropertyBag propertyBag = new OlapCommand(conn, (CommandInfo)command).executeFunction();
                String propertyValue = propertyBag.get("version");
                if (!StringUtils.isNotEmpty((CharSequence)propertyValue) || (verJson = (Map)JSON.parse((String)propertyValue)) == null) break block4;
                versions = new Object[]{verJson.get("stringValue"), verJson.get("majorVersion"), verJson.get("minorVersion")};
                log.info("check-server-version:" + versions[0]);
            }
            catch (Exception ex) {
                try {
                    log.error("shrekVersion-error:", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    ShrekOlapUtils.close(new Object[]{conn});
                    throw throwable;
                }
                ShrekOlapUtils.close(new Object[]{conn});
            }
        }
        ShrekOlapUtils.close(new Object[]{conn});
        return versions;
    }
}

