/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.dataSources.AggFactorMetadataItem;
import kd.bos.olap.dataSources.AggOperators;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.MemberMetadataItem;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.MetadataItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.olap.metadata.MetadataTypes;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.service.ShrekServiceFactory;
import kd.epm.eb.common.shrek.service.interfaces.IDynamicCalc;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.shrek.util.ShrekParamUtils;

public class DynamicCalc
implements IDynamicCalc {
    private static final Log log = LogFactory.getLog(DynamicCalc.class);

    @Override
    public void syncDynamicCalc(Model model, OlapConnection conn, String cubeNumber, String dimension, Collection<Member> members) {
        this.verifyElement(conn);
        this.verifyDimensions(dimension);
        this.verifyMembers(members);
        if (members.size() == 0) {
            return;
        }
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.alter);
        meta.setMetadataType(MetadataTypes.Member);
        meta.setOwnerUniqueName(cubeNumber + "." + dimension);
        ShrekParamUtils.CubeParams cubeParams = null;
        if (SysDimensionEnum.Entity.getNumber().equals(dimension) && (cubeParams = ShrekParamUtils.getCubeParamsByCache(model.getId())) != null && cubeParams.hasDynamicStore()) {
            meta.getProperties().set("enabledDS", "true");
        }
        Set<String> existMember = ShrekServiceFactory.SHREK_MEMBER.getAllMembers(conn, cubeNumber, dimension, true);
        List items = meta.getItems();
        boolean isAccount = !model.isModelByEB() && SysDimensionEnum.Account.getNumber().equals(dimension);
        for (Member member : members) {
            this.syncDynamicCalc(dimension, member, isAccount, existMember, items, cubeParams);
        }
        if (!items.isEmpty()) {
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)meta, null);
            try {
                OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
                command.executeNonQuery();
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    @Override
    public void syncDynamicCalc(String dimension, Member member, boolean needCheckDataset, Set<String> existMember, List<MetadataItem> items, ShrekParamUtils.CubeParams cubeParams) {
        if (member == null || items == null) {
            return;
        }
        MemberMetadataItem item = new MemberMetadataItem(member.getNumber());
        if (member.isLeaf()) {
            item.setStorageType(MemberStorageTypes.Stored);
            item.setFactors(Collections.emptyList());
        } else if (cubeParams != null && cubeParams.getLevels() != null && cubeParams.getLevels().contains(member.getLevel())) {
            item.setStorageType(MemberStorageTypes.DynamicCalcAndStored);
            item = this.syncDynamicCalc(dimension, member, item, existMember, needCheckDataset);
        } else {
            item.setStorageType(MemberStorageTypes.DynamicCalc);
            item = this.syncDynamicCalc(dimension, member, item, existMember, needCheckDataset);
        }
        items.add((MetadataItem)item);
    }

    @Override
    public MemberMetadataItem syncDynamicCalc(String dimension, Member member, MemberMetadataItem item, Set<String> existMembers, boolean needCheckDataset) {
        if (member == null || item == null) {
            return item;
        }
        boolean isRoot = dimension.equals(member.getNumber());
        ArrayList aggItems = Lists.newArrayListWithCapacity((int)member.getChildren().size());
        HashSet existChild = Sets.newHashSetWithExpectedSize((int)member.getChildren().size());
        for (Member _child : member.getChildren()) {
            AggOperators _operator;
            if (existMembers != null && !existMembers.contains(_child.getNumber().toLowerCase()) || !isRoot && needCheckDataset && !_child.getDatasetId().equals(member.getDatasetId()) || !existChild.add(_child.getNumber()) || (_operator = this.getOperator(_child)).equals((Object)AggOperators.NoConsolidationInCurrentDimension)) continue;
            aggItems.add(new AggFactorMetadataItem(_child.getNumber(), _operator));
        }
        if (!aggItems.isEmpty()) {
            item.repairFactors((List)aggItems);
        } else {
            item.setFactors((List)aggItems);
        }
        return item;
    }

    private AggOperators getOperator(Member member) {
        if (member == null) {
            return AggOperators.PLUS;
        }
        String aggType = member.getAggType();
        if (AggOprtEnum.ADD.getSign().equals(aggType)) {
            return AggOperators.PLUS;
        }
        if (AggOprtEnum.SUBSTRACT.getSign().equals(aggType)) {
            return AggOperators.SUBTRACT;
        }
        if (AggOprtEnum.SKIP.getSign().equals(aggType)) {
            return AggOperators.NoConsolidationInCurrentDimension;
        }
        return AggOperators.PLUS;
    }
}

