/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.service.impl;

import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.olap.metadata.OlapDataTypes;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.shrek.service.ShrekServiceFactory;
import kd.epm.eb.common.shrek.service.interfaces.IShrekCube;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;

public class ShrekCube
implements IShrekCube {
    @Override
    public boolean existCube(OlapConnection conn, String cubeName) {
        return Boolean.parseBoolean(ShrekServiceFactory.SHREK_METADATA.exitCube(conn, cubeName, false).get("exist"));
    }

    @Override
    public String createCube(OlapConnection conn, Model model, Dataset dataset) {
        this.verify(conn);
        this.verifyModel(model);
        this.verifyDataset(dataset);
        String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.create);
        meta.setMetadataType(MetadataTypes.Cube);
        meta.setName(cubeNumber);
        meta.getProperties().set("caption", ShrekOlapUtils.getCubeCaption(model, dataset));
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)meta, null);
        OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
        command.executeNonQuery();
        return cubeNumber;
    }

    @Override
    public void alterCubeDatabase(OlapConnection olapConn, String cubeNumber, String database) {
        MetadataCommandInfo commandInfo = new MetadataCommandInfo();
        commandInfo.setMetadataType(MetadataTypes.Cube);
        commandInfo.setName(cubeNumber);
        commandInfo.setOwnerUniqueName(cubeNumber);
        commandInfo.setAction(CommandTypes.alter);
        commandInfo.getProperties().set("database", database);
        OlapCommand command = new OlapCommand(olapConn, (CommandInfo)commandInfo);
        command.executeNonQuery();
    }

    @Override
    public boolean createMeasure(OlapConnection conn, String cubeNumber) {
        return this.createMeasure(conn, cubeNumber, "FMONEY");
    }

    @Override
    public boolean createMeasure(OlapConnection conn, String cubeNumber, String measure) {
        this.verify(conn);
        this.verifyCube(cubeNumber);
        this.verifyMeasure(measure);
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.create);
        meta.setMetadataType(MetadataTypes.Measure);
        meta.setName(measure.trim());
        meta.setOwnerUniqueName(cubeNumber);
        meta.setDataType(OlapDataTypes.object);
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)meta, null);
        OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
        command.executeNonQuery();
        return true;
    }

    @Override
    public boolean dropCube(OlapConnection conn, String cubeNumber) {
        this.verify(conn);
        this.verifyCube(cubeNumber);
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.drop);
        meta.setMetadataType(MetadataTypes.Cube);
        meta.setName(cubeNumber.trim());
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)meta, null);
        OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
        command.executeNonQuery();
        return true;
    }

    @Override
    public boolean clearCubeData(OlapConnection conn, String cubeNumber) {
        this.verify(conn);
        this.verifyCube(cubeNumber);
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.repair);
        meta.setMetadataType(MetadataTypes.Cube);
        meta.setName(cubeNumber.trim());
        meta.getProperties().set("ClearAll", "true");
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)meta, null);
        OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
        command.executeNonQuery();
        return true;
    }

    @Override
    public boolean createPartition(OlapConnection conn, String cubeNumber, String ... dimNumbers) {
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setMetadataType(MetadataTypes.Partition);
        meta.setAction(CommandTypes.repair);
        meta.setOwnerUniqueName(cubeNumber);
        meta.addPartitions(dimNumbers);
        OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
        command.executeNonQuery();
        return true;
    }
}

