/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.service.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekCubeServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekServiceFactory;
import kd.epm.eb.common.shrek.service.interfaces.IShrekDimension;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ShrekDimension
implements IShrekDimension {
    @Override
    public boolean createDimension(OlapConnection conn, String cubeNumber, List<Dimension> dimensions) {
        this.verifyElement(conn);
        this.verifyCube(cubeNumber);
        this.verifyDimensions(dimensions);
        Set<String> dimNumbers = ShrekServiceFactory.SHREK_METADATA.getProperties(conn, cubeNumber, "", true);
        dimensions = dimensions.stream().filter(d -> !dimNumbers.contains(d.getNumber())).collect(Collectors.toList());
        if (dimensions.isEmpty()) {
            return true;
        }
        MetadataCommandInfo meta = null;
        OlapCommand command = null;
        for (Dimension dimension : dimensions) {
            if (this.existDimension(conn, cubeNumber, dimension.getNumber())) continue;
            meta = new MetadataCommandInfo();
            meta.setAction(CommandTypes.create);
            meta.setMetadataType(MetadataTypes.Dimension);
            meta.setName(dimension.getNumber());
            meta.setOwnerUniqueName(cubeNumber);
            SysDimensionEnum sysDimensionEnum = SysDimensionEnum.getEnumByNumber(dimension.getNumber());
            if (sysDimensionEnum == null || sysDimensionEnum == SysDimensionEnum.InternalCompany) {
                meta.setDefaultMemberName(dimension.getNoneNumber());
            } else {
                meta.setDefaultMemberName(dimension.getNumber());
            }
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)meta, null);
            command = new OlapCommand(conn, (CommandInfo)meta);
            command.executeNonQuery();
        }
        return true;
    }

    @Override
    public boolean dropDimension(OlapConnection conn, String cubeNumber, String ... dimensions) {
        this.verifyElement(conn);
        this.verifyCube(cubeNumber);
        this.verifyDimensions(dimensions);
        MetadataCommandInfo meta = null;
        OlapCommand command = null;
        for (String dimension : dimensions) {
            if (!this.existDimension(conn, cubeNumber, dimension)) continue;
            meta = new MetadataCommandInfo();
            meta.setAction(CommandTypes.drop);
            meta.setMetadataType(MetadataTypes.Dimension);
            meta.setName(dimension.trim());
            meta.setOwnerUniqueName(cubeNumber);
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)meta, null);
            command = new OlapCommand(conn, (CommandInfo)meta);
            command.executeNonQuery();
        }
        return true;
    }

    @Override
    public boolean existDimension(OlapConnection conn, String cubeNumber, String dimension) {
        return Boolean.parseBoolean(ShrekServiceFactory.SHREK_METADATA.getMetaData(conn, cubeNumber, dimension, false).get("exist"));
    }

    @Override
    public void updateDimension(Model model, OlapConnection conn, String cubeNumber, String dimNumber, IModelCacheHelper modelCache, Map<String, Member> oldMembers, Dataset dataset, ShrekConfig config, LogStats stats, boolean isNeedUpdateAll) {
        List<Long> viewIds = modelCache.getViewGroupViewsByDataSetAndDimNumber(dataset.getId(), dimNumber);
        List<Object> members = new ArrayList<Member>(16);
        boolean viewIdsEmpty = CollectionUtils.isEmpty(viewIds);
        if (viewIdsEmpty) {
            members.addAll(modelCache.getMembers(null, dimNumber));
        } else {
            for (Long viewId : viewIds) {
                members.addAll(modelCache.getMembers(viewId, dimNumber));
            }
        }
        if (CollectionUtils.isEmpty(members)) {
            return;
        }
        if (!model.isModelByEB() && SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            Optional<Member> first = members.stream().filter(m -> SysDimensionEnum.Account.getNumber().equals(m.getNumber())).findFirst();
            members = members.stream().filter(m -> dataset.getId().equals(m.getDatasetId())).collect(Collectors.toList());
            if (first.isPresent()) {
                Member rootMember = first.get();
                List<Member> children = rootMember.getChildren();
                children = children.stream().filter(m -> dataset.getId().equals(m.getDatasetId())).collect(Collectors.toList());
                rootMember = (Member)rootMember.clone();
                rootMember.setChildren(children);
                members.add(rootMember);
            }
        }
        Set<String> olapExistMembers = ShrekServiceFactory.SHREK_MEMBER.getAllMembers(conn, cubeNumber, dimNumber, true);
        ArrayList<Member> neeAdd = new ArrayList<Member>(members.size());
        for (Object member2 : members) {
            if (!olapExistMembers.add(((BaseCache)member2).getNumber().toLowerCase())) continue;
            neeAdd.add((Member)member2);
        }
        Set allMembers = members.stream().map(member -> member.getNumber().toLowerCase()).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        olapExistMembers.removeAll(allMembers);
        if (!olapExistMembers.isEmpty()) {
            stats.addInfo("needDeleteMember:" + olapExistMembers);
            ShrekServiceFactory.SHREK_MEMBER.dropMembers(conn, cubeNumber, dimNumber, olapExistMembers, modelCache);
        }
        stats.addInfo("needAddMember:" + neeAdd.stream().map(BaseCache::getNumber).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(neeAdd)) {
            if (viewIdsEmpty) {
                ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimNumber, 0L, neeAdd, config);
            } else {
                for (Long viewId : viewIds) {
                    List<Member> createMembers = ShrekCubeServiceHelper.getCreateMembersByViewId(neeAdd, viewId);
                    if (CollectionUtils.isEmpty(createMembers)) continue;
                    ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimNumber, viewId, createMembers, config);
                }
            }
        }
        if (isNeedUpdateAll) {
            if (MemberStorageTypes.DynamicCalc.equals((Object)config.getDefaultStorageType())) {
                ShrekServiceFactory.DYNAMIC_CALC.syncDynamicCalc(model, conn, cubeNumber, dimNumber, members);
            } else {
                ShrekServiceFactory.STOREDCALC.syncStoredCalc(conn, cubeNumber, dimNumber, members);
            }
        }
        Set<String> memberNumbers = members.stream().filter(Objects::nonNull).map(m -> m.getNumber()).collect(Collectors.toSet());
        ShrekServiceFactory.SHREK_MEMBER.alterMember(conn, cubeNumber, dimNumber, memberNumbers);
    }

    @Override
    public void updateAnalyzeViewDimension(Model model, OlapConnection conn, Dataset dataset, String cubeNumber, String dimNumber, @NotNull Long analyzeViewId, IModelCacheHelper modelCache, ShrekConfig config, LogStats stats) {
        Preconditions.checkArgument((boolean)IDUtils.isNotNull(analyzeViewId), (Object)"analyzeViewId is null.");
        if (!ShrekOlapServiceHelper.existCube(model, dataset)) {
            return;
        }
        DynamicObject doj = BusinessDataServiceHelper.loadSingle((Object)analyzeViewId, (String)"eb_dimensionview");
        if (doj == null || !"1".equals(doj.getString("usage"))) {
            throw new KDBizException("the viewId is not analyzeView," + analyzeViewId);
        }
        if (!model.getId().equals(doj.getLong("model.id"))) {
            throw new KDBizException(String.format("the viewId is not this model,view:%s,model:%s", analyzeViewId, model.getId()));
        }
        Set<String> olapExistMembers = ShrekServiceFactory.SHREK_MEMBER.getAllMembers(conn, cubeNumber, dimNumber, true);
        List<Member> analyzeMembers = modelCache.getMembers(analyzeViewId, dimNumber);
        ArrayList<Member> needAdd = new ArrayList<Member>(16);
        for (Member analyzeMember : analyzeMembers) {
            if (olapExistMembers.contains(analyzeMember.getNumber().toLowerCase())) continue;
            needAdd.add(analyzeMember);
        }
        long baseviewId = doj.getLong("baseview.id");
        List<Member> _members = modelCache.getMembers(baseviewId, dimNumber);
        Set baseViewMembers = _members.stream().map(member -> member.getNumber().toLowerCase()).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        olapExistMembers.removeAll(baseViewMembers);
        List<Long> analyzeViewIds = DatasetServiceHelper.getAnalyzeViewIdByBaseViewId(baseviewId);
        for (Long viewId : analyzeViewIds) {
            _members = modelCache.getMembers(viewId, dimNumber);
            Set analyzeViewMembers = _members.stream().map(member -> member.getNumber().toLowerCase()).collect(Collectors.toSet());
            olapExistMembers.removeAll(analyzeViewMembers);
        }
        if (!olapExistMembers.isEmpty()) {
            stats.addInfo("needDeleteMember:" + olapExistMembers);
            ShrekServiceFactory.SHREK_MEMBER.dropMembers(conn, cubeNumber, dimNumber, olapExistMembers, modelCache);
        }
        if (CollectionUtils.isNotEmpty(needAdd)) {
            stats.addInfo("needAddMember:" + needAdd.stream().map(BaseCache::getNumber).collect(Collectors.toList()));
            ShrekConfig _config = ShrekConfigServiceHelper.getStoredConfig();
            ShrekServiceFactory.SHREK_MEMBER.createMember(conn, model, cubeNumber, dimNumber, analyzeViewId, needAdd, _config);
        }
        if (MemberStorageTypes.DynamicCalc.equals((Object)config.getDefaultStorageType())) {
            HashSet<Member> needUpdate = new HashSet<Member>(16);
            for (Member analyzeMember : analyzeMembers) {
                if (baseViewMembers.contains(analyzeMember.getNumber().toLowerCase())) continue;
                needUpdate.add(analyzeMember);
            }
            if (!needUpdate.isEmpty()) {
                ShrekServiceFactory.DYNAMIC_CALC.syncDynamicCalc(model, conn, cubeNumber, dimNumber, needUpdate);
            }
        }
        DataLockService.getInstance().updateLockRuleAsync(dimNumber, Collections.singletonList(dataset.getId()), model.getId());
    }

    @Override
    public void dropAnalyzeDimension(OlapConnection conn, Model model, String cubeNumber, String dimNumber, Long analyzeViewId, IModelCacheHelper modelCache, ShrekConfig config) {
        long baseviewId;
        List<Member> _members;
        Set baseMembers;
        Preconditions.checkArgument((boolean)IDUtils.isNotNull(analyzeViewId), (Object)"analyzeViewId is null.");
        DynamicObject doj = BusinessDataServiceHelper.loadSingle((Object)analyzeViewId, (String)"eb_dimensionview");
        if (doj == null || !"1".equals(doj.getString("usage"))) {
            throw new KDBizException("the viewId is not analyzeView," + analyzeViewId);
        }
        if (!model.getId().equals(doj.getLong("model.id"))) {
            throw new KDBizException(String.format("the viewId is not this model,view:%s,model:%s", analyzeViewId, model.getId()));
        }
        List<Member> analyzeMembers = modelCache.getMembers(analyzeViewId, dimNumber);
        Set analyzeMemberNumbers = analyzeMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        Collection needDelete = CollectionUtils.removeAll(analyzeMemberNumbers, baseMembers = (_members = modelCache.getMembers(baseviewId = doj.getLong("baseview.id"), dimNumber)).stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
        if (!needDelete.isEmpty()) {
            ShrekServiceFactory.SHREK_MEMBER.dropMembers(conn, cubeNumber, dimNumber, needDelete, modelCache);
        }
    }
}

