/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.MemberMetadataItem;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.olap.metadata.IMetadataBuilder;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.olap.metadata.StringMetadataBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekMemberServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekServiceFactory;
import kd.epm.eb.common.shrek.service.interfaces.IShrekMember;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.shrek.util.ShrekParamUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DynamicObjectUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;

public class ShrekMember
implements IShrekMember {
    private static final String[] RESERVES = new String[]{"all", "none", "other"};
    private static final String STORAGE_TYPE_CALC = "dynamicCalc";
    private static final String STORAGE_AND_CALC = "dynamicCalcAndStored";

    @Override
    public void createMember(OlapConnection conn, Model model, String cubeNumber, String dimension, Long viewId, List<Member> members, ShrekConfig config) {
        if (members == null || members.isEmpty()) {
            return;
        }
        this.verifyElement(conn, config);
        this.verifyCube(cubeNumber);
        this.verifyDimensions(dimension);
        this.verifyMembers(members);
        boolean existDimension = ShrekServiceFactory.SHREK_DIMENSION.existDimension(conn, cubeNumber, dimension);
        if (!existDimension) {
            return;
        }
        LinkedHashSet errors = Sets.newLinkedHashSet();
        LinkedHashSet counts = Sets.newLinkedHashSet();
        ArrayList _members = Lists.newArrayListWithExpectedSize((int)members.size());
        for (Member member2 : members) {
            if (!SysDimensionEnum.Period.getNumber().equalsIgnoreCase(dimension) && !NumberCheckUtils.checkNumber(member2.getNumber())) {
                errors.add(member2.getNumber());
            }
            for (String reserve : RESERVES) {
                if (!member2.getNumber().equalsIgnoreCase(reserve)) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u7684\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a'all', 'none', 'null', 'other'\u4fdd\u7559\u7f16\u7801\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ShrekMember_1", (String)"epm-eb-common", (Object[])new Object[]{dimension}));
            }
            if (!counts.add(member2.getNumber())) continue;
            _members.add(member2);
        }
        members = _members;
        if (!errors.isEmpty()) {
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u7684\u6210\u5458\u7f16\u7801%2\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u6a2a\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ShrekMember_0", (String)"epm-eb-common", (Object[])new Object[]{dimension, StringUtils.join((Collection)errors, ',')}));
        }
        Set<String> existMember = ShrekServiceFactory.SHREK_MEMBER.getAllMembers(conn, cubeNumber, dimension, true);
        if ((members = members.stream().filter(m -> !existMember.contains(m.getNumber().toLowerCase())).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        MetadataCommandInfo metadataCommandInfo = new MetadataCommandInfo();
        metadataCommandInfo.setAction(CommandTypes.create);
        metadataCommandInfo.setMetadataType(MetadataTypes.Member);
        metadataCommandInfo.setOwnerUniqueName(cubeNumber.trim() + "." + dimension.trim());
        boolean hasMetric = SysDimensionEnum.Metric.getNumber().equals(dimension);
        List items = metadataCommandInfo.getItems();
        for (Member member3 : members) {
            MemberMetadataItem item = new MemberMetadataItem(member3.getNumber().trim());
            if (hasMetric && !member3.hasAgg()) {
                item.setMemberAggShieldRule("none");
            }
            if (member3.isLeaf()) {
                item.setStorageType(MemberStorageTypes.Stored);
            } else {
                item.setStorageType(config.getDefaultStorageType());
            }
            items.add(item);
        }
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)metadataCommandInfo, null);
        OlapCommand command = new OlapCommand(conn, (CommandInfo)metadataCommandInfo);
        command.executeNonQuery();
        if (config.getStats() != null) {
            config.getStats().addInfo(metadataCommandInfo.toString());
        }
        if (MemberStorageTypes.DynamicCalc == config.getDefaultStorageType()) {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(model.getId());
            HashSet allUpdateMember = Sets.newHashSetWithExpectedSize((int)members.size());
            for (Member member4 : members) {
                Member member5 = modelCache.getMember(dimension, viewId, member4.getNumber());
                if (member5 == null) continue;
                allUpdateMember.add(member5);
                Member _parent = modelCache.getParent(viewId, member5);
                if (_parent == null) continue;
                allUpdateMember.add(_parent);
            }
            if (members.stream().anyMatch(e -> e.getNumber().endsWith("._fvm"))) {
                allUpdateMember.addAll(members);
            }
            allUpdateMember.removeIf(member -> StorageTypeEnum.STORAGE.getOIndex().equals(member.getStorageType()));
            if (!allUpdateMember.isEmpty()) {
                ShrekServiceFactory.DYNAMIC_CALC.syncDynamicCalc(model, conn, cubeNumber, dimension, allUpdateMember);
            }
        }
    }

    @Override
    public boolean updateMembers(OlapConnection conn, String cubeNumber, String dimension, List<Member> members, ShrekConfig config) {
        this.verifyElement(conn, config);
        this.verifyCube(cubeNumber);
        this.verifyDimensions(dimension);
        Set<String> existMember = ShrekServiceFactory.SHREK_MEMBER.getAllMembers(conn, cubeNumber, dimension, true);
        members = members.stream().filter(m -> existMember.contains(m.getNumber().toLowerCase())).collect(Collectors.toList());
        if (members.size() == 0) {
            return true;
        }
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.alter);
        meta.setMetadataType(MetadataTypes.Member);
        meta.setOwnerUniqueName(cubeNumber.trim() + "." + dimension.trim());
        boolean hasMetric = SysDimensionEnum.Metric.getNumber().equals(dimension);
        ShrekParamUtils.CubeParams cubeParams = null;
        if (SysDimensionEnum.Entity.getNumber().equals(dimension) && (cubeParams = config.getCubeParams()) != null && cubeParams.hasDynamicStore()) {
            meta.getProperties().set("enabledDS", "true");
        }
        List items = meta.getItems();
        for (Member member : members) {
            MemberMetadataItem item = new MemberMetadataItem(member.getNumber().trim());
            if (hasMetric) {
                if (member.hasAgg()) {
                    item.setMemberAggShieldRule("all");
                } else {
                    item.setMemberAggShieldRule("none");
                }
            }
            if (MemberStorageTypes.DynamicCalc == config.getDefaultStorageType()) {
                ShrekServiceFactory.DYNAMIC_CALC.syncDynamicCalc(dimension, member, item, existMember, false);
            }
            if (member.isLeaf()) {
                item.setStorageType(MemberStorageTypes.Stored);
            } else if (cubeParams != null && cubeParams.getLevels() != null && cubeParams.getLevels().contains(member.getLevel())) {
                item.setStorageType(MemberStorageTypes.DynamicCalcAndStored);
            } else {
                item.setStorageType(config.getDefaultStorageType());
            }
            items.add(item);
        }
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)meta, ShrekIdCodeUtils.getDefaultIdCodes(null));
        OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
        command.executeNonQuery();
        Set<String> memberNumbers = members.stream().filter(Objects::nonNull).map(m -> m.getNumber()).collect(Collectors.toSet());
        this.alterMember(conn, cubeNumber, dimension, memberNumbers);
        return true;
    }

    @Override
    public boolean dropMembers(OlapConnection conn, String cubeNumber, String dimensionNumber, Collection<String> members, IModelCacheHelper modelCache) {
        this.verifyElement(conn);
        this.verifyCube(cubeNumber);
        this.verifyDimensions(dimensionNumber);
        this.verifyMemberList(members);
        this.verifyModel(modelCache);
        if (members.isEmpty()) {
            return false;
        }
        Set<String> existMember = this.getAllMembers(conn, cubeNumber, dimensionNumber, true);
        if ((members = (Collection)members.stream().filter(m -> existMember.contains(m.toLowerCase())).collect(Collectors.toList())).isEmpty()) {
            return false;
        }
        Dimension _dimension = modelCache.getDimension(dimensionNumber);
        Set<String> existNumbers = this.queryExistMembers(modelCache.getModelobj().getId(), _dimension.getId(), _dimension.getMemberModel(), members);
        if (existNumbers != null && !existNumbers.isEmpty()) {
            members.removeAll(existNumbers);
        }
        if (!members.isEmpty()) {
            MetadataCommandInfo commandInfo = new MetadataCommandInfo();
            commandInfo.setAction(CommandTypes.drop);
            commandInfo.setMetadataType(MetadataTypes.Member);
            commandInfo.setOwnerUniqueName(cubeNumber.trim() + "." + dimensionNumber.trim());
            commandInfo.setAllowDropMemberWhenRowReferenced(true);
            List items = commandInfo.getItems();
            for (String member : members) {
                items.add(new MemberMetadataItem(member.trim()));
            }
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)commandInfo, null);
            OlapCommand command = new OlapCommand(conn, (CommandInfo)commandInfo);
            command.executeNonQuery();
            return true;
        }
        return false;
    }

    @Override
    public boolean dropMembers(OlapConnection conn, IModelCacheHelper modelCache, String cubeNumber, String dimNumber, Long viewId, Map<String, Member> oldMembers, Collection<String> needDelete) {
        this.verifyElement(conn);
        this.verifyCube(cubeNumber);
        this.verifyDimensions(dimNumber);
        this.verifyMemberList(needDelete);
        this.verifyModel(modelCache);
        Dimension _dimension = modelCache.getDimension(dimNumber);
        Set<String> existNumbers = this.queryExistMembers(modelCache.getModelobj().getId(), _dimension.getId(), _dimension.getMemberModel(), needDelete);
        if (existNumbers != null && !existNumbers.isEmpty()) {
            needDelete.removeAll(existNumbers);
        }
        if (!needDelete.isEmpty()) {
            MetadataCommandInfo commandInfo = new MetadataCommandInfo();
            commandInfo.setAction(CommandTypes.drop);
            commandInfo.setMetadataType(MetadataTypes.Member);
            commandInfo.setOwnerUniqueName(cubeNumber.trim() + "." + dimNumber.trim());
            List items = commandInfo.getItems();
            for (String member : needDelete) {
                items.add(new MemberMetadataItem(member.trim()));
            }
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)commandInfo, null);
            OlapCommand command = new OlapCommand(conn, (CommandInfo)commandInfo);
            command.executeNonQuery();
            if (MapUtils.isNotEmpty(oldMembers)) {
                HashSet parentNumbers = Sets.newHashSetWithExpectedSize((int)needDelete.size());
                for (String memNumber : needDelete) {
                    Member member = oldMembers.get(memNumber);
                    String parentNumber = member.getParentNumber();
                    if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)parentNumber)) continue;
                    parentNumbers.add(parentNumber);
                }
                parentNumbers.removeAll(needDelete);
                HashSet members = Sets.newHashSetWithExpectedSize((int)parentNumbers.size());
                for (String parentNumber : parentNumbers) {
                    Member member = _dimension == null ? modelCache.getMember(dimNumber, viewId, parentNumber) : _dimension.getMember(viewId, parentNumber);
                    if (member == null) continue;
                    members.add(member);
                }
                ShrekServiceFactory.DYNAMIC_CALC.syncDynamicCalc(modelCache.getModelobj(), conn, cubeNumber, dimNumber, members);
            }
            return true;
        }
        return false;
    }

    private Set<String> queryExistMembers(Long modelId, Long dimensionId, String dimEntityNumber, Collection<String> memberNumbers) {
        if (modelId == null || dimensionId == null || dimEntityNumber == null || memberNumbers == null) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", modelId);
        builder.add("dimension", "=", dimensionId);
        builder.add("number", "in", memberNumbers);
        HashSet existNumbers = Sets.newHashSetWithExpectedSize((int)memberNumbers.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMemberNum", (String)dimEntityNumber, (String)"id,number", (QFilter[])builder.toArrays(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    existNumbers.add(row.getString("number"));
                }
            }
        }
        return existNumbers;
    }

    @Override
    public Set<String> getAllMembers(OlapConnection conn, String cubeNumber, String dimNumber, boolean isLower) {
        Set<String> properties = ShrekServiceFactory.SHREK_METADATA.getProperties(conn, cubeNumber, dimNumber, true);
        if (isLower && org.apache.commons.collections4.CollectionUtils.isNotEmpty(properties)) {
            return properties.stream().map(String::toLowerCase).collect(Collectors.toSet());
        }
        return properties;
    }

    @Override
    public boolean existData(OlapConnection conn, String dimension, Set<String> members) {
        this.verifyElement(conn);
        this.verifyDimensions(dimension);
        this.verifyMemberList(members);
        SelectCommandInfo query = new SelectCommandInfo();
        query.addDims(new String[]{dimension});
        query.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        query.addFilter(dimension, members.toArray(new String[0]));
        query.setTop(1);
        query.setExcludeDynamicCalcResult(true);
        query.setExcludeNull(true);
        try (ShrekOlapReader shrekOlapReader = new ShrekOlapReader(conn, new OlapCommand(conn, (CommandInfo)query).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE));){
            if (shrekOlapReader.hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public boolean existData(Model model, List<Dataset> datasets, String dimensionNumber, Set<String> members) {
        if (model == null || datasets == null || dimensionNumber == null || CollectionUtils.isEmpty(members)) {
            return false;
        }
        try {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(model.getId());
            for (Dataset dataset : datasets) {
                LinkedHashSet<String> queryMembers = new LinkedHashSet<String>();
                SelectCommandInfo commandInfo = this.getBaseSelectCommandInfo(dimensionNumber);
                List<Long> views = modelCache.getViewGroupViewsByDataSetAndDimNumber(dataset.getId(), dimensionNumber);
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(views)) {
                    for (Long viewId : views) {
                        queryMembers.addAll(modelCache.getMemberNumber(dimensionNumber, viewId));
                    }
                } else {
                    queryMembers.addAll(modelCache.getMemberNumber(dimensionNumber, null));
                }
                queryMembers.retainAll(members);
                if (queryMembers.isEmpty()) continue;
                Set<String> allMembers = ShrekMemberServiceHelper.getAllMembers(model, dataset, dimensionNumber);
                queryMembers.retainAll(allMembers);
                if (queryMembers.isEmpty()) continue;
                commandInfo.addFilter(dimensionNumber, queryMembers.toArray(new String[0]));
                MembersKey membersKeys = ShrekOlapServiceHelper.queryOne(model, dataset, commandInfo);
                if (membersKeys == null) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.warn("shrekmemberexistData", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        return false;
    }

    private SelectCommandInfo getBaseSelectCommandInfo(String dimensionNumber) {
        SelectCommandInfo commandInfo = new SelectCommandInfo();
        commandInfo.addDims(new String[]{dimensionNumber});
        commandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        commandInfo.setTop(1);
        commandInfo.setExcludeDynamicCalcResult(true);
        commandInfo.setExcludeNull(true);
        return commandInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getExistDataMember(Model model, Dataset dataset, String dimensionNumber, Set<String> members) {
        Set collect;
        OlapDataReader reader;
        OlapConnection conn;
        HashSet<String> returnData;
        block15: {
            block14: {
                Serializable viewId22;
                if (members == null || members.isEmpty()) {
                    return Collections.emptySet();
                }
                returnData = new HashSet<String>(members.size());
                conn = null;
                reader = null;
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(model.getId());
                List<Long> views = modelCache.getViewGroupViewsByDataSetAndDimNumber(dataset.getId(), dimensionNumber);
                ArrayList<Member> queryMembers = new ArrayList<Member>(16);
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(views)) {
                    for (Serializable viewId22 : views) {
                        queryMembers.addAll(modelCache.getMembers((Long)viewId22, dimensionNumber));
                    }
                } else {
                    queryMembers.addAll(modelCache.getMembers(null, dimensionNumber));
                }
                collect = queryMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                collect.retainAll(members);
                if (!collect.isEmpty()) break block14;
                viewId22 = returnData;
                ShrekOlapUtils.close(new Object[]{reader});
                ShrekOlapUtils.close(new Object[]{conn});
                return viewId22;
            }
            Set<String> allMembers = ShrekMemberServiceHelper.getAllMembers(model, dataset, dimensionNumber);
            collect.retainAll(allMembers);
            if (!collect.isEmpty()) break block15;
            HashSet<String> hashSet = returnData;
            ShrekOlapUtils.close(new Object[]{reader});
            ShrekOlapUtils.close(new Object[]{conn});
            return hashSet;
        }
        try {
            List<T>[] batchMembers;
            conn = ShrekOlapServiceHelper.getConnection(model, dataset);
            for (List<String> list : batchMembers = DynamicObjectUtils.getBatchObjects(new ArrayList(collect), 50)) {
                if (list == null || list.isEmpty()) continue;
                SelectCommandInfo commandInfo = this.getBaseSelectCommandInfo(dimensionNumber);
                commandInfo.addFilter(dimensionNumber, list.toArray(new String[0]));
                reader = new OlapCommand(conn, (CommandInfo)commandInfo).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
                if (reader.next()) {
                    ShrekOlapUtils.close(new Object[]{reader});
                    for (String _check : list) {
                        commandInfo = this.getBaseSelectCommandInfo(dimensionNumber);
                        commandInfo.addFilter(dimensionNumber, new String[]{_check});
                        reader = new OlapCommand(conn, (CommandInfo)commandInfo).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
                        if (reader.next()) {
                            returnData.add(_check);
                        }
                        ShrekOlapUtils.close(new Object[]{reader});
                    }
                }
                ShrekOlapUtils.close(new Object[]{reader});
            }
        }
        catch (Exception ex) {
            try {
                log.warn("shrekmemberexistData", (Throwable)ex);
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close(new Object[]{reader});
                ShrekOlapUtils.close(new Object[]{conn});
                throw throwable;
            }
            ShrekOlapUtils.close(new Object[]{reader});
            ShrekOlapUtils.close(new Object[]{conn});
        }
        ShrekOlapUtils.close(new Object[]{reader});
        ShrekOlapUtils.close(new Object[]{conn});
        return returnData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getExistDataMemberByNotNull(Model model, Dataset dataset, String dimensionNumber, Set<String> members, boolean isIgnoreZero) {
        Set collect;
        OlapDataReader reader;
        OlapConnection conn;
        HashSet<String> returnData;
        block12: {
            block11: {
                Serializable viewId2;
                returnData = new HashSet<String>(members.size());
                conn = null;
                reader = null;
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(model.getId());
                List<Long> views = modelCache.getViewGroupViewsByDataSetAndDimNumber(dataset.getId(), dimensionNumber);
                ArrayList<Member> queryMembers = new ArrayList<Member>(16);
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(views)) {
                    for (Serializable viewId2 : views) {
                        queryMembers.addAll(modelCache.getMembers((Long)viewId2, dimensionNumber));
                    }
                } else {
                    queryMembers.addAll(modelCache.getMembers(null, dimensionNumber));
                }
                collect = queryMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                collect.retainAll(members);
                if (!collect.isEmpty()) break block11;
                viewId2 = returnData;
                ShrekOlapUtils.close(new Object[]{reader});
                ShrekOlapUtils.close(new Object[]{conn});
                return viewId2;
            }
            Set<String> allMembers = ShrekMemberServiceHelper.getAllMembers(model, dataset, dimensionNumber);
            collect.retainAll(allMembers);
            if (!collect.isEmpty()) break block12;
            HashSet<String> hashSet = returnData;
            ShrekOlapUtils.close(new Object[]{reader});
            ShrekOlapUtils.close(new Object[]{conn});
            return hashSet;
        }
        try {
            conn = ShrekOlapServiceHelper.getConnection(model, dataset);
            for (String member : collect) {
                SelectCommandInfo commandInfo = this.getBaseSelectCommandInfo(dimensionNumber);
                commandInfo.addFilter(dimensionNumber, new String[]{member});
                reader = new OlapCommand(conn, (CommandInfo)commandInfo).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
                int fieldCount = reader.getFieldCount();
                Object[] values = new Object[fieldCount];
                if (reader.next()) {
                    reader.getValues(values);
                    if (values[0] == null || isIgnoreZero && ConvertUtils.equalValue(values[0], BigDecimal.ZERO)) continue;
                    returnData.add(member);
                }
                ShrekOlapUtils.close(new Object[]{reader});
            }
        }
        catch (Exception e) {
            try {
                log.warn("shrekmemberexistDataByNotNull", (Throwable)e);
            }
            catch (Throwable throwable) {
                ShrekOlapUtils.close(new Object[]{reader});
                ShrekOlapUtils.close(new Object[]{conn});
                throw throwable;
            }
            ShrekOlapUtils.close(new Object[]{reader});
            ShrekOlapUtils.close(new Object[]{conn});
        }
        ShrekOlapUtils.close(new Object[]{reader});
        ShrekOlapUtils.close(new Object[]{conn});
        return returnData;
    }

    @Override
    public Set<String> alterMember(Model model, List<Dataset> datasets, String dimensionNumber, Set<String> memberNumbers) {
        if (model == null || datasets == null || dimensionNumber == null || memberNumbers == null || memberNumbers.isEmpty()) {
            return Collections.emptySet();
        }
        OlapConnection conn = null;
        LinkedHashSet alterNumbers = Sets.newLinkedHashSet();
        for (Dataset dataset : datasets) {
            try {
                conn = ShrekOlapServiceHelper.getConnection(model, dataset);
                conn.Open();
                String cubeNumber = ShrekOlapUtils.getCubeNumber(dataset);
                alterNumbers.addAll(this.alterMember(conn, cubeNumber, dimensionNumber, memberNumbers));
            }
            catch (Exception ex) {
                try {
                    throw ex;
                }
                catch (Throwable throwable) {
                    ShrekOlapUtils.close(new Object[]{conn});
                    throw throwable;
                }
            }
            ShrekOlapUtils.close(new Object[]{conn});
        }
        return alterNumbers;
    }

    @Override
    public Set<String> alterMember(OlapConnection conn, String cubeNumber, String dimensionNumber, Set<String> memberNumbers) {
        if (memberNumbers == null || memberNumbers.isEmpty()) {
            return Collections.emptySet();
        }
        this.verifyElement(conn);
        this.verifyCube(cubeNumber);
        Set<String> existNumbers = this.getAllMembers(conn, cubeNumber, dimensionNumber, false);
        Map<String, String> lowNumberMap = existNumbers.stream().collect(Collectors.toMap(n -> n.toLowerCase(), n -> n));
        LinkedHashSet metaNumbers = Sets.newLinkedHashSet();
        Map<String, String> shrekProperties = ShrekIdCodeUtils.getDefaultIdCodes(null);
        for (String memberNumber : memberNumbers) {
            String metaNumber;
            if (existNumbers.contains(memberNumber) || (metaNumber = lowNumberMap.get(memberNumber.toLowerCase())) == null) continue;
            MetadataCommandInfo metadataCommand = new MetadataCommandInfo();
            metadataCommand.setMetadataType(MetadataTypes.Member);
            metadataCommand.setAction(CommandTypes.alter);
            metadataCommand.setName(metaNumber);
            metadataCommand.setOwnerUniqueName(cubeNumber + "." + dimensionNumber);
            metadataCommand.setNewName(memberNumber);
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)metadataCommand, shrekProperties);
            try {
                OlapCommand olapCommand = new OlapCommand(conn, (CommandInfo)metadataCommand);
                olapCommand.executeNonQuery();
                metaNumbers.add(memberNumber);
            }
            catch (Exception ex) {
                log.error("olapCommand-error:", (Throwable)ex);
            }
        }
        return metaNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Set<String>> verifyMemberFactors(@NotNull IModelCacheHelper modelCacheHelper, @NotNull List<Dataset> datasets, @NotNull String dimensionNumber, Set<String> memberNums, boolean autoUpdate, @NotNull ShrekConfig config) {
        if (datasets == null || datasets.isEmpty()) {
            datasets = DatasetServiceHelper.getAllDatasets(modelCacheHelper.getModelobj().getId(), dimensionNumber);
        }
        if (datasets == null || datasets.isEmpty()) {
            return null;
        }
        OlapConnection conn = null;
        Dimension dimension = modelCacheHelper.getDimension(dimensionNumber);
        if (dimension == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"CommonUtils_0", (String)"epm-eb-common", (Object[])new Object[]{dimensionNumber}));
        }
        List members = null;
        if (memberNums != null && !memberNums.isEmpty()) {
            members = Lists.newArrayListWithExpectedSize((int)memberNums.size());
        }
        HashMap errDatasets = Maps.newHashMapWithExpectedSize((int)datasets.size());
        Set<String> errMembers = null;
        HashSet<String> allErrMembers = new HashSet<String>(16);
        for (Dataset dataset : datasets) {
            block23: {
                List<Member> allMembersByView;
                HashSet<String> allMemNumSet = new HashSet<String>(16);
                Long busModelId = modelCacheHelper.getBusModelByDataSet(dataset.getId());
                List<Long> viewIds = modelCacheHelper.getViewGroupViewsByBusModelAndDimNumber(busModelId, dimensionNumber);
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(viewIds)) {
                    for (Long view : viewIds) {
                        allMembersByView = dimension.getAllMembers(view);
                        allMemNumSet.addAll(allMembersByView.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                    }
                } else {
                    allMembersByView = dimension.getAllMembers();
                    allMemNumSet.addAll(allMembersByView.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                }
                try {
                    FunctionCommandInfo command;
                    PropertyBag propertyBag;
                    conn = ShrekOlapServiceHelper.getConnection(modelCacheHelper.getModelobj(), dataset);
                    if (memberNums == null || memberNums.isEmpty()) {
                        String propertyValue;
                        propertyBag = new PropertyBag();
                        propertyBag.set("path", dimension.getNumber());
                        command = new FunctionCommandInfo("getFactors", propertyBag);
                        propertyBag = new OlapCommand(conn, (CommandInfo)command).executeFunction();
                        if (propertyBag != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(propertyValue = propertyBag.get("result")))) {
                            members = (List)JSON.parse((String)propertyValue);
                        }
                    } else {
                        for (String _memberNum : memberNums) {
                            String propertyValue;
                            propertyBag = new PropertyBag();
                            propertyBag.set("path", dimension.getNumber() + '@' + _memberNum);
                            command = new FunctionCommandInfo("getFactors", propertyBag);
                            if ((propertyBag = new OlapCommand(conn, (CommandInfo)command).executeFunction()) == null || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(propertyValue = propertyBag.get("result")))) continue;
                            List _members = (List)JSON.parse((String)propertyValue);
                            if (members == null || _members == null) continue;
                            members.addAll(_members);
                        }
                    }
                    if (members != null && !members.isEmpty()) {
                        Set errMembersByDataSet;
                        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(viewIds)) {
                            for (Long view : viewIds) {
                                errMembers = this.verifyMember(members, dimension, view, memberNums, allMemNumSet);
                                if (errMembers.isEmpty()) continue;
                                errMembersByDataSet = errDatasets.computeIfAbsent(dataset.getNumber(), k -> new HashSet(16));
                                errMembersByDataSet.addAll(errMembers);
                                allErrMembers.addAll(errMembers);
                            }
                        } else {
                            errMembers = this.verifyMember(members, dimension, 0L, memberNums, allMemNumSet);
                            if (!errMembers.isEmpty()) {
                                errMembersByDataSet = errDatasets.computeIfAbsent(dataset.getNumber(), k -> new HashSet(16));
                                errMembersByDataSet.addAll(errMembers);
                                allErrMembers.addAll(errMembers);
                            }
                        }
                    }
                    if (allErrMembers.isEmpty() || !autoUpdate) break block23;
                    if (SysDimensionEnum.Entity.getNumber().equals(dimensionNumber)) {
                        config.setCubeParams(ShrekParamUtils.getCubeParamsByCache(modelCacheHelper.getModelobj().getId()));
                    } else {
                        config.setCubeParams(null);
                    }
                    if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(viewIds)) {
                        for (Long viewId : viewIds) {
                            this.updateMembers(conn, ShrekOlapUtils.getCubeNumber(dataset), dimension.getNumber(), dimension.getMemberByNumbers(viewId, allErrMembers), config);
                        }
                        break block23;
                    }
                    this.updateMembers(conn, ShrekOlapUtils.getCubeNumber(dataset), dimension.getNumber(), dimension.getMemberByNumbers(null, allErrMembers), config);
                }
                catch (Throwable throwable) {
                    ShrekOlapUtils.close(new Object[]{conn});
                    throw throwable;
                }
            }
            ShrekOlapUtils.close(new Object[]{conn});
        }
        DataLockService.getInstance().updateLockRuleAsync(dimensionNumber, datasets.stream().map(Dataset::getId).collect(Collectors.toList()), modelCacheHelper.getModelobj().getId());
        return errDatasets;
    }

    private Set<String> verifyMember(List<Map<String, Object>> metas, Dimension dimension, Long viewId, Set<String> members, Set<String> allMemNumSet) {
        LinkedHashSet errMembers = Sets.newLinkedHashSet();
        if (allMemNumSet == null) {
            allMemNumSet = new HashSet<String>(16);
        }
        if (metas == null || metas.isEmpty()) {
            List<Member> allMembers = dimension.getAllMembers(viewId);
            errMembers.addAll(allMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
            Collection<Member> viewMembers = dimension.getViewMember();
            errMembers.addAll(viewMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
            return errMembers;
        }
        SysDimensionEnum sysDimensionEnum = SysDimensionEnum.getEnumByNumber(dimension.getNumber());
        for (Map<String, Object> meta : metas) {
            String memberNumber = (String)meta.get("name");
            if (sysDimensionEnum != null && memberNumber.equals(sysDimensionEnum.getNumber()) || members != null && !members.contains(memberNumber)) continue;
            Member member = dimension.getMember(viewId, memberNumber);
            if (member == null) {
                if (allMemNumSet.contains(memberNumber)) continue;
                errMembers.add(memberNumber);
                continue;
            }
            String storageType = (String)meta.get("storageType");
            MemberSourceEnum sourceEnum = MemberSourceEnum.getByIndex(member.getSource());
            if (member.isLeaf()) {
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)STORAGE_TYPE_CALC, (CharSequence)storageType) && !org.apache.commons.lang3.StringUtils.equals((CharSequence)STORAGE_AND_CALC, (CharSequence)storageType)) continue;
                errMembers.add(memberNumber);
                continue;
            }
            if (StringUtils.notEquals(STORAGE_TYPE_CALC, storageType) && StringUtils.notEquals(STORAGE_AND_CALC, storageType)) {
                errMembers.add(memberNumber);
            }
            List factors = (List)meta.get("factors");
            if (MemberSourceEnum.ANALYZE_VIEW == sourceEnum || this.checkFactors(factors, dimension, viewId, member)) continue;
            errMembers.add(memberNumber);
        }
        return errMembers;
    }

    private boolean checkFactors(List<Map<String, Object>> factors, @NotNull Dimension dimension, Long viewId, @NotNull Member member) {
        boolean check;
        block6: {
            block7: {
                check = true;
                if (factors == null) break block7;
                HashMap<String, String> effective = new HashMap<String, String>(member.getChildren().size());
                for (Member member2 : member.getChildren()) {
                    AggOprtEnum oprtEnum = AggOprtEnum.getAggOprtEnumBySign(member2.getAggType());
                    if (oprtEnum == null) {
                        return false;
                    }
                    MemberSourceEnum sourceEnum = MemberSourceEnum.getByIndex(member2.getSource());
                    if (oprtEnum == null) {
                        return false;
                    }
                    if (oprtEnum == AggOprtEnum.SKIP) continue;
                    effective.put(member2.getNumber(), oprtEnum.getName());
                }
                for (Map map : factors) {
                    String childNumber = (String)map.get("name");
                    String operator = (String)map.get("operator");
                    Member child = dimension.getMember(viewId, childNumber);
                    if (child == null) {
                        return false;
                    }
                    String tmpOperator = (String)effective.get(childNumber);
                    if (org.apache.commons.lang3.StringUtils.equals((CharSequence)tmpOperator, (CharSequence)operator)) continue;
                    return false;
                }
                break block6;
            }
            if (member.getChildren() == null || member.getChildren().isEmpty()) break block6;
            for (Member _child : member.getChildren()) {
                AggOprtEnum oprtEnum = AggOprtEnum.getAggOprtEnumBySign(_child.getAggType());
                if (oprtEnum != null && oprtEnum == AggOprtEnum.SKIP) continue;
                check = false;
                break;
            }
        }
        return check;
    }
}

