/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.service.impl;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.epm.eb.common.shrek.service.interfaces.IShrekVerify;
import org.apache.commons.lang3.StringUtils;

public class ShrekMetaData
implements IShrekVerify {
    public PropertyBag exitCube(OlapConnection conn, String cubeName, boolean children) {
        this.verify(conn);
        this.verifyCube(cubeName);
        PropertyBag property = new PropertyBag();
        property.set("path", cubeName);
        property.set("children", String.valueOf(children));
        FunctionCommandInfo fc = new FunctionCommandInfo("getMetadataNames", property);
        return new OlapCommand(conn, (CommandInfo)fc).executeFunction();
    }

    public PropertyBag getMetaData(OlapConnection conn, String cubeName, String path, boolean children) {
        this.verify(conn);
        this.verifyCube(cubeName);
        PropertyBag property = new PropertyBag();
        property.set("cubeName", cubeName);
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty(path)) {
            property.set("path", path);
        } else {
            property.set("path", "");
        }
        property.set("children", String.valueOf(children));
        FunctionCommandInfo fc = new FunctionCommandInfo("getMetadataNames", property);
        return new OlapCommand(conn, (CommandInfo)fc).executeFunction();
    }

    public Set<String> getProperties(OlapConnection conn, String cubeName, String path, boolean children) {
        this.verify(conn);
        this.verifyCube(cubeName);
        this.verifyPath(path);
        PropertyBag metaData = this.getMetaData(conn, cubeName, path, children);
        String metas = metaData.get("children");
        String[] split = metas.contains(System.lineSeparator()) ? metas.split(System.lineSeparator()) : metas.split("\n");
        return Arrays.stream(split).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    public PropertyBag getFactors(OlapConnection conn, String cubeName, String dimNumber, String memberNumber) {
        this.verify(conn);
        this.verifyCube(cubeName);
        PropertyBag property = new PropertyBag();
        property.set("cubeName", cubeName);
        property.set("path", dimNumber + "@" + memberNumber);
        FunctionCommandInfo fc = new FunctionCommandInfo("getFactors", property);
        return new OlapCommand(conn, (CommandInfo)fc).executeFunction();
    }
}

