/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.service.impl;

import java.util.Collection;
import java.util.List;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.MemberMetadataItem;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.olap.metadata.MetadataTypes;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.shrek.service.interfaces.IShrekVerify;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;

public class StoredCalc
implements IShrekVerify {
    public void syncStoredCalc(OlapConnection conn, String cubeNumber, String dimension, Collection<Member> members) {
        this.verifyElement(conn);
        this.verifyDimensions(dimension);
        this.verifyMembers(members);
        if (members.size() == 0) {
            return;
        }
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.alter);
        meta.setMetadataType(MetadataTypes.Member);
        meta.setOwnerUniqueName(cubeNumber + "." + dimension);
        List items = meta.getItems();
        for (Member member : members) {
            MemberMetadataItem item = new MemberMetadataItem(member.getNumber());
            item.setStorageType(MemberStorageTypes.Stored);
            items.add(item);
        }
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)meta, null);
        if (!items.isEmpty()) {
            OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
            command.executeNonQuery();
        }
    }
}

