/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.service.interfaces;

import java.util.Collection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.domain.ShrekCube;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public interface IShrekVerify {
    public static final Log log = LogFactory.getLog(IShrekVerify.class);

    default public void verifyElement(Object ... elements) {
        if (elements == null) {
            return;
        }
        for (Object element : elements) {
            if (element == null) {
                throw new KDBizException("error shrek service parameter. element is null.");
            }
            if (element instanceof ShrekConfig) {
                this.verify((ShrekConfig)element);
                continue;
            }
            if (element instanceof OlapConnection) {
                this.verify((OlapConnection)element);
                continue;
            }
            if (element instanceof ShrekCube) {
                this.verifyShrek((ShrekCube)element);
                continue;
            }
            if (element instanceof Model) {
                this.verifyModel((Model)element);
                continue;
            }
            if (element instanceof IModelCacheHelper) {
                this.verifyModel((IModelCacheHelper)element);
                continue;
            }
            if (element instanceof Dataset) {
                this.verifyDataset((Dataset)element);
                continue;
            }
            if (element instanceof Member) {
                this.verifyMember((Member)element);
                continue;
            }
            if (element instanceof SelectCommandInfo) {
                this.verifyQuery((SelectCommandInfo)element);
                continue;
            }
            if (element instanceof Collection) {
                Collection _elements = (Collection)element;
                if (_elements.isEmpty()) {
                    throw new KDBizException("error shrek service parameter. elements isEmpty.");
                }
                for (Object _element : _elements) {
                    if (_element == null) {
                        throw new KDBizException("error shrek service parameter. elements.element is null.");
                    }
                    if (_element instanceof Member) {
                        this.verifyMember((Member)_element);
                        continue;
                    }
                    if (_element instanceof Dataset) {
                        this.verifyDataset((Dataset)_element);
                        continue;
                    }
                    if (!(_element instanceof Dimension)) continue;
                    this.verifyDimension((Dimension)_element);
                }
                continue;
            }
            throw new KDBizException("unsupported element.");
        }
    }

    default public void verifyDataset(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            throw new KDBizException("error shrek service parameter. dataset is null.");
        }
    }

    default public void verifyMembers(Collection<Member> members) {
        if (members == null || members.isEmpty()) {
            throw new KDBizException("error shrek service parameter. members is null.");
        }
        for (Member member : members) {
            this.verifyMember(member);
        }
    }

    default public void verifyMemberList(Collection<String> members) {
        if (members == null) {
            throw new KDBizException("error shrek service parameter. members is null.");
        }
        for (String member : members) {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)member)) continue;
            throw new KDBizException("error shrek service parameter. member is null.");
        }
    }

    default public void verifyMembers(String ... members) {
        if (members == null) {
            throw new KDBizException("error shrek service parameter. members is null.");
        }
        for (String member : members) {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)member)) continue;
            throw new KDBizException("error shrek service parameter. member is null.");
        }
    }

    default public void verifyDatasets(Collection<Dataset> datasets) {
        if (datasets == null) {
            throw new KDBizException("error shrek service parameter. datasets is null.");
        }
        for (Dataset dataset : datasets) {
            this.verifyDataset(dataset);
        }
    }

    default public void verifyCube(String cubeNumber) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cubeNumber)) {
            throw new KDBizException("error shrek service parameter. cubeNumber is null.");
        }
    }

    default public void verifyDimensions(String ... dimensions) {
        if (dimensions == null) {
            throw new KDBizException("error shrek service parameter. dimensions is null.");
        }
        for (String dimension : dimensions) {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dimension)) continue;
            throw new KDBizException("error shrek service parameter. dimensions is null.");
        }
    }

    default public void verifyDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            throw new KDBizException("error shrek service parameter. dimension is null.");
        }
        for (Dimension dimension : dimensions) {
            this.verifyDimension(dimension);
        }
    }

    default public void verifyDimension(Dimension dimension) {
        if (dimension == null || dimension.getNumber() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u7ef4\u5ea6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"IShrekVerify_4", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    default public void verifyMeasure(String measure) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)measure)) {
            throw new KDBizException("error shrek service parameter. measure is null.");
        }
    }

    default public void verifyPath(String path) {
        if (path == null) {
            throw new KDBizException("error shrek service parameter. path is null.");
        }
    }

    default public void verify(ShrekConfig config) {
        if (config == null) {
            throw new KDBizException("error shrek service parameter. config is null.");
        }
    }

    default public void verify(OlapConnection conn) {
        if (conn == null) {
            throw new KDBizException("error shrek service parameter. connection is null.");
        }
    }

    default public void verifyShrek(ShrekCube shrek) {
        if (shrek == null) {
            throw new KDBizException("error shrek service parameter. shrek is null.");
        }
    }

    default public void verifyModel(Model model) {
        if (model == null || model.getDataSourceId() == null || model.getDataSourceId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u4f53\u7cfb\u6216\u8005\u4f53\u7cfb\u6570\u636e\u6e90\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"IShrekVerify_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    default public void verifyModel(IModelCacheHelper modelCacheHelper) {
        if (modelCacheHelper == null || modelCacheHelper.getModelobj() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u4f53\u7cfb\u7f13\u5b58\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"IShrekVerify_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    default public boolean verifyQuery(SelectCommandInfo query) {
        return query == null || CollectionUtils.isEmpty((Collection)query.getDimensions());
    }

    default public void verifyDataset(Dataset dataset) {
        if (dataset == null || dataset.getId() == null || dataset.getId() == 0L || kd.epm.eb.common.utils.StringUtils.isEmpty(dataset.getNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u6570\u636e\u96c6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"IShrekVerify_2", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    default public void verifyMember(Member member) {
        if (member == null || StringUtils.isEmpty((String)member.getNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u7ef4\u5ea6\u6210\u5458\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"IShrekVerify_3", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }
}

