/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.util;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;

public final class ShrekIdCodeUtils {
    public static final String TRACE_INFO = "traceId";
    private static final String REQUEST_INFO = "reqId";
    private static final String USER_INFO = "userId";

    public static Map<String, String> getDefaultIdCodes(LogStats stats) {
        return ShrekIdCodeUtils.getDefaultIdCodes(null, stats);
    }

    public static Map<String, String> getDefaultIdCodes(String requestId, LogStats stats) {
        if (StringUtils.isEmpty(requestId)) {
            requestId = String.valueOf(DBServiceHelper.genGlobalLongId());
        }
        HashMap shrekProperties = Maps.newHashMap();
        shrekProperties.put(TRACE_INFO, RequestContext.get().getTraceId());
        shrekProperties.put(REQUEST_INFO, requestId);
        shrekProperties.put(USER_INFO, RequestContext.get().getUserId());
        return shrekProperties;
    }

    public static void setTraceInfo(CommandInfo commandInfo, Map<String, String> shrekProperties) {
        String traceId;
        if (commandInfo == null) {
            return;
        }
        if (commandInfo.getExtProperties() == null) {
            commandInfo.setExtProperties(new HashMap());
        }
        String string = traceId = shrekProperties != null ? shrekProperties.get(TRACE_INFO) : null;
        if (traceId == null) {
            traceId = RequestContext.get().getTraceId();
        }
        long traceNum = 0L;
        try {
            traceNum = Long.parseLong(traceId, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        commandInfo.getExtProperties().put(TRACE_INFO, Long.toString(traceNum));
        OlapTraceServiceHelper.setTraceLog((Long)Long.parseLong((String)commandInfo.getExtProperties().get(TRACE_INFO)), null);
    }
}

