/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.util;

import java.io.Closeable;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.utils.StringUtils;

public class ShrekOlapUtils {
    public static final Log log = LogFactory.getLog(ShrekOlapUtils.class);

    public static void close(Object ... elements) {
        if (elements == null) {
            return;
        }
        for (Object element : elements) {
            if (element instanceof OlapConnection) {
                ShrekOlapUtils.close((OlapConnection)element);
                continue;
            }
            if (element instanceof OlapDataReader) {
                ShrekOlapUtils.close((OlapDataReader)element);
                continue;
            }
            if (element instanceof OlapDataWriter) {
                ShrekOlapUtils.close((OlapDataWriter)element);
                continue;
            }
            if (element instanceof Closeable) {
                ShrekOlapUtils.close((Closeable)element);
                continue;
            }
            if (element == null) continue;
            throw new KDBizException("unsupported element");
        }
    }

    private static void close(OlapConnection conn) {
        if (conn != null && !conn.isClosed()) {
            conn.Close();
        }
    }

    private static void close(OlapDataReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception ex) {
                log.error("close olapDataReader error: ", (Throwable)ex);
            }
        }
    }

    private static void close(OlapDataWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception ex) {
                log.error("close olapDataWriter error: ", (Throwable)ex);
            }
        }
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                log.error("close closeable error: ", (Throwable)ex);
            }
        }
    }

    public static String getCubeNumber(Model model) {
        if (model == null || StringUtils.isEmpty(model.getCubeNumber())) {
            return null;
        }
        return model.getCubeNumber();
    }

    public static String getCubeNumber(Dataset dataset) {
        if (dataset == null || StringUtils.isEmpty(dataset.getNumber())) {
            return null;
        }
        return "CUBE" + dataset.getNumber() + dataset.getId();
    }

    public static String getSandboxName(int boxSeq) {
        return "FMONEYANA" + boxSeq;
    }

    public static String getCubeCaption(Model model, Dataset dataset) {
        return model.getNumber() + "(" + dataset.getNumber() + "," + RequestContext.get().getTenantId() + ")";
    }
}

