/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.util;

import com.alibaba.fastjson.JSON;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.Cache;

public class ShrekParamUtils {
    private static final Log log = LogFactory.getLog(ShrekParamUtils.class);
    public static final String BUDGET_CUBE_PARAMS_CACHE = "BUDGET_CUBE_PARAMS_CACHE";
    public static final Long CUBE_PARAMS_EPM_NODE_ID = 21L;

    public static CubeParams getCubeParamsByCache(long modelId) {
        CubeParams cubeParams;
        String paramJson = Cache.get().get(BUDGET_CUBE_PARAMS_CACHE + modelId);
        if (StringUtils.isEmpty(paramJson)) {
            cubeParams = ShrekParamUtils.getF7Params(modelId);
            if (cubeParams == null) {
                cubeParams = new CubeParams(modelId, null);
            }
            Cache.get().set(BUDGET_CUBE_PARAMS_CACHE + modelId, JSON.toJSONString((Object)cubeParams));
        } else {
            cubeParams = (CubeParams)JSON.parseObject((String)paramJson, CubeParams.class);
        }
        return cubeParams;
    }

    public static void clearCubeParamsByCache(long modelId) {
        Cache.get().remove(BUDGET_CUBE_PARAMS_CACHE + modelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CubeParams getF7Params(long modelId) {
        if (IDUtils.isNull(modelId)) {
            return null;
        }
        LogStats stats = new LogStats("budget-log : ");
        stats.addInfo("begin-load-cubeParams.");
        CubeParams cubeParams = null;
        String paramJson = "";
        try {
            String levelsValue = ParamQueryServiceHelper.getChildString(modelId, ParamEnum.BG031, "storelevel");
            cubeParams = ShrekParamUtils.parseCubeParams(modelId, levelsValue);
        }
        catch (Exception ex) {
            log.error("params-parse-error", (Throwable)ex);
        }
        finally {
            stats.add("end-load-cubeParams.");
            log.info(stats.toString());
        }
        return cubeParams;
    }

    public static CubeParams parseCubeParams(Long modelId, String levelsValue) {
        CubeParams cubeParams = null;
        if (StringUtils.isNotEmpty(levelsValue)) {
            HashSet<Integer> levels = new HashSet<Integer>(32);
            try {
                String[] levelStr;
                for (String s : levelStr = levelsValue.split(",")) {
                    if (!StringUtils.isNotEmpty(s)) continue;
                    levels.add(Integer.valueOf(s));
                }
            }
            catch (Exception ex) {
                log.error("dimIds-parse-error:" + levelsValue);
            }
            cubeParams = new CubeParams(modelId, levels);
        }
        return cubeParams;
    }

    public static void updateDatasetMeta(Long modelId) {
        if (IDUtils.isNull(modelId)) {
            return;
        }
        ShrekParamUtils.clearCubeParamsByCache(modelId);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        if (!modelCacheHelper.getModelobj().isModelByEB()) {
            List<Dataset> datasets = DatasetServiceHelper.getAllDatasets(modelId);
            ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig(modelCacheHelper.getModelobj());
            try {
                ShrekOlapServiceHelper.updateDimension(modelCacheHelper.getModelobj(), datasets, SysDimensionEnum.Entity.getNumber(), config);
            }
            catch (Exception ex) {
                log.error("after-save-error:", (Throwable)ex);
            }
        }
    }

    public static class CubeParams {
        private long modelId;
        private Set<Integer> levels;

        public CubeParams(long modelId, Set<Integer> levels) {
            this.modelId = modelId;
            this.levels = levels;
        }

        public long getModelId() {
            return this.modelId;
        }

        public Set<Integer> getLevels() {
            return this.levels;
        }

        public boolean hasDynamicStore() {
            return this.getLevels() != null && this.getLevels().size() > 0;
        }
    }
}

