/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.util;

import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;

public abstract class ShrekVerify {
    public static final Log log = LogFactory.getLog(ShrekVerify.class);

    protected static boolean verifyElements(Object ... elements) {
        if (elements == null) {
            return true;
        }
        boolean verifyStatus = false;
        for (int i = 0; i < elements.length && !verifyStatus; ++i) {
            Object element = elements[i];
            if (element == null) {
                verifyStatus = true;
                continue;
            }
            if (element instanceof Model) {
                verifyStatus = ShrekVerify.verifyModel((Model)element);
                continue;
            }
            if (element instanceof Dataset) {
                verifyStatus = ShrekVerify.verifyDataset((Dataset)element);
                continue;
            }
            if (element instanceof SelectCommandInfo) {
                verifyStatus = ShrekVerify.verifyQuery((SelectCommandInfo)element);
                continue;
            }
            if (element instanceof LogStats) {
                verifyStatus = false;
                continue;
            }
            throw new KDBizException("unsupported element");
        }
        return verifyStatus;
    }

    protected static boolean verifyDataset(Long datasetId) {
        return datasetId == null || datasetId == 0L;
    }

    private static boolean verifyModel(Model model) {
        return model == null || model.getDataSourceId() == null || model.getDataSourceId() == 0L;
    }

    protected static boolean verifyDataset(Dataset dataset) {
        return dataset == null || ShrekVerify.verifyDataset(dataset.getId()) || StringUtils.isEmpty(dataset.getNumber());
    }

    private static boolean verifyQuery(SelectCommandInfo query) {
        return query == null || query.getDimensions() == null || query.getDimensions().isEmpty();
    }
}

