/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.sonmodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.sonmodel.ControlParam;
import kd.epm.eb.common.sonmodel.MainSubControlRangeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.CacheUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class BgmdMainSubControlHelper {
    private Log log = LogFactory.getLog(BgmdMainSubControlHelper.class);
    Map<String, String> numberMap = new HashMap<String, String>(16);
    private static volatile BgmdMainSubControlHelper bgmdMainSubControlHelper = null;
    public static final Set<String> IMPORT_CONTROL_FIELDS = new HashSet<String>();

    private BgmdMainSubControlHelper() {
        this.numberMap.put("eb_examinecategory", "code");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BgmdMainSubControlHelper getInstance() {
        if (bgmdMainSubControlHelper != null) return bgmdMainSubControlHelper;
        Class<BgmdMainSubControlHelper> clazz = BgmdMainSubControlHelper.class;
        synchronized (BgmdMainSubControlHelper.class) {
            if (bgmdMainSubControlHelper != null) return bgmdMainSubControlHelper;
            bgmdMainSubControlHelper = new BgmdMainSubControlHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return bgmdMainSubControlHelper;
        }
    }

    public DynamicObject getControlMsg(ControlParam controlParam) {
        QFilter qFilter = new QFilter("isenable", "=", (Object)true);
        qFilter.and("basename", "=", (Object)controlParam.getBaseName());
        qFilter.and("controltype", "=", (Object)controlParam.getControlName());
        qFilter.and("controlmodeltype", "=", (Object)controlParam.getControlModelType().toString());
        String selectFields = "id,basename,controlmodeltype,controltype,controlname,isenable,datameta";
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_mainsubset", (String)selectFields, (QFilter[])qFilter.toArray());
        return dynamicObjectCollection.size() == 0 ? null : (DynamicObject)dynamicObjectCollection.get(0);
    }

    public boolean canDoOperation(ControlParam controlParam) {
        if (StringUtils.isEmpty(controlParam.getBaseName())) {
            return true;
        }
        DynamicObject controlMsg = this.getControlMsg(controlParam);
        if (controlMsg != null) {
            String modelMeta = controlMsg.getString("datameta");
            if (StringUtils.isNotEmpty(modelMeta)) {
                controlParam.setDataMete(modelMeta);
            }
            String controlName = controlParam.getControlName();
            if (controlParam.getAddAndUpdate().booleanValue()) {
                return this.addValidate(controlParam, controlParam.getNumbers(), controlMsg) && this.updateValidate(controlParam, controlMsg);
            }
            if ("0".equals(controlName)) {
                return this.addValidate(controlParam, controlParam.getNumbers(), controlMsg);
            }
            if ("2".equals(controlName)) {
                return this.deleteValidate(controlParam, controlMsg);
            }
            if ("1".equals(controlName)) {
                return this.updateValidate(controlParam, controlMsg);
            }
            if ("5".equals(controlName)) {
                return this.pasteAndCutValidate(controlParam, controlMsg);
            }
        }
        return true;
    }

    public String getMainModelName(Long subModelId) {
        if (subModelId == null || subModelId == 0L) {
            return "";
        }
        DynamicObject mainModel = this.getMainModel(subModelId);
        if (mainModel != null) {
            return mainModel.getString("name");
        }
        return "";
    }

    private boolean addValidate(ControlParam controlParam, Set<String> numbers, DynamicObject controlMsg) {
        return this.addValidateNumber(controlParam, numbers, controlMsg);
    }

    private boolean addValidateNumber(ControlParam controlParam, Set<String> numbers, DynamicObject controlMsg) {
        DynamicObjectCollection dynamicObjectCollection;
        Long modelId = controlParam.getModelId();
        if (CollectionUtils.isEmpty(numbers)) {
            return true;
        }
        Set<Long> ids = this.getAllSubIds(modelId);
        List<DynamicObject> grandSubs = this.getAllGrandSonModel(ids);
        grandSubs.forEach(e -> ids.add(e.getLong("id")));
        DynamicObject mainModel = this.getMainModel(modelId);
        if (mainModel != null) {
            Long mainId = mainModel.getLong("id");
            ids.add(mainId);
            DynamicObject grandModel = this.getMainModel(mainId);
            if (grandModel != null) {
                ids.add(grandModel.getLong("id"));
            }
        }
        if (CollectionUtils.isEmpty(ids)) {
            return true;
        }
        QFilter qFilter = null;
        if (controlParam.getAddValidateQFilter() != null) {
            qFilter = controlParam.getAddValidateQFilter();
        } else {
            String model = controlParam.getModelTag();
            qFilter = new QFilter(model, "in", ids);
            String number = "number";
            if (controlMsg != null && this.numberMap.containsKey(controlMsg.getString("basename"))) {
                number = this.numberMap.get(controlMsg.getString("basename"));
            }
            qFilter.and(number, "in", numbers);
        }
        if (StringUtils.isNotEmpty(controlParam.getControlDimensionNumber())) {
            qFilter.and(new QFilter("dimension.number", "=", (Object)controlParam.getControlDimensionNumber()));
        }
        if ((dynamicObjectCollection = QueryServiceHelper.query((String)controlParam.getDataMete(), (String)"id", (QFilter[])qFilter.toArray())).size() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u4e0e\u5f53\u524d\u4f53\u7cfb\u7684\u4e3b\u4f53\u7cfb\u6216\u5b50\u4f53\u7cfb\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BgmdMainSubControlHelper_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return true;
    }

    private boolean deleteValidate(ControlParam controlParam, DynamicObject controlMsg) {
        boolean result = this.deleteDataValidate(controlParam, controlMsg);
        return result;
    }

    private boolean deleteDataValidate(ControlParam controlParam, DynamicObject controlMsg) {
        if (!this.checkDataFromMain(controlParam, controlMsg)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e3b\u4f53\u7cfb %1 \u7ba1\u63a7\u7684\u57fa\u7840\u8d44\u6599\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BgmdMainSubControlHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getMainModelName(controlParam.getModelId())}));
        }
        return true;
    }

    private boolean updateValidate(ControlParam controlParam, DynamicObject controlMsg) {
        return this.updateFieldValidate(controlParam, controlMsg);
    }

    private boolean updateFieldValidate(ControlParam controlParam, DynamicObject controlMsg) {
        String errorMsg = "";
        if (this.checkDataFromMain(controlParam, controlMsg)) {
            return true;
        }
        errorMsg = ResManager.loadResFormat((String)"\u4e3b\u4f53\u7cfb %1 \u7ba1\u63a7\u7684\u57fa\u7840\u8d44\u6599\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BgmdMainSubControlHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getMainModelName(controlParam.getModelId())});
        String dbControlName = controlMsg.getString("controlname");
        boolean isFinish = true;
        if (StringUtils.isNotEmpty(controlParam.getControlField())) {
            errorMsg = "";
            if (StringUtils.isNotEmpty(dbControlName)) {
                Object[] requestField = controlParam.getControlField().split(";");
                HashSet requestSet = new HashSet(16);
                CollectionUtils.addAll(requestSet, (Object[])requestField);
                Object[] fields = dbControlName.split(";");
                HashSet dbSet = new HashSet(16);
                CollectionUtils.addAll(dbSet, (Object[])fields);
                HashSet result = new HashSet(16);
                result.addAll(requestSet);
                result.retainAll(dbSet);
                if (CollectionUtils.isNotEmpty(result)) {
                    isFinish = false;
                    errorMsg = ResManager.loadResFormat((String)"\u4e3b\u4f53\u7cfb %1 \u7ba1\u63a7\u7684\u57fa\u7840\u8d44\u6599\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BgmdMainSubControlHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getMainModelName(controlParam.getModelId())});
                }
            }
        }
        if (StringUtils.isEmpty(dbControlName) && StringUtils.isNotEmpty(errorMsg)) {
            throw new KDBizException(errorMsg);
        }
        if (StringUtils.isNotEmpty(dbControlName) && StringUtils.isNotEmpty(errorMsg) && !isFinish) {
            throw new KDBizException(errorMsg);
        }
        return true;
    }

    private boolean pasteAndCutValidate(ControlParam controlParam, DynamicObject controlMsg) {
        if (!this.checkDataFromMain(controlParam, controlMsg)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e3b\u4f53\u7cfb %1 \u7ba1\u63a7\u7684\u57fa\u7840\u8d44\u6599\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BgmdMainSubControlHelper_1", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getMainModelName(controlParam.getModelId())}));
        }
        return true;
    }

    public void updateSubSign(String baseName, String sign, Set<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids) && StringUtils.isNotEmpty(baseName)) {
            QFilter qFilter = new QFilter("id", "in", ids);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)baseName, (String)"id,syncstatus,syncdate", (QFilter[])qFilter.toArray());
            this.log.info("BgmdMainSubControlHelper updateSubSign :", (Object)(baseName + "," + sign + "," + SerializationUtils.toJsonString(ids)));
            if (dynamicObjects.length > 0) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    dynamicObject.set("syncstatus", (Object)sign);
                }
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
                this.log.info("BgmdMainSubControlHelper updateSubSign success");
            }
        }
    }

    public Set<Long> getDataIdsFromSub(String baseName, Set<String> mainNumber, Set<Long> subIds, String dimensionNumber) {
        HashSet<Long> ids = new HashSet<Long>(16);
        String number = "number";
        if (this.numberMap.containsKey(baseName)) {
            number = this.numberMap.get(baseName);
        }
        QFilter qFilter = new QFilter(number, "in", mainNumber);
        qFilter.and("model", "in", subIds);
        boolean needAddDimensionFilter = SysDimensionEnum.getEnumByMemberTreemodel(baseName) != null;
        QFilter dimensionFilter = null;
        if (needAddDimensionFilter && StringUtils.isNotEmpty(dimensionNumber)) {
            dimensionFilter = new QFilter("dimension.number", "=", (Object)dimensionNumber);
        }
        if (dimensionFilter != null) {
            qFilter.and(dimensionFilter);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)baseName, (String)"id", (QFilter[])qFilter.toArray());
        for (DynamicObject dynamicObject : dynamicObjects) {
            ids.add(dynamicObject.getLong("id"));
        }
        return ids;
    }

    public Set<Long> getDataIdsByNumber(String baseName, Set<String> mainNumber, Set<Long> subIds) {
        return this.getDataIdsByNumber(baseName, mainNumber, subIds, null, null);
    }

    public Set<Long> getDataIdsByNumber(String baseName, Set<String> mainNumber, Set<Long> subIds, QFilter customQFilter, String dimensionNumber) {
        QFilter qFilter;
        HashSet<Long> ids = new HashSet(16);
        if (customQFilter != null) {
            qFilter = customQFilter;
            qFilter.and("model", "in", subIds);
        } else {
            qFilter = new QFilter("model", "in", subIds);
        }
        String number = "number";
        if (this.numberMap.containsKey(baseName)) {
            number = this.numberMap.get(baseName);
        }
        boolean needAddDimensionFilter = SysDimensionEnum.getEnumByMemberTreemodel(baseName) != null;
        QFilter dimensionFilter = null;
        if (needAddDimensionFilter && StringUtils.isNotEmpty(dimensionNumber)) {
            dimensionFilter = new QFilter("dimension.number", "=", (Object)dimensionNumber);
        }
        if (StringUtils.equals("eb_bizruleset", baseName)) {
            ids = this.bizRuleGetDataIdsByNumber(mainNumber, subIds);
        } else {
            qFilter.and(number, "in", mainNumber);
            if (needAddDimensionFilter) {
                qFilter.and(dimensionFilter);
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)baseName, (String)"id", (QFilter[])qFilter.toArray());
            for (DynamicObject dynamicObject : dynamicObjects) {
                ids.add(dynamicObject.getLong("id"));
            }
        }
        return ids;
    }

    private Set<Long> bizRuleGetDataIdsByNumber(Set<String> mainNumber, Set<Long> subIds) {
        HashSet<Long> ids = new HashSet<Long>(16);
        if (CollectionUtils.isNotEmpty(mainNumber) && CollectionUtils.isNotEmpty(subIds)) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid from t_eb_bizruleset where ", new Object[0]);
            sqlBuilder.appendIn("fmodel", (List)Lists.newArrayList(subIds));
            StringBuilder sb = new StringBuilder();
            sb.append(" and ( ");
            int i = 0;
            for (String s : mainNumber) {
                sb.append(" fnumber like '").append(s).append("%'");
                if (++i >= mainNumber.size()) continue;
                sb.append(" or ");
            }
            sb.append(" ) ");
            sqlBuilder.append(sb.toString(), new Object[0]);
            try (DataSet dataSet = DB.queryDataSet((String)"mainSubBizRule", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    ids.add(row.getLong("fid"));
                }
            }
        }
        return ids;
    }

    public Set<Long> getDataIdsByIds(String baseName, Set<Long> mainIds, Set<Long> subIds) {
        DynamicObjectCollection dimensions;
        HashSet<Long> result = new HashSet<Long>(16);
        String number = "number";
        if (this.numberMap.containsKey(baseName)) {
            number = this.numberMap.get("eb_examinecategory");
        }
        QFilter qFilter = new QFilter("id", "in", mainIds);
        DynamicObjectCollection numbers = QueryServiceHelper.query((String)baseName, (String)number, (QFilter[])qFilter.toArray());
        boolean needAddDimensionFilter = SysDimensionEnum.getEnumByMemberTreemodel(baseName) != null;
        QFilter dimensionFilter = null;
        if (needAddDimensionFilter && CollectionUtils.isNotEmpty((Collection)(dimensions = QueryServiceHelper.query((String)baseName, (String)"dimension.number", (QFilter[])qFilter.toArray())))) {
            Set dimensionNumbers = dimensions.stream().map(dynamicObject -> dynamicObject.getString("dimension.number")).collect(Collectors.toSet());
            dimensionFilter = new QFilter("dimension.number", "in", (Object)dimensionNumbers);
        }
        HashSet<String> numberSet = new HashSet<String>(16);
        for (DynamicObject dynamicObject2 : numbers) {
            numberSet.add(dynamicObject2.getString(number));
        }
        if (CollectionUtils.isNotEmpty((Collection)numbers)) {
            if (StringUtils.equals("eb_bizruleset", baseName)) {
                // empty if block
            }
            QFilter q = new QFilter(number, "in", numberSet);
            q.and("model", "in", subIds);
            if (needAddDimensionFilter) {
                q.and(dimensionFilter);
            }
            DynamicObjectCollection ids = QueryServiceHelper.query((String)baseName, (String)"id", (QFilter[])q.toArray());
            for (DynamicObject dynamicObject3 : ids) {
                result.add(dynamicObject3.getLong("id"));
            }
        }
        return result;
    }

    public Integer checkModelType(Long modelId) {
        if (modelId == null || modelId == 0L) {
            throw new KDBizException("modelId is empty");
        }
        QFilter qFilter = new QFilter("id", "=", (Object)modelId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"parentnumber", (QFilter[])qFilter.toArray());
        if (dynamicObject != null && StringUtils.isNotEmpty(dynamicObject.getString("parentnumber"))) {
            return 1;
        }
        return 0;
    }

    public int queryLevel(Long modelId) {
        if (modelId == null || modelId == 0L) {
            return 1;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)modelId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"level", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            return 1;
        }
        return dynamicObject.getInt("level");
    }

    public String getDateMete(String baseName) {
        if (StringUtils.isEmpty(baseName)) {
            return null;
        }
        QFilter qFilter = new QFilter("basename", "=", (Object)baseName);
        qFilter.and("isenable", "=", (Object)true);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_mainsubset", (String)"datameta", (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            return dynamicObject.getString("datameta");
        }
        return null;
    }

    public void getAllSubIds(Set<Long> result, Set<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            result.addAll(ids);
            QFilter qFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epm_model", (String)"id,shownumber,parentnumber", (QFilter[])qFilter.toArray());
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                HashSet parentnumbers = new HashSet(16);
                dynamicObjects.forEach(e -> parentnumbers.add(e.getString("shownumber")));
                qFilter = new QFilter("parentnumber", "in", parentnumbers);
                dynamicObjects = QueryServiceHelper.query((String)"epm_model", (String)"id,shownumber,parentnumber", (QFilter[])qFilter.toArray());
                if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                    HashSet<Long> nextIds = new HashSet<Long>(16);
                    dynamicObjects.forEach(e -> nextIds.add(e.getLong("id")));
                    this.getAllSubIds(result, nextIds);
                }
            }
        }
    }

    public Set<Long> getAllSubIds(Long modelId) {
        List<DynamicObject> subs;
        HashSet<Long> subIds = new HashSet<Long>(16);
        if (modelId != 0L && CollectionUtils.isNotEmpty(subs = this.getAllSubModel(modelId))) {
            subs.forEach(e -> subIds.add(e.getLong("id")));
        }
        return subIds;
    }

    public List<DynamicObject> getAllSubModel(Long modelId) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        if (modelId != 0L) {
            QFilter qFilter = new QFilter("id", "=", (Object)modelId);
            qFilter.and("reporttype", "=", (Object)"7");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"shownumber", (QFilter[])qFilter.toArray());
            if (dynamicObject == null) {
                return result;
            }
            String number = dynamicObject.getString("shownumber");
            if (StringUtils.isNotEmpty(number)) {
                QFilter qFilterSon = new QFilter("parentnumber", "=", (Object)number);
                qFilterSon.and("reporttype", "=", (Object)"7");
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"epm_model", (String)"id", (QFilter[])qFilterSon.toArray());
                result.addAll((Collection<DynamicObject>)dynamicObjectCollection);
            }
        }
        return result;
    }

    public List<DynamicObject> getAllGrandSonModel(Set<Long> sonModelIds) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        if (sonModelIds != null && sonModelIds.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", sonModelIds);
            qFilter.and("reporttype", "=", (Object)"7");
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epm_model", (String)"id,shownumber", (QFilter[])qFilter.toArray());
            if (dynamicObjects == null) {
                return result;
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                String number = dynamicObject.getString("shownumber");
                if (!StringUtils.isNotEmpty(number)) continue;
                QFilter qFilterSon = new QFilter("parentnumber", "=", (Object)number);
                qFilterSon.and("reporttype", "=", (Object)"7");
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"epm_model", (String)"id,name", (QFilter[])qFilterSon.toArray());
                result.addAll((Collection<DynamicObject>)dynamicObjectCollection);
            }
        }
        return result;
    }

    public DynamicObject getMainModel(Long modelId) {
        DynamicObject target;
        if (modelId != 0L && (target = QueryServiceHelper.queryOne((String)"epm_model", (String)"parentnumber", (QFilter[])new QFilter("id", "=", (Object)modelId).toArray())) != null && StringUtils.isNotEmpty(target.getString("parentnumber"))) {
            QFilter qFilter = new QFilter("shownumber", "=", (Object)target.getString("parentnumber"));
            qFilter.and("reporttype", "=", (Object)"7");
            return QueryServiceHelper.queryOne((String)"epm_model", (String)"id,name,shownumber", (QFilter[])qFilter.toArray());
        }
        return null;
    }

    public Set<Long> getMainModel(Set<Long> subIds) {
        QFilter qFilter;
        DynamicObjectCollection subs;
        HashSet<Long> set = new HashSet<Long>(16);
        if (CollectionUtils.isNotEmpty(subIds) && CollectionUtils.isNotEmpty((Collection)(subs = QueryServiceHelper.query((String)"epm_model", (String)"id,parentnumber", (QFilter[])(qFilter = new QFilter("id", "in", subIds)).toArray())))) {
            HashSet<String> parentnumbers = new HashSet<String>(16);
            for (DynamicObject sub : subs) {
                parentnumbers.add(sub.getString("parentnumber"));
            }
            qFilter = new QFilter("shownumber", "in", parentnumbers);
            DynamicObjectCollection mains = QueryServiceHelper.query((String)"epm_model", (String)"id", (QFilter[])qFilter.toArray());
            if (CollectionUtils.isNotEmpty((Collection)mains)) {
                for (DynamicObject main : mains) {
                    set.add(main.getLong("id"));
                }
            }
        }
        return set;
    }

    private boolean checkDataFromMain(ControlParam controlParam, DynamicObject controlMsg) {
        Set<Long> deleteIds = controlParam.getDeleteIds();
        Set<String> numbers = controlParam.getNumbers();
        if (CollectionUtils.isEmpty(deleteIds) && CollectionUtils.isEmpty(numbers)) {
            return true;
        }
        if (StringUtils.isEmpty(controlParam.getBaseName())) {
            return true;
        }
        QFilter qFilter = controlParam.getCustomQFilter();
        if (CollectionUtils.isNotEmpty(deleteIds)) {
            if (qFilter == null) {
                qFilter = new QFilter("id", "in", deleteIds);
            } else {
                qFilter.and("id", "in", deleteIds);
            }
        } else if (qFilter == null) {
            qFilter = new QFilter("model", "=", (Object)controlParam.getModelId());
            String number = "number";
            if (controlMsg != null && this.numberMap.containsKey(controlMsg.getString("basename"))) {
                number = this.numberMap.get(controlMsg.getString("basename"));
            }
            qFilter.and(number, "in", numbers);
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)controlParam.getDataMete(), (String)"syncstatus", (QFilter[])qFilter.toArray());
        boolean result = true;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String syncStatus = dynamicObject.getString("syncstatus");
            if (!StringUtils.isNotEmpty(syncStatus) || StringUtils.equals(syncStatus, "0")) continue;
            result = false;
            break;
        }
        return result;
    }

    public void sendMessage(IFormView view, Long modelId, Set<Long> userIds, IFormPlugin plugin, String closeCallBack) {
        if (view == null || modelId == null || CollectionUtils.isEmpty(userIds)) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_mainsubremind");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (plugin != null && StringUtils.isNotEmpty(closeCallBack)) {
            formShowParameter.setCloseCallBack(new CloseCallBack(plugin, closeCallBack));
        }
        formShowParameter.setCustomParam("modelId", (Object)modelId);
        formShowParameter.setCustomParam("userIds", (Object)SerializationUtils.toJsonString(userIds));
        view.showForm(formShowParameter);
    }

    public Boolean checkAllMainSubNumber(Long modelId, String dataMete, Set<String> number) {
        return this.checkAllMainSubNumber(null, modelId, dataMete, number);
    }

    public Boolean checkAllMainSubNumber(QFilter qFilter, Long modelId, String dataMete, Set<String> number) {
        if (modelId != 0L && StringUtils.isNotEmpty(dataMete) && CollectionUtils.isNotEmpty(number)) {
            List<DynamicObject> grandSubs;
            DynamicObject main = this.getMainModel(modelId);
            List<DynamicObject> subs = this.getAllSubModel(modelId);
            HashSet<Long> ids = new HashSet<Long>(16);
            if (CollectionUtils.isNotEmpty(subs)) {
                subs.forEach(e -> ids.add(e.getLong("id")));
            }
            if (CollectionUtils.isNotEmpty(grandSubs = this.getAllGrandSonModel(ids))) {
                grandSubs.forEach(e -> ids.add(e.getLong("id")));
            }
            if (main != null) {
                Long mainId = main.getLong("id");
                ids.add(mainId);
                DynamicObject grandModel = this.getMainModel(mainId);
                if (grandModel != null) {
                    ids.add(grandModel.getLong("id"));
                }
            }
            if (qFilter == null) {
                qFilter = new QFilter("model", "in", ids);
            } else {
                qFilter.and("model", "in", ids);
            }
            qFilter.and("number", "in", number);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)dataMete, (String)"id", (QFilter[])qFilter.toArray());
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                return false;
            }
        }
        return true;
    }

    public void updateSubMainNumber(String dataMeta, Set<Long> ids, String number) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)dataMeta, (String)"id,syncmainnumber,syncstatus,syncdate", (QFilter[])qFilter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("syncmainnumber", (Object)number);
                dynamicObject.set("syncstatus", (Object)"");
                dynamicObject.set("syncdate", null);
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public void setDefaultValueWhenCopy(DynamicObjectCollection dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            this.setDefaultValueWhenCopy(dynamicObject);
        }
    }

    public void setDefaultValueWhenCopy(DynamicObject dynamicObject) {
        if (dynamicObject.containsProperty("syncstatus")) {
            dynamicObject.set("syncstatus", (Object)"");
        }
        if (dynamicObject.containsProperty("syncdate")) {
            dynamicObject.set("syncdate", null);
        }
        if (dynamicObject.containsProperty("syncmainnumber")) {
            dynamicObject.set("syncmainnumber", (Object)"");
        }
    }

    public Map<String, Map<String, Object>> checkDataWhenImport(String dataMete, Set<String> numbers, Long modelId, String dimensionNumber, String viewNumber, String dataType, DynamicObject mainSubControl) {
        if (StringUtils.isEmpty(dataMete) || CollectionUtils.isEmpty(numbers) || IDUtils.isNull(modelId) || StringUtils.isEmpty(dimensionNumber)) {
            return Collections.emptyMap();
        }
        boolean hasMainSubModel = false;
        boolean isMainModel = false;
        boolean isSubModel = false;
        boolean hasSelf = StringUtils.equals("self", dataType);
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model");
        DynamicObject parent = null;
        DynamicObject ancestor = null;
        Map children = null;
        QFBuilder builder = new QFBuilder();
        if (model.getInt("level") > 0) {
            hasMainSubModel = true;
            if (StringUtils.isEmpty(model.getString("parentnumber"))) {
                isMainModel = true;
            } else {
                isSubModel = true;
                builder.clear();
                builder.add("shownumber", "=", model.getString("parentnumber"));
                parent = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"id,shownumber,parentnumber", (QFilter[])builder.toArray());
                if (StringUtils.isNotEmpty(parent.getString("parentnumber"))) {
                    builder.clear();
                    builder.add("shownumber", "=", parent.getString("parentnumber"));
                    ancestor = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"id,shownumber,parentnumber", (QFilter[])builder.toArray());
                }
            }
            builder.clear();
            builder.add("parentnumber", "=", model.getString("shownumber"));
            children = BusinessDataServiceHelper.loadFromCache((String)"epm_model", (String)"id,shownumber", (QFilter[])builder.toArray());
        }
        if (!hasMainSubModel) {
            return Collections.emptyMap();
        }
        HashMap dataMap = Collections.emptyMap();
        HashSet<Long> allModelIds = new HashSet<Long>(16);
        if (StringUtils.equals(dataType, "all")) {
            if (parent != null) {
                allModelIds.add(parent.getLong("id"));
            }
            if (ancestor != null) {
                allModelIds.add(ancestor.getLong("id"));
            }
            if (children != null) {
                allModelIds.addAll(IDUtils.toLongs(children.keySet()));
            }
            allModelIds.remove(modelId);
        } else if (hasSelf) {
            allModelIds.add(modelId);
        }
        if (CollectionUtils.isNotEmpty(allModelIds)) {
            builder.clear();
            builder.add("model", "in", allModelIds);
            builder.add("number", "in", numbers);
            builder.add("dimension.number", "=", dimensionNumber);
            if (StringUtils.isNotEmpty(viewNumber)) {
                builder.add("view.number", "=", viewNumber);
            }
            boolean hasProperty = false;
            StringBuilder tmpFields = new StringBuilder("id,number,syncstatus");
            if (hasSelf) {
                if (mainSubControl != null && StringUtils.isNotEmpty(mainSubControl.getString("controlname"))) {
                    String[] _fields;
                    LinkedHashSet fieldSet = Sets.newLinkedHashSet();
                    for (String _field : _fields = mainSubControl.getString("controlname").split(";")) {
                        if (!IMPORT_CONTROL_FIELDS.contains(_field)) continue;
                        if ("currency".equals(_field)) {
                            fieldSet.add(",currency.number");
                            continue;
                        }
                        if ("parent".equals(_field)) {
                            fieldSet.add(",parent.number");
                            continue;
                        }
                        if ("propertyvalue".equals(_field)) {
                            hasProperty = true;
                            continue;
                        }
                        fieldSet.add(_field);
                    }
                    tmpFields.append(",").append(StringUtils.join((Collection)fieldSet, ','));
                    dataMete = mainSubControl.getString("datameta");
                } else if (StringUtils.isNotEmpty(viewNumber)) {
                    dataMete = "eb_viewmember";
                }
            } else {
                QFBuilder tmpBuilder = new QFBuilder();
                tmpBuilder.add("basename", "=", dataMete);
                tmpBuilder.and("isenable", "=", true);
                mainSubControl = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_mainsubset", (QFilter[])tmpBuilder.toArray());
                if (mainSubControl != null) {
                    dataMete = mainSubControl.getString("datameta");
                } else if (StringUtils.isNotEmpty(viewNumber)) {
                    dataMete = "eb_viewmember";
                }
            }
            String fields = tmpFields.toString();
            DynamicObjectCollection objects = QueryServiceHelper.query((String)dataMete, (String)fields, (QFilter[])builder.toArray());
            if (objects != null && !objects.isEmpty()) {
                dataMap = Maps.newHashMapWithExpectedSize((int)objects.size());
                MemberPropCache propCache = null;
                List<CustomProperty> properties = null;
                if (hasProperty) {
                    propCache = MemberPropCacheService.getOrCreate(modelId);
                    properties = propCache.getPropertiesByDim(dimensionNumber);
                }
                String[] _fields = fields.split(",");
                for (DynamicObject object : objects) {
                    dataMap.put(object.getString("number"), CommonServiceHelper.transDataMap(_fields, object));
                }
                if (properties != null && !properties.isEmpty()) {
                    for (Map.Entry member : dataMap.entrySet()) {
                        HashMap propMap = Maps.newHashMapWithExpectedSize((int)properties.size());
                        for (CustomProperty property : properties) {
                            CustomPropertyValue propertyValue = propCache.getPropertyValueByMemNumber(dimensionNumber, property.getNumber(), (String)member.getKey());
                            if (propertyValue == null) continue;
                            propMap.put(property.getNumber(), propertyValue.getNumber());
                        }
                        if (propMap.isEmpty()) continue;
                        ((Map)member.getValue()).put("property", propMap);
                    }
                }
            }
        }
        return dataMap;
    }

    public boolean validateDataWhenImport(String key, String excelData, @NotNull Map<String, Object> dynamicObject) {
        return StringUtils.isNotEmpty((String)dynamicObject.get("syncstatus")) && !StringUtils.equals((String)dynamicObject.get(key), excelData);
    }

    public void checkIsDeleteBySyncStatus(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return;
        }
        if (dynamicObject.getDataEntityType().getProperties().containsKey((Object)"syncstatus") && StringUtils.equals(dynamicObject.getString("syncstatus"), "2")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u4e3b\u4f53\u7cfb\u5df2\u5220\u9664\uff0c\u4e0d\u5141\u8bb8\u6253\u5f00\u3002", (String)"MainSubModelDataSetPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public Set<Long> checkMainSubModelHasSub(Set<Long> ids) {
        HashSet<Long> set = new HashSet<Long>(16);
        if (CollectionUtils.isNotEmpty(ids)) {
            QFilter qFilter = new QFilter("id", "in", ids);
            qFilter.and("level", "=", (Object)1);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epm_model", (String)"id,level,shownumber", (QFilter[])qFilter.toArray());
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                HashSet<String> numbers = new HashSet<String>(16);
                HashMap<String, Long> map = new HashMap<String, Long>(16);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    numbers.add(dynamicObject.getString("shownumber"));
                    map.put(dynamicObject.getString("shownumber"), dynamicObject.getLong("id"));
                }
                if (CollectionUtils.isNotEmpty(numbers)) {
                    qFilter = new QFilter("parentnumber", "in", numbers);
                    DynamicObjectCollection subs = QueryServiceHelper.query((String)"epm_model", (String)"id,parentnumber", (QFilter[])qFilter.toArray());
                    if (CollectionUtils.isNotEmpty((Collection)subs)) {
                        HashSet<String> hasSubModel = new HashSet<String>(16);
                        for (DynamicObject sub : subs) {
                            hasSubModel.add(sub.getString("parentnumber"));
                        }
                        map.forEach((k, v) -> {
                            if (!hasSubModel.contains(k)) {
                                set.add((Long)v);
                            }
                        });
                    } else {
                        return ids;
                    }
                }
            }
        }
        return set;
    }

    public void updateMainSubModelLevel(Set<Long> ids, int level) {
        QFilter qFilter;
        DynamicObject[] dynamicObjects;
        if (CollectionUtils.isNotEmpty(ids) && (dynamicObjects = BusinessDataServiceHelper.load((String)"epm_model", (String)"id,level", (QFilter[])(qFilter = new QFilter("id", "in", ids)).toArray())) != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("level", (Object)level);
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public boolean validateDimControl(Long modelId, String dimType, Long parentId) {
        if (IDUtils.isNotNull(modelId) && StringUtils.isNotEmpty(dimType) && IDUtils.isNotNull(parentId)) {
            return this.validateIsControl(modelId, dimType) && this.validateIsLeaf(dimType, parentId);
        }
        return false;
    }

    public boolean validateIsControl(Long modelId, String dimType) {
        DynamicObject mainSubModelBase;
        QFilter qFilter = new QFilter("id", "=", (Object)modelId);
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"shownumber,level, parentnumber", (QFilter[])qFilter.toArray());
        if (model != null && model.getInt("level") > 1 && (mainSubModelBase = QueryServiceHelper.queryOne((String)"eb_mainsubmodel_base", (String)"controldim, controltype, controlrange", (QFilter[])(qFilter = new QFilter("number", "=", (Object)model.getString("shownumber"))).toArray())) != null) {
            String controltype = mainSubModelBase.getString("controltype");
            String controlrange = mainSubModelBase.getString("controlrange");
            if (MainSubControlRangeEnum.all_dim.getCode().equals(controlrange)) {
                DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_dimension", (String)"number", (QFilter[])new QFilter[]{new QFilter("model.shownumber", "=", (Object)model.getString("parentnumber"))});
                HashSet<String> mainModelNumbers = new HashSet<String>(16);
                for (DynamicObject dynamicObject : query) {
                    String number = dynamicObject.getString("number");
                    if (SysDimensionEnum.getEnumByNumber(number) != null && !StringUtils.equals(number, SysDimensionEnum.Entity.getNumber()) && !StringUtils.equals(number, SysDimensionEnum.Account.getNumber())) continue;
                    mainModelNumbers.add(dynamicObject.getString("number"));
                }
                controltype = String.join((CharSequence)",", mainModelNumbers);
            }
            if (mainSubModelBase.getBoolean("controldim") && StringUtils.isNotEmpty(controltype)) {
                String[] controltypes = controltype.split(",");
                HashSet<String> dbControlType = new HashSet<String>(16);
                dbControlType.addAll(Arrays.asList(controltypes));
                if (StringUtils.isNotEmpty(dimType)) {
                    return !dbControlType.add(dimType);
                }
            }
        }
        return false;
    }

    public boolean validateIsLeaf(String dimType, Long parentId) {
        QFilter qFilter;
        DynamicObject member;
        String dataModel = "epm_userdefinedmembertree";
        SysDimensionEnum enumByNumber = SysDimensionEnum.getEnumByNumber(dimType);
        if (enumByNumber != null) {
            dataModel = enumByNumber.getMemberTreemodel();
        }
        if ((member = QueryServiceHelper.queryOne((String)dataModel, (String)"isleaf,level", (QFilter[])(qFilter = new QFilter("id", "=", (Object)parentId)).toArray())) != null) {
            return !member.getBoolean("isleaf");
        }
        return false;
    }

    public boolean checkTemplateNewDimIsCollect(Long modelId, Long templateId) {
        Integer modelType = this.checkModelType(modelId);
        if (modelType == 0) {
            return false;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)templateId);
        DynamicObject templateObj = QueryServiceHelper.queryOne((String)"eb_templateentity", (String)"syncstatus", (QFilter[])qFilter.toArray());
        if (templateObj != null) {
            String syncStatus = templateObj.getString("syncstatus");
            return StringUtils.isNotEmpty(syncStatus) && !StringUtils.equals(syncStatus, "0");
        }
        return false;
    }

    public void cacheFocusBizRuleRowInfo(String focusId, String focusNumber, IPageCache pageCache) {
        CacheUtils.put(pageCache, "mainsub_cache_focus_rule_Id", focusId == null ? "" : focusId);
        CacheUtils.put(pageCache, "mainsub_cache_focus_rule_number", focusNumber == null ? "" : focusNumber);
    }

    public String getFocusBizRuleRowNumber(IPageCache pageCache) {
        return CacheUtils.get(pageCache, "mainsub_cache_focus_rule_number");
    }

    public String getFocusBizRuleRowId(IPageCache pageCache) {
        return CacheUtils.get(pageCache, "mainsub_cache_focus_rule_Id");
    }

    static {
        IMPORT_CONTROL_FIELDS.add("name");
        IMPORT_CONTROL_FIELDS.add("simplename");
        IMPORT_CONTROL_FIELDS.add("parent");
        IMPORT_CONTROL_FIELDS.add("parent.number");
        IMPORT_CONTROL_FIELDS.add("propertyvalue");
        IMPORT_CONTROL_FIELDS.add("aggoprt");
        IMPORT_CONTROL_FIELDS.add("accounttype");
    }
}

