/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.taskflow.graph;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.epm.eb.common.taskflow.graph.TaskFlowLine;
import kd.epm.eb.common.taskflow.graph.TaskFlowNode;
import kd.epm.eb.common.utils.StringUtils;

public interface ITaskFlowGraph {
    default public List<TaskFlowLine> getNodePreRelLine(String nodeNum) {
        return this.getLineMap().values().stream().filter(e -> StringUtils.equals(e.getTargetNodeNum(), nodeNum)).collect(Collectors.toList());
    }

    default public List<TaskFlowLine> getNextLineByNode(String nodeNum) {
        return this.getLineMap().values().stream().filter(e -> StringUtils.equals(e.getSourceNodeNum(), nodeNum)).collect(Collectors.toList());
    }

    default public TaskFlowNode getStartNode() {
        Optional<TaskFlowNode> first = this.getNodeMap().values().stream().filter(e -> "start".equals(e.getNumber())).findFirst();
        return first.orElse(null);
    }

    default public TaskFlowNode getEndNode() {
        Optional<TaskFlowNode> first = this.getNodeMap().values().stream().filter(e -> "end".equals(e.getNumber())).findFirst();
        return first.orElse(null);
    }

    default public TaskFlowNode getNode(String number) {
        return this.getNodeMap().get(number);
    }

    default public TaskFlowLine getLine(String number) {
        return this.getLineMap().get(number);
    }

    default public void addNode(TaskFlowNode node) {
        this.getNodeMap().put(node.getNumber(), node);
    }

    default public void addLine(TaskFlowLine line) {
        this.getLineMap().put(line.getNumber(), line);
    }

    default public void removeNode(String number) {
        this.getNodeMap().remove(number);
    }

    default public void removeLine(String number) {
        this.getLineMap().remove(number);
    }

    public Map<String, TaskFlowNode> getNodeMap();

    public Map<String, TaskFlowLine> getLineMap();
}

