/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;

public class EpmThreadPools {
    private static final Log log = LogFactory.getLog(EpmThreadPools.class);
    public static final ThreadPool CommPools = ThreadPools.newFixedThreadPool((String)"budget-comm", (int)16, (String)"bgmd");
    public static final ThreadPool RULE_EXECUTION_POOL = ThreadPools.newFixedThreadPool((String)"epm_ruleExecution", (int)16, (String)"bgmd");
    public static final ThreadPool RULE_HANDLE_POOL = ThreadPools.newFixedThreadPool((String)"epm_rule_handle", (int)16, (String)"bgmd");
    public static final ThreadPool EVENT_POOL = ThreadPools.newFixedThreadPool((String)"epm_bus_pool", (int)16, (String)"bgmd");
    public static final ThreadPool HALF_CORE_POOL = ThreadPools.newFixedThreadPool((String)"epm_half", (int)(Runtime.getRuntime().availableProcessors() / 2 + 1), (String)"bgmd");
    public static final ThreadPool EXEC_LONGTIME_POOL = ThreadPools.newFixedThreadPool((String)"epm_longtime_pool", (int)16, (String)"bgmd");
    public static final EBThreadPoolExecutor exportConsumerThreadPool = new EBThreadPoolExecutor(1, 1, 5L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(50), new ThreadPoolExecutor.AbortPolicy(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            int activeCount;
            if (!e.isShutdown() && (activeCount = e.getQueue().size()) >= 50) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5bfc\u51fa\u4efb\u52a1\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"POIExportCommand_003", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    });
    public static final EBThreadPoolExecutor ruleCaseExecConsumerThreadPool = new EBThreadPoolExecutor(1, 1, 5L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(50), new ThreadPoolExecutor.AbortPolicy(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            int activeCount;
            if (!e.isShutdown() && (activeCount = e.getQueue().size()) >= 50) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5bfc\u51fa\u4efb\u52a1\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"POIExportCommand_003", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    });
    public static final EBThreadPoolExecutor importDataThreadPool = new EBThreadPoolExecutor(Math.min(Runtime.getRuntime().availableProcessors(), 4), 4, 10L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(20), new ThreadPoolExecutor.AbortPolicy(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            int activeCount;
            if (!e.isShutdown() && (activeCount = e.getQueue().size()) >= 20) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5bfc\u5165\u4efb\u52a1\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"POIExportCommand_008", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    });
    public static final EBThreadPoolExecutor exportConsumerExecuteThreadPool = new EBThreadPoolExecutor(1, 1, 5L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
    public static final EBThreadPoolExecutor predictThreadPool = new EBThreadPoolExecutor(4, 4, 5L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5000), new ThreadPoolExecutor.AbortPolicy(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            try {
                e.getQueue().put(r);
            }
            catch (InterruptedException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    });
    public static final ThreadPool EXAMINE_POOL = ThreadPools.newFixedThreadPool((String)"epm_examineCheck", (int)4, (String)"bgmd");
    public static final ThreadPool PROCESS_ASSIGN_POOL = ThreadPools.newFixedThreadPool((String)"epm_report_process_assign", (int)4, (String)"bgmd");
    public static final ThreadPool PROCESS_CANCEL_POOL = ThreadPools.newFixedThreadPool((String)"epm_report_process_cancel", (int)4, (String)"bgmd");
    public static final ThreadPool TASK_FLOW_POOL = ThreadPools.newFixedThreadPool((String)"epm_task_flow_pool", (int)4, (String)"bgmd");
}

