/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.tree;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.tree.ITreeNode;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class AbstractTreeNode<T>
implements ITreeNode<T> {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private ITreeNode<T> parent;
    private Set<ITreeNode<T>> children = new LinkedHashSet<ITreeNode<T>>();
    private T userData;
    private Map<String, Object> detailData = new HashMap<String, Object>();
    private Long rootid;
    private boolean isOpened = false;

    public AbstractTreeNode(Long id, String name) {
        this(id, name, null);
    }

    public AbstractTreeNode(Long id, String name, ITreeNode<T> parent) {
        this.id = id;
        this.name = name;
        this.parent = parent;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public T getData() {
        return this.userData;
    }

    public void setData(T userData) {
        this.userData = userData;
    }

    public Map<String, Object> getDetailData() {
        return this.detailData;
    }

    public void setDetailData(Map<String, Object> detailData) {
        this.detailData = detailData;
    }

    public Long getRootid() {
        return this.rootid;
    }

    public void setRootid(Long rootid) {
        this.rootid = rootid;
    }

    @Override
    public ITreeNode<T> getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ITreeNode<T> parent) {
        this.parent = parent;
    }

    @Override
    public Set<ITreeNode<T>> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(ITreeNode<T> child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public boolean removeChild(ITreeNode<T> child) {
        return this.children.removeIf(p -> child.getId().equals(p.getId()));
    }

    @Override
    public boolean isOpened() {
        return this.isOpened;
    }

    public void SetIsOpened(boolean isOpened) {
        this.isOpened = isOpened;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.getId()).append((Object)this.getName()).append(this.getData()).append(this.getChildren()).build();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).append((Object)this.getName()).append(this.getParent()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!AbstractTreeNode.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        AbstractTreeNode treeNode = (AbstractTreeNode)obj;
        return new EqualsBuilder().append((Object)this.getId(), (Object)treeNode.getId()).append((Object)this.getName(), (Object)treeNode.getName()).append(this.getParent(), treeNode.getParent()).isEquals();
    }
}

