/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.tree;

import java.io.Serializable;
import java.util.Set;
import java.util.function.Consumer;

public interface ITreeNode<T>
extends Serializable {
    public Long getId();

    public String getName();

    public T getData();

    public ITreeNode<T> getParent();

    public void setParent(ITreeNode<T> var1);

    public Set<ITreeNode<T>> getChildren();

    public void addChild(ITreeNode<T> var1);

    public boolean removeChild(ITreeNode<T> var1);

    public boolean isOpened();

    default public boolean isLeaf() {
        if (this.getChildren() == null || this.getChildren().size() == 0) {
            return true;
        }
        for (ITreeNode<T> node : this.getChildren()) {
            if (node == null) continue;
            return false;
        }
        return true;
    }

    default public void iterate(int maxLevel, Consumer<ITreeNode<T>> callback) {
        callback.accept(this);
        if (maxLevel > 0 && this.getChildren() != null) {
            for (ITreeNode<ITreeNode<ITreeNode>> iTreeNode : this.getChildren()) {
                iTreeNode.iterate(maxLevel - 1, callback);
            }
        }
    }
}

