/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.tree.AbstractTreeNode;
import kd.epm.eb.common.tree.ITreeNode;
import kd.epm.eb.common.utils.ObjectSerialUtil;

public class TreeModel<E extends ITreeNode<?>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CACHE_KEY = "key_treemodel";
    private E root;
    private Map<Long, ITreeNode<?>> dict = new HashMap();
    private boolean isBuiltDict = false;
    private TreeNode treenode = null;

    public TreeNode getTreenode() {
        return this.treenode;
    }

    public TreeModel(E root) {
        Objects.requireNonNull(root);
        this.root = root;
    }

    public E getRoot() {
        return this.root;
    }

    public void setRoot(E root) {
        this.root = root;
    }

    public boolean isBuiltDict() {
        return this.isBuiltDict;
    }

    public E searchByNodeId(Long nodeId) {
        if (!this.isBuiltDict) {
            this.buildNodeDictionary();
        }
        return (E)this.dict.get(nodeId);
    }

    protected void buildNodeDictionary() {
        this.cycleIterateNode((ITreeNode<?>)this.root);
        this.isBuiltDict = true;
    }

    private void cycleIterateNode(ITreeNode<?> node) {
        if (node != null) {
            this.dict.put(node.getId(), node);
            for (ITreeNode<?> n : node.getChildren()) {
                this.cycleIterateNode(n);
            }
        }
    }

    public E seekChildIf(Long pNodeId, Predicate<E> p) {
        E node = this.searchByNodeId(pNodeId);
        this.checkNode((ITreeNode<?>)node, pNodeId);
        Recorder<Object> r = new Recorder<Object>(null);
        this.cycleSeekNode((ITreeNode<?>)node, p, (Recorder<ITreeNode<?>>)r);
        return (E)((ITreeNode)((Recorder)r).record);
    }

    private boolean cycleSeekNode(ITreeNode<?> node, Predicate<E> p, Recorder<ITreeNode<?>> r) {
        return node.getChildren().stream().anyMatch(t -> {
            if (p.test(t)) {
                ((Recorder)r).record = t;
                return true;
            }
            return this.cycleSeekNode((ITreeNode<?>)t, p, r);
        });
    }

    public List<Long> seekChildrenByGivenNodeIds(Long pNodeId, boolean isIncludeSelf) {
        ArrayList<Long> children = new ArrayList<Long>();
        E pnode = this.searchByNodeId(pNodeId);
        this.checkNode((ITreeNode<?>)pnode, pNodeId);
        if (isIncludeSelf) {
            children.add(pnode.getId());
        }
        this.cycleNode((ITreeNode<?>)pnode, c -> children.add(c.getId()));
        return children;
    }

    public List<E> seekChildrenByGivenNode(Long pNodeId, boolean isIncludeSelf) {
        ArrayList children = new ArrayList();
        E pnode = this.searchByNodeId(pNodeId);
        this.checkNode((ITreeNode<?>)pnode, pNodeId);
        if (isIncludeSelf) {
            children.add(pnode);
        }
        this.cycleNode((ITreeNode<?>)pnode, c -> children.add(c));
        return children;
    }

    private void cycleNode(ITreeNode<?> pNode, Consumer<ITreeNode<?>> cs) {
        pNode.getChildren().forEach(c -> {
            cs.accept((ITreeNode<?>)c);
            this.cycleNode((ITreeNode<?>)c, cs);
        });
    }

    private void checkNode(ITreeNode<?> node, Long nodeId) {
        if (node == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8282\u70b9ID\u201c%1\u201d\u5728\u6811\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"TreeModel_0", (String)"epm-eb-common", (Object[])new Object[]{nodeId}));
        }
    }

    public TreeNode buildEntryTree(TreeView tree) {
        if (!this.isBuiltDict) {
            this.buildNodeDictionary();
        }
        tree.deleteAllNodes();
        TreeNode troot = new TreeNode();
        if (this.root != null) {
            this.cloneTreeNode(true, troot, (ITreeNode<?>)this.root);
            this.treenode = troot;
        }
        tree.addNode(troot);
        return troot;
    }

    private void cloneTreeNode(boolean isRoot, TreeNode parentNode, ITreeNode<?> currNode) {
        TreeNode pNode = parentNode;
        if (isRoot) {
            parentNode.setId(String.valueOf(currNode.getId()));
            parentNode.setText(currNode.getName());
            parentNode.setIsOpened(currNode.isOpened());
            if (!currNode.isLeaf()) {
                parentNode.setChildren(new ArrayList());
            }
        } else {
            TreeNode child = new TreeNode(parentNode.getId(), String.valueOf(currNode.getId()), currNode.getName(), !currNode.isLeaf());
            child.setIsOpened(currNode.isOpened());
            child.setData(currNode.getData());
            parentNode.addChild(child);
            pNode = child;
        }
        for (ITreeNode<?> c : currNode.getChildren()) {
            if (c == null) continue;
            this.cloneTreeNode(false, pNode, c);
        }
    }

    public void cache2page(IPageCache cache) {
        cache.put(CACHE_KEY, ObjectSerialUtil.toByteSerialized(this));
    }

    public void ache2page(IPageCache cache, String pagecachekey) {
        cache.put(pagecachekey, ObjectSerialUtil.toByteSerialized(this));
    }

    public static TreeModel<?> toTreeModel(IPageCache cache, String pagecachekey) {
        String serial = cache.get(pagecachekey);
        if (StringUtils.isNotEmpty((String)serial)) {
            return (TreeModel)ObjectSerialUtil.deSerializedBytes(serial);
        }
        return null;
    }

    public static TreeModel<?> toTreeModel(IPageCache cache) {
        String serial = cache.get(CACHE_KEY);
        if (StringUtils.isNotEmpty((String)serial)) {
            return (TreeModel)ObjectSerialUtil.deSerializedBytes(serial);
        }
        return null;
    }

    public static AbstractTreeNode<Object> QueryTreeNodeById(AbstractTreeNode<Object> root, Long selectedNodeId) {
        AbstractTreeNode<Object> theNode = null;
        if (root.getId().equals(selectedNodeId)) {
            theNode = root;
        } else {
            Set<ITreeNode<Object>> children = root.getChildren();
            for (ITreeNode<Object> node : children) {
                if (node.getId().equals(selectedNodeId)) {
                    theNode = (AbstractTreeNode<Object>)node;
                    break;
                }
                theNode = TreeModel.QueryTreeNodeById((AbstractTreeNode)node, selectedNodeId);
            }
        }
        return theNode;
    }

    public Map<Long, ITreeNode<?>> getDict() {
        return this.dict;
    }

    private static class Recorder<T> {
        private T record;

        public Recorder(T r) {
            this.record = r;
        }
    }
}

