/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.tree.integrationcate;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.tree.AbstractTreeNode;
import kd.epm.eb.common.tree.integrationcate.IntegrationCateTree;
import kd.epm.eb.common.utils.UserUtils;

public class IntegrationCateTreeBuild {
    public static IntegrationCateTree getIntegrationCateTree(Long modelId) {
        String selectFields = "id,name,number,parent,sequence";
        QFilter fModelId = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fModelId};
        String orderBys = "sequence";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_rpa_integration_cate", (String)selectFields, (QFilter[])filters, (String)orderBys);
        IntegrationCateTree tree = IntegrationCateTreeBuild.getCommonTree((List<DynamicObject>)dys);
        if (tree == null) {
            tree = IntegrationCateTreeBuild.createRootRpaIntegrationCate(modelId);
        }
        return tree;
    }

    public static IntegrationCateTree getCommonTree(List<DynamicObject> dys) {
        if (dys == null || dys.size() == 0) {
            return null;
        }
        HashMap<Long, Set<AbstractTreeNode>> allNodes = new HashMap<Long, Set<AbstractTreeNode>>(16);
        for (DynamicObject dy : dys) {
            Long parentid = dy.getLong("parent");
            LinkedHashSet<IntegrationCateTree> childs = (LinkedHashSet<IntegrationCateTree>)allNodes.get(parentid);
            if (childs == null) {
                childs = new LinkedHashSet<IntegrationCateTree>();
                allNodes.put(parentid, childs);
            }
            IntegrationCateTree child = new IntegrationCateTree((Long)dy.getLong("id"), dy.getString("name"), dy.getString("number"));
            DataEntityPropertyCollection dyProperties = dy.getDynamicObjectType().getProperties();
            if (dyProperties.containsKey((Object)"sequence")) {
                child.setSeq(dy.getInt("sequence"));
            }
            childs.add(child);
        }
        IntegrationCateTree result = IntegrationCateTreeBuild.getIntegrationCateTree(allNodes);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntegrationCateTree createRootRpaIntegrationCate(Long modelId) {
        DLock dLock = DLock.create((String)("bgmd/rpaIntegration/model/create/" + modelId));
        dLock.fastMode();
        boolean lockFlag = dLock.tryLock(5000L);
        if (!lockFlag) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u7684\u65b9\u6848\u5206\u7c7b\u6839\u76ee\u5f55\u6b63\u5728\u521b\u5efa\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5\u3002", (String)"IntegrationCateTreeBuild_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        try {
            String rootName = ResManager.loadKDString((String)"\u65b9\u6848\u5206\u7c7b", (String)"IntegrationCateTreeBuild_0", (String)"epm-eb-common", (Object[])new Object[0]);
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and(new QFilter("number", "=", (Object)"root"));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_rpa_integration_cate", (String)"id", (QFilter[])qFilter.toArray());
            if (dynamicObject != null) {
                IntegrationCateTree root = new IntegrationCateTree((Long)dynamicObject.getLong("id"), rootName, "root");
                root.SetIsOpened(true);
                IntegrationCateTree integrationCateTree = root;
                return integrationCateTree;
            }
            Date nowDate = TimeServiceHelper.now();
            DynamicObject rootDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_rpa_integration_cate");
            rootDy.set("model", (Object)modelId);
            rootDy.set("parent", (Object)0);
            rootDy.set("sequence", (Object)0);
            rootDy.set("creator", (Object)UserUtils.getUserId());
            rootDy.set("createtime", (Object)nowDate);
            rootDy.set("number", (Object)"root");
            rootDy.set("name", (Object)rootName);
            DynamicObject[] rootDys = new DynamicObject[]{rootDy};
            SaveServiceHelper.save((DynamicObject[])rootDys);
            IntegrationCateTree root = new IntegrationCateTree((Long)rootDy.getLong("id"), rootName, "root");
            root.SetIsOpened(true);
            IntegrationCateTree integrationCateTree = root;
            return integrationCateTree;
        }
        finally {
            dLock.unlock();
        }
    }

    private static IntegrationCateTree getIntegrationCateTree(Map<Long, Set<AbstractTreeNode>> allnodes) {
        IntegrationCateTree root_root = new IntegrationCateTree((Long)0L, null, null);
        IntegrationCateTreeBuild.circleTransDynaToTreeNode(root_root, allnodes);
        if (root_root.getChildren() == null || root_root.getChildren().size() == 0) {
            return null;
        }
        return (IntegrationCateTree)root_root.getChildren().iterator().next();
    }

    private static void circleTransDynaToTreeNode(AbstractTreeNode parent, Map<Long, Set<AbstractTreeNode>> allNodes) {
        Long id = parent.getId();
        Set<AbstractTreeNode> children = allNodes.get(id);
        if (children != null && children.size() > 0) {
            for (AbstractTreeNode child : children) {
                child.setParent(parent);
                parent.addChild(child);
                parent.SetIsOpened(true);
                IntegrationCateTreeBuild.circleTransDynaToTreeNode(child, allNodes);
            }
        }
    }
}

