/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.tree.model;

import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.enums.OrgFromEnum;
import kd.epm.eb.common.lazytree.ITreeNode;

public class AuthorOrgTreeNode
implements ITreeNode {
    private static final long serialVersionUID = -6336402783555855527L;
    private Long id;
    private String name;
    private AuthorOrgTreeNode parent;
    private List<ITreeNode> children = new ArrayList<ITreeNode>(16);
    private String number;
    private Boolean hasRight = false;
    private Boolean havechanged = false;
    private Boolean ebControl = false;
    private Boolean showEbBalance = false;
    private String longNumber;
    private OrgFromEnum from = OrgFromEnum.ADMINISTRATION;
    private AuthorOrgTreeNode newValue = null;
    private Boolean isleaf = false;

    public AuthorOrgTreeNode(Long id) {
        this(id, null, null, null);
    }

    public AuthorOrgTreeNode(Long id, String name, String number) {
        this(id, name, number, null);
    }

    public AuthorOrgTreeNode(Long id, String name, String number, AuthorOrgTreeNode parent) {
        this.id = id;
        this.name = name;
        this.number = number;
        this.parent = parent;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public long getParentId() {
        if (this.parent == null) {
            return 0L;
        }
        return this.parent.getId();
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AuthorOrgTreeNode getParent() {
        return this.parent;
    }

    public void setParent(AuthorOrgTreeNode parent) {
        this.parent = parent;
    }

    public List<ITreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<ITreeNode> children) {
        this.children = children;
    }

    public AuthorOrgTreeNode getNewValue() {
        return this.newValue;
    }

    public void setNewValue(AuthorOrgTreeNode newValue) {
        this.newValue = newValue;
    }

    @Override
    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public Boolean getIsleaf() {
        return this.isleaf;
    }

    public void setIsleaf(Boolean isleaf) {
        this.isleaf = isleaf;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setHasRight(Boolean hasRight) {
        this.hasRight = hasRight;
    }

    public void setHavechanged(Boolean havechanged) {
        this.havechanged = havechanged;
    }

    public void setFrom(OrgFromEnum from) {
        this.from = from;
    }

    public void setNewvalue(AuthorOrgTreeNode newvalue) {
        this.newValue = newvalue;
        if (this.getNumber().equals(newvalue.getNumber()) && this.getEbControl().equals(newvalue.getEbControl()) && this.getShowEbBalance().equals(newvalue.getShowEbBalance())) {
            this.setHavechanged(false);
        } else {
            this.setHavechanged(true);
        }
    }

    public String getNumber() {
        return this.number;
    }

    public Boolean getHasRight() {
        return this.hasRight;
    }

    public Boolean getHavechanged() {
        return this.havechanged;
    }

    public OrgFromEnum getFrom() {
        return this.from;
    }

    public AuthorOrgTreeNode getLastestValue() {
        if (this.newValue != null) {
            return this.newValue;
        }
        return this;
    }

    public Boolean getEbControl() {
        return this.ebControl;
    }

    public void setEbControl(Boolean ebControl) {
        this.ebControl = ebControl;
    }

    public Boolean getShowEbBalance() {
        return this.showEbBalance;
    }

    public void setShowEbBalance(Boolean showEbBalance) {
        this.showEbBalance = showEbBalance;
    }

    public String getLongNumber() {
        return this.longNumber;
    }

    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public String toString() {
        return super.toString();
    }

    public void addChild(AuthorOrgTreeNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    public boolean removeChild(ITreeNode child) {
        return this.children.removeIf(p -> child.getId().equals(p.getId()));
    }
}

