/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.tree.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.tree.model.AuthorOrgTreeNode;
import kd.epm.eb.common.utils.UserUtils;

public class AuthorOrgTreeNodeBuilder {
    private static final String systemSeparator = "!";

    public static AuthorOrgTreeNode getAuthorOrgTreeNodeexcutebrance(AuthorOrgTreeNode root, IFormView view, String entityNum, List<String> permItems, DynamicObjectCollection authorOrg) {
        Map<Long, Long> rightids = AuthorOrgTreeNodeBuilder.getRightOrgMap(view, entityNum, permItems);
        if ((root = AuthorOrgTreeNodeBuilder.transDynaToTreeNode(authorOrg, root, rightids)) == null) {
            return null;
        }
        return root;
    }

    public static AuthorOrgTreeNode getAuthorOrgTreeNode(AuthorOrgTreeNode root, Map<Long, Long> rightids, Long orgid) {
        DynamicObjectCollection authorOrg = AuthorOrgTreeNodeBuilder.getAuthorOrgDyna(orgid);
        root = AuthorOrgTreeNodeBuilder.transDynaToTreeNode(authorOrg, root, rightids);
        if (root == null) {
            return null;
        }
        HashSet<AuthorOrgTreeNode> leafnodes = new HashSet<AuthorOrgTreeNode>();
        AuthorOrgTreeNodeBuilder.getLeafNodes(root, leafnodes);
        AuthorOrgTreeNodeBuilder.checkAuthorOrgWithRight(leafnodes);
        return root;
    }

    public static Map<Long, Long> getRightOrgMap(IFormView view, String entityNum, List<String> permItems) {
        String appId = AppMetadataCache.getAppInfo((String)view.getFormShowParameter().getAppId()).getId();
        HashMap<Long, Long> rightids = new HashMap<Long, Long>();
        for (String permItemId : permItems) {
            List ids = PermissionServiceHelper.getAllPermissionOrgs((Long)UserUtils.getUserId(), (String)appId, (String)entityNum, (String)permItemId);
            for (Long idd : ids) {
                rightids.put(idd, idd);
            }
        }
        return rightids;
    }

    private static DynamicObjectCollection getAuthorOrgDyna(Long orgid) {
        String selectFields = "org.id as id,org.number as number,org.name as name,parent,longnumber,isleaf";
        if (orgid != 0L) {
            QFilter orgidqfilter = new QFilter("org.id", "=", (Object)orgid);
            DynamicObject orgdyn = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{orgidqfilter});
            if (orgdyn == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u767b\u5f55\u7ec4\u7ec7\u5df2\u7ecf\u4e0d\u5b58\u5728\u3002", (String)"AuthorOrgTreeNodeBuilder_0", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            QFilter longnumberqfilter = new QFilter("longnumber", "like", (Object)(orgdyn.getString("longnumber") + systemSeparator + "%"));
            QFilter viewqfilter = new QFilter("view", "=", (Object)Integer.valueOf("1"));
            DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{longnumberqfilter, viewqfilter});
            dynamicObject.add((Object)orgdyn);
            return dynamicObject;
        }
        QFilter viewqfilter = new QFilter("view", "=", (Object)Integer.valueOf("01")).and("org.enable", "=", (Object)Integer.valueOf("1"));
        DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{viewqfilter});
        return dynamicObject;
    }

    public static DynamicObjectCollection getAuthorOrgDynaexcute() {
        String selectFields = "org.id as id,org.number as number,org.name as name,parent,longnumber,isleaf";
        QFilter viewqfilter = new QFilter("view", "=", (Object)Long.parseLong(OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType())).and("org.enable", "=", (Object)"1").and("isfreeze", "!=", (Object)"1");
        DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{viewqfilter}, (String)"longnumber");
        return dynamicObject;
    }

    private static AuthorOrgTreeNode transDynaToTreeNode(DynamicObjectCollection authorOrg, AuthorOrgTreeNode parent, Map<Long, Long> rightOrgids) {
        HashMap<Long, Set<AuthorOrgTreeNode>> allnodes = new HashMap<Long, Set<AuthorOrgTreeNode>>();
        for (DynamicObject obj : authorOrg) {
            Long parentid = obj.getLong("parent");
            Set childs = allnodes.computeIfAbsent(parentid, k -> new LinkedHashSet());
            AuthorOrgTreeNode child = new AuthorOrgTreeNode(obj.getLong("id"), obj.getString("name"), obj.getString("number"));
            child.setLongNumber(obj.getString("longnumber"));
            child.setIsleaf(obj.getBoolean("isleaf"));
            if (child.getId().equals(parentid)) continue;
            childs.add(child);
        }
        AuthorOrgTreeNodeBuilder.crcyleTransDynaToTreeNode(parent, rightOrgids, allnodes);
        if (parent.getChildren() == null || parent.getChildren().size() == 0) {
            return null;
        }
        return (AuthorOrgTreeNode)parent.getChildren().get(0);
    }

    private static void crcyleTransDynaToTreeNode(AuthorOrgTreeNode parent, Map<Long, Long> rightOrgids, Map<Long, Set<AuthorOrgTreeNode>> allnodes) {
        Long id = parent.getId();
        Set<AuthorOrgTreeNode> childs = allnodes.get(id);
        if (childs != null && childs.size() > 0) {
            for (AuthorOrgTreeNode child : childs) {
                child.setParent(parent);
                if (rightOrgids.get(child.getId()) != null) {
                    child.setHasRight(true);
                }
                if (rightOrgids.get(parent.getId()) != null) {
                    parent.setHasRight(true);
                }
                parent.addChild(child);
                AuthorOrgTreeNodeBuilder.crcyleTransDynaToTreeNode(child, rightOrgids, allnodes);
            }
        }
    }

    public static List<DynamicObject> getMinDynamicObject(DynamicObjectCollection dynamicObjects, List<DynamicObject> list1) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        block0: for (DynamicObject dcs : dynamicObjects) {
            if (list.size() == 0) {
                list.add(dcs);
                continue;
            }
            for (int i = 0; i < list.size(); ++i) {
                if (((DynamicObject)list.get(i)).getInt("level") > dcs.getInt("level")) {
                    list.remove(i);
                    list.add(dcs);
                    continue;
                }
                if (((DynamicObject)list.get(i)).getInt("level") != dcs.getInt("level")) continue;
                list.add(dcs);
                continue block0;
            }
        }
        for (DynamicObject dcs : list) {
            String longnumber = dcs.getString("longnumber");
            list1.add(dcs);
            dynamicObjects.removeIf(dcs1 -> dcs1.getString("longnumber").startsWith(longnumber));
            if (dynamicObjects.size() != 0) continue;
            AuthorOrgTreeNodeBuilder.getMinDynamicObject(dynamicObjects, list1);
        }
        return list1;
    }

    private static void getLeafNodes(AuthorOrgTreeNode root, Set<AuthorOrgTreeNode> leafnodes) {
        if (root.isLeaf() && !root.getHasRight().booleanValue()) {
            leafnodes.add(root);
        } else {
            for (ITreeNode node : root.getChildren()) {
                AuthorOrgTreeNodeBuilder.getLeafNodes((AuthorOrgTreeNode)node, leafnodes);
            }
        }
    }

    private static void checkAuthorOrgWithRight(Set<AuthorOrgTreeNode> leafnodes) {
        for (AuthorOrgTreeNode node : leafnodes) {
            node.getParent().removeChild(node);
            AuthorOrgTreeNodeBuilder.checkParentRight(node.getParent());
        }
    }

    private static void checkParentRight(AuthorOrgTreeNode parent) {
        if (parent == null) {
            return;
        }
        if (!parent.getHasRight().booleanValue() && parent.isLeaf()) {
            AuthorOrgTreeNode parent_parent = parent.getParent();
            if (parent_parent != null) {
                parent_parent.removeChild(parent);
            }
            AuthorOrgTreeNodeBuilder.checkParentRight(parent_parent);
        }
    }
}

