/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.tree.model;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.tree.model.DataPermTreeNode;

public class PermDataNodeTreeBuilder {
    public static DataPermTreeNode buildTree(Long modelId, Long dimId, String entryKey, String ... customDataProps) {
        SysDimensionEnum dimensionEnum;
        String tableName = null;
        tableName = entryKey.equals(SysDimensionEnum.Version.getMemberTreemodel()) ? "T_BCM_StructOfVersion" : ((dimensionEnum = SysDimensionEnum.getEnumByBcmTreeNumber(entryKey)) == null ? SysDimensionEnum.Project.getBcmMemberTreetable() : dimensionEnum.getBcmMemberTreetable());
        String sql = "select fid,fnumber,fparentid from " + tableName + " where fmodelid = " + modelId + " and fdimensionid = " + dimId + " and fstoragetype != '3'";
        if (entryKey.equals(SysDimensionEnum.Entity.getMemberTreemodel())) {
            sql = sql + "and fisexchangerate = 0";
        }
        HashMap<Long, DataPermTreeNode> nodeMap = new HashMap<Long, DataPermTreeNode>();
        DataPermTreeNode rootNode = PermDataNodeTreeBuilder.toNodeMap(sql, "bcm", nodeMap);
        PermDataNodeTreeBuilder.toTree(false, rootNode, nodeMap);
        return rootNode;
    }

    private static DataPermTreeNode toNodeMap(String sql, String routeKey, Map<Long, DataPermTreeNode> nodeMap) {
        DataPermTreeNode rootNode = null;
        try (DataSet dataSet = DB.queryDataSet((String)"getDimMembs", (DBRoute)new DBRoute(routeKey), (String)sql);){
            DataPermTreeNode node = null;
            for (Row dy : dataSet) {
                HashMap<String, Object> customData = new HashMap<String, Object>(2);
                String number = dy.getString("fnumber");
                Long id = dy.getLong("fid");
                node = new DataPermTreeNode(id, "");
                node.setNumber(number);
                customData.put("pid", dy.getLong("fparentid"));
                if (rootNode == null && customData.get("pid").equals(0L)) {
                    rootNode = node;
                }
                node.setDetailData(customData);
                nodeMap.put(id, node);
            }
        }
        return rootNode;
    }

    public static DataPermTreeNode buildTreeNew(Long modelId, String dimNum, Long dimId, Long viewId) {
        SysDimensionEnum sysDimensionEnum;
        String tableName = viewId != null && !viewId.equals(0L) ? "t_eb_viewmember" : ((sysDimensionEnum = SysDimensionEnum.getEnumByNumber(dimNum)) == null ? SysDimensionEnum.Project.getMemberTreetable() : SysDimensionEnum.getEnumByNumber(dimNum).getMemberTreetable());
        String sql = "select fid,fnumber,fparentid from " + tableName + " where fmodelid = " + modelId + " and fdimensionid = " + dimId;
        HashMap<Long, DataPermTreeNode> nodeMap = new HashMap<Long, DataPermTreeNode>();
        DataPermTreeNode rootNode = PermDataNodeTreeBuilder.toNodeMap(sql, "EPM", nodeMap);
        PermDataNodeTreeBuilder.toTree(false, rootNode, nodeMap);
        return rootNode;
    }

    public static DataPermTreeNode buildTree(List<Member> members, Set<String> shareMembNums, boolean needBreakNode, boolean showShareNode, boolean needLongNum, String ... customProp) {
        HashMap nodeMap = Maps.newHashMapWithExpectedSize((int)members.size());
        DataPermTreeNode node = null;
        DataPermTreeNode rootNode = null;
        boolean isShareNode = false;
        for (Member member : members) {
            node = new DataPermTreeNode(member.getId(), member.getName(), member.getNumber());
            isShareNode = StorageTypeEnum.SHARE.getOIndex().equals(member.getStorageType());
            if (isShareNode) {
                if (!showShareNode) continue;
                if (shareMembNums != null) {
                    shareMembNums.add(member.getNumber());
                }
                node.setName(ResManager.loadResFormat((String)"%1(\u5171\u4eab)", (String)"PermDataNodeTreeBuilder_0", (String)"epm-eb-common", (Object[])new Object[]{node.getName()}));
                node.setShareNode(true);
            }
            HashMap<String, Object> customData = new HashMap<String, Object>(2);
            Long creator = member.getCreator();
            if (creator == null) {
                creator = 0L;
            }
            customData.put("creator", creator);
            customData.put("pid", member.getParentId());
            node.setDseq(member.getSeq());
            if (needLongNum) {
                customData.put("longNumber", member.getLongNumber());
            }
            if (rootNode == null && member.getParentId().equals(0L)) {
                rootNode = node;
            }
            node.setDetailData(customData);
            nodeMap.put(member.getId(), node);
        }
        PermDataNodeTreeBuilder.toTree(needBreakNode, rootNode, nodeMap);
        return rootNode;
    }

    private static void toTree(boolean needBreakNode, DataPermTreeNode rootNode, Map<Long, DataPermTreeNode> nodeMap) {
        if (rootNode != null) {
            for (DataPermTreeNode childNode : nodeMap.values()) {
                Object pId = childNode.getDetailData().get("pid");
                if (pId == null || pId.equals(0L)) continue;
                DataPermTreeNode pNode = nodeMap.get(pId);
                if (pNode != null) {
                    pNode.addChild(childNode);
                    continue;
                }
                if (!needBreakNode) continue;
                rootNode.addChild(childNode);
            }
        }
    }

    public static DataPermTreeNode getChildNodeByNodeId(Long nodeId, DataPermTreeNode root) {
        DataPermTreeNode node;
        block2: {
            DataPermTreeNode childNode;
            block1: {
                node = null;
                if (!nodeId.equals(root.getId())) break block1;
                node = root;
                break block2;
            }
            if (root.getChildren() == null) break block2;
            Iterator<DataPermTreeNode> iterator = root.getChildren().iterator();
            while (iterator.hasNext() && (node = PermDataNodeTreeBuilder.getChildNodeByNodeId(nodeId, childNode = iterator.next())) == null) {
            }
        }
        return node;
    }
}

