/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.tree.templatecatalog;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class CustomTreeNode {
    private String number;
    private String longnumber;
    private int seq;
    private String label;
    private boolean show = false;
    private String category;
    private String id;
    private String parentId;
    private List<CustomTreeNode> children = new ArrayList<CustomTreeNode>(16);
    Map<String, Object> data;
    private String name;

    public CustomTreeNode(String id, String name, String number) {
        this.id = id;
        this.name = name;
        this.number = number;
        this.label = name;
    }

    public CustomTreeNode(String number, String longnumber, int seq, boolean show, String category, String id, String parentId, List<CustomTreeNode> children, String name, Map<String, Object> data) {
        this.number = number;
        this.longnumber = longnumber;
        this.seq = seq;
        this.label = name;
        this.show = show;
        this.category = category;
        this.id = id;
        this.parentId = parentId;
        this.children = children;
        this.name = name;
        this.data = data;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getLongnumber() {
        return this.longnumber;
    }

    public void setLongnumber(String longnumber) {
        this.longnumber = longnumber;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public List<CustomTreeNode> getChildren() {
        return this.children;
    }

    public void addChild(CustomTreeNode child) {
        this.children.add(child);
        child.setParentId(this.id);
    }

    public void setChildren(List<CustomTreeNode> children) {
        this.children = children;
    }

    public boolean removeChild(CustomTreeNode child) {
        return this.children.removeIf(p -> child.getId().equals(p.getId()));
    }

    public Set<Long> getChildId(boolean includeSelf) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (includeSelf) {
            result.add(IDUtils.toLong(this.getId()));
        }
        this.cycleNode(result, this.getChildren());
        return result;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    private void cycleNode(Set<Long> result, List<CustomTreeNode> children) {
        if (CollectionUtils.isNotEmpty(children)) {
            for (CustomTreeNode child : children) {
                result.add(IDUtils.toLong(child.getId()));
                this.cycleNode(result, child.getChildren());
            }
        }
    }

    public CustomTreeNode getTreeNode(String id, int maxLevel) {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getId(), (CharSequence)id)) {
            return this;
        }
        if (maxLevel > 0 && this.getChildren() != null) {
            for (CustomTreeNode child : this.getChildren()) {
                CustomTreeNode node = child.getTreeNode(id, maxLevel - 1);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }
}

