/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.tree.templatecatalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.tree.templatecatalog.CustomTreeNode;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.jetbrains.annotations.NotNull;

public class ReportCustomTreeBuilder {
    public static final String EB_CREATE_PUBLICK_CATEGORY = "eb_create_pubcategory";

    public static CustomTreeNode getCustomTreeNode(Long model, Long userId) {
        CustomTreeNode tree;
        block35: {
            CustomTreeNode initPrivateNode;
            Optional<DynamicObject> privateNode;
            TXHandle tx;
            Throwable dynamicObject;
            Optional<DynamicObject> rootNumber;
            Optional<DynamicObject> publicNode;
            if (IDUtils.isNull(model)) {
                return null;
            }
            DynamicObjectCollection dys = ReportCustomTreeBuilder.getCategory(model, userId);
            if (CollectionUtils.isNotEmpty(dys) && !(publicNode = dys.stream().filter(x -> x.getString("longnumber").equals("root.02_sys")).findFirst()).isPresent() && (rootNumber = dys.stream().filter(x -> x.getString("longnumber").equals("root")).findFirst()).isPresent()) {
                dynamicObject = rootNumber.get();
                LocaleString rootPublicName = ResManager.getLocaleString((String)"\u5168\u90e8\u5206\u7c7b.\u5171\u4eab", (String)"ReportCustomTreeBuilder_7", (String)"epm-eb-common");
                LocaleString publicName = ResManager.getLocaleString((String)"\u5171\u4eab", (String)"ReportCustomTreeBuilder_2", (String)"epm-eb-common");
                ReportCustomTreeBuilder.createPublicNode(model, userId, (ILocaleString)rootPublicName, (ILocaleString)publicName, TimeServiceHelper.now(), (DynamicObject)dynamicObject, "1", "02_sys");
                dys = ReportCustomTreeBuilder.getCategory(model, userId);
            }
            if ((tree = ReportCustomTreeBuilder.getCommomTree((List<DynamicObject>)dys, Boolean.FALSE)) == null && CollectionUtils.isEmpty(dys)) {
                tx = TX.required((String)"createRootCategory");
                dynamicObject = null;
                try {
                    try {
                        tree = ReportCustomTreeBuilder.createRootReportCataLogTree(model, userId, Boolean.TRUE);
                        break block35;
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw new KDBizException(ResManager.loadResFormat((String)"\u521b\u5efa\u5206\u7c7b\u76ee\u5f55\u5931\u8d25", (String)"ReportCustomTreeBuilder_5", (String)"epm-eb-common", (Object[])new Object[]{e.getMessage()}));
                    }
                }
                catch (Throwable e) {
                    dynamicObject = e;
                    throw e;
                }
                finally {
                    if (tx != null) {
                        if (dynamicObject != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable e) {
                                dynamicObject.addSuppressed(e);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            if (tree == null && CollectionUtils.isNotEmpty(dys)) {
                tx = TX.required((String)"createRootCategory");
                dynamicObject = null;
                try {
                    try {
                        ReportCustomTreeBuilder.createRootReportCataLogTree(model, userId, Boolean.FALSE);
                        dys = ReportCustomTreeBuilder.getCategory(model, userId);
                        tree = ReportCustomTreeBuilder.getCommomTree((List<DynamicObject>)dys, Boolean.FALSE);
                        break block35;
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw new KDBizException(ResManager.loadResFormat((String)"\u521b\u5efa\u5206\u7c7b\u76ee\u5f55\u5931\u8d25", (String)"ReportCustomTreeBuilder_5", (String)"epm-eb-common", (Object[])new Object[]{e.getMessage()}));
                    }
                }
                catch (Throwable e) {
                    dynamicObject = e;
                    throw e;
                }
                finally {
                    if (tx != null) {
                        if (dynamicObject != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable e) {
                                dynamicObject.addSuppressed(e);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            if (tree != null && (privateNode = dys.stream().filter(x -> x.getString("number").equals("01_sys") && x.getString("longnumber").equals("root.01_sys")).findFirst()).isPresent() && (initPrivateNode = tree.getTreeNode((dynamicObject = privateNode.get()).getString("id"), 10)) != null && CollectionUtils.isNotEmpty(initPrivateNode.getChildren())) {
                HashMap<Long, String> map = new HashMap<Long, String>(16);
                ReportCustomTreeBuilder.updatePrivateLoneNumber(initPrivateNode, map);
                if (map.size() > 0) {
                    String updateSql = "update t_eb_reportcatalog  set flongnumber  = ? where fid  = ? ";
                    ArrayList<Object[]> params = new ArrayList<Object[]>(16);
                    for (Map.Entry ent : map.entrySet()) {
                        Long fid = (Long)ent.getKey();
                        String longNumber = (String)ent.getValue();
                        Object[] param = new Object[]{longNumber, fid};
                        params.add(param);
                    }
                    DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, params);
                    CacheServiceHelper.clearEntityCache("eb_reportcatalog");
                }
            }
        }
        return tree;
    }

    private static void updatePrivateLoneNumber(CustomTreeNode initPrivateNode, Map<Long, String> map) {
        for (CustomTreeNode child : initPrivateNode.getChildren()) {
            if (!StringUtils.isNotEmpty(child.getLongnumber()) || child.getLongnumber().equals(initPrivateNode.getLongnumber() + "." + child.getNumber())) continue;
            child.setLongnumber(initPrivateNode.getLongnumber() + "." + child.getNumber());
            child.setCategory("floder");
            map.put(IDUtils.toLong(child.getId()), child.getLongnumber());
            if (!CollectionUtils.isNotEmpty(child.getChildren())) continue;
            ReportCustomTreeBuilder.updatePrivateLoneNumber(child, map);
        }
    }

    private static DynamicObjectCollection getCategory(Long model, Long userId) {
        String value = "root.02_sys%";
        String selectFields = "id,name,number,parent,sequence,longnumber";
        QFilter modleFilter = new QFilter("model", "=", (Object)model);
        QFilter userFilter = new QFilter("creator", "=", (Object)userId);
        userFilter.and(new QFilter("longnumber", "not like", (Object)value));
        QFilter publicFilter = new QFilter("longnumber", "like", (Object)value);
        modleFilter.and(userFilter.or(publicFilter));
        String orderBys = "sequence";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_reportcatalog", (String)selectFields, (QFilter[])new QFilter[]{modleFilter}, (String)orderBys);
        return dys;
    }

    public static CustomTreeNode createRootReportCataLogTree(Long modelid, Long userId, boolean needPublic) {
        LocaleString rootName = ResManager.getLocaleString((String)"\u5168\u90e8\u5206\u7c7b", (String)"ReportCustomTreeBuilder_0", (String)"epm-eb-common");
        LocaleString defName = ResManager.getLocaleString((String)"\u79c1\u6709", (String)"ReportCustomTreeBuilder_1", (String)"epm-eb-common");
        LocaleString publicName = ResManager.getLocaleString((String)"\u5171\u4eab", (String)"ReportCustomTreeBuilder_2", (String)"epm-eb-common");
        LocaleString shareName = ResManager.getLocaleString((String)"\u5206\u4eab\u7ed9\u6211\u7684", (String)"ReportCustomTreeBuilder_3", (String)"epm-eb-common");
        LocaleString rootDefName = ResManager.getLocaleString((String)"\u5168\u90e8\u5206\u7c7b.\u79c1\u6709", (String)"ReportCustomTreeBuilder_6", (String)"epm-eb-common");
        LocaleString rootPublicName = ResManager.getLocaleString((String)"\u5168\u90e8\u5206\u7c7b.\u5171\u4eab", (String)"ReportCustomTreeBuilder_7", (String)"epm-eb-common");
        LocaleString rootShareName = ResManager.getLocaleString((String)"\u5168\u90e8\u5206\u7c7b.\u5206\u4eab\u7ed9\u6211\u7684", (String)"ReportCustomTreeBuilder_8", (String)"epm-eb-common");
        Date nowDate = TimeServiceHelper.now();
        DynamicObject rootDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_reportcatalog");
        rootDy.set("model", (Object)modelid);
        rootDy.set("parent", (Object)"0");
        rootDy.set("sequence", (Object)"0");
        rootDy.set("status", (Object)"C");
        rootDy.set("enable", (Object)"1");
        rootDy.set("creator", (Object)userId);
        rootDy.set("createtime", (Object)nowDate);
        rootDy.set("number", (Object)"root");
        rootDy.set("longnumber", (Object)"root");
        rootDy.set("name", (Object)rootName);
        rootDy.set("fullname", (Object)rootName);
        rootDy.set("level", (Object)"1");
        rootDy.set("isleaf", (Object)"0");
        DynamicObject[] rootDys = new DynamicObject[]{rootDy};
        SaveServiceHelper.save((DynamicObject[])rootDys);
        CustomTreeNode root = new CustomTreeNode(rootDy.getString("id"), rootName.getLocaleValue(), "root");
        root.setLongnumber(rootDy.getString("longnumber"));
        root.setCategory("root");
        DynamicObject defDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_reportcatalog");
        defDy.set("model", (Object)modelid);
        defDy.set("parent", (Object)rootDy.getLong("id"));
        defDy.set("sequence", (Object)"0");
        defDy.set("status", (Object)"C");
        defDy.set("enable", (Object)"1");
        defDy.set("creator", (Object)userId);
        defDy.set("createtime", (Object)nowDate);
        defDy.set("number", (Object)"01_sys");
        defDy.set("longnumber", (Object)"root.01_sys");
        defDy.set("name", (Object)defName);
        defDy.set("fullname", (Object)rootDefName);
        defDy.set("level", (Object)"2");
        defDy.set("isleaf", (Object)"1");
        DynamicObject[] defDys = new DynamicObject[]{defDy};
        SaveServiceHelper.save((DynamicObject[])defDys);
        if (needPublic) {
            DynamicObject pubDy = ReportCustomTreeBuilder.createPublicNode(modelid, userId, (ILocaleString)rootPublicName, (ILocaleString)publicName, nowDate, rootDy, "1", "02_sys");
            CustomTreeNode pub = new CustomTreeNode(pubDy.getString("id"), publicName.getLocaleValue(), "02_sys");
            pub.setLongnumber(pubDy.getString("longnumber"));
            pub.setCategory("init-category");
            root.addChild(pub);
        }
        DynamicObject shareDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_reportcatalog");
        shareDy.set("model", (Object)modelid);
        shareDy.set("parent", (Object)rootDy.getLong("id"));
        shareDy.set("sequence", (Object)"2");
        shareDy.set("status", (Object)"C");
        shareDy.set("enable", (Object)"1");
        shareDy.set("creator", (Object)userId);
        shareDy.set("createtime", (Object)nowDate);
        shareDy.set("number", (Object)"share");
        shareDy.set("longnumber", (Object)"root.share");
        shareDy.set("name", (Object)shareName);
        shareDy.set("fullname", (Object)rootShareName);
        shareDy.set("level", (Object)"2");
        shareDy.set("isleaf", (Object)"1");
        DynamicObject[] shareDys = new DynamicObject[]{shareDy};
        SaveServiceHelper.save((DynamicObject[])shareDys);
        CustomTreeNode share = new CustomTreeNode(shareDy.getString("id"), shareName.getLocaleValue(), "share");
        share.setCategory("share-category");
        share.setLongnumber(shareDy.getString("longnumber"));
        CustomTreeNode def = new CustomTreeNode(defDy.getString("id"), defName.getLocaleValue(), "01_sys");
        def.setLongnumber(defDy.getString("longnumber"));
        def.setCategory("init-category");
        root.addChild(def);
        root.addChild(share);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static DynamicObject createPublicNode(Long modelid, Long userId, ILocaleString fullName, ILocaleString publicName, Date nowDate, DynamicObject rootDy, String s, String keyPublicnum) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        qFilter.and("longnumber", "=", (Object)("root." + keyPublicnum));
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"eb_reportcatalog", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (ids.length > 0) {
            return ids[0];
        }
        DLock dLock = DLock.create((String)(EB_CREATE_PUBLICK_CATEGORY + modelid));
        dLock.fastMode();
        boolean lockFlag = dLock.tryLock(5000L);
        if (!lockFlag) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u7684\u5206\u7c7b\u76ee\u5f55\u6b63\u5728\u521b\u5efa\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5\u3002", (String)"ReportCustomTreeBuilder_4", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        try {
            DynamicObject pubDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_reportcatalog");
            pubDy.set("model", (Object)modelid);
            pubDy.set("parent", (Object)rootDy.getLong("id"));
            pubDy.set("sequence", (Object)s);
            pubDy.set("status", (Object)"C");
            pubDy.set("enable", (Object)"1");
            pubDy.set("creator", (Object)userId);
            pubDy.set("createtime", (Object)nowDate);
            pubDy.set("number", (Object)keyPublicnum);
            pubDy.set("longnumber", (Object)("root." + keyPublicnum));
            pubDy.set("name", (Object)publicName);
            pubDy.set("fullname", (Object)fullName);
            pubDy.set("level", (Object)"2");
            pubDy.set("isleaf", (Object)"1");
            DynamicObject[] pubDys = new DynamicObject[]{pubDy};
            SaveServiceHelper.save((DynamicObject[])pubDys);
            DynamicObject dynamicObject = pubDy;
            return dynamicObject;
        }
        finally {
            dLock.unlock();
        }
    }

    public static CustomTreeNode getCommomTree(List<DynamicObject> dys, boolean isDimSet) {
        List<CustomTreeNode> children;
        if (dys == null || dys.size() == 0) {
            return null;
        }
        HashMap<Long, Set<CustomTreeNode>> allnodes = new HashMap<Long, Set<CustomTreeNode>>(16);
        CustomTreeNode publicNode = null;
        for (DynamicObject dy : dys) {
            Long parentid = dy.getLong("parent");
            LinkedHashSet<CustomTreeNode> childs = (LinkedHashSet<CustomTreeNode>)allnodes.get(parentid);
            if (childs == null) {
                childs = new LinkedHashSet<CustomTreeNode>();
                allnodes.put(parentid, childs);
            }
            CustomTreeNode child = new CustomTreeNode(dy.getString("id"), dy.getString("name"), dy.getString("number"));
            DataEntityPropertyCollection dyPropertys = dy.getDynamicObjectType().getProperties();
            if (dyPropertys.containsKey((Object)"longnumber")) {
                child.setLongnumber(dy.getString("longnumber"));
                if ("root.02_sys".equals(dy.getString("longnumber"))) {
                    publicNode = child;
                }
            }
            if (dyPropertys.containsKey((Object)"sequence")) {
                child.setSeq(dy.getInt("sequence"));
            }
            childs.add(child);
        }
        CustomTreeNode result = ReportCustomTreeBuilder.getTemplateCataLogTree(allnodes, isDimSet, publicNode);
        if (result != null && (children = result.getChildren()) != null && children.size() > 0) {
            children.sort((a, b) -> Integer.compare(a.getSeq(), b.getSeq()));
        }
        return result;
    }

    private static CustomTreeNode getTemplateCataLogTree(Map<Long, Set<CustomTreeNode>> allnodes, boolean isDimSet, CustomTreeNode publicNode) {
        CustomTreeNode root_root = new CustomTreeNode("0", null, null);
        HashMap<Long, Integer> needUpdateSeq = new HashMap<Long, Integer>(16);
        ReportCustomTreeBuilder.crcyleTransDynaToTreeNode(root_root, allnodes, isDimSet, publicNode, needUpdateSeq);
        if (needUpdateSeq.size() > 0) {
            String updateSql = "update t_eb_reportcatalog  set fsequence  = ? where fid  = ? ";
            ArrayList<Object[]> params = new ArrayList<Object[]>(16);
            for (Map.Entry ent : needUpdateSeq.entrySet()) {
                Long fid = (Long)ent.getKey();
                Integer seq = (Integer)ent.getValue();
                Object[] param = new Object[]{seq, fid};
                params.add(param);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, params);
            CacheServiceHelper.clearEntityCache("eb_reportcatalog");
        }
        if (root_root.getChildren() == null || root_root.getChildren().size() == 0) {
            return null;
        }
        return root_root.getChildren().get(0);
    }

    private static void crcyleTransDynaToTreeNode(CustomTreeNode parent, Map<Long, Set<CustomTreeNode>> allnodes, boolean isDimSet, CustomTreeNode publicNode, Map<Long, Integer> needUpdateSeq) {
        String id = parent.getId();
        Set<CustomTreeNode> childs = allnodes.get(IDUtils.toLong(id));
        if (childs != null && childs.size() > 0) {
            Integer n;
            Integer n2;
            if (publicNode != null && "root".equals(parent.getLongnumber())) {
                childs.add(publicNode);
            }
            Optional<List> first = childs.stream().collect(Collectors.groupingBy(CustomTreeNode::getSeq, Collectors.toList())).values().stream().filter(x -> x.size() > 1).findFirst();
            boolean isNeedUpdateSeq = false;
            Integer index = 0;
            if (first.isPresent()) {
                isNeedUpdateSeq = true;
                for (CustomTreeNode child : childs) {
                    needUpdateSeq.put(IDUtils.toLong(child.getId()), index);
                    n2 = index;
                    n = index = Integer.valueOf(index + 1);
                }
            }
            index = 0;
            for (CustomTreeNode child : childs) {
                if ("root".equals(child.getLongnumber())) {
                    child.setCategory("root");
                } else if ("root.01_sys".equals(child.getLongnumber())) {
                    child.setCategory("init-category");
                } else if ("root.share".equals(child.getLongnumber())) {
                    child.setCategory("share-category");
                } else if ("root.02_sys".equals(child.getLongnumber())) {
                    child.setCategory("init-category");
                } else {
                    child.setCategory(isDimSet ? "dim-category-floder" : "floder");
                }
                child.setParentId(parent.getId());
                parent.addChild(child);
                if (isNeedUpdateSeq) {
                    child.setSeq(index);
                    n2 = index;
                    n = index = Integer.valueOf(index + 1);
                }
                ReportCustomTreeBuilder.crcyleTransDynaToTreeNode(child, allnodes, isDimSet, publicNode, needUpdateSeq);
            }
        }
    }

    public static boolean isShareNode(String longNumer) {
        if (StringUtils.isEmpty(longNumer)) {
            return false;
        }
        return longNumer.startsWith("root.share");
    }

    public static CustomTreeNode addRptNodes(CustomTreeNode customTreeNode, Long userId, Long modelid, Set<String> startReport) {
        ArrayList<Object[]> params;
        String updateSql;
        CustomTreeNode result = customTreeNode;
        if (customTreeNode == null) {
            return result;
        }
        ArrayList<Long> allnodes = new ArrayList<Long>();
        allnodes.add(IDUtils.toLong(customTreeNode.getId()));
        ReportCustomTreeBuilder.getNodeIds(customTreeNode, allnodes);
        String selectFields = "number,name,id,templatetype,reportcatalog catalog,sequence,model,template,dataset,sourceid,type,reportcatalog.longnumber catelongnumber";
        QFilter filter = new QFilter("reportcatalog", "in", allnodes);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_reportquery", (String)selectFields, (QFilter[])new QFilter[]{filter});
        Map<String, List<DynamicObject>> templatesMap = templates.stream().collect(Collectors.groupingBy(dy -> dy.getString("catalog")));
        List<String> dataField = Arrays.asList("catalog", "templatetype", "model", "template", "number", "dataset");
        HashMap<String, Set<Long>> needUpdateType = new HashMap<String, Set<Long>>(2);
        HashMap<String, Integer> needUpdateSeq = new HashMap<String, Integer>(16);
        ReportCustomTreeBuilder.setTemplateNodes(customTreeNode, templatesMap, dataField, "default", startReport, needUpdateType, needUpdateSeq);
        if (needUpdateType.size() > 0) {
            updateSql = "update t_eb_reportquery  set ftype = ? where fid  = ? ";
            params = new ArrayList<Object[]>(16);
            for (Map.Entry ent : needUpdateType.entrySet()) {
                String type = (String)ent.getKey();
                Set fids = (Set)ent.getValue();
                if (!CollectionUtils.isNotEmpty(fids)) continue;
                for (Long fid : fids) {
                    Object[] param = new Object[]{type, fid};
                    params.add(param);
                }
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, params);
            CacheServiceHelper.clearEntityCache("eb_reportquery");
        }
        if (needUpdateSeq.size() > 0) {
            updateSql = "update t_eb_reportquery  set fsequence = ? where fid  = ? ";
            params = new ArrayList(16);
            for (Map.Entry ent : needUpdateSeq.entrySet()) {
                String id = (String)ent.getKey();
                Integer seq = (Integer)ent.getValue();
                Object[] param = new Object[]{seq, IDUtils.toLong(id)};
                params.add(param);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, params);
            CacheServiceHelper.clearEntityCache("eb_reportquery");
        }
        ReportCustomTreeBuilder.addRptShartNodes(customTreeNode, userId, modelid);
        return result;
    }

    private static CustomTreeNode addRptShartNodes(CustomTreeNode customTreeNode, Long userId, Long modelid) {
        CustomTreeNode result = customTreeNode;
        if (customTreeNode == null) {
            return result;
        }
        List<CustomTreeNode> childs = customTreeNode.getChildren();
        if (childs == null || childs.size() == 0) {
            return result;
        }
        CustomTreeNode shareNode = null;
        for (CustomTreeNode child : childs) {
            if (!child.getNumber().equalsIgnoreCase("share")) continue;
            shareNode = child;
            break;
        }
        if (shareNode == null) {
            return result;
        }
        String selectFields = "number,name||'('||number||')' as name,id,sharers,receiver,messageid,reportcatalog,'1' as templatetype,formid,dataset";
        QFilter qFilter1 = new QFilter("receiver", "=", (Object)userId);
        QFilter qFilter2 = new QFilter("sharestatus", "=", (Object)"A");
        QFilter qFilter3 = new QFilter("modelid", "=", (Object)modelid);
        QFilter qFilter4 = new QFilter("templatetype", "not in", (Object)new String[]{"M", "E"});
        DynamicObjectCollection shareDys = QueryServiceHelper.query((String)"eb_reportshare", (String)selectFields, (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4});
        List<String> dataField = Arrays.asList("sharers", "receiver", "reportcatalog", "messageid", "templatetype", "formid", "number", "dataset");
        HashMap<String, List<DynamicObject>> templatesMap = new HashMap<String, List<DynamicObject>>(16);
        templatesMap.put(shareNode.getId(), (List<DynamicObject>)shareDys);
        ReportCustomTreeBuilder.setTemplateNodes(shareNode, templatesMap, dataField, "share", null, null, null);
        return result;
    }

    private static void getNodeIds(CustomTreeNode parent, List<Long> allnodes) {
        List<CustomTreeNode> childs = parent.getChildren();
        if (childs != null && childs.size() > 0) {
            for (CustomTreeNode child : childs) {
                allnodes.add(IDUtils.toLong(child.getId()));
                ReportCustomTreeBuilder.getNodeIds(child, allnodes);
            }
        }
    }

    private static void setTemplateNodes(CustomTreeNode curNode, Map<String, List<DynamicObject>> templatesMap, List<String> dataField, String flag, Set<String> startReport, Map<String, Set<Long>> needUpdateType, Map<String, Integer> needUpdateSeq) {
        List<CustomTreeNode> childs;
        String noteId = curNode.getId();
        if (templatesMap.containsKey(noteId)) {
            ReportCustomTreeBuilder.setTemplateNode(curNode, templatesMap.get(noteId), dataField, flag, startReport, needUpdateType, needUpdateSeq);
        }
        if ((childs = curNode.getChildren()) != null && childs.size() > 0) {
            for (CustomTreeNode child : childs) {
                ReportCustomTreeBuilder.setTemplateNodes(child, templatesMap, dataField, flag, startReport, needUpdateType, needUpdateSeq);
            }
        }
    }

    private static void setTemplateNode(CustomTreeNode curNode, List<DynamicObject> templates, List<String> dataFields, String flag, Set<String> startReport, Map<String, Set<Long>> needUpdateType, Map<String, Integer> needUpdateSeq) {
        Boolean hasProperty = false;
        Boolean needUpSeq = false;
        if (CollectionUtils.isNotEmpty(templates) && needUpdateSeq != null && (hasProperty = Boolean.valueOf(templates.get(0).getDynamicObjectType().getProperties().containsKey((Object)"sequence"))).booleanValue()) {
            Map<Integer, List<DynamicObject>> sequence = templates.stream().collect(Collectors.groupingBy(t -> t.getInt("sequence")));
            for (List list : sequence.values()) {
                if (!CollectionUtils.isNotEmpty(list) || list.size() <= 1) continue;
                needUpSeq = true;
                break;
            }
        }
        int seq = 0;
        for (DynamicObject dynamicObject : templates) {
            String type;
            Boolean hasType;
            String aLong;
            boolean hasSource;
            CustomTreeNode child = new CustomTreeNode(dynamicObject.getString("id"), dynamicObject.getString("name"), dynamicObject.getString("number"));
            if ("default".equals(flag)) {
                String longnumber = curNode.getLongnumber();
                if (StringUtils.isNotEmpty(longnumber) && longnumber.startsWith("root.02_sys")) {
                    child.setCategory("report-public");
                } else {
                    child.setCategory("report");
                }
            } else if ("share".equals(flag)) {
                child.setCategory("report-share");
            } else if ("dimSet".equals(flag)) {
                child.setCategory("dim-category");
            }
            if (startReport != null && (hasSource = dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"sourceid")) && StringUtils.isNotEmpty(aLong = dynamicObject.getString("sourceid"))) {
                startReport.add(aLong);
            }
            if ((hasType = Boolean.valueOf(dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"type"))).booleanValue() && needUpdateType != null && StringUtils.isEmpty(type = dynamicObject.getString("type"))) {
                Set set;
                String catelongnumber = dynamicObject.getString("catelongnumber");
                if (StringUtils.isNotEmpty(catelongnumber) && (catelongnumber.equals("root.02_sys") || catelongnumber.equals("root.02_sys."))) {
                    set = needUpdateType.computeIfAbsent("1", k -> new HashSet(16));
                    set.add(dynamicObject.getLong("id"));
                } else {
                    set = needUpdateType.computeIfAbsent("0", k -> new HashSet(16));
                    set.add(dynamicObject.getLong("id"));
                }
            }
            child.setLongnumber(dynamicObject.getString("number"));
            hasProperty = dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"sequence");
            if (hasProperty.booleanValue()) {
                if (needUpSeq.booleanValue()) {
                    needUpdateSeq.put(dynamicObject.getString("id"), seq);
                    child.setSeq(seq);
                } else {
                    child.setSeq(dynamicObject.getInt("sequence"));
                }
            }
            child.setParentId(curNode.getId());
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            for (String field : dataFields) {
                data.put(field, dynamicObject.getString(field));
            }
            child.setData(data);
            curNode.addChild(child);
            ++seq;
        }
    }

    public static Map<String, Object> categoryHasReport(CustomTreeNode customTreeNode, Long model, Long userId) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("hasReport", Boolean.FALSE);
        if (customTreeNode == null || "report".equals(customTreeNode.getCategory())) {
            return result;
        }
        String selectFields = "id,longnumber";
        QFilter idFilter = new QFilter("id", "=", (Object)IDUtils.toLong(customTreeNode.getId()));
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_reportcatalog", (String)selectFields, (QFilter[])filters);
        if (CollectionUtils.isEmpty(dys)) {
            return result;
        }
        QFilter modleFilter = new QFilter("model", "=", (Object)model);
        QFilter userFilter = new QFilter("creator", "=", (Object)userId);
        QFilter numberFilter = new QFilter("longnumber", "like", (Object)(((DynamicObject)dys.get(0)).getString("longnumber") + "%"));
        QFilter[] filters2 = new QFilter[]{modleFilter, userFilter, numberFilter};
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_reportcatalog", (String)selectFields, (QFilter[])filters2);
        HashSet<Long> categoryId = new HashSet<Long>(16);
        categoryId.add(((DynamicObject)dys.get(0)).getLong("id"));
        Set id = query.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        categoryId.addAll(id);
        QFilter filter = new QFilter("reportcatalog", "in", categoryId);
        boolean eb_reportquery = QueryServiceHelper.exists((String)"eb_reportquery", (QFilter[])new QFilter[]{filter});
        result.put("hasReport", eb_reportquery);
        result.put("categoryId", categoryId);
        return result;
    }

    public static CustomTreeNode getDimSetCataTree(Long modelid, String algokey) {
        String selectFields = "id,name,number,parent,longname";
        QFilter modleFilter = new QFilter("model", "=", (Object)modelid);
        QFilter[] filters = new QFilter[]{modleFilter};
        String orderBys = "";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_datasetcatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
        CustomTreeNode tree = ReportCustomTreeBuilder.getCommomTree((List<DynamicObject>)dys, Boolean.TRUE);
        if (tree == null) {
            tree = ReportCustomTreeBuilder.createRootTemplateCataLogTree(modelid);
        }
        return tree;
    }

    public static CustomTreeNode addExistDimSetNodes(CustomTreeNode customTreeNode, List<Long> dataSetNumber) {
        CustomTreeNode result = customTreeNode;
        if (customTreeNode == null) {
            return result;
        }
        ArrayList<Long> allnodes = new ArrayList<Long>();
        allnodes.add(IDUtils.toLong(customTreeNode.getId()));
        ReportCustomTreeBuilder.getNodeIds(customTreeNode, allnodes);
        String selectFields = "id,number,name,catalog,model";
        QFilter filter = new QFilter("catalog", "in", allnodes);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_dataset", (String)selectFields, (QFilter[])new QFilter[]{filter});
        templates.removeIf(e -> !dataSetNumber.contains(e.getLong("id")));
        Map<String, List<DynamicObject>> templatesMap = templates.stream().collect(Collectors.groupingBy(dy -> dy.getString("catalog")));
        List<String> dataField = Arrays.asList("catalog", "model", "number");
        ReportCustomTreeBuilder.setTemplateNodes(customTreeNode, templatesMap, dataField, "dimSet", null, null, null);
        return result;
    }

    public static CustomTreeNode createRootTemplateCataLogTree(Long modelid) {
        String rootName = ResManager.loadKDString((String)"\u5168\u90e8\u5206\u7c7b", (String)"ReportCustomTreeBuilder_0", (String)"epm-eb-common", (Object[])new Object[0]);
        Date nowDate = TimeServiceHelper.now();
        DynamicObject rootDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_templatecatalog");
        rootDy.set("model", (Object)modelid);
        rootDy.set("parent", (Object)"0");
        rootDy.set("sequence", (Object)"0");
        rootDy.set("status", (Object)"C");
        rootDy.set("enable", (Object)"1");
        rootDy.set("creator", (Object)UserUtils.getUserId());
        rootDy.set("createtime", (Object)nowDate);
        rootDy.set("number", (Object)"root");
        rootDy.set("longnumber", (Object)"root");
        rootDy.set("name", (Object)rootName);
        rootDy.set("fullname", (Object)rootName);
        rootDy.set("level", (Object)"1");
        rootDy.set("isleaf", (Object)"0");
        DynamicObject[] rootDys = new DynamicObject[]{rootDy};
        SaveServiceHelper.save((DynamicObject[])rootDys);
        CustomTreeNode root = new CustomTreeNode(rootDy.getString("id"), rootName, "root");
        root.setCategory("root");
        return root;
    }
}

