/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.tree.templatecatalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.tree.AbstractTreeNode;
import kd.epm.eb.common.tree.templatecatalog.TemplateCataLogTree;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.lang3.BooleanUtils;

public class TemplateCataLogTreeBuilder {
    public static TemplateCataLogTree getTemplateCataTree(Long modelid, String algokey) {
        String selectFields = "id,name,number,parent,sequence,longnumber";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelid);
        QFilter[] filters = new QFilter[]{fmodelid};
        String orderBys = "sequence";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_templatecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
        TemplateCataLogTree tree = TemplateCataLogTreeBuilder.getCommomTree((List<DynamicObject>)dys);
        if (tree == null) {
            tree = TemplateCataLogTreeBuilder.createRootTemplateCataLogTree(modelid);
        }
        return tree;
    }

    public static TemplateCataLogTree getDimSetCataTree(Long modelid, String algokey) {
        String selectFields = "id,name,number,parent,longname";
        QFilter modleFilter = new QFilter("model", "=", (Object)modelid);
        QFilter[] filters = new QFilter[]{modleFilter};
        String orderBys = "";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_datasetcatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
        TemplateCataLogTree tree = TemplateCataLogTreeBuilder.getCommomTree((List<DynamicObject>)dys);
        if (tree == null) {
            tree = TemplateCataLogTreeBuilder.createRootTemplateCataLogTree(modelid);
        }
        return tree;
    }

    public static TemplateCataLogTree getReportCataTree(Long modelid, Long userId, String algokey) {
        String selectFields = "id,name,number,parent,sequence,longnumber";
        QFilter modleFilter = new QFilter("model", "=", (Object)modelid);
        QFilter userFilter = new QFilter("creator", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{modleFilter, userFilter};
        String orderBys = "sequence";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_reportcatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
        TemplateCataLogTree tree = TemplateCataLogTreeBuilder.getCommomTree((List<DynamicObject>)dys);
        if (tree == null) {
            tree = TemplateCataLogTreeBuilder.createRootReportCataLogTree(modelid, userId);
        } else {
            Set childs = tree.getChildren();
            Boolean isExistsShare = false;
            for (AbstractTreeNode abstractTreeNode : childs) {
                String number = ((TemplateCataLogTree)abstractTreeNode).getNumber();
                if (!number.equalsIgnoreCase("share")) continue;
                isExistsShare = true;
                break;
            }
            if (!isExistsShare.booleanValue()) {
                TemplateCataLogTreeBuilder.setShareNode(tree, modelid, userId);
            }
        }
        return tree;
    }

    public static TemplateCataLogTree getRptQueryMoveCatalog(Long modelId, Long userId, Boolean isPublic) {
        QFilter[] qFilterArray;
        String selectFields = "id,name,number,parent,sequence,longnumber";
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter userFilter = new QFilter("creator", "=", (Object)userId);
        String selfNum = "root.01_sys";
        String publicNum = "root.02_sys";
        String longNumber = selfNum + ".%";
        if (BooleanUtils.isTrue((Boolean)isPublic)) {
            longNumber = publicNum + ".%";
        }
        QFilter longNumberFilter = new QFilter("longnumber", "like", (Object)longNumber);
        if (BooleanUtils.isTrue((Boolean)isPublic)) {
            longNumberFilter.or(new QFilter("longnumber", "=", (Object)publicNum));
        } else {
            longNumberFilter.or(new QFilter("longnumber", "=", (Object)selfNum));
        }
        if (isPublic.booleanValue()) {
            QFilter[] qFilterArray2 = new QFilter[2];
            qFilterArray2[0] = modelFilter;
            qFilterArray = qFilterArray2;
            qFilterArray2[1] = longNumberFilter;
        } else {
            QFilter[] qFilterArray3 = new QFilter[3];
            qFilterArray3[0] = modelFilter;
            qFilterArray3[1] = userFilter;
            qFilterArray = qFilterArray3;
            qFilterArray3[2] = longNumberFilter;
        }
        QFilter[] filters = qFilterArray;
        String orderBys = "sequence";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_reportcatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
        for (DynamicObject dy : dys) {
            String longnumber = dy.getString("longnumber");
            if (selfNum.equals(longnumber)) {
                dy.set("parent", (Object)0L);
                continue;
            }
            if (!publicNum.equals(longnumber)) continue;
            dy.set("parent", (Object)0L);
        }
        return TemplateCataLogTreeBuilder.getCommomTree((List<DynamicObject>)dys);
    }

    public static TemplateCataLogTree getCommomTree(List<DynamicObject> dys) {
        if (dys == null || dys.size() == 0) {
            return null;
        }
        HashMap<Long, Set<AbstractTreeNode>> allnodes = new HashMap<Long, Set<AbstractTreeNode>>(16);
        for (DynamicObject dy : dys) {
            Long parentid = dy.getLong("parent");
            LinkedHashSet<TemplateCataLogTree> childs = (LinkedHashSet<TemplateCataLogTree>)allnodes.get(parentid);
            if (childs == null) {
                childs = new LinkedHashSet<TemplateCataLogTree>();
                allnodes.put(parentid, childs);
            }
            TemplateCataLogTree child = new TemplateCataLogTree((Long)dy.getLong("id"), dy.getString("name"), dy.getString("number"));
            DataEntityPropertyCollection dyPropertys = dy.getDynamicObjectType().getProperties();
            if (dyPropertys.containsKey((Object)"longnumber")) {
                child.setLongnumber(dy.getString("longnumber"));
            }
            if (dyPropertys.containsKey((Object)"sequence")) {
                child.setSeq(dy.getInt("sequence"));
            }
            childs.add(child);
        }
        TemplateCataLogTree result = TemplateCataLogTreeBuilder.getTemplateCataLogTree(allnodes);
        return result;
    }

    private static TemplateCataLogTree getTemplateCataLogTree(Map<Long, Set<AbstractTreeNode>> allnodes) {
        TemplateCataLogTree root_root = new TemplateCataLogTree((Long)0L, null, null);
        TemplateCataLogTreeBuilder.crcyleTransDynaToTreeNode(root_root, allnodes);
        if (root_root.getChildren() == null || root_root.getChildren().size() == 0) {
            return null;
        }
        return (TemplateCataLogTree)root_root.getChildren().iterator().next();
    }

    private static void crcyleTransDynaToTreeNode(AbstractTreeNode parent, Map<Long, Set<AbstractTreeNode>> allnodes) {
        Long id = parent.getId();
        Set<AbstractTreeNode> childs = allnodes.get(id);
        if (childs != null && childs.size() > 0) {
            for (AbstractTreeNode child : childs) {
                child.setParent(parent);
                parent.addChild(child);
                parent.SetIsOpened(true);
                TemplateCataLogTreeBuilder.crcyleTransDynaToTreeNode(child, allnodes);
            }
        }
    }

    public static TemplateCataLogTree addTemplateNodes(TemplateCataLogTree templateCataLogTree, List<String> templateType) {
        TemplateCataLogTree result = templateCataLogTree;
        if (templateCataLogTree == null) {
            return result;
        }
        ArrayList<Long> allnodes = new ArrayList<Long>();
        allnodes.add(templateCataLogTree.getId());
        TemplateCataLogTreeBuilder.getNodeIds(templateCataLogTree, allnodes);
        String selectFields = "number,name,id,templatetype,templatecatalog catalog,sequence,model,dataset";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("templatecatalog", "in", allnodes));
        if (templateType != null && templateType.size() > 0) {
            filters.add(new QFilter("templatetype", "in", templateType));
        }
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_templateentity", (String)selectFields, (QFilter[])filters.toArray(new QFilter[filters.size()]));
        Map<Long, List<DynamicObject>> templatesMap = templates.stream().collect(Collectors.groupingBy(dy -> dy.getLong("catalog")));
        List<String> dataField = Arrays.asList("catalog", "templatetype", "model", "number", "dataset");
        TemplateCataLogTreeBuilder.setTemplateNodes(templateCataLogTree, templatesMap, dataField);
        return result;
    }

    public static TemplateCataLogTree addRptNodes(TemplateCataLogTree templateCataLogTree, Long userId, Long modelid) {
        TemplateCataLogTree result = templateCataLogTree;
        if (templateCataLogTree == null) {
            return result;
        }
        ArrayList<Long> allnodes = new ArrayList<Long>();
        allnodes.add(templateCataLogTree.getId());
        TemplateCataLogTreeBuilder.getNodeIds(templateCataLogTree, allnodes);
        String selectFields = "number,name,id,templatetype,reportcatalog catalog,sequence,model,template,dataset";
        QFilter filter = new QFilter("reportcatalog", "in", allnodes);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_reportquery", (String)selectFields, (QFilter[])new QFilter[]{filter});
        Map<Long, List<DynamicObject>> templatesMap = templates.stream().collect(Collectors.groupingBy(dy -> dy.getLong("catalog")));
        List<String> dataField = Arrays.asList("catalog", "templatetype", "model", "template", "number", "dataset");
        TemplateCataLogTreeBuilder.setTemplateNodes(templateCataLogTree, templatesMap, dataField);
        TemplateCataLogTreeBuilder.addRptShartNodes(templateCataLogTree, userId, modelid);
        return result;
    }

    private static TemplateCataLogTree addRptShartNodes(TemplateCataLogTree templateCataLogTree, Long userId, Long modelid) {
        TemplateCataLogTree result = templateCataLogTree;
        if (templateCataLogTree == null) {
            return result;
        }
        Set childs = templateCataLogTree.getChildren();
        if (childs == null || childs.size() == 0) {
            return result;
        }
        TemplateCataLogTree shareNode = null;
        for (TemplateCataLogTree templateCataLogTree2 : childs) {
            if (!templateCataLogTree2.getNumber().equalsIgnoreCase("share")) continue;
            shareNode = templateCataLogTree2;
            break;
        }
        if (shareNode == null) {
            return result;
        }
        String selectFields = "number,name||'('||number||')' as name,id,sharers,receiver,messageid,reportcatalog,'1' as templatetype,formid,dataset";
        QFilter qFilter = new QFilter("receiver", "=", (Object)userId);
        QFilter qFilter2 = new QFilter("sharestatus", "=", (Object)"A");
        QFilter qFilter3 = new QFilter("modelid", "=", (Object)modelid);
        QFilter qFilter4 = new QFilter("templatetype", "not in", (Object)new String[]{"M", "E"});
        DynamicObjectCollection shareDys = QueryServiceHelper.query((String)"eb_reportshare", (String)selectFields, (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3, qFilter4});
        List<String> dataField = Arrays.asList("sharers", "receiver", "reportcatalog", "messageid", "templatetype", "formid", "number", "dataset");
        HashMap<Long, List<DynamicObject>> templatesMap = new HashMap<Long, List<DynamicObject>>(16);
        templatesMap.put(shareNode.getId(), (List<DynamicObject>)shareDys);
        TemplateCataLogTreeBuilder.setTemplateNodes(shareNode, templatesMap, dataField);
        return result;
    }

    public static TemplateCataLogTree addDimSetNodes(TemplateCataLogTree templateCataLogTree) {
        TemplateCataLogTree result = templateCataLogTree;
        if (templateCataLogTree == null) {
            return result;
        }
        ArrayList<Long> allnodes = new ArrayList<Long>();
        allnodes.add(templateCataLogTree.getId());
        TemplateCataLogTreeBuilder.getNodeIds(templateCataLogTree, allnodes);
        String selectFields = "id,number,name,catalog,model";
        QFilter filter = new QFilter("catalog", "in", allnodes);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_dataset", (String)selectFields, (QFilter[])new QFilter[]{filter});
        Map<Long, List<DynamicObject>> templatesMap = templates.stream().collect(Collectors.groupingBy(dy -> dy.getLong("catalog")));
        List<String> dataField = Arrays.asList("catalog", "model", "number");
        TemplateCataLogTreeBuilder.setTemplateNodes(templateCataLogTree, templatesMap, dataField);
        return result;
    }

    public static TemplateCataLogTree addExistDimSetNodes(TemplateCataLogTree templateCataLogTree, List<Long> dataSetNumber) {
        TemplateCataLogTree result = templateCataLogTree;
        if (templateCataLogTree == null) {
            return result;
        }
        ArrayList<Long> allnodes = new ArrayList<Long>();
        allnodes.add(templateCataLogTree.getId());
        TemplateCataLogTreeBuilder.getNodeIds(templateCataLogTree, allnodes);
        String selectFields = "id,number,name,catalog,model";
        QFilter filter = new QFilter("catalog", "in", allnodes);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_dataset", (String)selectFields, (QFilter[])new QFilter[]{filter});
        templates.removeIf(e -> !dataSetNumber.contains(e.getLong("id")));
        Map<Long, List<DynamicObject>> templatesMap = templates.stream().collect(Collectors.groupingBy(dy -> dy.getLong("catalog")));
        List<String> dataField = Arrays.asList("catalog", "model", "number");
        TemplateCataLogTreeBuilder.setTemplateNodes(templateCataLogTree, templatesMap, dataField);
        return result;
    }

    public static TemplateCataLogTree addMyReportNodes(TemplateCataLogTree templateCataLogTree, List<Map<String, Object>> reportNodes) {
        TemplateCataLogTree result = templateCataLogTree;
        if (templateCataLogTree == null) {
            return result;
        }
        Map<Long, List<Map<String, Object>>> catalogMap = reportNodes.stream().collect(Collectors.groupingBy(map -> Long.parseLong(map.get("catalog").toString())));
        List<String> dataField = Arrays.asList("catalog", "modelid", "number", "templatetype", "dataset", "customdimfielter");
        TemplateCataLogTreeBuilder.setNodesByMap(templateCataLogTree, catalogMap, dataField);
        return result;
    }

    private static void getNodeIds(AbstractTreeNode parent, List<Long> allnodes) {
        Set childs = parent.getChildren();
        if (childs != null && childs.size() > 0) {
            for (AbstractTreeNode abstractTreeNode : childs) {
                allnodes.add(abstractTreeNode.getId());
                TemplateCataLogTreeBuilder.getNodeIds(abstractTreeNode, allnodes);
            }
        }
    }

    private static void setTemplateNodes(AbstractTreeNode curNode, Map<Long, List<DynamicObject>> templatesMap, List<String> dataField) {
        Set childs;
        Long noteId = curNode.getId();
        if (templatesMap.containsKey(noteId)) {
            TemplateCataLogTreeBuilder.setTemplateNode(curNode, templatesMap.get(noteId), dataField);
        }
        if ((childs = curNode.getChildren()) != null && childs.size() > 0) {
            for (AbstractTreeNode abstractTreeNode : childs) {
                TemplateCataLogTreeBuilder.setTemplateNodes(abstractTreeNode, templatesMap, dataField);
            }
        }
    }

    private static void setTemplateNode(AbstractTreeNode curNode, List<DynamicObject> templates, List<String> dataFields) {
        Long noteId = curNode.getId();
        for (DynamicObject template : templates) {
            TemplateCataLogTree child = new TemplateCataLogTree((Long)template.getLong("id"), template.getString("name"), template.getString("number"));
            child.setLongnumber(template.getString("number"));
            Boolean hasProperty = template.getDynamicObjectType().getProperties().containsKey((Object)"sequence");
            if (hasProperty.booleanValue()) {
                child.setSeq(template.getInt("sequence"));
            }
            child.setParent(curNode);
            HashMap<String, String> data = new HashMap<String, String>(16);
            for (String field : dataFields) {
                data.put(field, template.getString(field));
            }
            child.setData(data);
            curNode.addChild(child);
            curNode.SetIsOpened(true);
        }
    }

    private static void setNodesByMap(AbstractTreeNode curNode, Map<Long, List<Map<String, Object>>> templatesMap, List<String> dataField) {
        Set childs;
        Long noteId = curNode.getId();
        if (templatesMap.containsKey(noteId)) {
            TemplateCataLogTreeBuilder.setNodeByMap(curNode, templatesMap.get(noteId), dataField);
        }
        if ((childs = curNode.getChildren()) != null && childs.size() > 0) {
            for (AbstractTreeNode abstractTreeNode : childs) {
                TemplateCataLogTreeBuilder.setNodesByMap(abstractTreeNode, templatesMap, dataField);
            }
        }
    }

    private static void setNodeByMap(AbstractTreeNode curNode, List<Map<String, Object>> templates, List<String> dataFields) {
        for (Map<String, Object> template : templates) {
            Long id = Long.parseLong(template.get("id").toString());
            String number = template.get("number").toString();
            String name = template.get("name").toString();
            TemplateCataLogTree child = new TemplateCataLogTree(id, name, number);
            child.setLongnumber(number);
            Boolean hasProperty = template.containsKey("sequence");
            if (hasProperty.booleanValue()) {
                child.setSeq(Integer.parseInt(template.get("sequence").toString()));
            }
            child.setParent(curNode);
            HashMap<String, String> data = new HashMap<String, String>(16);
            for (String field : dataFields) {
                data.put(field, template.get(field).toString());
            }
            child.setData(data);
            curNode.addChild(child);
            curNode.SetIsOpened(true);
        }
    }

    public static TemplateCataLogTree createRootTemplateCataLogTree(Long modelid) {
        String rootName = ResManager.loadKDString((String)"\u5168\u90e8\u6a21\u677f\u5206\u7c7b", (String)"TemplateCataLogTreeBuilder_0", (String)"epm-eb-common", (Object[])new Object[0]);
        Date nowDate = TimeServiceHelper.now();
        DynamicObject rootDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_templatecatalog");
        rootDy.set("model", (Object)modelid);
        rootDy.set("parent", (Object)"0");
        rootDy.set("sequence", (Object)"0");
        rootDy.set("status", (Object)"C");
        rootDy.set("enable", (Object)"1");
        rootDy.set("creator", (Object)UserUtils.getUserId());
        rootDy.set("createtime", (Object)nowDate);
        rootDy.set("number", (Object)"root");
        rootDy.set("longnumber", (Object)"root");
        rootDy.set("name", (Object)rootName);
        rootDy.set("fullname", (Object)rootName);
        rootDy.set("level", (Object)"1");
        rootDy.set("isleaf", (Object)"0");
        DynamicObject[] rootDys = new DynamicObject[]{rootDy};
        SaveServiceHelper.save((DynamicObject[])rootDys);
        TemplateCataLogTree root = new TemplateCataLogTree((Long)rootDy.getLong("id"), rootName, "root");
        root.SetIsOpened(true);
        return root;
    }

    private static void setShareNode(TemplateCataLogTree tree, Long modelid, Long userId) {
        Date nowDate = TimeServiceHelper.now();
        String shareName = ResManager.loadKDString((String)"\u6211\u7684\u5206\u4eab", (String)"TemplateCataLogTreeBuilder_4", (String)"epm-eb-common", (Object[])new Object[0]);
        DynamicObject shareDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_reportcatalog");
        shareDy.set("model", (Object)modelid);
        shareDy.set("parent", (Object)tree.getId());
        shareDy.set("sequence", (Object)"0");
        shareDy.set("status", (Object)"C");
        shareDy.set("enable", (Object)"1");
        shareDy.set("creator", (Object)userId);
        shareDy.set("createtime", (Object)nowDate);
        shareDy.set("number", (Object)"share");
        shareDy.set("longnumber", (Object)"root.share");
        shareDy.set("name", (Object)shareName);
        shareDy.set("fullname", (Object)(tree.getName() + "." + shareName));
        shareDy.set("level", (Object)"2");
        shareDy.set("isleaf", (Object)"1");
        DynamicObject[] shareDys = new DynamicObject[]{shareDy};
        SaveServiceHelper.save((DynamicObject[])shareDys);
        TemplateCataLogTree share = new TemplateCataLogTree((Long)shareDy.getLong("id"), shareName, "share");
        tree.addChild(share);
    }

    public static TemplateCataLogTree createRootReportCataLogTree(Long modelid, Long userId) {
        String rootName = ResManager.loadKDString((String)"\u5168\u90e8\u62a5\u8868\u5206\u7c7b", (String)"TemplateCataLogTreeBuilder_2", (String)"epm-eb-common", (Object[])new Object[0]);
        String defName = ResManager.loadKDString((String)"\u9ed8\u8ba4\u5206\u7c7b", (String)"TemplateCataLogTreeBuilder_3", (String)"epm-eb-common", (Object[])new Object[0]);
        String shareName = ResManager.loadKDString((String)"\u5206\u4eab\u7ed9\u6211\u7684", (String)"TemplateCataLogTreeBuilder_1", (String)"epm-eb-common", (Object[])new Object[0]);
        Date nowDate = TimeServiceHelper.now();
        DynamicObject rootDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_reportcatalog");
        rootDy.set("model", (Object)modelid);
        rootDy.set("parent", (Object)"0");
        rootDy.set("sequence", (Object)"0");
        rootDy.set("status", (Object)"C");
        rootDy.set("enable", (Object)"1");
        rootDy.set("creator", (Object)userId);
        rootDy.set("createtime", (Object)nowDate);
        rootDy.set("number", (Object)"root");
        rootDy.set("longnumber", (Object)"root");
        rootDy.set("name", (Object)rootName);
        rootDy.set("fullname", (Object)rootName);
        rootDy.set("level", (Object)"1");
        rootDy.set("isleaf", (Object)"0");
        DynamicObject[] rootDys = new DynamicObject[]{rootDy};
        SaveServiceHelper.save((DynamicObject[])rootDys);
        DynamicObject shareDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_reportcatalog");
        shareDy.set("model", (Object)modelid);
        shareDy.set("parent", (Object)rootDy.getLong("id"));
        shareDy.set("sequence", (Object)"0");
        shareDy.set("status", (Object)"C");
        shareDy.set("enable", (Object)"1");
        shareDy.set("creator", (Object)userId);
        shareDy.set("createtime", (Object)nowDate);
        shareDy.set("number", (Object)"share");
        shareDy.set("longnumber", (Object)"root.share");
        shareDy.set("name", (Object)shareName);
        shareDy.set("fullname", (Object)(rootName + "." + shareName));
        shareDy.set("level", (Object)"2");
        shareDy.set("isleaf", (Object)"1");
        DynamicObject[] shareDys = new DynamicObject[]{shareDy};
        SaveServiceHelper.save((DynamicObject[])shareDys);
        DynamicObject defDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_reportcatalog");
        defDy.set("model", (Object)modelid);
        defDy.set("parent", (Object)rootDy.getLong("id"));
        defDy.set("sequence", (Object)"1");
        defDy.set("status", (Object)"C");
        defDy.set("enable", (Object)"1");
        defDy.set("creator", (Object)userId);
        defDy.set("createtime", (Object)nowDate);
        defDy.set("number", (Object)"01_sys");
        defDy.set("longnumber", (Object)"root.01_sys");
        defDy.set("name", (Object)defName);
        defDy.set("fullname", (Object)(rootName + "." + defName));
        defDy.set("level", (Object)"2");
        defDy.set("isleaf", (Object)"1");
        DynamicObject[] defDys = new DynamicObject[]{defDy};
        SaveServiceHelper.save((DynamicObject[])defDys);
        TemplateCataLogTree root = new TemplateCataLogTree((Long)rootDy.getLong("id"), rootName, "root");
        TemplateCataLogTree share = new TemplateCataLogTree((Long)shareDy.getLong("id"), shareName, "share");
        TemplateCataLogTree def = new TemplateCataLogTree((Long)defDy.getLong("id"), defName, "01_sys");
        root.SetIsOpened(true);
        root.addChild(share);
        root.addChild(def);
        return root;
    }

    public static TemplateCataLogTree createRootApplyTemplateLogTree(Long modelid, String entity) {
        String rootName = ResManager.loadKDString((String)"\u5168\u90e8\u6a21\u677f\u5206\u7c7b", (String)"TemplateCataLogTreeBuilder_0", (String)"epm-eb-common", (Object[])new Object[0]);
        Date nowDate = TimeServiceHelper.now();
        DynamicObject rootDy = BusinessDataServiceHelper.newDynamicObject((String)entity);
        rootDy.set("model", (Object)modelid);
        rootDy.set("parent", (Object)"0");
        rootDy.set("sequence", (Object)"0");
        rootDy.set("status", (Object)"C");
        rootDy.set("enable", (Object)"1");
        rootDy.set("creator", (Object)UserUtils.getUserId());
        rootDy.set("createtime", (Object)nowDate);
        rootDy.set("number", (Object)"root");
        rootDy.set("longnumber", (Object)"root");
        rootDy.set("name", (Object)rootName);
        rootDy.set("fullname", (Object)rootName);
        rootDy.set("level", (Object)"1");
        rootDy.set("isleaf", (Object)"0");
        DynamicObject[] rootDys = new DynamicObject[]{rootDy};
        SaveServiceHelper.save((DynamicObject[])rootDys);
        TemplateCataLogTree root = new TemplateCataLogTree((Long)rootDy.getLong("id"), rootName, "root");
        root.SetIsOpened(true);
        return root;
    }
}

