/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.f7.MemberCondition;
import kd.epm.eb.common.pojo.CustomAttributeRelationTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.var.ReportVarUtil;
import kd.epm.eb.common.var.TemplateVarCommonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AnalyzeRangeUtils {
    public static Set<String> analyzeMemberConditionToMember2(String dimNumber, List<kd.epm.eb.common.dao.formula.MemberCondition> memberList, String examinePropRelation, IModelCacheHelper modelCache, MemberPropCache memberPropCache, Map<String, Map<String, Set<String>>> varValues, boolean onlyLeaf) {
        String viewStr;
        Long viewId = 0L;
        if (!memberList.isEmpty() && StringUtils.isNotEmpty(viewStr = memberList.get(0).getViewId())) {
            viewId = Long.parseLong(viewStr);
        }
        memberList = memberList.stream().filter(e -> !Boolean.TRUE.equals(e.getRemoveBoolean())).collect(Collectors.toList());
        List realMemberList = memberList.stream().filter(e -> !e.isProp()).collect(Collectors.toList());
        List propValueList = memberList.stream().filter(kd.epm.eb.common.dao.formula.MemberCondition::isProp).collect(Collectors.toList());
        List<Member> members = new LinkedList<Member>();
        for (Object memberCondition : realMemberList) {
            List<Member> currentRangeMembers = modelCache.getMember(dimNumber, viewId, ((kd.epm.eb.common.dao.formula.MemberCondition)memberCondition).getNumber(), Integer.parseInt(((kd.epm.eb.common.dao.formula.MemberCondition)memberCondition).getRange()));
            members.addAll(currentRangeMembers);
        }
        ArrayList<Member> propMembers = new ArrayList<Member>(10);
        if (CollectionUtils.isNotEmpty(propValueList)) {
            for (kd.epm.eb.common.dao.formula.MemberCondition prop : propValueList) {
                CustomPropertyValue customPropertyValue = MemberPropCache.getCustomPropertyValue(memberPropCache, dimNumber, prop.getLongnumber());
                List<Member> propMemberList = MemberPropCache.getMembersByPropValues(modelCache, memberPropCache, viewId, customPropertyValue);
                propMembers.addAll(propMemberList);
            }
        }
        if (!realMemberList.isEmpty() && !propValueList.isEmpty()) {
            if ("intersection".equals(examinePropRelation)) {
                Set propSet = propMembers.stream().map(e -> e.getNumber()).collect(Collectors.toSet());
                members = members.stream().filter(e -> propSet.contains(e.getNumber())).collect(Collectors.toList());
            } else {
                members.addAll(propMembers);
            }
        } else {
            members.addAll(propMembers);
        }
        if (onlyLeaf) {
            members = members.stream().filter(Member::isLeaf).collect(Collectors.toList());
        }
        return members.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
    }

    public static Set<String> analyzeMemberConditionToMember(String dimensionNumberString, Long viewIdLong, List<MemberCondition> memberConditionList, IModelCacheHelper modelCacheHelper, MemberPropCache memberPropCache, Map<String, Map<String, Set<String>>> varValues, DynamicObjectCollection varList, boolean onlyLeaf, CustomAttributeRelationTypeEnum customAttributeRelationTypeEnum) {
        Pair<List<MemberCondition>, List<MemberCondition>> matchedAndNotMatchedListPair = LambdaUtils.getMatchedAndNotMatchedListPair(memberConditionList, item -> !Boolean.TRUE.equals(item.getRemoveBoolean()));
        Set memberNumberStringSet = LambdaUtils.get(() -> {
            List<Member> memberList = AnalyzeRangeUtils.getMemberList(customAttributeRelationTypeEnum, (List)matchedAndNotMatchedListPair.getLeft(), modelCacheHelper, memberPropCache, dimensionNumberString, viewIdLong, varValues, varList);
            if (onlyLeaf) {
                return memberList.stream().filter(Member::isLeaf).map(item -> item.getNumber()).collect(Collectors.toSet());
            }
            return memberList.stream().map(item -> item.getNumber()).collect(Collectors.toSet());
        });
        Set removeMemberNumberStringSet = LambdaUtils.get(() -> {
            List removeMemberConditionList = (List)matchedAndNotMatchedListPair.getRight();
            if (CollectionUtils.isEmpty((Collection)removeMemberConditionList)) {
                return null;
            }
            List<Member> removeMemberList = AnalyzeRangeUtils.getMemberList(customAttributeRelationTypeEnum, removeMemberConditionList, modelCacheHelper, memberPropCache, dimensionNumberString, viewIdLong, varValues, varList);
            if (CollectionUtils.isEmpty(removeMemberList)) {
                return null;
            }
            return removeMemberList.stream().map(item -> item.getNumber()).collect(Collectors.toSet());
        });
        if (CollectionUtils.isEmpty((Collection)removeMemberNumberStringSet)) {
            return memberNumberStringSet;
        }
        return memberNumberStringSet.stream().filter(item -> !removeMemberNumberStringSet.contains(item)).collect(Collectors.toSet());
    }

    public static List<Member> getMemberList(CustomAttributeRelationTypeEnum customAttributeRelationTypeEnum, List<MemberCondition> memberConditionList, IModelCacheHelper modelCacheHelper, MemberPropCache memberPropCache, String dimensionNumberString, Long viewIdLong, Map<String, Map<String, Set<String>>> varValues, DynamicObjectCollection varList) {
        boolean unionBoolean;
        List normalMemberConditionList = memberConditionList.stream().filter(e -> !e.isProp()).collect(Collectors.toList());
        List propMemberConditionList = memberConditionList.stream().filter(MemberCondition::isProp).collect(Collectors.toList());
        LinkedList memberList = Lists.newLinkedList();
        for (Object memberCondition : normalMemberConditionList) {
            Long viewId = viewIdLong;
            Long memberViewIdLong = ((MemberCondition)memberCondition).getViewIdLong();
            if (IDUtils.isNotEmptyLong(memberViewIdLong).booleanValue()) {
                viewId = memberViewIdLong;
            }
            if (TemplateVarCommonUtil.checkIsVar(((MemberCondition)memberCondition).getNumber(), dimensionNumberString).booleanValue()) {
                String messageString = ResManager.loadResFormat((String)"\u89c4\u5219\u4e0a\u8bbe\u7f6e\u7684\u201c%1\u201d\u7ef4\u5ea6\u53d8\u91cf\u201c%2\u201d\u6ca1\u6709\u8bbe\u7f6e\u503c\uff0c\u8bf7\u5728\u89c4\u5219\u5217\u8868-\u53d8\u91cf\u8d4b\u503c\u4e2d\u8bbe\u7f6e\u3002", (String)"RuleService_1", (String)"epm-eb-olap", (Object[])new Object[]{dimensionNumberString, ((MemberCondition)memberCondition).getNumber()});
                Set<String> memberNumberStringSet = ReportVarUtil.getRealDimByVar(modelCacheHelper.getModelobj().getId(), ((MemberCondition)memberCondition).getNumber(), dimensionNumberString, varValues, messageString, varList);
                for (String memberNumberString : memberNumberStringSet) {
                    memberList.addAll(modelCacheHelper.getMemberIncludeCosmic(dimensionNumberString, viewId, memberNumberString, Integer.parseInt(((MemberCondition)memberCondition).getRange())));
                }
                continue;
            }
            memberList.addAll(modelCacheHelper.getMemberIncludeCosmic(dimensionNumberString, viewId, ((MemberCondition)memberCondition).getNumber(), Integer.parseInt(((MemberCondition)memberCondition).getRange())));
        }
        ArrayList propMemberList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(propMemberConditionList)) {
            for (MemberCondition propMemberCondition : propMemberConditionList) {
                Long viewId = viewIdLong;
                Long memberViewIdLong = propMemberCondition.getViewIdLong();
                if (IDUtils.isNotEmptyLong(memberViewIdLong).booleanValue()) {
                    viewId = memberViewIdLong;
                }
                CustomPropertyValue customPropertyValue = memberPropCache.getPropertyValue(dimensionNumberString, propMemberCondition.getLongnumber());
                propMemberList.addAll(MemberPropCache.getMembersByPropValues(modelCacheHelper, memberPropCache, viewId, customPropertyValue));
            }
        }
        boolean bl = unionBoolean = customAttributeRelationTypeEnum == null || CustomAttributeRelationTypeEnum.union == customAttributeRelationTypeEnum;
        if (unionBoolean) {
            memberList.addAll(propMemberList);
            return memberList;
        }
        if (normalMemberConditionList.isEmpty()) {
            return propMemberList;
        }
        if (propMemberConditionList.isEmpty()) {
            return memberList;
        }
        Set memberNumberStringSet = propMemberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        return memberList.stream().filter(item -> memberNumberStringSet.contains(item.getNumber())).collect(Collectors.toList());
    }
}

