/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.approveBill.Entity.RejectStatus;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgTaskExecuteConstant;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.common.utils.StringUtils;

public class ApproveAdjustUtils
implements BgTaskExecuteConstant {
    public static final String CANCEL_CLOSE_KEY = "btn_batchcancel";
    public static final String APPROVE_CLOSE_KEY = "btn_batchapprove";
    public static final String APPROVE_CLOSE_KEY_TIP = "btn_batchapprove_tip";
    public static final String UN_AUDIT_CLOSE_KEY = "btn_batchunapprove";
    public static final String REJECT_CLOSE_KEY = "btn_reject";
    private static final ApproveAdjustUtils instance = new ApproveAdjustUtils();
    private static final Log log = LogFactory.getLog(ApproveAdjustUtils.class);

    public static ApproveAdjustUtils getInstance() {
        return instance;
    }

    public boolean approveAdjust(Long modelId, Long reportProcessId, IFormView view, Long approveBillId) {
        return this.approveAdjust(modelId, reportProcessId, view, approveBillId, false);
    }

    public boolean approveAdjust(Long modelId, Long reportProcessId, IFormView view, Long approveBillId, Boolean isVirtual) {
        if (view == null || view.getPageCache().get("approveAdjust") != null) {
            return true;
        }
        if (this.isFromReportQuery(view)) {
            log.info("approveAdjust:false,isFromReportQuery");
            return false;
        }
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String approveBill = (String)formShowParameter.getCustomParam("approveBill");
        if (StringUtils.isEmpty(approveBill) && "eb_executetask".equals(formShowParameter.getFormId())) {
            return false;
        }
        boolean approveAdjust = CommonUtils.approveAdjust(modelId);
        if (approveAdjust) {
            boolean isParentEntityInApprove;
            Map<Long, Set<Long>> approveMap;
            long templateId = 0L;
            DynamicObject dy = QueryServiceHelper.queryOne((String)"eb_reportprocess", (String)"approvebill,template,status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportProcessId)});
            if (IDUtils.isNull(approveBillId)) {
                approveBillId = 0L;
            }
            if (dy != null) {
                templateId = dy.getLong("template");
                if (approveBillId == 0L || isVirtual.booleanValue()) {
                    approveBillId = dy.getLong("approvebill");
                }
            }
            if (approveBillId == 0L && dy != null && BgTaskStateEnum.INCOMPLETE.getNumber().equals(dy.getString("status")) && (approveMap = ApproveAdjustUtils.getReportBillMap(Sets.newHashSet((Object[])new Long[]{reportProcessId}), true)).containsKey(reportProcessId) && !approveMap.get(reportProcessId).isEmpty()) {
                approveBillId = approveMap.get(reportProcessId).iterator().next();
            }
            if (isParentEntityInApprove = this.isParentEntityInApprove(view, templateId, modelId)) {
                log.info(String.format("approveAdjust:false,PEIP:temp:%s,model:%s", templateId, modelId));
                return false;
            }
            RejectStatus processRejectStatus = (RejectStatus)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"ApproveBillService", (String)"getProcessRejectStatusForService", (Object[])new Object[]{reportProcessId, approveBillId});
            boolean canAdjust = processRejectStatus.getCanAdjust();
            if (canAdjust || dy != null && BgTaskStateEnum.INCOMPLETE.getNumber().equals(dy.getString("status"))) {
                view.getPageCache().put("approveAdjust", "1");
                return true;
            }
            log.info(String.format("approveAdjust:%s,PRS:rpt:%s,bill:%s", canAdjust, reportProcessId, approveBillId));
            return canAdjust;
        }
        return false;
    }

    private boolean isFromReportQuery(IFormView view) {
        if (view == null) {
            return false;
        }
        return "eb_reportquery_new".equals(view.getEntityId());
    }

    public boolean isParentEntityInApprove(IFormView view, Long templateId, Long modelId) {
        Map<String, Long> dimMembers;
        if (view == null) {
            return false;
        }
        IPageCache pageCache = view.getPageCache();
        if (pageCache == null) {
            return false;
        }
        if (ApproveBillHelper.hasCentralBill(view)) {
            return false;
        }
        String org = pageCache.get("current_org");
        String period = pageCache.get("CURRENT_PERIOD");
        String version = pageCache.get("CURRENT_VERSION");
        String dataType = pageCache.get("CURRENT_DATATYPE");
        String viewId = pageCache.get("current_entity_view_id");
        Long view_id = ConvertUtils.toLong(viewId);
        if (StringUtils.isEmpty(period) || StringUtils.isEmpty(org) || StringUtils.isEmpty(version) || StringUtils.isEmpty(dataType)) {
            dimMembers = this.getUserSelectF7FromCache(pageCache);
            if (!dimMembers.containsKey(SysDimensionEnum.Entity.getNumber())) {
                dimMembers.put(SysDimensionEnum.Entity.getNumber(), IDUtils.toLong(org));
            }
            if (!(dimMembers.containsKey(SysDimensionEnum.DataType.getNumber()) && dimMembers.containsKey(SysDimensionEnum.Version.getNumber()) && dimMembers.containsKey(SysDimensionEnum.BudgetPeriod.getNumber()))) {
                Long taskPk = ConvertUtils.toLong(pageCache.get("current_taskp"));
                DynamicObject taskP = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"year, version, datatype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskPk)});
                if (taskP == null) {
                    return false;
                }
                if (!dimMembers.containsKey(SysDimensionEnum.DataType.getNumber())) {
                    dimMembers.put(SysDimensionEnum.DataType.getNumber(), taskP.getLong("datatype"));
                }
                if (!dimMembers.containsKey(SysDimensionEnum.Version.getNumber())) {
                    dimMembers.put(SysDimensionEnum.Version.getNumber(), taskP.getLong("version"));
                }
                if (!dimMembers.containsKey(SysDimensionEnum.BudgetPeriod.getNumber())) {
                    dimMembers.put(SysDimensionEnum.BudgetPeriod.getNumber(), taskP.getLong("year"));
                }
            }
        } else {
            dimMembers = new HashMap<String, Long>(16);
            dimMembers.put(SysDimensionEnum.Entity.getNumber(), Long.parseLong(org));
            dimMembers.put(SysDimensionEnum.BudgetPeriod.getNumber(), Long.parseLong(period));
            dimMembers.put(SysDimensionEnum.Version.getNumber(), Long.parseLong(version));
            dimMembers.put(SysDimensionEnum.DataType.getNumber(), Long.parseLong(dataType));
        }
        return this.isParentEntityInApprove(dimMembers, templateId, modelId, view_id);
    }

    public boolean isParentEntityInApprove(Map<String, Long> dimMembers, Long templateId, Long modelId, Long viewId) {
        if (dimMembers == null || dimMembers.size() == 0) {
            return false;
        }
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        qFilter.and("dim_period", "=", (Object)dimMembers.get(SysDimensionEnum.BudgetPeriod.getNumber()));
        qFilter.and("dim_version", "=", (Object)dimMembers.get(SysDimensionEnum.Version.getNumber()));
        qFilter.and("dim_datatype", "=", (Object)dimMembers.get(SysDimensionEnum.DataType.getNumber()));
        qFilter.and("entryentity.tempid", "=", (Object)templateId);
        qFilter.and("billstatus", "in", Arrays.asList("B", "E"));
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"eborgid", (QFilter[])qFilter.toArray());
        if (approveBills.size() == 0) {
            return false;
        }
        Set ebOrgIds = approveBills.stream().map(e -> e.getLong("eborgid")).collect(Collectors.toSet());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Dimension entity = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        List<Long> viewIds = MemberServiceHelper.getViewGroupViewsByViewId(viewId);
        Long orgId = dimMembers.get(SysDimensionEnum.Entity.getNumber());
        for (Long vid : viewIds) {
            String[] split;
            Member member = entity.getMember(vid, orgId);
            if (member == null) continue;
            for (String number : split = member.getLongNumber().split("!")) {
                Member parent = entity.getMember(vid, number);
                if (parent == null || StringUtils.equals(parent.getNumber(), member.getNumber()) || !ebOrgIds.contains(parent.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, Long> getUserSelectF7FromCache(IPageCache pageCache) {
        HashMap<String, Long> f7KeyValues = new HashMap<String, Long>(16);
        for (Map.Entry e : pageCache.getAll().entrySet()) {
            if (!((String)e.getKey()).startsWith("lastselect_") || e.getValue() == null) continue;
            String dimNumber = ((String)e.getKey()).substring("lastselect_".length());
            f7KeyValues.put(dimNumber, Long.valueOf((String)e.getValue()));
        }
        return f7KeyValues;
    }

    public static Map<Long, Set<Long>> getReportBillMap(Set<Long> reportIds, boolean filterBillStatus) {
        QFilter reportFilter = new QFilter("id", "in", reportIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,model,period,version,datatype,entity,template", (QFilter[])reportFilter.toArray());
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> versionIds = new HashSet<Long>(16);
        HashSet<Long> dataTypeIds = new HashSet<Long>(16);
        HashSet<Long> templateIds = new HashSet<Long>(16);
        HashSet<Long> entityIds = new HashSet<Long>(16);
        Long modelId = 0L;
        HashMap<String, Long> dimReportMap = new HashMap<String, Long>(16);
        StringBuilder dimStr = new StringBuilder();
        for (DynamicObject report : reportList) {
            Long reportId = report.getLong("id");
            modelId = report.getLong("model");
            Long periodId = report.getLong("period");
            Long versionId = report.getLong("version");
            Long datatypeId = report.getLong("datatype");
            Long templateId = report.getLong("template");
            Long entityId = report.getLong("entity");
            periodIds.add(periodId);
            versionIds.add(versionId);
            dataTypeIds.add(datatypeId);
            templateIds.add(templateId);
            entityIds.add(entityId);
            dimStr.append(periodId).append('!').append(versionId).append('!').append(datatypeId).append('!').append(templateId).append('!').append(entityId);
            dimReportMap.put(dimStr.toString(), reportId);
            dimStr.setLength(0);
        }
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        qFilter.and("dim_period", "in", periodIds);
        qFilter.and("dim_version", "in", versionIds);
        qFilter.and("dim_datatype", "in", dataTypeIds);
        qFilter.and("entryentity.tempid", "in", templateIds);
        qFilter.and("eborgid", "in", entityIds);
        qFilter.and("splitbilltype", "=", (Object)CentralBillType.Normal.getNumber());
        if (filterBillStatus) {
            qFilter.and("billstatus", "!=", (Object)ApproveBillStatus.DISCARD.getNumber());
        }
        String fields = "id, dim_datatype, dim_period, dim_version, eborgid, entryentity.tempid as tempid";
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)fields, (QFilter[])qFilter.toArray(), (String)"createdate desc");
        HashMap<Long, Set<Long>> reportBillMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject approveBill : approveBills) {
            Long billId = approveBill.getLong("id");
            Long periodId = approveBill.getLong("dim_period");
            Long versionId = approveBill.getLong("dim_version");
            Long datatypeId = approveBill.getLong("dim_datatype");
            Long templateId = approveBill.getLong("tempid");
            Long entityId = approveBill.getLong("eborgid");
            String signKey = periodId + "!" + versionId + "!" + datatypeId + "!" + templateId + "!" + entityId;
            Long reportId = (Long)dimReportMap.get(signKey);
            Set billIds = reportBillMap.computeIfAbsent(reportId, v -> new LinkedHashSet(16));
            billIds.add(billId);
        }
        return reportBillMap;
    }
}

