/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class BgAccountUtils {
    public static String getAccountFields() {
        return "id, name, number, longnumber, isleaf, drcrdirect, storagetype, dataset";
    }

    public static DynamicObjectCollection queryBgAccount(Long modelId, Set<String> numbers) {
        DynamicObjectCollection accounts = new DynamicObjectCollection();
        if (modelId == null || numbers == null || numbers.isEmpty()) {
            return accounts;
        }
        QFilter[] filters = new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "in", numbers)};
        accounts = QueryServiceHelper.query((String)SysDimensionEnum.Account.getMemberTreemodel(), (String)BgAccountUtils.getAccountFields(), (QFilter[])filters);
        return accounts;
    }

    public static DynamicObjectCollection queryLeafAccounts(Long modelId, Set<String> numbers) {
        DynamicObjectCollection leafAccounts = new DynamicObjectCollection();
        DynamicObjectCollection parents = BgAccountUtils.queryBgAccount(modelId, numbers);
        ArrayList longNumbers = new ArrayList();
        if (parents != null) {
            parents.forEach(e -> {
                if (e.getBoolean("isleaf")) {
                    leafAccounts.add(e);
                } else {
                    longNumbers.add(e.getString("longnumber"));
                }
            });
        }
        if (!longNumbers.isEmpty()) {
            QFilter qFilter = null;
            for (int i = 0; i < longNumbers.size(); ++i) {
                if (i == 0) {
                    qFilter = new QFilter("longnumber", "like", (Object)((String)longNumbers.get(i) + "!%"));
                    continue;
                }
                if (qFilter == null) continue;
                qFilter = qFilter.or(new QFilter("longnumber", "like", (Object)((String)longNumbers.get(i) + "!%")));
            }
            QFilter[] filters = new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("isleaf", "=", (Object)Boolean.TRUE), qFilter};
            leafAccounts.addAll((Collection)QueryServiceHelper.query((String)SysDimensionEnum.Account.getMemberTreemodel(), (String)BgAccountUtils.getAccountFields(), (QFilter[])filters));
        }
        return leafAccounts;
    }
}

