/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;

public class BgDataUtils {
    private static final Set<String> ignDimNumbers = new HashSet<String>();

    public static Set<String> getIgnDimNumbers() {
        return ignDimNumbers;
    }

    public static String getMemberKey(BgData bgData, Collection<kd.epm.eb.common.model.Dimension> dimensions) {
        if (bgData == null || dimensions == null || dimensions.isEmpty()) {
            return null;
        }
        String member = null;
        StringBuilder dataKey = new StringBuilder();
        dataKey.append(bgData.getModelId()).append("!");
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            member = bgData.getMemberNumber(dimension.getNumber());
            if (StringUtils.isNotEmpty(member)) {
                dataKey.append(dimension.getNumber()).append("_").append(member).append("!");
                continue;
            }
            throw new KDBizException("member is null. dimenson Number = " + dimension.getNumber());
        }
        return dataKey.toString();
    }

    public static String getMemberKey(BgData bgData, String[] dimensions) {
        if (bgData == null || dimensions == null || dimensions.length == 0) {
            return null;
        }
        String member = null;
        StringBuilder dataKey = new StringBuilder();
        dataKey.append(bgData.getModelId()).append("!");
        for (String dimension : dimensions) {
            member = bgData.getMemberNumber(dimension);
            if (!StringUtils.isNotEmpty(member)) {
                throw new KDBizException("member is null. dimenson Number = " + dimension);
            }
            dataKey.append(dimension).append("_").append(member).append("!");
        }
        return dataKey.toString();
    }

    public static String getMemberKey(BgData bgData, Collection<kd.epm.eb.common.model.Dimension> dimensions, Set<String> ignDimNumbers) {
        if (bgData == null || dimensions == null || dimensions.isEmpty()) {
            return null;
        }
        String member = null;
        StringBuilder dataKey = new StringBuilder();
        dataKey.append(bgData.getModelId()).append("!");
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            if (ignDimNumbers != null && ignDimNumbers.contains(dimension.getNumber())) continue;
            member = bgData.getMemberNumber(dimension.getNumber());
            if (StringUtils.isNotEmpty(member)) {
                dataKey.append(dimension.getNumber()).append("_").append(member).append("!");
                continue;
            }
            throw new KDBizException("member is null. dimension Number = " + dimension.getNumber());
        }
        return dataKey.toString();
    }

    public static String getPeriodKey(boolean isEb, BgData bgData) {
        if (bgData != null) {
            if (isEb) {
                return bgData.getMemberNumber(SysDimensionEnum.Year.getNumber()) + "_" + bgData.getMemberNumber(SysDimensionEnum.Period.getNumber());
            }
            return bgData.getMemberNumber(SysDimensionEnum.BudgetPeriod.getNumber());
        }
        return null;
    }

    public static Long calcKey(String[] dimensions, String[] members, Map<String, Dimension> dimensionMap, boolean ignOrgDim, LogStats stats) {
        if (dimensions == null || dimensions.length == 0 || dimensionMap == null || dimensionMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u552f\u4e00\u6807\u8bc6\u751f\u6210\u9519\u8bef\uff0c\u4f53\u7cfb\u7ef4\u5ea6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BgDataUtils_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        if (dimensions.length != members.length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u7684\u7ef4\u5ea6\u6570\u91cf\u4e0e\u6570\u636e\u96c6\u7684\u7ef4\u5ea6\u6570\u91cf\u4e0d\u5339\u914d\u3002", (String)"BgDataUtils_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        Dimension dimension = null;
        StringBuilder str = new StringBuilder();
        int in = dimensions.length;
        for (int i = 0; i < in; ++i) {
            String noneNumber;
            if (ignOrgDim && dimensions[i].equals(SysDimensionEnum.Entity.getNumber()) || (BgDimensionServiceHelper.hasUserDefinedDimension(dimension = dimensionMap.get(dimensions[i])) || SysDimensionEnum.Version.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.Currency.getNumber().equals(dimension.getNumber())) && members[i].equals(noneNumber = dimension.getNoneNumber())) continue;
            str.append(dimension.getShortNumber()).append("!").append(members[i]).append("@");
        }
        if (str.length() > 0) {
            str.setLength(str.length() - "@".length());
        }
        String key = str.toString();
        Long keyId = Hashing.sha256().hashString((CharSequence)key, StandardCharsets.UTF_8).padToLong();
        if (stats != null) {
            stats.add("log-cell-key:" + key + ", " + keyId);
        }
        return keyId;
    }

    public static Long calcKey(String[] dimensions, String[] members, Map<String, Dimension> dimensionMap) {
        return BgDataUtils.calcKey(dimensions, members, dimensionMap, false, null);
    }

    static {
        ignDimNumbers.add(SysDimensionEnum.Year.getNumber());
        ignDimNumbers.add(SysDimensionEnum.Period.getNumber());
        ignDimNumbers.add(SysDimensionEnum.BudgetPeriod.getNumber());
        ignDimNumbers.add(SysDimensionEnum.ChangeType.getNumber());
        ignDimNumbers.add(SysDimensionEnum.Version.getNumber());
    }
}

