/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BgDimensionServiceHelper {
    public static final String FIELDS = "id, name, number, shortnumber, dseq, fieldmapped, model.id, membermodel";
    public static final String FIELDS_NOMODEL = "id, name, number, shortnumber, dseq, fieldmapped, membermodel, issysdimension, version";

    public static Member getRootMember(Dimension dimension) {
        if (dimension == null || StringUtils.isEmpty(dimension.getNumber())) {
            return null;
        }
        Member member = new Member(null, dimension.getNumber(), dimension.getNumber());
        member.setDimension(dimension);
        return member;
    }

    public static Member getNoneMember(Dimension dimension) {
        if (dimension == null || StringUtils.isEmpty(dimension.getShortNumber())) {
            return null;
        }
        Member member = new Member(null, dimension.getShortNumber() + "None", dimension.getShortNumber() + "None");
        member.setDimension(dimension);
        return member;
    }

    public static boolean hasUserDefinedDimension(Dimension dimension) {
        return dimension != null && StringUtils.isNotEmpty(dimension.getFieldMapped()) && BgDimensionServiceHelper.hasUserDefinedDimension(dimension.getMemberModel());
    }

    public static boolean hasUserDefinedDimension(kd.epm.eb.common.cache.impl.Dimension dimension) {
        return dimension != null && !dimension.isPreset() && StringUtils.isNotEmpty(dimension.getFieldMapped()) && BgDimensionServiceHelper.hasUserDefinedDimension(dimension.getMemberModel());
    }

    public static boolean hasUserDefinedDimension(String memberModel) {
        return "epm_userdefinedmembertree".equals(memberModel) || "bcm_userdefinedmembertree".equals(memberModel);
    }

    public static boolean hasUserDefinedDimension(Map<String, Object> dimension) {
        if (dimension == null || dimension.isEmpty()) {
            return false;
        }
        Object memberModel = dimension.get("membermodel");
        return memberModel != null && "epm_userdefinedmembertree".equals(memberModel);
    }

    public static Dimension getDimension(Long modelId, String dimNumber) {
        if (modelId == null || StringUtils.isEmpty(dimNumber)) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("number", "=", (Object)dimNumber));
        DynamicObject object = QueryServiceHelper.queryOne((String)"epm_dimension", (String)FIELDS, (QFilter[])builder.toArrays());
        return Dimension.loadFromDynamicobject(object);
    }

    public static Map<String, Object> queryDimension(Long modelId, String dimNumber) {
        Map<String, Object> dimension = null;
        if (modelId == null || StringUtils.isEmpty(dimNumber)) {
            return dimension;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("number", "=", (Object)dimNumber));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryDimension", (String)"epm_dimension", (String)FIELDS, (QFilter[])builder.toArrays(), null, (int)1);){
            dimension = CommonServiceHelper.transDataMap(ds);
        }
        return dimension;
    }

    public static List<Dimension> getDimensionByModel(Long modelId) {
        return BgDimensionServiceHelper.getDimensionByModel(modelId, null, false);
    }

    public static List<Dimension> getDimensionByModel(BizModel bizModel, boolean loadFromCache) {
        return BgDimensionServiceHelper.getDimensionByModel(bizModel.getId(), bizModel.getReportType(), loadFromCache);
    }

    public static List<Dimension> getDimensionByModel(Long modelId, String reportType, boolean loadFromCache) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        if (modelId == null) {
            return dimensions;
        }
        String dimEntityNumber = "epm_dimension";
        if (StringUtils.isEmpty(reportType)) {
            DynamicObject modelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model", (String)"id, reporttype");
            if (modelObj == null) {
                modelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model", (String)"id, reporttype");
            }
            if (modelObj != null) {
                reportType = modelObj.getString("reporttype");
            }
        }
        if (ApplicationTypeEnum.BGMD.getIndex().equals(reportType)) {
            dimEntityNumber = "epm_dimension";
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        if (loadFromCache) {
            Map dims = BusinessDataServiceHelper.loadFromCache((String)dimEntityNumber, (QFilter[])builder.toArrays());
            if (dims != null) {
                dims.values().forEach(dim -> {
                    Dimension dimension = Dimension.loadFromDynamicobject(dim);
                    dimension.setModelId(modelId);
                    dimensions.add(dimension);
                });
            }
            dimensions.sort(Comparator.comparingInt(Dimension::getSeq));
        } else {
            List<Map<String, Object>> rst = null;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryDimension", (String)dimEntityNumber, (String)FIELDS, (QFilter[])builder.toArrays(), (String)"dseq");){
                rst = CommonServiceHelper.transDataSet(ds);
            }
            if (rst != null) {
                rst.forEach(dim -> {
                    Dimension dimension = Dimension.loadFromMap(dim);
                    dimension.setModelId(modelId);
                    dimensions.add(dimension);
                });
            }
        }
        return dimensions;
    }

    public static Map<Long, List<Dimension>> getDimensionByModels(Set<Long> modelIds) {
        HashMap<Long, List<Dimension>> dimensionMap = new HashMap<Long, List<Dimension>>();
        if (modelIds == null || modelIds.isEmpty()) {
            return dimensionMap;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "in", modelIds));
        DynamicObjectCollection dimensionObjs = QueryServiceHelper.query((String)"epm_dimension", (String)FIELDS, (QFilter[])builder.toArrays(), (String)"model, dseq");
        dimensionObjs.forEach(dimensionObj -> {
            Dimension dimension = Dimension.loadFromDynamicobject(dimensionObj);
            dimension.setModelId(dimensionObj.getLong("model.id"));
            ArrayList<Dimension> dimensions = (ArrayList<Dimension>)dimensionMap.get(dimension.getModelId());
            if (dimensions == null) {
                dimensions = new ArrayList<Dimension>();
                dimensionMap.put(dimension.getModelId(), dimensions);
            }
            dimensions.add(dimension);
        });
        return dimensionMap;
    }

    public static Collection<Map<String, Object>> queryDimensions(Long modelId) {
        List<Map<String, Object>> dimensions = new ArrayList<Map<String, Object>>();
        if (modelId == null || modelId == 0L) {
            return dimensions;
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryDimension", (String)"epm_dimension", (String)FIELDS, (QFilter[])filter.toArray(), (String)"dseq");){
            dimensions = CommonServiceHelper.transDataSet(ds);
        }
        return dimensions;
    }

    public static Set<String> getDataSetDims(Long dataSetID) {
        HashSet<String> datasetDims = new HashSet<String>();
        if (dataSetID != null && dataSetID != 0L) {
            datasetDims.add(SysDimensionEnum.Account.getNumber());
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_dataset", (String)"entryentity.datasetdim.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataSetID)});
            dynamicObjects.forEach(e -> datasetDims.add(e.getString("entryentity.datasetdim.number")));
        }
        return datasetDims;
    }

    public static void updateIsLeafByParentId(Long[] memberIds, @NotNull Long modelId, @NotNull Long dimensionId, @NotNull String entityNumber) {
        DynamicObject[] loads;
        if (memberIds == null || memberIds.length == 0) {
            return;
        }
        String table = "t_eb_structofdefined";
        SysDimensionEnum sde = SysDimensionEnum.getEnumByMemberTreemodel(entityNumber);
        if (sde != null) {
            table = sde.getMemberTreetable();
        } else if ("eb_viewmember".equals(entityNumber)) {
            table = BusinessDataServiceHelper.newDynamicObject((String)entityNumber).getDynamicObjectType().getAlias();
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct fparentid from ", new Object[0]).append(table, new Object[0]).append(" where fmodelid = ? ", new Object[]{modelId});
        sql.append(" and fdimensionid = ?", new Object[]{dimensionId});
        sql.append(" and ", new Object[0]).appendIn("fparentid", (Object[])memberIds);
        HashSet hasChildren = Sets.newHashSetWithExpectedSize((int)memberIds.length);
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet ds = DB.queryDataSet((String)"queryParentSize", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    hasChildren.add(row.getLong(0));
                }
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)entityNumber, (String)"id, isleaf", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)memberIds)})) {
            if (hasChildren.contains(load.getLong("id"))) {
                load.set("isleaf", (Object)0);
                continue;
            }
            load.set("isleaf", (Object)1);
        }
        SaveServiceHelper.update((DynamicObject[])loads);
    }
}

