/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;

public class BgTaskNode {
    private int level = 0;
    private DynamicObject task = null;
    private Map<Long, BgTaskNode> parents = new HashMap<Long, BgTaskNode>();
    private Map<Long, BgTaskNode> childs = new HashMap<Long, BgTaskNode>();

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setTask(DynamicObject task) {
        this.task = task;
    }

    public DynamicObject getTask() {
        return this.task;
    }

    public Map<Long, BgTaskNode> getParents() {
        return Collections.unmodifiableMap(this.parents);
    }

    public BgTaskNode addParent(Long nodeId, BgTaskNode node) {
        return this.parents.put(nodeId, node);
    }

    public Map<Long, BgTaskNode> getChilds() {
        return Collections.unmodifiableMap(this.childs);
    }

    public BgTaskNode addChild(Long nodeId, BgTaskNode node) {
        return this.childs.put(nodeId, node);
    }

    public BgTaskNode(DynamicObject task) {
        this.task = task;
    }

    public void calcLevel() {
        if (!this.getChilds().isEmpty()) {
            for (BgTaskNode child : this.getChilds().values()) {
                if (child.level != this.level && child.level >= this.level + 1) continue;
                child.level = this.level + 1;
                child.calcLevel();
            }
        }
        if (!this.getParents().isEmpty()) {
            for (BgTaskNode parent : this.getParents().values()) {
                if (parent.level != this.level && parent.level <= this.level - 1) continue;
                parent.level = this.level - 1;
                parent.calcLevel();
            }
        }
    }
}

