/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Builder<T> {
    private final Supplier<T> instantiator;
    private List<Consumer<T>> modifiers = new ArrayList<Consumer<T>>();

    public Builder(Supplier<T> instant) {
        this.instantiator = instant;
    }

    public static <T> Builder<T> of(Supplier<T> instant) {
        return new Builder<T>(instant);
    }

    public <P1> Builder<T> with(Consumer1<T, P1> consumer, P1 p1) {
        Consumer<Object> c = instance -> consumer.accept(instance, p1);
        this.modifiers.add(c);
        return this;
    }

    public <P1, P2> Builder<T> with(Consumer2<T, P1, P2> consumer, P1 p1, P2 p2) {
        Consumer<Object> c = instance -> consumer.accept(instance, p1, p2);
        this.modifiers.add(c);
        return this;
    }

    public <P1, P2, P3> Builder<T> with(Consumer3<T, P1, P2, P3> consumer, P1 p1, P2 p2, P3 p3) {
        Consumer<Object> c = instance -> consumer.accept(instance, p1, p2, p3);
        this.modifiers.add(c);
        return this;
    }

    public <P1, P2, P3, P4> Builder<T> with(Consumer4<T, P1, P2, P3, P4> consumer, P1 p1, P2 p2, P3 p3, P4 p4) {
        Consumer<Object> c = instance -> consumer.accept(instance, p1, p2, p3, p4);
        this.modifiers.add(c);
        return this;
    }

    public <P1, P2, P3, P4, P5> Builder<T> with(Consumer5<T, P1, P2, P3, P4, P5> consumer, P1 p1, P2 p2, P3 p3, P4 p4, P5 p5) {
        Consumer<Object> c = instance -> consumer.accept(instance, p1, p2, p3, p4, p5);
        this.modifiers.add(c);
        return this;
    }

    public T build() {
        Object value = this.instantiator.get();
        this.modifiers.forEach(modifier -> modifier.accept(value));
        this.modifiers.clear();
        return value;
    }

    @FunctionalInterface
    public static interface Consumer5<T, P1, P2, P3, P4, P5> {
        public void accept(T var1, P1 var2, P2 var3, P3 var4, P4 var5, P5 var6);
    }

    @FunctionalInterface
    public static interface Consumer4<T, P1, P2, P3, P4> {
        public void accept(T var1, P1 var2, P2 var3, P3 var4, P4 var5);
    }

    @FunctionalInterface
    public static interface Consumer3<T, P1, P2, P3> {
        public void accept(T var1, P1 var2, P2 var3, P3 var4);
    }

    @FunctionalInterface
    public static interface Consumer2<T, P1, P2> {
        public void accept(T var1, P1 var2, P2 var3);
    }

    @FunctionalInterface
    public static interface Consumer1<T, P1> {
        public void accept(T var1, P1 var2);
    }
}

