/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BusinessModelServiceHelper {
    private static final BusinessModelServiceHelper instance = new BusinessModelServiceHelper();
    private static final String VIEW_ENTRY_VIEW_GROUP_DEFAULT_VIEW = "viewentry.viewgroup.defaultview";
    private static final String VIEW_ENTRY_VIEW_GROUP = "viewentry.viewgroup";
    private static final String VIEW_GROUP_DEFAULT_VIEW = "viewgroup.defaultview";

    private BusinessModelServiceHelper() {
    }

    public static BusinessModelServiceHelper getInstance() {
        return instance;
    }

    public List<Long> queryDataSetIds(Long bizModelId) {
        LinkedList<Long> datasetIds = new LinkedList<Long>();
        if (bizModelId == null || bizModelId == 0L) {
            return datasetIds;
        }
        try (DataSet ds = DB.queryDataSet((String)"dataset", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid from t_eb_dataset where fbizmodelid = ?", (Object[])new Object[]{bizModelId});){
            if (ds != null) {
                Row row = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    datasetIds.add(row.getLong("fid"));
                }
            }
        }
        return datasetIds;
    }

    public Set<Long> queryDimId(List<Long> dataSetIds) {
        HashSet<Long> dimIds = new HashSet<Long>();
        if (dataSetIds == null || dataSetIds.size() == 0) {
            return dimIds;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fdatasetdim from t_eb_datasetdim where ", new Object[0]);
        sql.appendIn("fid", dataSetIds.toArray(new Object[0]));
        try (DataSet ds = DB.queryDataSet((String)"datasetDim", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    dimIds.add(row.getLong("fdatasetdim"));
                }
            }
        }
        return dimIds;
    }

    public Set<Long> queryDimIdByBizModelId(Long bizModelId) {
        List<Long> datasetIds = this.queryDataSetIds(bizModelId);
        return this.queryDimId(datasetIds);
    }

    public boolean queryDimIdByBizModelId(@NotNull Long bizModelId, @NotNull Long dimensionId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select top 1 fid from t_eb_viewentry where fid = ?", new Object[]{bizModelId}).append(" and fdimensionid = ?", new Object[]{dimensionId});
        try (DataSet ds = DB.queryDataSet((String)"queryDimId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null && ds.hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static List<Dimension> getRefDim(Long busModelId, List<Dimension> dimensions) {
        LinkedList<Dimension> refDims = new LinkedList<Dimension>();
        if (busModelId == null || busModelId == 0L) {
            return refDims;
        }
        DynamicObject busModel = BusinessModelServiceHelper.queryBusModel(busModelId);
        if (busModel == null || busModel.getDynamicObjectCollection("viewentry") == null) {
            return refDims;
        }
        DynamicObjectCollection entries = busModel.getDynamicObjectCollection("viewentry");
        HashSet<String> refDimNumbers = new HashSet<String>(entries.size());
        for (DynamicObject entry : entries) {
            refDimNumbers.add(entry.getString("dimension.number"));
        }
        for (Dimension dimension : dimensions) {
            if (!refDimNumbers.contains(dimension.getNumber())) continue;
            refDims.add(dimension);
        }
        return refDims;
    }

    private static DynamicObject queryBusModel(Long busModelId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)busModelId, (String)"eb_businessmodel", (String)"id, viewentry.dimension, viewentry.view");
    }

    public Long getViewId(Long busModelId, String dimNumber, Long modelId) {
        Long dimId = this.getDimId(dimNumber, modelId);
        QFilter qf1 = new QFilter("id", "=", (Object)busModelId);
        QFilter qf2 = new QFilter("viewentry.dimension", "=", (Object)dimId);
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)VIEW_ENTRY_VIEW_GROUP_DEFAULT_VIEW, (QFilter[])new QFilter[]{qf1.and(qf2)});
        if (query != null) {
            return query.getLong(VIEW_ENTRY_VIEW_GROUP_DEFAULT_VIEW);
        }
        return 0L;
    }

    public Long getViewId(Long busModelId, String dimNumber, Long modelId, boolean needBaseView) {
        Long dimId = this.getDimId(dimNumber, modelId);
        QFBuilder qb = new QFBuilder();
        qb.add("id", "=", busModelId);
        qb.add("viewentry.dimension", "=", dimId);
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)VIEW_ENTRY_VIEW_GROUP_DEFAULT_VIEW, (QFilter[])qb.toArrays());
        if (query != null) {
            return query.getLong(VIEW_ENTRY_VIEW_GROUP_DEFAULT_VIEW);
        }
        return 0L;
    }

    public Map<Long, Long> getViewIds(Long busModelId, Set<Long> dims) {
        QFilter qf1 = new QFilter("id", "=", (Object)busModelId);
        QFilter qf2 = new QFilter("viewentry.dimension", "in", dims);
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        DynamicObjectCollection queryIds = QueryServiceHelper.query((String)"eb_businessmodel", (String)"viewentry.dimension, viewentry.viewgroup.defaultview", (QFilter[])new QFilter[]{qf1.and(qf2)});
        if (queryIds != null && queryIds.size() > 0) {
            for (DynamicObject dy : queryIds) {
                Long view = dy.getLong(VIEW_ENTRY_VIEW_GROUP_DEFAULT_VIEW);
                if (view == null) {
                    view = 0L;
                }
                map.put(dy.getLong("viewentry.dimension"), view);
            }
            return map;
        }
        return null;
    }

    public static Map<String, Long> getViewIds(Long busModelId) {
        if (busModelId == null || busModelId == 0L) {
            return Collections.emptyMap();
        }
        return BusinessModelServiceHelper.getDefaultViewIdByBusModel(BusinessDataServiceHelper.loadSingleFromCache((Object)busModelId, (String)"eb_businessmodel"));
    }

    public static Map<String, Long> getViewGroupIds(Long busModelId) {
        if (busModelId == null || busModelId == 0L) {
            return Collections.emptyMap();
        }
        return BusinessModelServiceHelper.getViewGroupIdByBusModel(BusinessDataServiceHelper.loadSingleFromCache((Object)busModelId, (String)"eb_businessmodel"));
    }

    public static Map<String, Long> getViewIds(Long busModelId, boolean includeBase) {
        if (busModelId == null || busModelId == 0L) {
            return Collections.emptyMap();
        }
        return BusinessModelServiceHelper.getDefaultViewIdByBusModel(BusinessDataServiceHelper.loadSingleFromCache((Object)busModelId, (String)"eb_businessmodel"));
    }

    public static Map<String, Long> getViewGroupIdsByBusinessModel(DynamicObject busModel) {
        HashMap viewGroupIds = Maps.newHashMap();
        DynamicObjectCollection viewEntry = busModel.getDynamicObjectCollection("viewentry");
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)viewEntry)) {
            for (DynamicObject entry : viewEntry) {
                DynamicObject viewGroup = entry.getDynamicObject("viewgroup");
                if (viewGroup == null) continue;
                viewGroupIds.put(entry.getDynamicObject("dimension").getString("number"), viewGroup.getLong("id"));
            }
        }
        return viewGroupIds;
    }

    public static Map<String, List<Long>> getViewGroupViewIdsByBusinessModel(Long busModelId) {
        if (busModelId == null || busModelId == 0L) {
            return Collections.emptyMap();
        }
        return BusinessModelServiceHelper.getViewGroupViewIdsByBusinessModel(BusinessDataServiceHelper.loadSingleFromCache((Object)busModelId, (String)"eb_businessmodel"));
    }

    public static Map<String, List<Long>> getViewGroupViewIdsByBusinessModel(DynamicObject busModel) {
        HashMap<String, List<Long>> viewIdsMap = new HashMap<String, List<Long>>(16);
        BusinessModelServiceHelper.getViewGroupViewsByBusinessModel(busModel, viewObj -> {
            List viewIds = viewIdsMap.computeIfAbsent(viewObj.getString("dimension.number"), k -> new ArrayList(16));
            viewIds.add(viewObj.getLong("id"));
        });
        return viewIdsMap;
    }

    public static Map<String, Map<String, Long>> getViewGroupViewNumIdsByBusinessModel(DynamicObject busModel) {
        HashMap<String, Map<String, Long>> viewIdsMap = new HashMap<String, Map<String, Long>>(16);
        BusinessModelServiceHelper.getViewGroupViewsByBusinessModel(busModel, viewObj -> {
            Map viewIdNumMap = viewIdsMap.computeIfAbsent(viewObj.getString("dimension.number"), k -> new HashMap(16));
            viewIdNumMap.put(viewObj.getString("number"), viewObj.getLong("id"));
        });
        return viewIdsMap;
    }

    public static void getViewGroupViewsByBusinessModel(DynamicObject busModel, Consumer<DynamicObject> viewConsumer) {
        if (busModel == null) {
            return;
        }
        DynamicObjectCollection viewEntry = busModel.getDynamicObjectCollection("viewentry");
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)viewEntry)) {
            QFilter qFilter1;
            DynamicObjectCollection viewIdDynList;
            ArrayList<Long> viewGroupAndDirIds = new ArrayList<Long>(16);
            for (DynamicObject entry : viewEntry) {
                DynamicObject viewGroup = entry.getDynamicObject("viewgroup");
                if (viewGroup == null) continue;
                viewGroupAndDirIds.add(viewGroup.getLong("id"));
            }
            QFilter qFilter = new QFilter("parent", "in", viewGroupAndDirIds);
            DynamicObjectCollection viewGroupDirs = QueryServiceHelper.query((String)"eb_dimensionview_group", (String)"id", (QFilter[])qFilter.toArray());
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)viewGroupDirs)) {
                for (DynamicObject viewGroupDir : viewGroupDirs) {
                    viewGroupAndDirIds.add(viewGroupDir.getLong("id"));
                }
            }
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)(viewIdDynList = QueryServiceHelper.query((String)"eb_dimensionview", (String)"number,id,dimension.number", (QFilter[])(qFilter1 = new QFilter("viewgroup", "in", viewGroupAndDirIds)).toArray())))) {
                for (DynamicObject viewId : viewIdDynList) {
                    viewConsumer.accept(viewId);
                }
            }
        }
    }

    public static Map<String, Long> getEditViewIds(Long busModelId) {
        return BusinessModelServiceHelper.getViewIds(busModelId);
    }

    public static Map<String, Long> getDefaultViewIdByBusModel(DynamicObject busModel) {
        if (busModel == null) {
            return Collections.emptyMap();
        }
        HashMap views = Maps.newHashMapWithExpectedSize((int)32);
        DynamicObjectCollection entries = busModel.getDynamicObjectCollection("viewentry");
        if (entries != null) {
            for (DynamicObject entry : entries) {
                DynamicObject dimension;
                Long viewId;
                DynamicObject defaultView;
                DynamicObject viewGroup = entry.getDynamicObject("viewgroup");
                if (viewGroup == null || (defaultView = viewGroup.getDynamicObject("defaultview")) == null || IDUtils.isEmptyLong(viewId = Long.valueOf(defaultView.getLong("id"))).booleanValue() || (dimension = entry.getDynamicObject("dimension")) == null) continue;
                String dimNumber = dimension.getString("number");
                views.put(dimNumber, viewId);
            }
        }
        return views;
    }

    public static Map<String, Long> getViewGroupIdByBusModel(DynamicObject busModel) {
        if (busModel == null) {
            return Collections.emptyMap();
        }
        HashMap viewGroups = Maps.newHashMapWithExpectedSize((int)32);
        DynamicObjectCollection entries = busModel.getDynamicObjectCollection("viewentry");
        if (entries != null) {
            for (DynamicObject entry : entries) {
                DynamicObject dimension;
                DynamicObject viewGroup = entry.getDynamicObject("viewgroup");
                if (viewGroup == null || (dimension = entry.getDynamicObject("dimension")) == null) continue;
                Long viewGroupId = viewGroup.getLong("id");
                String dimNumber = dimension.getString("number");
                viewGroups.put(dimNumber, viewGroupId);
            }
        }
        return viewGroups;
    }

    private Long getDimId(String dimNumber, Long modelId) {
        QFilter qf1 = new QFilter("number", "=", (Object)dimNumber);
        QFilter qf2 = new QFilter("model", "=", (Object)modelId);
        DynamicObject query = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id", (QFilter[])new QFilter[]{qf1.and(qf2)});
        if (query != null) {
            return query.getLong("id");
        }
        return 0L;
    }

    public Map<Object, DynamicObject> getBusModelsByModelId(Long modelId) {
        if (modelId == null || modelId == 0L) {
            return null;
        }
        QFilter qf1 = new QFilter("model", "=", (Object)modelId);
        return BusinessDataServiceHelper.loadFromCache((String)"eb_businessmodel", (String)"id, name, number", (QFilter[])new QFilter[]{qf1});
    }

    public List<Long> getBusModelIdsByModelId(Long modelId) {
        if (modelId == null || modelId == 0L) {
            return null;
        }
        QFilter qf1 = new QFilter("model", "=", (Object)modelId);
        Map busModels = BusinessDataServiceHelper.loadFromCache((String)"eb_businessmodel", (String)"id, name, number", (QFilter[])new QFilter[]{qf1});
        ArrayList<Long> bizModelIds = new ArrayList<Long>();
        busModels.keySet().forEach(bizmodelId -> bizModelIds.add((Long)bizmodelId));
        return bizModelIds;
    }

    public List<Long> getBusModelIdsByViewId(Long viewId) {
        if (IDUtils.isNull(viewId)) {
            return Collections.emptyList();
        }
        ArrayList<Long> busModelIds = new ArrayList<Long>(32);
        QFilter qf = new QFilter(VIEW_ENTRY_VIEW_GROUP_DEFAULT_VIEW, "=", (Object)viewId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter[]{qf});
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                busModelIds.add(dynamicObject.getLong("id"));
            }
        }
        return busModelIds;
    }

    public List<Long> getBusModelIdsByViewGroupId(Long modelId, Set<Long> viewGroupIds) {
        if (IDUtils.isNull(modelId) || CollectionUtils.isEmpty(viewGroupIds)) {
            return Collections.emptyList();
        }
        ArrayList<Long> busModelIds = new ArrayList<Long>(32);
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", modelId);
        builder.add(VIEW_ENTRY_VIEW_GROUP, "in", viewGroupIds);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id", (QFilter[])builder.toArray());
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                busModelIds.add(dynamicObject.getLong("id"));
            }
        }
        return busModelIds;
    }

    public DynamicObject getDefaultBusModel(Long modelId, String fields) {
        if (IDUtils.isNull(modelId)) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", modelId);
        builder.add("number", "=", "AunnalBudget");
        if (StringUtils.isEmpty(fields)) {
            return BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (QFilter[])builder.toArray());
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (String)fields, (QFilter[])builder.toArray());
    }

    public List<Long> getRefBaseViewBizModelIdsByDimId(Long modelId, Long dimId) {
        ArrayList<Long> bizModelIds = new ArrayList<Long>();
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", modelId);
        builder.add("viewentry.dimension", "=", dimId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id,viewentry.viewgroup as viewGroup", (QFilter[])builder.toArray());
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!IDUtils.isNotEmptyLong(dynamicObject.getLong("viewGroup")).booleanValue()) continue;
                bizModelIds.add(dynamicObject.getLong("id"));
            }
        }
        return bizModelIds;
    }

    public List<Long> getRefBizModelIdsByViewId(Long viewId, Long modelId) {
        ArrayList<Long> bizModelIds = new ArrayList<Long>();
        QFBuilder qfBuilder = new QFBuilder("model", "=", modelId);
        Map bizModelObjs = BusinessDataServiceHelper.loadFromCache((String)"eb_businessmodel", (String)"viewentry.viewgroup,id,number", (QFilter[])qfBuilder.toArray());
        boolean checkView = viewId != null && !viewId.equals(0L);
        bizModelObjs.values().forEach(obj -> {
            long id = obj.getLong("id");
            if (checkView) {
                DynamicObjectCollection viewentry = obj.getDynamicObjectCollection("viewentry");
                if (viewentry != null) {
                    for (DynamicObject entryRow : viewentry) {
                        Long vId;
                        DynamicObject defaultView = entryRow.getDynamicObject(VIEW_GROUP_DEFAULT_VIEW);
                        if (defaultView == null || !viewId.equals(vId = Long.valueOf(defaultView.getLong("id")))) continue;
                        bizModelIds.add(id);
                        break;
                    }
                }
            } else {
                bizModelIds.add(id);
            }
        });
        return bizModelIds;
    }

    public static Map<Long, Set<Long>> getRefDimsByBCRIds(Set<Long> bizCtrlRangeIds) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id,viewentry.dimension as dimId", (QFilter[])new QFilter[]{new QFilter("id", "in", bizCtrlRangeIds)});
        for (DynamicObject obj : dynamicObject) {
            Long bcrId = obj.getLong("id");
            Long dimId = obj.getLong("dimId");
            Set dimIds = result.computeIfAbsent(bcrId, key -> new HashSet(16));
            dimIds.add(dimId);
        }
        return result;
    }

    public DynamicObject getBusinessModel(Long businessModelId) {
        if (businessModelId == null || businessModelId == 0L) {
            return null;
        }
        QFilter qf1 = new QFilter("id", "=", (Object)businessModelId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (String)"id, name, number", (QFilter[])new QFilter[]{qf1});
    }

    public static boolean checkExistDim(IModelCacheHelper modelCacheHelper, Long busModelId, String dimensionNumber) {
        Dimension dim;
        if (modelCacheHelper == null || IDUtils.isNull(busModelId) || StringUtils.isEmpty(dimensionNumber)) {
            return false;
        }
        List<Dimension> dimensions = modelCacheHelper.getDimensionListByBusModel(busModelId);
        boolean checkICDim = false;
        Iterator<Dimension> iterator = dimensions.iterator();
        while (iterator.hasNext() && !(checkICDim = StringUtils.equals(dimensionNumber, (dim = iterator.next()).getNumber()))) {
        }
        return checkICDim;
    }
}

