/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.utils.CentralizedServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.AbstractCacheServiceHelper;
import kd.epm.eb.common.utils.control.Centralized;
import kd.epm.eb.common.utils.control.StartVersionServiceHelper;
import org.jetbrains.annotations.NotNull;

public class CacheServiceHelper
extends AbstractCacheServiceHelper {
    public static final String CONTROL_PARAM_CACHE = "CONTROL_PARAM_CACHE";
    public static final String CONTROL_MEMBER_CACHE = "CONTROL_MEMBER_CACHE";
    public static final String CONTROL_VERSION_CACHE = "CONTROL_VERSION_CACHE";
    public static final String CONTROL_MAPPING_CACHE = "CONTROL_MAPPING_CACHE1";
    public static final String CONTROL_MAPPING_TIMESTAMP_CACHE = "CONTROL_MAPPING_TIMESTAMP_CACHE1";
    public static final String CONTROL_LOCK_CACHE = "CONTROL_LOCK_CACHE";
    public static final String CONTROL_LOCK_TIMESTAMP_CACHE = "CONTROL_LOCK_TIMESTAMP_CACHE";
    public static final String CONTROL_CENTRALIZED_CACHE = "CONTROL_CENTRALIZED_CACHE_NEW3";
    public static final String CONTROL_CENTRALIZED_VERSION_CACHE = "CONTROL_CENTRALIZED_VERSION_CACHE";
    public static final String CONTROL_WHITE_LIST_CACHE = "CONTROL_WHITE_LIST_CACHE1";
    public static final String CONTROL_WHITE_LIST_TIMESTAMP_CACHE = "CONTROL_WHITE_LIST_TIMESTAMP_CACHE1";
    public static final String CONTROL_FIELDS_CACHE = "CONTROL_FIELDS_CACHE";
    private static final String BUDGET_FLOAT_DATA = "BUDGET_FLOAT_DATA";
    public static final String BUDGET_RELATION_DATA = "BUDGET_RELATION_DATA";

    public static void clearEntityCache(@NotNull String entityNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dataEntityType);
        cacheManager.removeByDt();
        cacheManager.removeByFilterDt();
    }

    public static void clearShowControlParamByEntityAndParamKey(String entityNumber, String paramKey) {
        Map paramMap;
        Map paramsCache;
        if (StringUtils.isEmpty(entityNumber)) {
            return;
        }
        HashMap entityCache = CacheServiceHelper.get(CONTROL_PARAM_CACHE, Map.class);
        if (entityCache == null) {
            entityCache = new HashMap(16);
        }
        if ((paramsCache = (Map)entityCache.get(entityNumber)) != null && (paramMap = (Map)paramsCache.get(paramKey)) != null) {
            paramMap.clear();
        }
        CacheServiceHelper.put(CONTROL_PARAM_CACHE, entityCache);
    }

    public static void clearShowControlParam() {
        HashMap entityCache = CacheServiceHelper.get(CONTROL_PARAM_CACHE, Map.class);
        if (entityCache == null) {
            entityCache = new HashMap(16);
        }
        for (Map paramsCache : entityCache.values()) {
            Map showBeyondMessageMap;
            Map showCheckMemPermissionMap;
            if (paramsCache == null) continue;
            Map showBalanceMap = (Map)paramsCache.get("IS_SHOWBALANCE");
            if (showBalanceMap != null) {
                showBalanceMap.clear();
            }
            if ((showCheckMemPermissionMap = (Map)paramsCache.get("IS_SHOWCHECKMEMPERMISSION")) != null) {
                showCheckMemPermissionMap.clear();
            }
            if ((showBeyondMessageMap = (Map)paramsCache.get("IS_SHOWBEYONDMESSAGE")) == null) continue;
            showBeyondMessageMap.clear();
        }
        CacheServiceHelper.put(CONTROL_PARAM_CACHE, entityCache);
    }

    public static void updateProcessByControl() {
        boolean hasSave = false;
        HashMap entityCache = CacheServiceHelper.get(CONTROL_PARAM_CACHE, Map.class);
        if (entityCache == null) {
            entityCache = new HashMap();
        }
        for (Map paramsCache : entityCache.values()) {
            Map controlMap;
            if (paramsCache == null || (controlMap = (Map)paramsCache.get("IS_CONTROL")) == null || controlMap.isEmpty()) continue;
            controlMap.clear();
            hasSave = true;
        }
        if (hasSave) {
            CacheServiceHelper.put(CONTROL_PARAM_CACHE, entityCache);
        }
    }

    public static Collection<BizModel> queryCacheByScenVerNoTime() {
        return CacheServiceHelper.queryCacheByScenVerByTime(null);
    }

    public static Collection<BizModel> queryCacheByScenVer(Date bizTime) {
        if (bizTime == null) {
            return null;
        }
        return CacheServiceHelper.queryCacheByScenVerByTime(bizTime);
    }

    private static Collection<BizModel> queryCacheByScenVerByTime(Date bizTime) {
        HashMap<Long, String> startVersion = CacheServiceHelper.get(CONTROL_VERSION_CACHE, Map.class);
        if (startVersion == null) {
            startVersion = new HashMap<Long, String>();
        }
        Collection<Object> versions = new ArrayList();
        if (startVersion.isEmpty()) {
            versions = StartVersionServiceHelper.queryStartVersion();
            if (versions != null) {
                for (Map map : versions) {
                    startVersion.put((Long)map.get("id"), SerializationUtils.serializeToBase64((Object)map));
                }
            }
            CacheServiceHelper.put(CONTROL_VERSION_CACHE, startVersion);
        } else {
            Map version = null;
            Iterator iterator = startVersion.values().iterator();
            while (iterator.hasNext()) {
                version = (Map)SerializationUtils.deSerializeFromBase64((String)((String)iterator.next()));
                versions.add(version);
            }
        }
        Date beginTime = null;
        Object var4_7 = null;
        ArrayList<BizModel> result = new ArrayList<BizModel>();
        if (versions != null) {
            for (Map map : versions) {
                BizModel bizModel;
                beginTime = (Date)map.get("effectivetime");
                Date date = (Date)map.get("invalidtime");
                if (beginTime == null || bizTime != null && (bizTime.compareTo(beginTime) < 0 || date != null && date.compareTo(bizTime) < 0) || (bizModel = StartVersionServiceHelper.getBizModel(map)) == null) continue;
                result.add(bizModel);
            }
        }
        return result;
    }

    public static void clearCacheByScenVer() {
        CacheServiceHelper.remove(CONTROL_VERSION_CACHE);
    }

    public static List<Centralized> queryCacheByCentralized(@NotNull Long modelId, @NotNull Long busModelId, @NotNull LogStats stats) {
        Long cacheVersion;
        stats.addInfo("begin-load-Centralized.");
        HashMap<String, String> centMapCache = CacheServiceHelper.get(CONTROL_CENTRALIZED_CACHE, Map.class);
        if (centMapCache == null) {
            centMapCache = new HashMap<String, String>();
        }
        String centralizedKey = modelId + "@" + busModelId;
        List<Centralized> centralizeds = null;
        Long oldVersion = 0L;
        String centData = (String)centMapCache.get(centralizedKey);
        if (StringUtils.isNotEmpty(centData)) {
            stats.addInfo("begin-cache-Centralized.");
            CollectionType centType = JSONUtils.getMapper().getTypeFactory().constructCollectionType(List.class, Centralized.class);
            centralizeds = (List<Centralized>)JSONUtils.parse(centData, (JavaType)centType);
            stats.add("end-cache-Centralized.");
            if (centralizeds != null && !centralizeds.isEmpty()) {
                oldVersion = centralizeds.get(0).getVersion();
            }
        }
        if ((cacheVersion = CacheServiceHelper.getVersionCacheByCentralized(centralizedKey)) == null || cacheVersion.compareTo(oldVersion) != 0) {
            centralizeds = null;
        }
        if (centralizeds == null) {
            stats.addInfo("begin-query-Centralized.");
            centralizeds = CentralizedServiceHelper.queryCentralized(modelId, busModelId, stats);
            centMapCache.put(centralizedKey, JSONUtils.toString(centralizeds));
            CacheServiceHelper.put(CONTROL_CENTRALIZED_CACHE, centMapCache);
            oldVersion = !centralizeds.isEmpty() ? centralizeds.get(0).getVersion() : Long.valueOf(0L);
            CacheServiceHelper.setVersionCacheByCentralized(centralizedKey, oldVersion);
            stats.add("end-query-Centralized.");
        }
        stats.addInfo("end-load-Centralized.");
        return centralizeds;
    }

    public static void clearCacheByCentralized(@NotNull Long modelId, @NotNull LogStats stats) {
        String _modelId = String.valueOf(modelId);
        Map centMapCache = CacheServiceHelper.get(CONTROL_CENTRALIZED_CACHE, Map.class);
        if (centMapCache != null && !centMapCache.isEmpty()) {
            HashSet remove = Sets.newHashSetWithExpectedSize((int)centMapCache.size());
            for (String _centKey : centMapCache.keySet()) {
                if (_centKey.startsWith(_modelId)) {
                    remove.add(_centKey);
                    stats.addInfo("release-redis-key:" + _centKey);
                    continue;
                }
                stats.addInfo("ignore-redis-key:" + _centKey);
            }
            if (!remove.isEmpty()) {
                for (String _centKey : remove) {
                    centMapCache.remove(_centKey);
                }
                CacheServiceHelper.put(CONTROL_CENTRALIZED_CACHE, centMapCache);
            }
        }
    }

    public static Long getVersionCacheByCentralized(@NotNull String centralizedKey) {
        String _version;
        Map versionCache = CacheServiceHelper.get(CONTROL_CENTRALIZED_VERSION_CACHE, Map.class);
        if (versionCache != null && (_version = (String)versionCache.get(centralizedKey)) != null) {
            return Long.valueOf(_version);
        }
        return null;
    }

    public static void setVersionCacheByCentralized(@NotNull String centralizedKey, @NotNull Long version) {
        HashMap<String, String> versionCache = CacheServiceHelper.get(CONTROL_CENTRALIZED_VERSION_CACHE, Map.class);
        if (versionCache == null) {
            versionCache = new HashMap<String, String>();
        }
        versionCache.put(centralizedKey, version.toString());
        CacheServiceHelper.put(CONTROL_CENTRALIZED_VERSION_CACHE, versionCache);
    }

    public static void clearVersionCacheByCentralized(@NotNull Long modelId, @NotNull LogStats stats) {
        String _modelId = modelId.toString();
        Map versionCache = CacheServiceHelper.get(CONTROL_CENTRALIZED_VERSION_CACHE, Map.class);
        if (versionCache != null && !versionCache.isEmpty()) {
            HashSet remove = Sets.newHashSetWithExpectedSize((int)versionCache.size());
            for (String _versionKey : versionCache.keySet()) {
                if (_versionKey.startsWith(_modelId)) {
                    remove.add(_versionKey);
                    stats.addInfo("release-redis-version-key:" + _versionKey);
                    continue;
                }
                stats.addInfo("ignore-redis-version-key:" + _versionKey);
            }
            if (!remove.isEmpty()) {
                for (String _versionKey : remove) {
                    versionCache.remove(_versionKey);
                }
                CacheServiceHelper.put(CONTROL_CENTRALIZED_VERSION_CACHE, versionCache);
            }
        }
    }

    public static Map<String, List<List<String[]>>> getFloatDataByCache(String floatKey) {
        String floatData;
        if (StringUtils.isEmpty(floatKey)) {
            return null;
        }
        Map floatCache = CacheServiceHelper.get(BUDGET_FLOAT_DATA, Map.class);
        if (floatCache != null && StringUtils.isNotEmpty(floatData = (String)floatCache.get(floatKey))) {
            CollectionType flatDataType = JSONUtils.getMapper().getTypeFactory().constructCollectionType(List.class, String[].class);
            CollectionType floatAreaType = JSONUtils.getMapper().getTypeFactory().constructCollectionType(List.class, (JavaType)flatDataType);
            MapType floatMapType = JSONUtils.getMapper().getTypeFactory().constructMapType(Map.class, JSONUtils.strType, (JavaType)floatAreaType);
            return (Map)JSONUtils.parse(floatData, (JavaType)floatMapType);
        }
        return null;
    }

    public static void clearFloatDataByCache() {
        CacheServiceHelper.remove(BUDGET_FLOAT_DATA);
    }

    public static void clearRelation(Long relationId) {
        String relData;
        if (IDUtils.isEmptyLong(relationId).booleanValue()) {
            return;
        }
        Map relationDataMap = CacheServiceHelper.get(BUDGET_RELATION_DATA, Map.class);
        if (relationDataMap != null && relationDataMap.size() > 0 && (relData = (String)relationDataMap.remove(relationId.toString())) != null) {
            CacheServiceHelper.put(BUDGET_RELATION_DATA, relationDataMap);
        }
    }

    private static String getFieldCacheKey(String entitynumber, boolean isopenapi) {
        return "CONTROL_FIELDS_CACHE_" + entitynumber + "_" + isopenapi;
    }

    public static void clearFieldsCache(String entitynumber) {
        CacheServiceHelper.remove(CacheServiceHelper.getFieldCacheKey(entitynumber, true));
        CacheServiceHelper.remove(CacheServiceHelper.getFieldCacheKey(entitynumber, false));
    }

    public static Set<String> getFieldsCache(String entitynumber, boolean isopenapi) {
        return CacheServiceHelper.get(CacheServiceHelper.getFieldCacheKey(entitynumber, isopenapi), Set.class);
    }

    public static void setFieldsCache(String entitynumber, boolean isopenapi, Set<String> fields) {
        CacheServiceHelper.put(CacheServiceHelper.getFieldCacheKey(entitynumber, isopenapi), fields);
    }
}

